/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.baseAdapter.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class GridItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable dividerDrawable;
    private int orientation = 1;

    public GridItemDecoration(Drawable divider) {
        this.dividerDrawable = divider;
    }

    public GridItemDecoration(Context context, int resId) {
        this.dividerDrawable = context.getResources().getDrawable(resId);
    }

    public GridItemDecoration(Context context, int resId, int orientation) {
        this.dividerDrawable = context.getResources().getDrawable(resId);
        this.orientation = orientation;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.dividerDrawable == null) {
            return;
        }
        if (parent.getChildLayoutPosition(view) < 1) {
            return;
        }
        if (this.orientation == 1) {
            outRect.top = this.dividerDrawable.getIntrinsicHeight();
        } else if (this.orientation == 0) {
            outRect.left = this.dividerDrawable.getIntrinsicWidth();
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.dividerDrawable == null) {
            return;
        }
        int childCount = parent.getChildCount();
        int rightV = parent.getWidth();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int leftV = parent.getPaddingLeft() + child.getPaddingLeft();
            int bottomV = child.getTop() - params.topMargin;
            int topV = bottomV - this.dividerDrawable.getIntrinsicHeight();
            int topH = child.getTop() + params.topMargin;
            int bottomH = child.getBottom() + params.bottomMargin;
            int rightH = child.getLeft() - params.leftMargin;
            int leftH = rightH - this.dividerDrawable.getIntrinsicWidth();
            this.dividerDrawable.setBounds(leftH, topH, rightH, bottomH);
            this.dividerDrawable.draw(c);
            this.dividerDrawable.setBounds(leftV, topV, rightV, bottomV);
            this.dividerDrawable.draw(c);
        }
    }
}

