/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import com.aliyun.svideo.common.utils.DensityUtils;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import java.security.MessageDigest;

public class GlideRoundedCornersTransform
extends CenterCrop {
    private float mRadius;
    private CornerType mCornerType;
    private static final int VERSION = 1;
    private static final String ID = "com.bumptech.glideGlideRoundedCornersTransform.1";
    private static final byte[] ID_BYTES = "com.bumptech.glideGlideRoundedCornersTransform.1".getBytes(CHARSET);

    public GlideRoundedCornersTransform(Context context, float radius, CornerType cornerType) {
        this.mRadius = DensityUtils.dip2px(context, radius);
        this.mCornerType = cornerType;
    }

    protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
        Bitmap transform = super.transform(pool, toTransform, outWidth, outHeight);
        return this.roundCrop(pool, transform);
    }

    private Bitmap roundCrop(BitmapPool pool, Bitmap source) {
        if (source == null) {
            return null;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap result = pool.get(source.getWidth(), source.getHeight(), Bitmap.Config.ARGB_8888);
        if (result == null) {
            result = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint();
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        paint.setAntiAlias(true);
        Path path = new Path();
        this.drawRoundRect(canvas, paint, path, width, height);
        return result;
    }

    private void drawRoundRect(Canvas canvas, Paint paint, Path path, int width, int height) {
        switch (this.mCornerType) {
            case ALL: {
                float[] rids = new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case TOP_LEFT: {
                float[] rids = new float[]{this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case TOP_RIGHT: {
                float[] rids = new float[]{0.0f, 0.0f, this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case BOTTOM_RIGHT: {
                float[] rids = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius, 0.0f, 0.0f};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case BOTTOM_LEFT: {
                float[] rids = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case TOP: {
                float[] rids = new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case BOTTOM: {
                float[] rids = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case LEFT: {
                float[] rids = new float[]{this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case RIGHT: {
                float[] rids = new float[]{0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case TOP_LEFT_BOTTOM_RIGHT: {
                float[] rids = new float[]{this.mRadius, this.mRadius, 0.0f, 0.0f, this.mRadius, this.mRadius, 0.0f, 0.0f};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case TOP_RIGHT_BOTTOM_LEFT: {
                float[] rids = new float[]{0.0f, 0.0f, this.mRadius, this.mRadius, 0.0f, 0.0f, this.mRadius, this.mRadius};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case TOP_LEFT_TOP_RIGHT_BOTTOM_RIGHT: {
                float[] rids = new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            case TOP_RIGHT_BOTTOM_RIGHT_BOTTOM_LEFT: {
                float[] rids = new float[]{0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius, this.mRadius};
                this.drawPath(rids, canvas, paint, path, width, height);
                break;
            }
            default: {
                throw new RuntimeException("RoundedCorners type not belong to CornerType");
            }
        }
    }

    private void drawPath(float[] rids, Canvas canvas, Paint paint, Path path, int width, int height) {
        path.addRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), rids, Path.Direction.CW);
        canvas.drawPath(path, paint);
    }

    public boolean equals(Object o) {
        return o instanceof GlideRoundedCornersTransform;
    }

    public int hashCode() {
        return ID.hashCode();
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
    }

    public static enum CornerType {
        ALL,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        TOP_LEFT_BOTTOM_RIGHT,
        TOP_RIGHT_BOTTOM_LEFT,
        TOP_LEFT_TOP_RIGHT_BOTTOM_RIGHT,
        TOP_RIGHT_BOTTOM_RIGHT_BOTTOM_LEFT;

    }
}

