/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils.image;

import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;

public class ImageLoaderOptions {
    private int mHolderDrawableId = -1;
    private Drawable mHolderDrawable;
    private int mErrorDrawableId = -1;
    private boolean mIsAsBitmap = false;
    private boolean mIsCrossFade = false;
    private float mThumbnail = 1.0f;
    private boolean mIsCenterCrop = false;
    private boolean mIsSkipMemoryCache = false;
    private boolean mIsSkipDiskCacheCache = false;
    private boolean mIsCircle = false;
    private Point mOverridePoint = new Point();
    private boolean mIsRoundCorner = false;

    private ImageLoaderOptions() {
    }

    public boolean isCircle() {
        return this.mIsCircle;
    }

    public boolean isCenterCrop() {
        return this.mIsCenterCrop;
    }

    public int getHolderDrawableId() {
        return this.mHolderDrawableId;
    }

    public int getErrorDrawableId() {
        return this.mErrorDrawableId;
    }

    public boolean isAsBitmap() {
        return this.mIsAsBitmap;
    }

    public boolean isCrossFade() {
        return this.mIsCrossFade;
    }

    public float getThumbnail() {
        return this.mThumbnail;
    }

    public Drawable getHolderDrawable() {
        return this.mHolderDrawable;
    }

    public boolean isSkipMemoryCache() {
        return this.mIsSkipMemoryCache;
    }

    public boolean isSkipDiskCacheCache() {
        return this.mIsSkipDiskCacheCache;
    }

    public Point getOverridePoint() {
        return this.mOverridePoint;
    }

    public boolean isRoundCorner() {
        return this.mIsRoundCorner;
    }

    public static final class Builder {
        private final ImageLoaderOptions mLoaderOptions = new ImageLoaderOptions();

        public Builder placeholder(@DrawableRes int mHolderDrawableId) {
            this.mLoaderOptions.mHolderDrawableId = mHolderDrawableId;
            return this;
        }

        public Builder placeholder(Drawable mHolderDrawableId) {
            this.mLoaderOptions.mHolderDrawable = mHolderDrawableId;
            return this;
        }

        public Builder crossFade() {
            this.mLoaderOptions.mIsCrossFade = true;
            return this;
        }

        public Builder centerCrop() {
            this.mLoaderOptions.mIsCenterCrop = true;
            return this;
        }

        public Builder circle() {
            this.mLoaderOptions.mIsCircle = true;
            return this;
        }

        public Builder roundCorner() {
            this.mLoaderOptions.mIsRoundCorner = true;
            return this;
        }

        public Builder thumbnail(float sizeMultiplier) {
            this.mLoaderOptions.mThumbnail = sizeMultiplier;
            return this;
        }

        public Builder asBitmap() {
            this.mLoaderOptions.mIsAsBitmap = true;
            return this;
        }

        public Builder error(@DrawableRes int mErrorDrawableId) {
            this.mLoaderOptions.mErrorDrawableId = mErrorDrawableId;
            return this;
        }

        public Builder override(int width, int height) {
            ((ImageLoaderOptions)this.mLoaderOptions).mOverridePoint.x = width;
            ((ImageLoaderOptions)this.mLoaderOptions).mOverridePoint.y = height;
            return this;
        }

        public Builder skipDiskCacheCache() {
            this.mLoaderOptions.mIsSkipDiskCacheCache = true;
            return this;
        }

        public Builder skipMemoryCache() {
            this.mLoaderOptions.mIsSkipMemoryCache = true;
            return this;
        }

        public ImageLoaderOptions build() {
            return this.mLoaderOptions;
        }
    }
}

