/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.net;

import android.content.Context;
import com.aliyun.player.aliyunplayerbase.bean.AliyunUserInfo;
import com.aliyun.player.aliyunplayerbase.net.ServiceCommon;
import com.aliyun.svideo.common.okhttp.AlivcOkHttpClient;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Request;

public class GetVideoInfomation {
    public void getRandomUser(final OnGetRandomUserListener listener) {
        AlivcOkHttpClient.getInstance().get(ServiceCommon.GET_RANDOM_USER, new AlivcOkHttpClient.HttpCallBack(){

            public void onError(Request request, IOException e) {
                if (listener != null) {
                    listener.onGetError(request, e);
                }
            }

            public void onSuccess(Request request, String result) {
                Gson gson = new Gson();
                AliyunUserInfo aliyunUserInfo = (AliyunUserInfo)gson.fromJson(result, AliyunUserInfo.class);
                if (aliyunUserInfo != null && listener != null) {
                    listener.onGetSuccess(aliyunUserInfo);
                }
            }
        });
    }

    public void getListPlayerVideoInfos(Context context, String pageIndex, String userToken, int id2, final OnGetListPlayerVideoInfosListener listener) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String mPackageName = context.getPackageName();
        hashMap.put("PACKAGE_NAME", mPackageName);
        hashMap.put("pageIndex", pageIndex);
        hashMap.put("pageSize", "10");
        hashMap.put("token", userToken);
        if (id2 > 0) {
            hashMap.put("id", id2 + "");
        }
        AlivcOkHttpClient.getInstance().get(ServiceCommon.GET_VIDEO_LIST_INFO, hashMap, new AlivcOkHttpClient.HttpCallBack(){

            public void onError(Request request, IOException e) {
                if (listener != null) {
                    listener.onGetError(request, e);
                }
            }

            public void onSuccess(Request request, String result) {
                if (listener != null) {
                    listener.onGetSuccess(request, result);
                }
            }
        });
    }

    public static interface OnGetListPlayerVideoInfosListener {
        public void onGetSuccess(Request var1, String var2);

        public void onGetError(Request var1, IOException var2);
    }

    public static interface OnGetRandomUserListener {
        public void onGetSuccess(AliyunUserInfo var1);

        public void onGetError(Request var1, IOException var2);
    }
}

