/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.view.tipsview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.aliyunplayerbase.R;
import com.aliyun.player.aliyunplayerbase.view.tipsview.OnTipsViewBackClickListener;

public class ErrorView
extends RelativeLayout {
    private static final String TAG = ErrorView.class.getSimpleName();
    private TextView mMsgView;
    private TextView mCodeView;
    private View mRetryView;
    private TextView mRetryBtn;
    private OnTipsViewBackClickListener mOnTipsViewBackClickListener = null;
    private OnRetryClickListener mOnRetryClickListener = null;
    private ImageView mBackImageView;

    public ErrorView(Context context) {
        super(context);
        this.init();
    }

    public ErrorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ErrorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getApplicationContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.alivc_dialog_error, (ViewGroup)this);
        this.mRetryBtn = (TextView)view.findViewById(R.id.retry_btn);
        this.mMsgView = (TextView)view.findViewById(R.id.msg);
        this.mCodeView = (TextView)view.findViewById(R.id.code);
        this.mRetryView = view.findViewById(R.id.retry);
        this.mBackImageView = (ImageView)view.findViewById(R.id.iv_back);
        this.mRetryView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ErrorView.this.mOnRetryClickListener != null) {
                    ErrorView.this.mOnRetryClickListener.onRetryClick();
                }
            }
        });
        this.mBackImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ErrorView.this.mOnTipsViewBackClickListener != null) {
                    ErrorView.this.mOnTipsViewBackClickListener.onBackClick();
                }
            }
        });
    }

    public void updateTips(int errorCode, String errorEvent, String errMsg) {
        this.mMsgView.setText((CharSequence)errMsg);
        this.mCodeView.setText((CharSequence)(this.getContext().getString(R.string.alivc_error_code) + errorCode + " - " + errorEvent));
    }

    public void updateTipsWithoutCode(String errMsg) {
        this.mMsgView.setText((CharSequence)errMsg);
        this.mCodeView.setVisibility(8);
    }

    public void setOnRetryClickListener(OnRetryClickListener l) {
        this.mOnRetryClickListener = l;
    }

    public void setOnBackClickListener(OnTipsViewBackClickListener listener) {
        this.mOnTipsViewBackClickListener = listener;
    }

    public static interface OnRetryClickListener {
        public void onRetryClick();
    }
}

