/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.util;

import android.text.TextUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Locale;

public class Formatter {
    public static String formatTime(int ms) {
        int totalSeconds = ms / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 60 / 60;
        String timeStr = "";
        if (hours > 9) {
            timeStr = timeStr + hours + ":";
        } else if (hours > 0) {
            timeStr = timeStr + "0" + hours + ":";
        }
        timeStr = minutes > 9 ? timeStr + minutes + ":" : (minutes > 0 ? timeStr + "0" + minutes + ":" : timeStr + "00:");
        timeStr = seconds > 9 ? timeStr + seconds : (seconds > 0 ? timeStr + "0" + seconds : timeStr + "00");
        return timeStr;
    }

    public static String formatDate(long seconds) {
        String finalStr = "";
        long mills = seconds * 1000L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(mills);
        int hour = calendar.get(11);
        finalStr = finalStr + (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":";
        int minute = calendar.get(12);
        finalStr = finalStr + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + ":";
        int second = calendar.get(13);
        finalStr = finalStr + (second < 10 ? "0" + second : Integer.valueOf(second));
        return finalStr;
    }

    public static String double2Date(double time) {
        long lTime = new Double(time).longValue();
        String s = Formatter.formatDate(lTime -= 28800L);
        String substring = s.substring(3);
        return substring;
    }

    public static int getIntTime(String formatTime) {
        if (TextUtils.isEmpty((CharSequence)formatTime)) {
            return 0;
        }
        String[] tmp = formatTime.split(":");
        if (tmp.length < 3) {
            return 0;
        }
        int second = Integer.valueOf(tmp[0]) * 3600 + Integer.valueOf(tmp[1]) * 60 + Integer.valueOf(tmp[2]);
        return second * 1000;
    }

    public static String getStringTime(int timeMs) {
        StringBuilder formatBuilder = new StringBuilder();
        java.util.Formatter formatter = new java.util.Formatter(formatBuilder, Locale.getDefault());
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        formatBuilder.setLength(0);
        return formatter.format("%02d:%02d:%02d", hours, minutes, seconds).toString();
    }

    public static String formatSizeDecimal(long size) {
        double kb = (double)size / 1024.0 * 1.0;
        BigDecimal bigDecimal = new BigDecimal(kb);
        if (kb < 1024.0) {
            return String.format("%.1f", bigDecimal.setScale(2, RoundingMode.HALF_UP)) + "K";
        }
        double mb = kb / 1024.0 * 1.0;
        BigDecimal decimal = new BigDecimal(mb);
        return String.format("%.1f", decimal.setScale(2, RoundingMode.HALF_UP)) + "M";
    }

    public static String getFileSizeDescription(long size) {
        StringBuffer bytes = new StringBuffer();
        DecimalFormat format = new DecimalFormat("###.0");
        if (size >= 0x40000000L) {
            double i = (double)size / 1.073741824E9;
            bytes.append(format.format(i)).append("G");
        } else if (size >= 0x100000L) {
            double i = (double)size / 1048576.0;
            bytes.append(format.format(i)).append("M");
        } else if (size >= 1024L) {
            double i = (double)size / 1024.0;
            bytes.append(format.format(i)).append("K");
        } else if (size < 1024L) {
            if (size <= 0L) {
                bytes.append("0B");
            } else {
                bytes.append((int)size).append("B");
            }
        }
        return bytes.toString();
    }
}

