/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.view.tipsview;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.aliyun.player.aliyunplayerbase.view.tipsview.CustomTipsView;
import com.aliyun.player.aliyunplayerbase.view.tipsview.ErrorView;
import com.aliyun.player.aliyunplayerbase.view.tipsview.LoadingView;
import com.aliyun.player.aliyunplayerbase.view.tipsview.NetChangeView;
import com.aliyun.player.aliyunplayerbase.view.tipsview.OnTipsViewBackClickListener;
import com.aliyun.player.aliyunplayerbase.view.tipsview.ReplayView;
import com.aliyun.player.bean.ErrorCode;

public class TipsView
extends RelativeLayout {
    private static final String TAG = TipsView.class.getSimpleName();
    private int mErrorCode;
    private ErrorView mErrorView = null;
    private ReplayView mReplayView = null;
    private LoadingView mNetLoadingView = null;
    private NetChangeView mNetChangeView = null;
    private LoadingView mBufferLoadingView = null;
    private CustomTipsView mCustomTipsView = null;
    private OnTipClickListener mOnTipClickListener = null;
    private OnTipsViewBackClickListener mOnTipsViewBackClickListener = null;
    private NetChangeView.OnNetChangeClickListener onNetChangeClickListener = new NetChangeView.OnNetChangeClickListener(){

        @Override
        public void onContinuePlay() {
            if (TipsView.this.mOnTipClickListener != null) {
                TipsView.this.mOnTipClickListener.onContinuePlay();
            }
        }

        @Override
        public void onStopPlay() {
            if (TipsView.this.mOnTipClickListener != null) {
                TipsView.this.mOnTipClickListener.onStopPlay();
            }
        }
    };
    private ErrorView.OnRetryClickListener onRetryClickListener = new ErrorView.OnRetryClickListener(){

        @Override
        public void onRetryClick() {
            if (TipsView.this.mOnTipClickListener != null) {
                if (TipsView.this.mErrorCode == ErrorCode.ERROR_SERVER_POP_UNKNOWN.getValue()) {
                    TipsView.this.mOnTipClickListener.onRefreshSts();
                } else {
                    TipsView.this.mOnTipClickListener.onRetryPlay(TipsView.this.mErrorCode);
                }
            }
        }
    };
    private ReplayView.OnReplayClickListener onReplayClickListener = new ReplayView.OnReplayClickListener(){

        @Override
        public void onReplay() {
            if (TipsView.this.mOnTipClickListener != null) {
                TipsView.this.mOnTipClickListener.onReplay();
            }
        }
    };
    private OnTipsViewBackClickListener onTipsViewBackClickListener = new OnTipsViewBackClickListener(){

        @Override
        public void onBackClick() {
            if (TipsView.this.mOnTipsViewBackClickListener != null) {
                TipsView.this.mOnTipsViewBackClickListener.onBackClick();
            }
        }
    };
    private CustomTipsView.OnTipsViewClickListener mOnTipsViewClickListener = new CustomTipsView.OnTipsViewClickListener(){

        @Override
        public void onWait() {
            if (TipsView.this.mOnTipClickListener != null) {
                TipsView.this.mOnTipClickListener.onWait();
            }
        }

        @Override
        public void onExit() {
            if (TipsView.this.mOnTipClickListener != null) {
                TipsView.this.mOnTipClickListener.onExit();
            }
        }
    };

    public TipsView(Context context) {
        super(context);
    }

    public TipsView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TipsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void showCustomTipView(String tipsText, String confirmText, String cancelText) {
        if (this.mCustomTipsView == null) {
            this.mCustomTipsView = new CustomTipsView(this.getContext());
            this.mCustomTipsView.setOnTipsViewClickListener(this.mOnTipsViewClickListener);
            this.mCustomTipsView.setOnBackClickListener(this.onTipsViewBackClickListener);
            this.mCustomTipsView.setTipsText(tipsText);
            this.mCustomTipsView.setConfirmText(confirmText);
            this.mCustomTipsView.setCancelText(cancelText);
            this.addSubView((View)this.mCustomTipsView);
        }
        if (this.mErrorView == null || this.mErrorView.getVisibility() != 0) {
            this.mCustomTipsView.setVisibility(0);
        }
    }

    public void showNetChangeTipView() {
        if (this.mNetChangeView == null) {
            this.mNetChangeView = new NetChangeView(this.getContext());
            this.mNetChangeView.setOnNetChangeClickListener(this.onNetChangeClickListener);
            this.mNetChangeView.setOnBackClickListener(this.onTipsViewBackClickListener);
            this.addSubView((View)this.mNetChangeView);
        }
        if (this.mErrorView == null || this.mErrorView.getVisibility() != 0) {
            this.mNetChangeView.setVisibility(0);
        }
    }

    public void showErrorTipView(int errorCode, String errorEvent, String errorMsg) {
        if (this.mErrorView == null) {
            this.mErrorView = new ErrorView(this.getContext());
            this.mErrorView.setOnRetryClickListener(this.onRetryClickListener);
            this.mErrorView.setOnBackClickListener(this.onTipsViewBackClickListener);
            this.addSubView((View)this.mErrorView);
        }
        this.hideNetChangeTipView();
        this.mErrorCode = errorCode;
        this.mErrorView.updateTips(errorCode, errorEvent, errorMsg);
        this.mErrorView.setVisibility(0);
        Log.d((String)TAG, (String)(" errorCode = " + this.mErrorCode));
    }

    public void showErrorTipViewWithoutCode(String msg) {
        if (this.mErrorView == null) {
            this.mErrorView = new ErrorView(this.getContext());
            this.mErrorView.updateTipsWithoutCode(msg);
            this.mErrorView.setOnBackClickListener(this.onTipsViewBackClickListener);
            this.mErrorView.setOnRetryClickListener(this.onRetryClickListener);
            this.addSubView((View)this.mErrorView);
        }
        if (this.mErrorView.getVisibility() != 0) {
            this.mErrorView.setVisibility(0);
        }
    }

    public void showReplayTipView() {
        if (this.mReplayView == null) {
            this.mReplayView = new ReplayView(this.getContext());
            this.mReplayView.setOnBackClickListener(this.onTipsViewBackClickListener);
            this.mReplayView.setOnReplayClickListener(this.onReplayClickListener);
            this.addSubView((View)this.mReplayView);
        }
        if (this.mReplayView.getVisibility() != 0) {
            this.mReplayView.setVisibility(0);
        }
    }

    public void showBufferLoadingTipView() {
        if (this.mBufferLoadingView == null) {
            this.mBufferLoadingView = new LoadingView(this.getContext());
            this.addSubView((View)this.mBufferLoadingView);
        }
        if (this.mBufferLoadingView.getVisibility() != 0) {
            this.mBufferLoadingView.setVisibility(0);
        }
    }

    public void updateLoadingPercent(int percent) {
        this.showBufferLoadingTipView();
        this.mBufferLoadingView.updateLoadingPercent(percent);
    }

    public void showNetLoadingTipView() {
        if (this.mNetLoadingView == null) {
            this.mNetLoadingView = new LoadingView(this.getContext());
            this.mNetLoadingView.setOnlyLoading();
            this.addSubView((View)this.mNetLoadingView);
        }
        if (this.mNetLoadingView.getVisibility() != 0) {
            this.mNetLoadingView.setVisibility(0);
        }
    }

    public void addSubView(View subView) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(subView, (ViewGroup.LayoutParams)params);
    }

    public void hideAll() {
        this.hideCustomTipView();
        this.hideNetChangeTipView();
        this.hideErrorTipView();
        this.hideReplayTipView();
        this.hideBufferLoadingTipView();
        this.hideNetLoadingTipView();
    }

    public void hideBufferLoadingTipView() {
        if (this.mBufferLoadingView != null && this.mBufferLoadingView.getVisibility() == 0) {
            this.mBufferLoadingView.updateLoadingPercent(0);
            this.mBufferLoadingView.setVisibility(4);
        }
    }

    public void hideNetLoadingTipView() {
        if (this.mNetLoadingView != null && this.mNetLoadingView.getVisibility() == 0) {
            this.mNetLoadingView.setVisibility(4);
        }
    }

    public void hideReplayTipView() {
        if (this.mReplayView != null && this.mReplayView.getVisibility() == 0) {
            this.mReplayView.setVisibility(4);
        }
    }

    public void hideNetChangeTipView() {
        if (this.mNetChangeView != null && this.mNetChangeView.getVisibility() == 0) {
            this.mNetChangeView.setVisibility(4);
        }
    }

    public void hideCustomTipView() {
        if (this.mCustomTipsView != null && this.mCustomTipsView.getVisibility() == 0) {
            this.mCustomTipsView.setVisibility(4);
        }
    }

    public void hideErrorTipView() {
        if (this.mErrorView != null && this.mErrorView.getVisibility() == 0) {
            this.mErrorView.setVisibility(4);
        }
    }

    public boolean isErrorShow() {
        if (this.mErrorView != null) {
            return this.mErrorView.getVisibility() == 0;
        }
        return false;
    }

    public void hideNetErrorTipView() {
    }

    public void setOnTipClickListener(OnTipClickListener l) {
        this.mOnTipClickListener = l;
    }

    public void setOnTipsViewBackClickListener(OnTipsViewBackClickListener listener) {
        this.onTipsViewBackClickListener = listener;
    }

    public static interface OnTipClickListener {
        public void onContinuePlay();

        public void onStopPlay();

        public void onRetryPlay(int var1);

        public void onReplay();

        public void onRefreshSts();

        public void onWait();

        public void onExit();
    }
}

