/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.control;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.bean.DotBean;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.alivcplayerexpand.theme.ITheme;
import com.aliyun.player.alivcplayerexpand.theme.Theme;
import com.aliyun.player.alivcplayerexpand.util.TimeFormater;
import com.aliyun.player.alivcplayerexpand.view.dot.DotView;
import com.aliyun.player.alivcplayerexpand.view.function.AdvVideoView;
import com.aliyun.player.alivcplayerexpand.view.function.MutiSeekBarView;
import com.aliyun.player.alivcplayerexpand.view.interfaces.ViewAction;
import com.aliyun.player.alivcplayerexpand.view.quality.QualityItem;
import com.aliyun.player.alivcplayerexpand.widget.AliyunVodPlayerView;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.nativeclass.MediaInfo;
import com.aliyun.player.nativeclass.TrackInfo;
import com.aliyun.svideo.common.utils.FastClickUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ControlView
extends RelativeLayout
implements ViewAction,
ITheme {
    private static final String TAG = ControlView.class.getSimpleName();
    private static final int WHAT_HIDE = 0;
    private static final int DELAY_TIME = 5000;
    private boolean mTitleBarCanShow = true;
    private boolean mControlBarCanShow = true;
    private View mTitleBar;
    private View mControlBar;
    private ImageView mTitlebarBackBtn;
    private TextView mTitlebarText;
    private PlayState mPlayState = PlayState.NotPlaying;
    private ImageView mPlayStateBtn;
    private boolean mScreenLocked = false;
    private ImageView mScreenLockBtn;
    private AliyunScreenMode mAliyunScreenMode = AliyunScreenMode.Small;
    private ImageView mScreenModeBtn;
    private MediaInfo mAliyunMediaInfo;
    private int mVideoPosition = 0;
    private int mAdvVideoPosition = 0;
    private boolean isSeekbarTouching = false;
    private int mVideoBufferPosition;
    private View mLargeInfoBar;
    private TextView mLargePositionText;
    private TextView mLargeDurationText;
    private SeekBar mLargeSeekbar;
    private String mCurrentQuality;
    private boolean mForceQuality = false;
    private Button mLargeChangeQualityBtn;
    private ImageView mTitleMore;
    private View mSmallInfoBar;
    private TextView mSmallPositionText;
    private TextView mSmallDurationText;
    private SeekBar mSmallSeekbar;
    private boolean mMarqueeShow = false;
    private boolean mDanmuShow = false;
    private ViewAction.HideType mHideType = null;
    private boolean isMtsSource;
    private OnSeekListener mOnSeekListener;
    private OnBackClickListener mOnBackClickListener;
    private OnPlayStateClickListener mOnPlayStateClickListener;
    private OnQualityBtnClickListener mOnQualityBtnClickListener;
    private OnScreenLockClickListener mOnScreenLockClickListener;
    private OnScreenModeClickListener mOnScreenModeClickListener;
    private OnShowMoreClickListener mOnShowMoreClickListener;
    private OnScreenShotClickListener mOnScreenShotClickListener;
    private OnScreenRecoderClickListener mOnScreenRecoderClickListener;
    private OnInputDanmakuClickListener mOnInputDanmakuClickListener;
    private OnDLNAControlListener mOnDLNAControlListener;
    private OnControlViewHideListener mOnControlViewHideListener;
    private OnTrackInfoClickListener mOnTrackInfoClickListener;
    private long mAdvDuration;
    private long mSourceDuration;
    private MutiSeekBarView.AdvPosition mAdvPosition;
    private ImageView mInputDanmkuImageView;
    private long mAdvTotalPosition;
    private AdvVideoView.VideoState mCurrentVideoState;
    private ImageView mScreenShot;
    private ImageView mScreenRecorder;
    private MutiSeekBarView mSmallMutiSeekbar;
    private MutiSeekBarView mLargeMutiSeekbar;
    private LinearLayout mScreenCostLinearLayout;
    private TextView mScreenCostStateTextView;
    private TextView mScreenCostExitTextView;
    private boolean mInScreenCosting;
    private int mMutiSeekBarCurrentProgress;
    private List<DotBean> mDotBean;
    private int mMediaDuration;
    private LinearLayout mTrackLinearLayout;
    private TextView mAudioTextView;
    private TextView mBitrateTextView;
    private TextView mSubtitleTextView;
    private TextView mDefinitionTextView;
    private List<TrackInfo> mAudioTrackInfoList;
    private List<TrackInfo> mBitrateTrackInfoList;
    private List<TrackInfo> mDefinitionTrackInfoList;
    private List<TrackInfo> mSubtitleTrackInfoList;
    private HideHandler mHideHandler = new HideHandler(this);
    private OnDotViewClickListener mOnDotViewClickListener;

    public ControlView(Context context) {
        super(context);
        this.init();
    }

    public ControlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ControlView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.alivc_view_control, (ViewGroup)this, true);
        this.findAllViews();
        this.setViewListener();
        this.updateAllViews();
    }

    private void findAllViews() {
        this.mTitleBar = this.findViewById(R.id.titlebar);
        this.mControlBar = this.findViewById(R.id.controlbar);
        this.mTrackLinearLayout = (LinearLayout)this.findViewById(R.id.ll_track);
        this.mAudioTextView = (TextView)this.findViewById(R.id.tv_audio);
        this.mBitrateTextView = (TextView)this.findViewById(R.id.tv_bitrate);
        this.mSubtitleTextView = (TextView)this.findViewById(R.id.tv_subtitle);
        this.mDefinitionTextView = (TextView)this.findViewById(R.id.tv_definition);
        this.mTitlebarBackBtn = (ImageView)this.findViewById(R.id.alivc_title_back);
        this.mTitlebarText = (TextView)this.findViewById(R.id.alivc_title_title);
        this.mTitleMore = (ImageView)this.findViewById(R.id.alivc_title_more);
        this.mScreenModeBtn = (ImageView)this.findViewById(R.id.alivc_screen_mode);
        this.mScreenLockBtn = (ImageView)this.findViewById(R.id.alivc_screen_lock);
        this.mPlayStateBtn = (ImageView)this.findViewById(R.id.alivc_player_state);
        this.mScreenShot = (ImageView)this.findViewById(R.id.alivc_screen_shot);
        this.mScreenRecorder = (ImageView)this.findViewById(R.id.alivc_screen_recoder);
        this.mLargeInfoBar = this.findViewById(R.id.alivc_info_large_bar);
        this.mLargePositionText = (TextView)this.findViewById(R.id.alivc_info_large_position);
        this.mLargeDurationText = (TextView)this.findViewById(R.id.alivc_info_large_duration);
        this.mLargeSeekbar = (SeekBar)this.findViewById(R.id.alivc_info_large_seekbar);
        this.mLargeChangeQualityBtn = (Button)this.findViewById(R.id.alivc_info_large_rate_btn);
        this.mSmallInfoBar = this.findViewById(R.id.alivc_info_small_bar);
        this.mSmallPositionText = (TextView)this.findViewById(R.id.alivc_info_small_position);
        this.mSmallDurationText = (TextView)this.findViewById(R.id.alivc_info_small_duration);
        this.mSmallSeekbar = (SeekBar)this.findViewById(R.id.alivc_info_small_seekbar);
        this.mSmallMutiSeekbar = (MutiSeekBarView)this.findViewById(R.id.alivc_info_small_mutiseekbar);
        this.mLargeMutiSeekbar = (MutiSeekBarView)this.findViewById(R.id.alivc_info_large_mutiseekbar);
        this.mInputDanmkuImageView = (ImageView)this.findViewById(R.id.iv_input_danmaku);
        this.mScreenCostLinearLayout = (LinearLayout)this.findViewById(R.id.screen_cost_ll);
        this.mScreenCostStateTextView = (TextView)this.findViewById(R.id.tv_screen_cost_state);
        this.mScreenCostExitTextView = (TextView)this.findViewById(R.id.tv_exit);
    }

    private void setViewListener() {
        this.mTitlebarBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ControlView.this.mOnBackClickListener != null) {
                    ControlView.this.mOnBackClickListener.onClick();
                }
            }
        });
        this.mPlayStateBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ControlView.this.mOnPlayStateClickListener != null) {
                    ControlView.this.mOnPlayStateClickListener.onPlayStateClick();
                }
            }
        });
        this.mScreenLockBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ControlView.this.mOnScreenLockClickListener != null) {
                    ControlView.this.mOnScreenLockClickListener.onClick();
                }
            }
        });
        this.mScreenShot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FastClickUtil.isFastClick()) {
                    return;
                }
                if (ControlView.this.mOnScreenShotClickListener != null) {
                    ControlView.this.mOnScreenShotClickListener.onScreenShotClick();
                }
            }
        });
        this.mScreenRecorder.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ControlView.this.mOnScreenRecoderClickListener != null && !GlobalPlayerConfig.IS_TRAILER && ControlView.this.mVideoPosition < AliyunVodPlayerView.TRAILER) {
                    ControlView.this.mOnScreenRecoderClickListener.onScreenRecoderClick();
                }
            }
        });
        this.mScreenModeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ControlView.this.mOnScreenModeClickListener != null) {
                    ControlView.this.mOnScreenModeClickListener.onClick();
                }
            }
        });
        this.mScreenCostExitTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnDLNAControlListener != null) {
                    ControlView.this.mOnDLNAControlListener.onExit();
                }
            }
        });
        this.mAudioTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnTrackInfoClickListener != null) {
                    ControlView.this.mOnTrackInfoClickListener.onAudioClick(ControlView.this.mAudioTrackInfoList);
                }
            }
        });
        this.mBitrateTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnTrackInfoClickListener != null) {
                    ControlView.this.mOnTrackInfoClickListener.onBitrateClick(ControlView.this.mBitrateTrackInfoList);
                }
            }
        });
        this.mSubtitleTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnTrackInfoClickListener != null) {
                    ControlView.this.mOnTrackInfoClickListener.onSubtitleClick(ControlView.this.mSubtitleTrackInfoList);
                }
            }
        });
        this.mDefinitionTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnTrackInfoClickListener != null) {
                    ControlView.this.mOnTrackInfoClickListener.onDefinitionClick(ControlView.this.mDefinitionTrackInfoList);
                }
            }
        });
        SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    if (ControlView.this.mAliyunScreenMode == AliyunScreenMode.Full) {
                        ControlView.this.mLargePositionText.setText((CharSequence)TimeFormater.formatMs(progress));
                    } else if (ControlView.this.mAliyunScreenMode == AliyunScreenMode.Small) {
                        ControlView.this.mSmallPositionText.setText((CharSequence)TimeFormater.formatMs(progress));
                    }
                    if (ControlView.this.mOnSeekListener != null) {
                        ControlView.this.mOnSeekListener.onProgressChanged(progress);
                    }
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                ControlView.this.isSeekbarTouching = true;
                ControlView.this.mMutiSeekBarCurrentProgress = seekBar.getProgress();
                ControlView.this.mHideHandler.removeMessages(0);
                if (ControlView.this.mOnSeekListener != null) {
                    ControlView.this.mOnSeekListener.onSeekStart(seekBar.getProgress());
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (ControlView.this.mOnSeekListener != null) {
                    ControlView.this.mOnSeekListener.onSeekEnd(seekBar.getProgress());
                }
                ControlView.this.isSeekbarTouching = false;
                ControlView.this.mHideHandler.removeMessages(0);
                ControlView.this.mHideHandler.sendEmptyMessageDelayed(0, 5000L);
            }
        };
        this.mLargeSeekbar.setOnSeekBarChangeListener(seekBarChangeListener);
        this.mSmallSeekbar.setOnSeekBarChangeListener(seekBarChangeListener);
        this.mLargeMutiSeekbar.setOnSeekBarChangeListener(seekBarChangeListener);
        this.mSmallMutiSeekbar.setOnSeekBarChangeListener(seekBarChangeListener);
        this.mLargeChangeQualityBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ControlView.this.mOnQualityBtnClickListener != null && ControlView.this.mAliyunMediaInfo != null) {
                    ArrayList<TrackInfo> qualityTrackInfos = new ArrayList<TrackInfo>();
                    List trackInfos = ControlView.this.mAliyunMediaInfo.getTrackInfos();
                    for (TrackInfo trackInfo : trackInfos) {
                        if (trackInfo.getType() != TrackInfo.Type.TYPE_VOD) continue;
                        qualityTrackInfos.add(trackInfo);
                    }
                    ControlView.this.mOnQualityBtnClickListener.onQualityBtnClick(v, qualityTrackInfos, ControlView.this.mCurrentQuality);
                }
            }
        });
        this.mTitleMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ControlView.this.mOnShowMoreClickListener != null) {
                    ControlView.this.mOnShowMoreClickListener.showMore();
                }
            }
        });
        this.mInputDanmkuImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnInputDanmakuClickListener != null) {
                    ControlView.this.mOnInputDanmakuClickListener.onInputDanmakuClick();
                }
            }
        });
    }

    public void setIsMtsSource(boolean isMts) {
        this.isMtsSource = isMts;
    }

    public void setCurrentQuality(String currentQuality) {
        this.mCurrentQuality = currentQuality;
        this.updateLargeInfoBar();
    }

    public void setForceQuality(boolean forceQuality) {
        this.mForceQuality = forceQuality;
    }

    public void setTitleBarCanShow(boolean show) {
        this.mTitleBarCanShow = show;
        this.updateAllTitleBar();
    }

    public void setControlBarCanShow(boolean show) {
        this.mControlBarCanShow = show;
        this.updateAllControlBar();
    }

    @Override
    public void setScreenModeStatus(AliyunScreenMode mode) {
        this.mAliyunScreenMode = mode;
        this.updateLargeInfoBar();
        this.updateSmallInfoBar();
        this.updateScreenLockBtn();
        this.updateScreenModeBtn();
        this.updateShowMoreBtn();
        this.updateScreenShotBtn();
        this.updateScreenRecorderBtn();
        this.updateInputDanmakuView();
        this.updateDotView();
        if (mode == AliyunScreenMode.Full) {
            this.updateTrackInfoView();
        }
    }

    private void updateScreenRecorderBtn() {
        this.mScreenRecorder.setVisibility(8);
    }

    private void updateScreenShotBtn() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Small || this.mScreenLocked || this.mInScreenCosting) {
            this.mScreenShot.setVisibility(4);
        } else if (this.mAliyunScreenMode == AliyunScreenMode.Full) {
            this.mScreenShot.setVisibility(0);
        }
    }

    private void updateShowMoreBtn() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Full && !this.mInScreenCosting) {
            this.mTitleMore.setVisibility(0);
        } else {
            this.mTitleMore.setVisibility(8);
        }
    }

    private void updateInputDanmakuView() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Small || this.mScreenLocked || this.mInScreenCosting) {
            this.mInputDanmkuImageView.setVisibility(4);
        } else if (this.mAliyunScreenMode == AliyunScreenMode.Full) {
            this.mInputDanmkuImageView.setVisibility(0);
        }
    }

    private void updateDotView() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Full && this.mLargeSeekbar != null) {
            this.mLargeSeekbar.post(new Runnable(){

                @Override
                public void run() {
                    int measuredWidth = ControlView.this.mLargeSeekbar.getMeasuredWidth();
                    if (measuredWidth != 0 && ControlView.this.mLargeSeekbar.isShown()) {
                        ControlView.this.initDotView();
                    }
                }
            });
        }
    }

    @Override
    public void setTheme(Theme theme) {
        this.updateSeekBarTheme(theme);
    }

    public void setPlayState(PlayState playState) {
        this.mPlayState = playState;
        this.updatePlayStateBtn();
    }

    public void setOtherEnable(boolean enable) {
        if (this.mSmallSeekbar != null) {
            this.mSmallSeekbar.setEnabled(enable);
        }
        if (this.mLargeSeekbar != null) {
            this.mLargeSeekbar.setEnabled(enable);
        }
        if (this.mPlayStateBtn != null) {
            this.mPlayStateBtn.setEnabled(enable);
        }
        if (this.mScreenLockBtn != null) {
            this.mScreenLockBtn.setEnabled(enable);
        }
        if (this.mLargeChangeQualityBtn != null) {
            this.mLargeChangeQualityBtn.setEnabled(enable);
        }
        if (this.mTitleMore != null) {
            this.mTitleMore.setEnabled(enable);
        }
        if (this.mInputDanmkuImageView != null) {
            this.mInputDanmkuImageView.setEnabled(enable);
        }
    }

    public void setMediaInfo(MediaInfo aliyunMediaInfo, String currentQuality) {
        this.mAliyunMediaInfo = aliyunMediaInfo;
        this.mMediaDuration = this.mAliyunMediaInfo.getDuration();
        this.mCurrentQuality = currentQuality;
        this.updateLargeInfoBar();
    }

    public void setMediaDuration(int duration) {
        this.mMediaDuration = duration;
        this.updateLargeInfoBar();
        this.updateSmallInfoBar();
    }

    public void showMoreButton() {
        this.mTitleMore.setVisibility(0);
    }

    public void hideMoreButton() {
        this.mTitleMore.setVisibility(8);
    }

    public void setInScreenCosting(boolean isScreenCosting) {
        this.mInScreenCosting = isScreenCosting;
    }

    private List<TrackInfo> getTrackInfoListWithTrackInfoType(TrackInfo.Type trackInfoType) {
        ArrayList<TrackInfo> trackInfoList = new ArrayList<TrackInfo>();
        if (this.mAliyunMediaInfo != null && this.mAliyunMediaInfo.getTrackInfos() != null) {
            for (TrackInfo trackInfo : this.mAliyunMediaInfo.getTrackInfos()) {
                TrackInfo.Type type = trackInfo.getType();
                if (type != trackInfoType) continue;
                if (trackInfoType == TrackInfo.Type.TYPE_SUBTITLE) {
                    if (TextUtils.isEmpty((CharSequence)trackInfo.getSubtitleLang())) continue;
                    trackInfoList.add(trackInfo);
                    continue;
                }
                if (trackInfoType == TrackInfo.Type.TYPE_AUDIO) {
                    if (TextUtils.isEmpty((CharSequence)trackInfo.getAudioLang())) continue;
                    trackInfoList.add(trackInfo);
                    continue;
                }
                if (trackInfoType == TrackInfo.Type.TYPE_VIDEO) {
                    if (trackInfo.getVideoBitrate() <= 0) continue;
                    if (trackInfoList.size() == 0) {
                        trackInfoList.add(trackInfo);
                    }
                    trackInfoList.add(trackInfo);
                    continue;
                }
                if (trackInfoType != TrackInfo.Type.TYPE_VOD || TextUtils.isEmpty((CharSequence)trackInfo.getVodDefinition())) continue;
                trackInfoList.add(trackInfo);
            }
        }
        return trackInfoList;
    }

    private void updateSeekBarTheme(Theme theme) {
        int progressDrawableResId = R.drawable.alivc_info_seekbar_bg_blue;
        int thumbResId = R.drawable.alivc_info_seekbar_thumb_blue;
        if (theme == Theme.Blue) {
            progressDrawableResId = R.drawable.alivc_info_seekbar_bg_blue;
            thumbResId = R.drawable.alivc_seekbar_thumb_blue;
        } else if (theme == Theme.Green) {
            progressDrawableResId = R.drawable.alivc_info_seekbar_bg_green;
            thumbResId = R.drawable.alivc_info_seekbar_thumb_green;
        } else if (theme == Theme.Orange) {
            progressDrawableResId = R.drawable.alivc_info_seekbar_bg_orange;
            thumbResId = R.drawable.alivc_info_seekbar_thumb_orange;
        } else if (theme == Theme.Red) {
            progressDrawableResId = R.drawable.alivc_info_seekbar_bg_red;
            thumbResId = R.drawable.alivc_info_seekbar_thumb_red;
        }
        Resources resources = this.getResources();
        Drawable smallProgressDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)progressDrawableResId);
        Drawable smallThumb = ContextCompat.getDrawable((Context)this.getContext(), (int)thumbResId);
        this.mSmallSeekbar.setProgressDrawable(smallProgressDrawable);
        this.mSmallSeekbar.setThumb(smallThumb);
        Drawable smallMutiThumb = ContextCompat.getDrawable((Context)this.getContext(), (int)thumbResId);
        this.mSmallMutiSeekbar.setThumb(smallMutiThumb);
        Drawable largeProgressDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)progressDrawableResId);
        Drawable largeThumb = ContextCompat.getDrawable((Context)this.getContext(), (int)thumbResId);
        this.mLargeSeekbar.setProgressDrawable(largeProgressDrawable);
        this.mLargeSeekbar.setThumb(largeThumb);
        this.mLargeMutiSeekbar.setThumb(largeThumb);
    }

    public void setScreenLockStatus(boolean screenLocked) {
        this.mScreenLocked = screenLocked;
        this.updateScreenLockBtn();
        this.updateAllTitleBar();
        this.updateAllControlBar();
        this.updateShowMoreBtn();
        this.updateScreenShotBtn();
        this.updateScreenRecorderBtn();
    }

    public void setVideoPosition(int position) {
        this.mVideoPosition = position;
        this.judgeCurrentPlayingVideo();
        this.updateSmallInfoBar();
        this.updateLargeInfoBar();
    }

    private void judgeCurrentPlayingVideo() {
        if (this.mAdvPosition == null || !GlobalPlayerConfig.IS_VIDEO) {
            return;
        }
        switch (this.mAdvPosition) {
            case ONLY_START: {
                if (this.isVideoPositionInStart(this.mAdvVideoPosition)) {
                    this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_ADV;
                    break;
                }
                this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_SOURCE;
                break;
            }
            case ONLY_MIDDLE: {
                if (this.isVideoPositionInMiddle(this.mAdvVideoPosition)) {
                    this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_ADV;
                    break;
                }
                this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_SOURCE;
                break;
            }
            case ONLY_END: {
                if (this.isVideoPositionInEnd(this.mAdvVideoPosition)) {
                    this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_ADV;
                    break;
                }
                this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_SOURCE;
                break;
            }
            case START_END: {
                if (this.isVideoPositionInStart(this.mAdvVideoPosition) || this.isVideoPositionInEnd(this.mAdvVideoPosition)) {
                    this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_ADV;
                    break;
                }
                this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_SOURCE;
                break;
            }
            case MIDDLE_END: {
                if (this.isVideoPositionInMiddle(this.mAdvVideoPosition) || this.isVideoPositionInEnd(this.mAdvVideoPosition)) {
                    this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_ADV;
                    break;
                }
                this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_SOURCE;
                break;
            }
            case START_MIDDLE: {
                if (this.isVideoPositionInStart(this.mAdvVideoPosition) || this.isVideoPositionInMiddle(this.mAdvVideoPosition)) {
                    this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_ADV;
                    break;
                }
                this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_SOURCE;
                break;
            }
            case ALL: {
                if (this.isVideoPositionInStart(this.mAdvVideoPosition) || this.isVideoPositionInMiddle(this.mAdvVideoPosition) || this.isVideoPositionInEnd(this.mAdvVideoPosition)) {
                    this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_ADV;
                    break;
                }
                this.mCurrentVideoState = AdvVideoView.VideoState.VIDEO_SOURCE;
                break;
            }
        }
    }

    public long afterSeekPlayStartPosition(long seekToPosition) {
        if (this.mAliyunScreenMode == AliyunScreenMode.Small && this.mSmallMutiSeekbar != null) {
            return this.mSmallMutiSeekbar.startPlayPosition(seekToPosition);
        }
        if (this.mAliyunScreenMode == AliyunScreenMode.Full && this.mLargeMutiSeekbar != null) {
            return this.mLargeMutiSeekbar.startPlayPosition(seekToPosition);
        }
        return seekToPosition;
    }

    public AdvVideoView.IntentPlayVideo getIntentPlayVideo(int currentPosition, int seekToPosition) {
        if (this.mAliyunScreenMode == AliyunScreenMode.Small && this.mSmallMutiSeekbar != null) {
            return this.mSmallMutiSeekbar.getIntentPlayVideo(currentPosition, seekToPosition);
        }
        if (this.mAliyunScreenMode == AliyunScreenMode.Full && this.mLargeMutiSeekbar != null) {
            return this.mLargeMutiSeekbar.getIntentPlayVideo(currentPosition, seekToPosition);
        }
        return AdvVideoView.IntentPlayVideo.NORMAL;
    }

    public AdvVideoView.VideoState getCurrentVideoState() {
        return this.mCurrentVideoState;
    }

    private boolean isVideoPositionInStart(int mVideoPosition) {
        return mVideoPosition >= 0 && (long)mVideoPosition <= this.mAdvDuration;
    }

    private boolean isVideoPositionInMiddle(int mVideoPosition) {
        if (this.mAdvPosition == MutiSeekBarView.AdvPosition.ALL || this.mAdvPosition == MutiSeekBarView.AdvPosition.START_MIDDLE) {
            return (long)mVideoPosition >= this.mSourceDuration / 2L + this.mAdvDuration && (long)mVideoPosition <= this.mSourceDuration / 2L + this.mAdvDuration * 2L;
        }
        if (this.mAdvPosition == MutiSeekBarView.AdvPosition.START_END || this.mAdvPosition == MutiSeekBarView.AdvPosition.ONLY_START || this.mAdvPosition == MutiSeekBarView.AdvPosition.ONLY_END) {
            return false;
        }
        return (long)mVideoPosition >= this.mSourceDuration / 2L && (long)mVideoPosition <= this.mSourceDuration / 2L + this.mAdvDuration;
    }

    private boolean isVideoPositionInEnd(int mVideoPosition) {
        if (this.mAdvPosition == MutiSeekBarView.AdvPosition.ALL || this.mAdvPosition == MutiSeekBarView.AdvPosition.START_MIDDLE) {
            return (long)mVideoPosition >= this.mSourceDuration + this.mAdvDuration * 2L;
        }
        if (this.mAdvPosition == MutiSeekBarView.AdvPosition.ONLY_START || this.mAdvPosition == MutiSeekBarView.AdvPosition.ONLY_MIDDLE || this.mAdvPosition == MutiSeekBarView.AdvPosition.START_END || this.mAdvPosition == MutiSeekBarView.AdvPosition.MIDDLE_END) {
            return (long)mVideoPosition >= this.mSourceDuration + this.mAdvDuration;
        }
        return (long)mVideoPosition >= this.mSourceDuration;
    }

    public void setAdvVideoPosition(int advTotalPosition, int sourcePosition) {
        this.mAdvVideoPosition = advTotalPosition;
        this.mVideoPosition = sourcePosition;
        this.updateSmallInfoBar();
        this.updateLargeInfoBar();
    }

    public int getVideoPosition() {
        return this.mVideoPosition;
    }

    private void updateAllViews() {
        this.updateTitleView();
        this.updateScreenLockBtn();
        this.updatePlayStateBtn();
        this.updateLargeInfoBar();
        this.updateSmallInfoBar();
        this.updateScreenModeBtn();
        this.updateAllTitleBar();
        this.updateAllControlBar();
        this.updateShowMoreBtn();
        this.updateScreenShotBtn();
        this.updateScreenRecorderBtn();
        this.updateInputDanmakuView();
    }

    private void updateAllControlBar() {
        boolean canShow;
        boolean bl = canShow = this.mControlBarCanShow && !this.mScreenLocked;
        if (this.mControlBar != null) {
            this.mControlBar.setVisibility(canShow ? 0 : 4);
        }
        if (this.mInputDanmkuImageView != null) {
            this.mInputDanmkuImageView.setVisibility(canShow ? 0 : 4);
        }
    }

    private void updateAllTitleBar() {
        boolean canShow;
        boolean bl = canShow = this.mTitleBarCanShow && !this.mScreenLocked;
        if (this.mTitleBar != null) {
            this.mTitleBar.setVisibility(canShow ? 0 : 4);
        }
    }

    private void updateTitleView() {
        if (this.mAliyunMediaInfo != null && this.mAliyunMediaInfo.getTitle() != null && !"null".equals(this.mAliyunMediaInfo.getTitle())) {
            this.mTitlebarText.setText((CharSequence)this.mAliyunMediaInfo.getTitle());
        } else {
            this.mTitlebarText.setText((CharSequence)"");
        }
    }

    private void updateSmallInfoBar() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Full) {
            this.mSmallInfoBar.setVisibility(4);
        } else if (this.mAliyunScreenMode == AliyunScreenMode.Small) {
            this.mTrackLinearLayout.setVisibility(8);
            this.mScreenModeBtn.setVisibility(0);
            if (GlobalPlayerConfig.IS_VIDEO && !this.mInScreenCosting) {
                this.setAdvVideoTotalDuration();
                this.mSmallMutiSeekbar.calculateWidth();
                if (!this.isSeekbarTouching) {
                    this.mSmallMutiSeekbar.setProgress(this.mAdvVideoPosition);
                    this.mSmallPositionText.setText((CharSequence)TimeFormater.formatMs(this.mVideoPosition));
                }
            } else {
                if (this.mAliyunMediaInfo != null) {
                    this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mMediaDuration)));
                    this.mSmallSeekbar.setMax(this.mMediaDuration);
                } else {
                    this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(0L)));
                    this.mSmallSeekbar.setMax(0);
                }
                if (!this.isSeekbarTouching) {
                    this.mSmallSeekbar.setSecondaryProgress(this.mVideoBufferPosition);
                    this.mSmallSeekbar.setProgress(this.mVideoPosition);
                    this.mSmallPositionText.setText((CharSequence)TimeFormater.formatMs(this.mVideoPosition));
                }
            }
            this.mSmallInfoBar.setVisibility(0);
        }
    }

    private void updateLargeInfoBar() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Small) {
            this.mLargeInfoBar.setVisibility(4);
        } else if (this.mAliyunScreenMode == AliyunScreenMode.Full) {
            this.mTrackLinearLayout.setVisibility(0);
            this.mScreenModeBtn.setVisibility(8);
            if (GlobalPlayerConfig.IS_VIDEO && !this.mInScreenCosting) {
                this.setAdvVideoTotalDuration();
                this.mLargeMutiSeekbar.calculateWidth();
                if (!this.isSeekbarTouching) {
                    this.mLargeMutiSeekbar.setProgress(this.mAdvVideoPosition);
                    this.mLargePositionText.setText((CharSequence)TimeFormater.formatMs(this.mVideoPosition));
                }
            } else {
                if (this.mAliyunMediaInfo != null) {
                    this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mMediaDuration));
                    this.mLargeSeekbar.setMax(this.mMediaDuration);
                } else {
                    this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(0L));
                    this.mLargeSeekbar.setMax(0);
                }
                if (!this.isSeekbarTouching) {
                    this.mLargeSeekbar.setSecondaryProgress(this.mVideoBufferPosition);
                    this.mLargeSeekbar.setProgress(this.mVideoPosition);
                    this.mLargePositionText.setText((CharSequence)TimeFormater.formatMs(this.mVideoPosition));
                }
                this.mLargeChangeQualityBtn.setText((CharSequence)QualityItem.getItem(this.getContext(), this.mCurrentQuality, this.isMtsSource).getName());
            }
            this.mLargeInfoBar.setVisibility(0);
        }
    }

    private void updateTrackInfoView() {
        this.mAudioTrackInfoList = this.getTrackInfoListWithTrackInfoType(TrackInfo.Type.TYPE_AUDIO);
        this.mBitrateTrackInfoList = this.getTrackInfoListWithTrackInfoType(TrackInfo.Type.TYPE_VIDEO);
        this.mDefinitionTrackInfoList = this.getTrackInfoListWithTrackInfoType(TrackInfo.Type.TYPE_VOD);
        this.mSubtitleTrackInfoList = this.getTrackInfoListWithTrackInfoType(TrackInfo.Type.TYPE_SUBTITLE);
        if (this.mAudioTrackInfoList == null || this.mAudioTrackInfoList.size() <= 0) {
            this.mAudioTextView.setVisibility(8);
        } else {
            this.mAudioTextView.setVisibility(0);
        }
        if (this.mBitrateTrackInfoList == null || this.mBitrateTrackInfoList.size() <= 0) {
            this.mBitrateTextView.setVisibility(8);
        } else {
            this.mBitrateTextView.setVisibility(0);
        }
        if (this.mSubtitleTrackInfoList == null || this.mSubtitleTrackInfoList.size() <= 0) {
            this.mSubtitleTextView.setVisibility(8);
        } else {
            this.mSubtitleTextView.setVisibility(0);
        }
        if (this.mDefinitionTrackInfoList == null || this.mDefinitionTrackInfoList.size() <= 0) {
            this.mDefinitionTextView.setVisibility(8);
        } else {
            this.mDefinitionTextView.setVisibility(0);
        }
    }

    private void setAdvVideoTotalDuration() {
        if (this.mAdvPosition == null) {
            return;
        }
        switch (this.mAdvPosition) {
            case ONLY_START: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration + this.mSourceDuration));
                break;
            }
            case ONLY_MIDDLE: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration + this.mSourceDuration));
                break;
            }
            case ONLY_END: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration + this.mSourceDuration));
                break;
            }
            case START_END: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration * 2L + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration * 2L + this.mSourceDuration));
                break;
            }
            case MIDDLE_END: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration * 2L + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration * 2L + this.mSourceDuration));
                break;
            }
            case START_MIDDLE: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration * 2L + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration * 2L + this.mSourceDuration));
                break;
            }
            case ALL: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration * 3L + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration * 3L + this.mSourceDuration));
                break;
            }
            default: {
                this.mSmallDurationText.setText((CharSequence)("/" + TimeFormater.formatMs(this.mAdvDuration * 3L + this.mSourceDuration)));
                this.mLargeDurationText.setText((CharSequence)TimeFormater.formatMs(this.mAdvDuration * 3L + this.mSourceDuration));
            }
        }
    }

    private void updateScreenModeBtn() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Full) {
            this.mScreenModeBtn.setImageResource(R.drawable.alivc_screen_mode_small);
        } else {
            this.mScreenModeBtn.setImageResource(R.drawable.alivc_screen_mode_large);
        }
    }

    private void updateScreenLockBtn() {
        if (this.mScreenLocked) {
            this.mScreenLockBtn.setImageResource(R.drawable.alivc_screen_lock);
        } else {
            this.mScreenLockBtn.setImageResource(R.drawable.alivc_screen_unlock);
        }
        if (this.mAliyunScreenMode == AliyunScreenMode.Full && !this.mInScreenCosting) {
            this.mScreenLockBtn.setVisibility(0);
        } else {
            this.mScreenLockBtn.setVisibility(8);
        }
        this.updateShowMoreBtn();
    }

    private void updatePlayStateBtn() {
        if (this.mPlayState == PlayState.NotPlaying) {
            this.mPlayStateBtn.setImageResource(R.drawable.alivc_playstate_play);
        } else if (this.mPlayState == PlayState.Playing) {
            this.mPlayStateBtn.setImageResource(R.drawable.alivc_playstate_pause);
        }
    }

    public void updateScreenCostPlayStateBtn(boolean showPlay) {
        if (showPlay) {
            this.mPlayStateBtn.setImageResource(R.drawable.alivc_playstate_play);
        } else {
            this.mPlayStateBtn.setImageResource(R.drawable.alivc_playstate_pause);
        }
    }

    protected void onVisibilityChanged(@Nullable View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.hideDelayed();
        }
    }

    public void setHideType(ViewAction.HideType hideType) {
        this.mHideType = hideType;
    }

    public boolean isNeedToPause(int currentPosition, int advVideoCount) {
        boolean needPause;
        if (this.mSourceDuration <= 0L) {
            return false;
        }
        switch (this.mAdvPosition) {
            case ONLY_START: {
                needPause = false;
                break;
            }
            case ONLY_END: 
            case START_END: {
                needPause = (long)currentPosition >= this.mSourceDuration;
                break;
            }
            case ONLY_MIDDLE: {
                needPause = (long)currentPosition >= this.mSourceDuration / 2L && advVideoCount == 0;
                break;
            }
            case START_MIDDLE: {
                needPause = (long)currentPosition >= this.mSourceDuration / 2L;
                break;
            }
            case MIDDLE_END: 
            case ALL: {
                needPause = (long)currentPosition >= this.mSourceDuration / 2L && advVideoCount == 1 || (long)currentPosition >= this.mSourceDuration;
                break;
            }
            default: {
                needPause = false;
            }
        }
        return needPause;
    }

    public void setTotalPosition(long mAdvTotalPosition) {
        this.mAdvTotalPosition = mAdvTotalPosition;
    }

    public void startScreenCost() {
        if (this.mScreenModeBtn != null) {
            this.mScreenModeBtn.setVisibility(4);
        }
        if (this.mScreenCostLinearLayout != null) {
            this.mScreenCostLinearLayout.setVisibility(0);
        }
        this.updateScreenCostPlayStateBtn(false);
        this.showNativeSeekBar();
        this.updateShowMoreBtn();
        this.updateScreenLockBtn();
        this.updateInputDanmakuView();
    }

    public void exitScreenCost() {
        this.updateShowMoreBtn();
        this.updateScreenLockBtn();
        this.updateInputDanmakuView();
        if (this.mScreenModeBtn != null) {
            this.mScreenModeBtn.setVisibility(0);
        }
        if (this.mScreenCostLinearLayout != null) {
            this.mScreenCostLinearLayout.setVisibility(8);
        }
        this.hideDelayed();
    }

    private void hideDelayed() {
        this.mHideHandler.removeMessages(0);
        this.mHideHandler.sendEmptyMessageDelayed(0, 5000L);
    }

    @Override
    public void reset() {
        this.mHideType = null;
        this.mAliyunMediaInfo = null;
        this.mVideoPosition = 0;
        this.mPlayState = PlayState.NotPlaying;
        this.isSeekbarTouching = false;
        this.showNativeSeekBar();
        this.updateAllViews();
    }

    public void closeAutoHide() {
        if (this.mHideHandler != null) {
            this.mHideHandler.removeMessages(0);
        }
        this.show();
    }

    public void openAutoHide() {
        if (this.mHideHandler != null) {
            this.hideDelayed();
        }
    }

    @Override
    public void show() {
        if (this.mHideType == ViewAction.HideType.End) {
            this.setVisibility(8);
            this.hideQualityDialog();
        } else {
            this.updateAllViews();
            this.setVisibility(0);
        }
    }

    @Override
    public void hide(ViewAction.HideType hideType) {
        if (this.mHideType != ViewAction.HideType.End) {
            this.mHideType = hideType;
        }
        if (this.mOnControlViewHideListener != null) {
            this.mOnControlViewHideListener.onControlViewHide();
        }
        this.setVisibility(8);
        this.hideQualityDialog();
    }

    private void hideQualityDialog() {
        if (this.mOnQualityBtnClickListener != null) {
            this.mOnQualityBtnClickListener.onHideQualityView();
        }
    }

    public void setVideoBufferPosition(int mVideoBufferPosition) {
        this.mVideoBufferPosition = mVideoBufferPosition;
        this.updateSmallInfoBar();
        this.updateLargeInfoBar();
    }

    public void setOnQualityBtnClickListener(OnQualityBtnClickListener l) {
        this.mOnQualityBtnClickListener = l;
    }

    public void setOnScreenLockClickListener(OnScreenLockClickListener l) {
        this.mOnScreenLockClickListener = l;
    }

    public void setOnScreenModeClickListener(OnScreenModeClickListener l) {
        this.mOnScreenModeClickListener = l;
    }

    public void setOnBackClickListener(OnBackClickListener l) {
        this.mOnBackClickListener = l;
    }

    public void setOnSeekListener(OnSeekListener onSeekListener) {
        this.mOnSeekListener = onSeekListener;
    }

    public void setOnPlayStateClickListener(OnPlayStateClickListener onPlayStateClickListener) {
        this.mOnPlayStateClickListener = onPlayStateClickListener;
    }

    public void setOnShowMoreClickListener(OnShowMoreClickListener listener) {
        this.mOnShowMoreClickListener = listener;
    }

    public void setOnScreenShotClickListener(OnScreenShotClickListener listener) {
        this.mOnScreenShotClickListener = listener;
    }

    public void setOnScreenRecoderClickListener(OnScreenRecoderClickListener listener) {
        this.mOnScreenRecoderClickListener = listener;
    }

    public void setOnControlViewHideListener(OnControlViewHideListener listener) {
        this.mOnControlViewHideListener = listener;
    }

    public void setOnInputDanmakuClickListener(OnInputDanmakuClickListener listener) {
        this.mOnInputDanmakuClickListener = listener;
    }

    public void setOnDLNAControlListener(OnDLNAControlListener listener) {
        this.mOnDLNAControlListener = listener;
    }

    public void setOnTrackInfoClickListener(OnTrackInfoClickListener listener) {
        this.mOnTrackInfoClickListener = listener;
    }

    public int getMutiSeekBarCurrentProgress() {
        return this.mMutiSeekBarCurrentProgress;
    }

    public void setMutiSeekBarInfo(long advTime, long sourceTime, MutiSeekBarView.AdvPosition advPosition) {
        this.mAdvDuration = advTime;
        this.mSourceDuration = sourceTime;
        this.mAdvPosition = advPosition;
    }

    public void hideNativeSeekBar() {
        if (this.mSmallMutiSeekbar != null) {
            this.mSmallMutiSeekbar.setVisibility(0);
            this.mSmallMutiSeekbar.post(new Runnable(){

                @Override
                public void run() {
                    ControlView.this.mSmallMutiSeekbar.setTime(ControlView.this.mAdvDuration, ControlView.this.mSourceDuration, ControlView.this.mAdvPosition);
                }
            });
        }
        if (this.mLargeMutiSeekbar != null) {
            this.mLargeMutiSeekbar.setVisibility(0);
            this.mLargeMutiSeekbar.post(new Runnable(){

                @Override
                public void run() {
                    ControlView.this.mLargeMutiSeekbar.setTime(ControlView.this.mAdvDuration, ControlView.this.mSourceDuration, ControlView.this.mAdvPosition);
                }
            });
        }
        if (this.mInScreenCosting) {
            if (this.mSmallMutiSeekbar != null) {
                this.mSmallMutiSeekbar.setVisibility(8);
            }
            if (this.mLargeMutiSeekbar != null) {
                this.mLargeMutiSeekbar.setVisibility(8);
            }
        } else {
            if (this.mSmallSeekbar != null) {
                this.mSmallSeekbar.setVisibility(8);
            }
            if (this.mLargeSeekbar != null) {
                this.mLargeSeekbar.setVisibility(8);
            }
        }
    }

    public void showNativeSeekBar() {
        if (this.mSmallSeekbar != null) {
            this.mSmallSeekbar.setVisibility(0);
        }
        if (this.mLargeSeekbar != null) {
            this.mLargeSeekbar.setVisibility(0);
        }
        if (this.mSmallMutiSeekbar != null) {
            this.mSmallMutiSeekbar.setVisibility(8);
        }
        if (this.mLargeMutiSeekbar != null) {
            this.mLargeMutiSeekbar.setVisibility(8);
        }
    }

    public void setDotInfo(List<DotBean> dotBean) {
        this.mDotBean = dotBean;
    }

    public void initDotView() {
        if (this.mDotBean == null) {
            return;
        }
        FrameLayout seekBarGrandParent = (FrameLayout)this.mLargeSeekbar.getParent();
        ArrayList<DotView> dotViewList = new ArrayList<DotView>();
        for (DotBean dotBean : this.mDotBean) {
            DotView mDotView = new DotView(this.getContext());
            mDotView.setDotTime(dotBean.getTime());
            mDotView.setDotMsg(dotBean.getContent());
            dotViewList.add(mDotView);
            seekBarGrandParent.removeView((View)mDotView);
            seekBarGrandParent.addView((View)mDotView);
        }
        for (final DotView dotView : dotViewList) {
            dotView.post(new Runnable(){

                @Override
                public void run() {
                    if (ControlView.this.mAliyunMediaInfo == null) {
                        return;
                    }
                    ControlView.this.reLayoutDotView(ControlView.this.mAliyunMediaInfo.getDuration() / 1000, dotView);
                }
            });
        }
    }

    private void reLayoutDotView(long mDuration, final DotView dotView) {
        int measuredWidth = this.mLargeSeekbar.getMeasuredWidth();
        if (mDuration <= 0L || measuredWidth <= 0) {
            return;
        }
        int currentPosition = Integer.valueOf(dotView.getDotTime());
        double xposition = (double)measuredWidth * 1.0 / (double)mDuration * (double)currentPosition;
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)dotView.getLayoutParams();
        layoutParams.leftMargin = (int)((double)this.mLargeSeekbar.getPaddingLeft() + xposition - (double)(dotView.getRootWidth() / 2));
        dotView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        dotView.setOnDotViewClickListener(new DotView.OnDotViewClickListener(){

            @Override
            public void onDotViewClick() {
                int[] position = new int[2];
                dotView.getLocationInWindow(position);
                ControlView.this.mOnDotViewClickListener.onDotViewClick(position[0], position[1], dotView);
            }
        });
    }

    public void setOnDotViewClickListener(OnDotViewClickListener listener) {
        this.mOnDotViewClickListener = listener;
    }

    public static interface OnDotViewClickListener {
        public void onDotViewClick(int var1, int var2, DotView var3);
    }

    public static interface OnTrackInfoClickListener {
        public void onSubtitleClick(List<TrackInfo> var1);

        public void onAudioClick(List<TrackInfo> var1);

        public void onBitrateClick(List<TrackInfo> var1);

        public void onDefinitionClick(List<TrackInfo> var1);
    }

    public static interface OnDLNAControlListener {
        public void onExit();

        public void onChangeQuality();
    }

    public static interface OnInputDanmakuClickListener {
        public void onInputDanmakuClick();
    }

    public static interface OnControlViewHideListener {
        public void onControlViewHide();
    }

    public static interface OnScreenRecoderClickListener {
        public void onScreenRecoderClick();
    }

    public static interface OnScreenShotClickListener {
        public void onScreenShotClick();
    }

    public static interface OnShowMoreClickListener {
        public void showMore();
    }

    public static interface OnPlayStateClickListener {
        public void onPlayStateClick();
    }

    public static enum PlayState {
        Playing,
        NotPlaying;

    }

    public static interface OnSeekListener {
        public void onSeekEnd(int var1);

        public void onSeekStart(int var1);

        public void onProgressChanged(int var1);
    }

    public static interface OnBackClickListener {
        public void onClick();
    }

    public static interface OnScreenModeClickListener {
        public void onClick();
    }

    public static interface OnScreenLockClickListener {
        public void onClick();
    }

    public static interface OnQualityBtnClickListener {
        public void onQualityBtnClick(View var1, List<TrackInfo> var2, String var3);

        public void onHideQualityView();
    }

    private static class HideHandler
    extends Handler {
        private WeakReference<ControlView> controlViewWeakReference;

        public HideHandler(ControlView controlView) {
            this.controlViewWeakReference = new WeakReference<ControlView>(controlView);
        }

        public void handleMessage(Message msg) {
            ControlView controlView = (ControlView)this.controlViewWeakReference.get();
            if (controlView != null && !controlView.isSeekbarTouching && !controlView.mInScreenCosting) {
                controlView.hide(ViewAction.HideType.Normal);
            }
            super.handleMessage(msg);
        }
    }
}

