/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.gesture;

import android.app.Activity;
import android.view.View;
import com.aliyun.player.alivcplayerexpand.view.gesturedialog.BrightnessDialog;
import com.aliyun.player.alivcplayerexpand.view.gesturedialog.SeekDialog;
import com.aliyun.player.alivcplayerexpand.view.gesturedialog.VolumeDialog;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;

public class GestureDialogManager {
    private Activity mActivity;
    private SeekDialog mSeekDialog = null;
    private BrightnessDialog mBrightnessDialog = null;
    private VolumeDialog mVolumeDialog = null;
    private AliyunScreenMode mCurrentScreenMode = AliyunScreenMode.Small;

    public GestureDialogManager(Activity activity) {
        this.mActivity = activity;
    }

    public void showSeekDialog(View parent, int targetPosition) {
        if (this.mSeekDialog == null) {
            this.mSeekDialog = new SeekDialog(this.mActivity, targetPosition);
        }
        if (!this.mSeekDialog.isShowing()) {
            this.mSeekDialog.show(parent);
            this.mSeekDialog.updatePosition(targetPosition);
        }
    }

    public void updateSeekDialog(long duration, long currentPosition, long deltaPosition) {
        int targetPosition = this.mSeekDialog.getTargetPosition(duration, currentPosition, deltaPosition);
        this.mSeekDialog.updatePosition(targetPosition);
    }

    public int dismissSeekDialog() {
        int seekPosition = -1;
        if (this.mSeekDialog != null && this.mSeekDialog.isShowing()) {
            seekPosition = this.mSeekDialog.getFinalPosition();
            this.mSeekDialog.dismiss();
        }
        this.mSeekDialog = null;
        return seekPosition;
    }

    public void showBrightnessDialog(View parent, int currentBrightness) {
        if (this.mBrightnessDialog == null) {
            this.mBrightnessDialog = new BrightnessDialog(this.mActivity, currentBrightness);
        }
        if (!this.mBrightnessDialog.isShowing()) {
            this.mBrightnessDialog.setScreenMode(this.mCurrentScreenMode);
            this.mBrightnessDialog.show(parent);
            this.mBrightnessDialog.updateBrightness(currentBrightness);
        }
    }

    public int updateBrightnessDialog(int changePercent) {
        int targetBrightnessPercent = this.mBrightnessDialog.getTargetBrightnessPercent(changePercent);
        this.mBrightnessDialog.updateBrightness(targetBrightnessPercent);
        return targetBrightnessPercent;
    }

    public void dismissBrightnessDialog() {
        if (this.mBrightnessDialog != null && this.mBrightnessDialog.isShowing()) {
            this.mBrightnessDialog.dismiss();
        }
        this.mBrightnessDialog = null;
    }

    public void initDialog(Activity activity, float currentPercent) {
        this.mActivity = activity;
        if (this.mVolumeDialog == null) {
            this.mVolumeDialog = new VolumeDialog(activity, currentPercent);
        }
    }

    public void showVolumeDialog(View parent, float currentPercent) {
        if (this.mVolumeDialog == null) {
            this.mVolumeDialog = new VolumeDialog(this.mActivity, currentPercent);
        }
        if (!this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.setScreenMode(this.mCurrentScreenMode);
            this.mVolumeDialog.show(parent);
            this.mVolumeDialog.updateVolume(currentPercent);
        }
    }

    public boolean isVolumeDialogIsShow() {
        if (this.mVolumeDialog == null) {
            return false;
        }
        return this.mVolumeDialog.isShowing();
    }

    public float updateVolumeDialog(int changePercent) {
        float targetVolume = this.mVolumeDialog.getTargetVolume(changePercent);
        this.mVolumeDialog.updateVolume(targetVolume);
        return targetVolume;
    }

    public void dismissVolumeDialog() {
        if (this.mVolumeDialog != null && this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.dismiss();
        }
        this.mVolumeDialog = null;
    }

    public void setCurrentScreenMode(AliyunScreenMode currentScreenMode) {
        this.mCurrentScreenMode = currentScreenMode;
    }
}

