/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.softinput;

import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.svideo.common.base.BaseDialogFragment;

public class SoftInputDialogFragment
extends BaseDialogFragment {
    private EditText mEditText;
    private TextView mTextView;
    private OnBarrageSendClickListener mOnBarrageSendClickListener;

    public static SoftInputDialogFragment newInstance() {
        SoftInputDialogFragment dialogFragment = new SoftInputDialogFragment();
        return dialogFragment;
    }

    protected int getLayoutRes() {
        return R.layout.alivc_softinput_send_danmaku;
    }

    protected void bindView(View view) {
        this.mTextView = (TextView)view.findViewById(R.id.alivc_tv_input_send);
        this.mEditText = (EditText)view.findViewById(R.id.alivc_et_input_danmu);
        this.initView();
    }

    private void initView() {
        this.mEditText.findFocus();
        this.mEditText.setFocusable(true);
        this.mEditText.setFocusableInTouchMode(true);
        this.mEditText.requestFocus();
        this.mEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(40)});
        this.mEditText.setImeOptions(0x10000000);
        this.mEditText.setSingleLine(true);
        this.showSoftInput(this.mEditText);
        this.mEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                int mTextMaxlenght = 0;
                Editable editable = SoftInputDialogFragment.this.mEditText.getText();
                String str = editable.toString().trim();
                int selEndIndex = Selection.getSelectionEnd((CharSequence)editable);
                for (int i = 0; i < str.length(); ++i) {
                    char charAt = str.charAt(i);
                    mTextMaxlenght = charAt >= ' ' && charAt <= 'z' ? ++mTextMaxlenght : (mTextMaxlenght += 2);
                    if (mTextMaxlenght <= 40) continue;
                    String newStr = str.substring(0, i);
                    SoftInputDialogFragment.this.mEditText.setText((CharSequence)newStr);
                    editable = SoftInputDialogFragment.this.mEditText.getText();
                    int newLen = editable.length();
                    if (selEndIndex > newLen) {
                        selEndIndex = editable.length();
                    }
                    Selection.setSelection((Spannable)editable, (int)selEndIndex);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.mTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SoftInputDialogFragment.this.mOnBarrageSendClickListener != null) {
                    String danmu = SoftInputDialogFragment.this.mEditText.getText().toString();
                    SoftInputDialogFragment.this.mOnBarrageSendClickListener.onBarrageSendClick(danmu);
                }
            }
        });
    }

    public void setOnBarrageSendClickListener(OnBarrageSendClickListener listener) {
        this.mOnBarrageSendClickListener = listener;
    }

    private void showSoftInput(EditText mEditText) {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.showSoftInput((View)mEditText, 0);
    }

    public static interface OnBarrageSendClickListener {
        public void onBarrageSendClick(String var1);
    }
}

