/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.download;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.util.DensityUtil;
import com.aliyun.player.alivcplayerexpand.util.FixedToastUtils;
import com.aliyun.player.alivcplayerexpand.util.ImageLoader;
import com.aliyun.player.alivcplayerexpand.util.WrapCheckGroup;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AddDownloadView
extends LinearLayout {
    private AliyunScreenMode screenMode;
    private ImageView ivVideoCover;
    private TextView tvAddDownloadViewTitle;
    private TextView tvAddDownloadViewSize;
    private Button downloadBtn;
    private WrapCheckGroup wrapCheckGroup;
    private Map<String, String> qualityList = new HashMap<String, String>();
    private RadioGroup rgQualityList;
    private AliyunDownloadMediaInfo downLoadTag;
    private OnViewClickListener onViewClickListener;
    private OnShowNativeVideoBtnClickListener onShowVideoListLisener;

    public AddDownloadView(Context context) {
        super(context);
        this.init();
    }

    public AddDownloadView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AddDownloadView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public AddDownloadView(Context context, AliyunScreenMode screenMode) {
        super(context);
        this.screenMode = screenMode;
        this.init();
    }

    private void init() {
        if (this.screenMode == AliyunScreenMode.Small) {
            LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_add_download, (ViewGroup)this, true);
            this.findAllViews();
        } else {
            LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_add_download_horizontal, (ViewGroup)this, true);
            this.findAllViewsByFullScreen();
        }
        this.qualityList.put("FD", this.getContext().getString(R.string.alivc_fd_definition));
        this.qualityList.put("LD", this.getContext().getString(R.string.alivc_ld_definition));
        this.qualityList.put("SD", this.getContext().getString(R.string.alivc_sd_definition));
        this.qualityList.put("HD", this.getContext().getString(R.string.alivc_hd_definition));
        this.qualityList.put("2K", this.getContext().getString(R.string.alivc_k2_definition));
        this.qualityList.put("4K", this.getContext().getString(R.string.alivc_k4_definition));
        this.qualityList.put("OD", this.getContext().getString(R.string.alivc_od_definition));
        this.qualityList.put("SQ", this.getContext().getString(R.string.alivc_sq_definition));
        this.qualityList.put("HQ", this.getContext().getString(R.string.alivc_hq_definition));
    }

    private void findAllViewsByFullScreen() {
        this.ivVideoCover = (ImageView)this.findViewById(R.id.iv_video_cover);
        this.tvAddDownloadViewTitle = (TextView)this.findViewById(R.id.tv_add_download_view_title);
        this.tvAddDownloadViewSize = (TextView)this.findViewById(R.id.tv_add_download_view_size);
        this.rgQualityList = (RadioGroup)this.findViewById(R.id.rg_quality_list);
        this.findViewById(R.id.iv_download_dialog_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddDownloadView.this.onViewClickListener != null) {
                    AddDownloadView.this.onViewClickListener.onCancel();
                }
            }
        });
        this.findViewById(R.id.alivc_download_start).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddDownloadView.this.onViewClickListener != null) {
                    AddDownloadView.this.onViewClickListener.onDownload(AddDownloadView.this.downLoadTag);
                }
            }
        });
        this.findViewById(R.id.alivc_current_download).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddDownloadView.this.onShowVideoListLisener != null) {
                    AddDownloadView.this.onShowVideoListLisener.onShowVideo();
                }
            }
        });
    }

    public void onPrepared(List<AliyunDownloadMediaInfo> infos) {
        this.showAllDownloadItems(infos);
    }

    private void showAllDownloadItems(List<AliyunDownloadMediaInfo> list) {
        if (list == null || list.isEmpty()) {
            FixedToastUtils.show(this.getContext().getApplicationContext(), R.string.no_download_right);
            return;
        }
        Log.d((String)"demo", (String)("list size = " + list.size()));
        RadioGroup.LayoutParams layoutParams = new RadioGroup.LayoutParams(-2, -2, 1.0f);
        layoutParams.setMargins(0, 0, DensityUtil.px2dip(this.getContext(), 16.0f), 0);
        int infoSize = list.size();
        Iterator<AliyunDownloadMediaInfo> iterator = list.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            AliyunDownloadMediaInfo info = iterator.next();
            String encript = info.isEncripted() == 1 ? this.getContext().getString(R.string.encrypted) : this.getContext().getString(R.string.encrypted_no);
            RadioButton item = (RadioButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_item_quality, (ViewGroup)new FrameLayout(this.getContext()), false);
            item.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            item.setText((CharSequence)this.qualityList.get(info.getQuality()));
            item.setTag((Object)info);
            int id2 = R.id.custom_id_min + i;
            item.setId(id2);
            this.rgQualityList.addView((View)item);
            ++i;
        }
        if (this.rgQualityList.getChildCount() > 0) {
            int checkId = this.rgQualityList.getChildAt(0).getId();
            this.rgQualityList.check(checkId);
            this.downLoadTag = (AliyunDownloadMediaInfo)this.rgQualityList.findViewById(checkId).getTag();
        }
        this.rgQualityList.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                RadioButton rbChecked = (RadioButton)AddDownloadView.this.findViewById(checkedId);
                if (rbChecked == null) {
                    FixedToastUtils.show(AddDownloadView.this.getContext().getApplicationContext(), R.string.choose_a_definition_to_download);
                    return;
                }
                AddDownloadView.this.downLoadTag = (AliyunDownloadMediaInfo)rbChecked.getTag();
                AddDownloadView.this.tvAddDownloadViewSize.setText((CharSequence)AddDownloadView.this.formatSizeDecimal(AddDownloadView.this.downLoadTag.getSize()));
            }
        });
        new ImageLoader(this.ivVideoCover).loadAsync(list.get(0).getCoverUrl());
        this.tvAddDownloadViewTitle.setText((CharSequence)list.get(0).getTitle());
        this.tvAddDownloadViewSize.setText((CharSequence)this.formatSizeDecimal(list.get(0).getSize()));
    }

    private String formatSize(long size) {
        int kb = (int)((float)size / 1024.0f);
        if (kb < 1024) {
            return kb + "KB";
        }
        int mb = (int)((float)kb / 1024.0f);
        return mb + "MB";
    }

    private String formatSizeDecimal(long size) {
        float kb = (float)(size / 1024L) * 1.0f;
        BigDecimal bigDecimal = new BigDecimal(kb);
        if (kb < 1024.0f) {
            return String.format("%.1f", bigDecimal.setScale(2, RoundingMode.HALF_UP)) + "KB";
        }
        float mb = kb / 1024.0f * 1.0f;
        BigDecimal decimal = new BigDecimal(mb);
        return String.format("%.1f", decimal.setScale(2, RoundingMode.HALF_UP)) + "MB";
    }

    private void findAllViews() {
        this.ivVideoCover = (ImageView)this.findViewById(R.id.iv_video_cover);
        this.tvAddDownloadViewTitle = (TextView)this.findViewById(R.id.tv_add_download_view_title);
        this.tvAddDownloadViewSize = (TextView)this.findViewById(R.id.tv_add_download_view_size);
        this.downloadBtn = (Button)this.findViewById(R.id.download);
        this.rgQualityList = (RadioGroup)this.findViewById(R.id.rg_quality_list);
        this.rgQualityList.removeAllViews();
        this.downloadBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddDownloadView.this.downloadItem();
            }
        });
        this.findViewById(R.id.iv_download_dialog_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddDownloadView.this.onViewClickListener != null) {
                    AddDownloadView.this.onViewClickListener.onCancel();
                }
            }
        });
    }

    private void downloadItem() {
        if (this.onViewClickListener != null) {
            this.onViewClickListener.onDownload(this.downLoadTag);
        }
    }

    public void setOnViewClickListener(OnViewClickListener l) {
        this.onViewClickListener = l;
    }

    public void setOnShowVideoListLisener(OnShowNativeVideoBtnClickListener listener) {
        this.onShowVideoListLisener = listener;
    }

    public static interface OnShowNativeVideoBtnClickListener {
        public void onShowVideo();
    }

    public static interface OnViewClickListener {
        public void onCancel();

        public void onDownload(AliyunDownloadMediaInfo var1);
    }
}

