/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.function;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.aliyunplayerbase.util.ScreenUtils;
import java.lang.ref.WeakReference;

public class MarqueeView
extends FrameLayout {
    private static final int START = 1;
    private static final int PAUSE = 2;
    private static final int STOP = 3;
    private int mCurrentState = -1;
    private int mInterval = 5000;
    private int mTextSize = 14;
    private int mTextColor = this.getResources().getColor(R.color.alivc_common_font_white_light);
    private String mFlipText = this.getResources().getString(R.string.alivc_marquee_test);
    private ObjectAnimator objectAnimator;
    private boolean isStart = false;
    private boolean isAnimStart = false;
    private Context mContext;
    private MarQueeHandler mMarQueeHandler;
    private View view;
    private TextView mContentTextView;
    private RelativeLayout mMarqueeRootRelativeLayout;
    private AliyunScreenMode mScreenMode = AliyunScreenMode.Small;

    public MarqueeView(Context context) {
        super(context);
        this.init(context);
    }

    public MarqueeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.alivc_marquee_view, (ViewGroup)this);
        this.initView();
        this.initHandler();
    }

    private void initView() {
        this.mContentTextView = (TextView)this.view.findViewById(R.id.tv_content);
        this.mMarqueeRootRelativeLayout = (RelativeLayout)this.view.findViewById(R.id.marquee_root);
        this.mContentTextView.setText((CharSequence)this.mFlipText);
    }

    private void initHandler() {
        this.mMarQueeHandler = new MarQueeHandler(this);
    }

    public void setInterval(int milliseconds) {
        if (milliseconds < 5000) {
            milliseconds = 5000;
        }
        this.mInterval = milliseconds;
        this.objectAnimator.setDuration((long)this.mInterval);
    }

    public void setTextSize(int size) {
        this.mTextSize = size;
        this.mContentTextView.setText(this.mTextSize);
    }

    public void setTextColor(int color2) {
        this.mTextColor = color2;
        this.mContentTextView.setTextColor(this.mTextColor);
    }

    public void setText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.mFlipText = text;
        this.mContentTextView.setText((CharSequence)this.mFlipText);
    }

    public boolean isStart() {
        return this.isStart;
    }

    public void startFlip() {
        if (this.mScreenMode == AliyunScreenMode.Small) {
            return;
        }
        this.mCurrentState = 1;
        this.mMarqueeRootRelativeLayout.setVisibility(0);
        this.isStart = true;
        if (this.mMarQueeHandler != null) {
            this.mMarQueeHandler.sendEmptyMessage(1);
        }
    }

    public void stopFlip() {
        this.mCurrentState = 3;
        this.mMarqueeRootRelativeLayout.setVisibility(4);
        this.isStart = false;
        if (this.mMarQueeHandler != null) {
            this.mMarQueeHandler.removeCallbacksAndMessages(null);
        }
    }

    public void pause() {
        this.mCurrentState = 2;
        this.mMarqueeRootRelativeLayout.setVisibility(4);
        if (this.mMarQueeHandler != null) {
            this.mMarQueeHandler.removeCallbacksAndMessages(null);
        }
    }

    public void setScreenMode(AliyunScreenMode screenMode) {
        this.mScreenMode = screenMode;
    }

    public void createAnimation() {
        int textWidth = this.mContentTextView.getMeasuredWidth();
        int screenWidth = ScreenUtils.getWidth((Context)this.getContext());
        if (this.objectAnimator == null) {
            this.objectAnimator = ObjectAnimator.ofFloat((Object)this.mContentTextView, (String)"translationX", (float[])new float[]{textWidth, -screenWidth});
            this.objectAnimator.setDuration((long)this.mInterval);
            this.objectAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    if (MarqueeView.this.mMarqueeRootRelativeLayout != null) {
                        MarqueeView.this.mMarqueeRootRelativeLayout.setVisibility(0);
                    }
                    MarqueeView.this.isAnimStart = true;
                }

                public void onAnimationEnd(Animator animation) {
                    if (MarqueeView.this.mMarqueeRootRelativeLayout != null) {
                        MarqueeView.this.mMarqueeRootRelativeLayout.setVisibility(4);
                    }
                    MarqueeView.this.isAnimStart = false;
                    MarqueeView.this.mMarQueeHandler.sendEmptyMessageDelayed(1, 2000L);
                }

                public void onAnimationCancel(Animator animation) {
                    MarqueeView.this.isAnimStart = false;
                    if (MarqueeView.this.mMarqueeRootRelativeLayout != null) {
                        MarqueeView.this.mMarqueeRootRelativeLayout.setVisibility(4);
                    }
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    public static enum MarqueeRegion {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    private static class MarQueeHandler
    extends Handler {
        private WeakReference<MarqueeView> weakReference;

        public MarQueeHandler(MarqueeView marqueeView) {
            this.weakReference = new WeakReference<MarqueeView>(marqueeView);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MarqueeView marqueeView = (MarqueeView)((Object)this.weakReference.get());
                    if (marqueeView == null) break;
                    if (marqueeView.mScreenMode == AliyunScreenMode.Small) {
                        marqueeView.stopFlip();
                        return;
                    }
                    if (marqueeView.isAnimStart || marqueeView.mCurrentState != 1) break;
                    marqueeView.objectAnimator.start();
                    break;
                }
            }
        }
    }
}

