/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.speed;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.listener.LockPortraitListener;
import com.aliyun.player.alivcplayerexpand.theme.ITheme;
import com.aliyun.player.alivcplayerexpand.theme.Theme;
import com.aliyun.player.alivcplayerexpand.widget.AliyunVodPlayerView;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;

public class SpeedView
extends RelativeLayout
implements ITheme {
    private static final String TAG = SpeedView.class.getSimpleName();
    private SpeedValue mSpeedValue;
    private View mMainSpeedView;
    private Animation showAnim;
    private Animation hideAnim;
    private boolean animEnd = true;
    private RadioButton mNormalBtn;
    private RadioButton mOneQrtTimeBtn;
    private RadioButton mOneHalfTimeBtn;
    private RadioButton mTwoTimeBtn;
    private TextView mSpeedTip;
    private AliyunScreenMode mScreenMode;
    private OnSpeedClickListener mOnSpeedClickListener = null;
    private boolean mSpeedChanged = false;
    private int mSpeedDrawable = R.drawable.alivc_speed_dot_blue;
    private int mSpeedTextColor = R.color.alivc_blue;
    private View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (SpeedView.this.mOnSpeedClickListener == null) {
                return;
            }
            if (view == SpeedView.this.mNormalBtn) {
                SpeedView.this.mOnSpeedClickListener.onSpeedClick(SpeedValue.Normal);
            } else if (view == SpeedView.this.mOneQrtTimeBtn) {
                SpeedView.this.mOnSpeedClickListener.onSpeedClick(SpeedValue.OneQuartern);
            } else if (view == SpeedView.this.mOneHalfTimeBtn) {
                SpeedView.this.mOnSpeedClickListener.onSpeedClick(SpeedValue.OneHalf);
            } else if (view == SpeedView.this.mTwoTimeBtn) {
                SpeedView.this.mOnSpeedClickListener.onSpeedClick(SpeedValue.Twice);
            }
        }
    };

    public SpeedView(Context context) {
        super(context);
        this.init();
    }

    public SpeedView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SpeedView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.alivc_view_speed, (ViewGroup)this, true);
        this.mMainSpeedView = this.findViewById(R.id.speed_view);
        this.mMainSpeedView.setVisibility(4);
        this.mOneQrtTimeBtn = (RadioButton)this.findViewById(R.id.one_quartern);
        this.mNormalBtn = (RadioButton)this.findViewById(R.id.normal);
        this.mOneHalfTimeBtn = (RadioButton)this.findViewById(R.id.one_half);
        this.mTwoTimeBtn = (RadioButton)this.findViewById(R.id.two);
        this.mSpeedTip = (TextView)this.findViewById(R.id.speed_tip);
        this.mSpeedTip.setVisibility(4);
        this.mOneQrtTimeBtn.setOnClickListener(this.mClickListener);
        this.mNormalBtn.setOnClickListener(this.mClickListener);
        this.mOneHalfTimeBtn.setOnClickListener(this.mClickListener);
        this.mTwoTimeBtn.setOnClickListener(this.mClickListener);
        this.showAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.view_speed_show);
        this.hideAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.view_speed_hide);
        this.showAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SpeedView.this.animEnd = false;
                SpeedView.this.mMainSpeedView.setVisibility(0);
            }

            public void onAnimationEnd(Animation animation) {
                SpeedView.this.animEnd = true;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.hideAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SpeedView.this.animEnd = false;
            }

            public void onAnimationEnd(Animation animation) {
                SpeedView.this.mMainSpeedView.setVisibility(4);
                if (SpeedView.this.mOnSpeedClickListener != null) {
                    SpeedView.this.mOnSpeedClickListener.onHide();
                }
                if (SpeedView.this.mSpeedChanged) {
                    String times = "";
                    if (SpeedView.this.mSpeedValue == SpeedValue.OneQuartern) {
                        times = SpeedView.this.getResources().getString(R.string.alivc_speed_optf_times);
                    } else if (SpeedView.this.mSpeedValue == SpeedValue.Normal) {
                        times = SpeedView.this.getResources().getString(R.string.alivc_speed_one_times);
                    } else if (SpeedView.this.mSpeedValue == SpeedValue.OneHalf) {
                        times = SpeedView.this.getResources().getString(R.string.alivc_speed_opt_times);
                    } else if (SpeedView.this.mSpeedValue == SpeedValue.Twice) {
                        times = SpeedView.this.getResources().getString(R.string.alivc_speed_twice_times);
                    }
                    String tips = SpeedView.this.getContext().getString(R.string.alivc_speed_tips, new Object[]{times});
                    SpeedView.this.mSpeedTip.setText((CharSequence)tips);
                    SpeedView.this.mSpeedTip.setVisibility(0);
                    SpeedView.this.mSpeedTip.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SpeedView.this.mSpeedTip.setVisibility(4);
                        }
                    }, 1000L);
                }
                SpeedView.this.animEnd = true;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.setSpeed(SpeedValue.Normal);
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new MyLayoutListener());
    }

    @Override
    public void setTheme(Theme theme) {
        this.mSpeedDrawable = R.drawable.alivc_speed_dot_blue;
        this.mSpeedTextColor = R.color.alivc_blue;
        if (theme == Theme.Blue) {
            this.mSpeedDrawable = R.drawable.alivc_speed_dot_blue;
            this.mSpeedTextColor = R.color.alivc_blue;
        } else if (theme == Theme.Green) {
            this.mSpeedDrawable = R.drawable.alivc_speed_dot_green;
            this.mSpeedTextColor = R.color.alivc_green;
        } else if (theme == Theme.Orange) {
            this.mSpeedDrawable = R.drawable.alivc_speed_dot_orange;
            this.mSpeedTextColor = R.color.alivc_orange;
        } else if (theme == Theme.Red) {
            this.mSpeedDrawable = R.drawable.alivc_speed_dot_red;
            this.mSpeedTextColor = R.color.alivc_red;
        }
        this.updateBtnTheme();
    }

    private void setRadioButtonTheme(RadioButton button) {
        if (button.isChecked()) {
            button.setCompoundDrawablesWithIntrinsicBounds(0, this.mSpeedDrawable, 0, 0);
            button.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.mSpeedTextColor));
        } else {
            button.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            button.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.alivc_common_font_white_light));
        }
    }

    public void setOnSpeedClickListener(OnSpeedClickListener l) {
        this.mOnSpeedClickListener = l;
    }

    public void setScreenMode(AliyunScreenMode screenMode) {
        ViewGroup.LayoutParams speedViewParam = this.mMainSpeedView.getLayoutParams();
        if (screenMode == AliyunScreenMode.Small) {
            speedViewParam.width = this.getWidth();
            speedViewParam.height = this.getHeight();
        } else if (screenMode == AliyunScreenMode.Full) {
            AliyunVodPlayerView parentView = (AliyunVodPlayerView)this.getParent();
            LockPortraitListener lockPortraitListener = parentView.getLockPortraitMode();
            speedViewParam.width = lockPortraitListener == null ? this.getWidth() / 2 : this.getWidth();
            speedViewParam.height = this.getHeight();
        }
        this.mScreenMode = screenMode;
        this.mMainSpeedView.setLayoutParams(speedViewParam);
    }

    public void setSpeed(SpeedValue speedValue) {
        if (speedValue == null) {
            return;
        }
        if (this.mSpeedValue != speedValue) {
            this.mSpeedValue = speedValue;
            this.mSpeedChanged = true;
            this.updateSpeedCheck();
        } else {
            this.mSpeedChanged = false;
        }
        this.hide();
    }

    private void updateSpeedCheck() {
        this.mOneQrtTimeBtn.setChecked(this.mSpeedValue == SpeedValue.OneQuartern);
        this.mNormalBtn.setChecked(this.mSpeedValue == SpeedValue.Normal);
        this.mOneHalfTimeBtn.setChecked(this.mSpeedValue == SpeedValue.OneHalf);
        this.mTwoTimeBtn.setChecked(this.mSpeedValue == SpeedValue.Twice);
        this.updateBtnTheme();
    }

    private void updateBtnTheme() {
        this.setRadioButtonTheme(this.mNormalBtn);
        this.setRadioButtonTheme(this.mOneQrtTimeBtn);
        this.setRadioButtonTheme(this.mOneHalfTimeBtn);
        this.setRadioButtonTheme(this.mTwoTimeBtn);
    }

    public void show(AliyunScreenMode screenMode) {
        this.setScreenMode(screenMode);
        this.mMainSpeedView.startAnimation(this.showAnim);
    }

    private void hide() {
        if (this.mMainSpeedView.getVisibility() == 0) {
            this.mMainSpeedView.startAnimation(this.hideAnim);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mMainSpeedView.getVisibility() == 0 && this.animEnd) {
            this.hide();
            return true;
        }
        return super.onTouchEvent(event);
    }

    public static enum SpeedValue {
        Normal,
        OneQuartern,
        OneHalf,
        Twice;

    }

    public static interface OnSpeedClickListener {
        public void onSpeedClick(SpeedValue var1);

        public void onHide();
    }

    private class MyLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private AliyunScreenMode lastLayoutMode = null;

        private MyLayoutListener() {
        }

        public void onGlobalLayout() {
            if (SpeedView.this.mMainSpeedView.getVisibility() == 0) {
                if (this.lastLayoutMode == SpeedView.this.mScreenMode) {
                    return;
                }
                SpeedView.this.setScreenMode(SpeedView.this.mScreenMode);
                this.lastLayoutMode = SpeedView.this.mScreenMode;
            }
        }
    }
}

