/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.activity;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadInfoListener;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadManager;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.util.download.StorageUtil;
import com.aliyun.player.aliyunplayerbase.bean.AliyunPlayAuth;
import com.aliyun.player.aliyunplayerbase.bean.AliyunSts;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.player.aliyunplayerbase.util.Formatter;
import com.aliyun.player.aliyunplayerbase.util.NetWatchdog;
import com.aliyun.player.bean.ErrorCode;
import com.aliyun.player.source.VidAuth;
import com.aliyun.player.source.VidSts;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.activity.AliyunPlayerSkinActivity;
import com.aliyun.vodplayerview.adapter.AliyunPlayerDownloadListAdapter;
import com.aliyun.vodplayerview.global.Global;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class AliyunPlayerDownloadListActivity
extends AppCompatActivity
implements View.OnClickListener,
AliyunDownloadInfoListener {
    public static final int DOWNLOAD_ACTIVITY_FOR_REQUEST_CODE = 1;
    private static final String TAG = "AliyunPlayerDownloadLis";
    private AliyunDownloadManager mAliyunDownloadManager;
    private FrameLayout mFlCacheBottom;
    private LinearLayout mLlStatusBottom;
    private RecyclerView mCacheVideoRecyclerView;
    private AliyunPlayerDownloadListAdapter mAliyunPlayerDownloadListAdapter;
    private TextView mCacheSizeTextView;
    private ProgressBar mCacheProgressBar;
    private TextView mSelectedAllTextView;
    private TextView mDeleteTextView;
    private boolean mIsEditing = false;
    private boolean mIsAllSelected = true;
    private boolean mIsNetWorkconnect = true;
    private NetWatchdog mNetWatchdog;
    private NetConnectedListener mNetConnectedListener = null;
    private TextView mTvRight;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_player_download_list);
        this.mAliyunDownloadManager = AliyunDownloadManager.getInstance((Context)this.getApplicationContext());
        this.mAliyunDownloadManager.addDownloadInfoListener((AliyunDownloadInfoListener)this);
        this.initView();
        this.initTitle();
        this.initRecyclerView();
        this.initNetWatchdog();
        this.initListener();
    }

    private void initTitle() {
        TextView tvTitle = (TextView)this.findViewById(R.id.alivc_base_tv_middle_title);
        FrameLayout mFlLeftBack = (FrameLayout)this.findViewById(R.id.alivc_base_fl_left_back);
        this.mTvRight = (TextView)this.findViewById(R.id.alivc_base_tv_right_edit);
        this.mTvRight.setOnClickListener((View.OnClickListener)this);
        mFlLeftBack.setOnClickListener((View.OnClickListener)this);
        tvTitle.setText((CharSequence)this.getResources().getString(R.string.alivc_player_cache_video_title));
        this.mTvRight.setText((CharSequence)this.getResources().getString(R.string.alivc_player_cache_video_edit));
    }

    private void initView() {
        this.mFlCacheBottom = (FrameLayout)this.findViewById(R.id.alivc_fl_cache_bottom);
        this.mLlStatusBottom = (LinearLayout)this.findViewById(R.id.alivc_fl_edit_bottom);
        this.mDeleteTextView = (TextView)this.findViewById(R.id.alivc_tv_delete);
        this.mSelectedAllTextView = (TextView)this.findViewById(R.id.alivc_tv_all_selected);
        this.mCacheSizeTextView = (TextView)this.findViewById(R.id.alivc_tv_cache_size);
        this.mCacheProgressBar = (ProgressBar)this.findViewById(R.id.alivc_progress_bar_healthy);
        this.mCacheVideoRecyclerView = (RecyclerView)this.findViewById(R.id.alivc_cache_video_recyclerView);
    }

    private void initRecyclerView() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.mCacheVideoRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mAliyunPlayerDownloadListAdapter = new AliyunPlayerDownloadListAdapter((Context)this);
        this.mCacheVideoRecyclerView.setAdapter((RecyclerView.Adapter)this.mAliyunPlayerDownloadListAdapter);
    }

    private void initData() {
        if (this.mAliyunPlayerDownloadListAdapter != null) {
            if (Global.mDownloadMediaLists == null) {
                Global.mDownloadMediaLists = new ArrayList<AliyunDownloadMediaInfo>();
            }
            this.mAliyunPlayerDownloadListAdapter.setData(Global.mDownloadMediaLists);
        }
        this.calculationCache();
        this.calculationTotal();
        this.changeEditType(false);
    }

    private void initNetWatchdog() {
        this.mNetWatchdog = new NetWatchdog((Context)this);
        this.mNetWatchdog.setNetChangeListener((NetWatchdog.NetChangeListener)new MyNetChangeListener(this));
        this.mNetWatchdog.setNetConnectedListener((NetWatchdog.NetConnectedListener)new MyNetConnectedListener(this));
    }

    private void initListener() {
        this.mSelectedAllTextView.setOnClickListener((View.OnClickListener)this);
        this.mDeleteTextView.setOnClickListener((View.OnClickListener)this);
        this.mAliyunPlayerDownloadListAdapter.setOnItemClickListener(new AliyunPlayerDownloadListAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(AliyunPlayerDownloadListAdapter adapter, View view, int position) {
                AliyunDownloadMediaInfo mediaInfo = adapter.getDatas().get(position);
                if (AliyunPlayerDownloadListActivity.this.mIsEditing) {
                    mediaInfo.setSelected(!mediaInfo.isSelected());
                    for (int i = 0; i < adapter.getDatas().size(); ++i) {
                        if (adapter.getDatas().get(i).isSelected()) continue;
                        AliyunPlayerDownloadListActivity.this.mIsAllSelected = false;
                        AliyunPlayerDownloadListActivity.this.mSelectedAllTextView.setText((CharSequence)AliyunPlayerDownloadListActivity.this.getResources().getString(R.string.alivc_player_download_video_all_selected));
                    }
                    adapter.notifyItemChanged(position, 1);
                    AliyunPlayerDownloadListActivity.this.calculationTotal();
                }
            }
        });
        this.mAliyunPlayerDownloadListAdapter.setOnItemChildClickListener(new AliyunPlayerDownloadListAdapter.OnItemChildClickListener(){

            @Override
            public void onItemChildClick(AliyunPlayerDownloadListAdapter adapter, View view, int position) {
                AliyunDownloadMediaInfo mediaInfo = adapter.getDatas().get(position);
                if (!AliyunPlayerDownloadListActivity.this.mIsEditing) {
                    if (view.getId() == R.id.alivc_iv_preview) {
                        AliyunPlayerSkinActivity.startAliyunPlayerSkinActivityWithLocalVideo((Context)AliyunPlayerDownloadListActivity.this, mediaInfo.getSavePath());
                    } else if (view.getId() == R.id.alivc_fl_font) {
                        if (!AliyunPlayerDownloadListActivity.this.mIsNetWorkconnect) {
                            Toast.makeText((Context)AliyunPlayerDownloadListActivity.this, (CharSequence)AliyunPlayerDownloadListActivity.this.getResources().getString(R.string.alivc_player_doawload_operator), (int)0).show();
                        }
                        if (mediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Prepare || mediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Stop || mediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Error || mediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Wait) {
                            AliyunPlayerDownloadListActivity.this.mAliyunDownloadManager.startDownload(mediaInfo);
                        } else {
                            AliyunPlayerDownloadListActivity.this.mAliyunDownloadManager.pauseDownload(mediaInfo);
                        }
                    }
                }
            }
        });
    }

    public void onClick(View view) {
        if (view.getId() == R.id.alivc_base_tv_right_edit) {
            if (Global.mDownloadMediaLists == null || Global.mDownloadMediaLists.isEmpty()) {
                return;
            }
            if (this.mIsEditing) {
                this.mIsEditing = false;
                this.mTvRight.setText((CharSequence)this.getResources().getString(R.string.alivc_player_cache_video_edit));
            } else {
                this.mIsEditing = true;
                this.mTvRight.setText((CharSequence)this.getResources().getString(R.string.alivc_common_cancel));
            }
            this.changeEditType(this.mIsEditing);
        } else if (view.getId() == R.id.alivc_tv_all_selected) {
            this.allSelectedStatus();
            this.allSelectedOrUnSelected();
        } else if (view.getId() == R.id.alivc_tv_delete) {
            this.deleteItem();
        } else if (view.getId() == R.id.alivc_base_fl_left_back) {
            this.finish();
        }
    }

    private void changeEditType(boolean mIsEditing) {
        this.statusAndCacheVisibility(mIsEditing);
        this.mAliyunPlayerDownloadListAdapter.setEditing(mIsEditing);
    }

    private void deleteItem() {
        for (int i = 0; i < Global.mDownloadMediaLists.size(); ++i) {
            if (!Global.mDownloadMediaLists.get(i).isSelected()) continue;
            this.mAliyunDownloadManager.deleteFile(Global.mDownloadMediaLists.get(i));
        }
        if (Global.mDownloadMediaLists.size() == 0) {
            this.changeEditType(false);
            this.mIsEditing = false;
        }
    }

    private void statusAndCacheVisibility(boolean isEditing) {
        this.mLlStatusBottom.setVisibility(isEditing ? 0 : 8);
        this.mFlCacheBottom.setVisibility(isEditing ? 8 : 0);
    }

    private void allSelectedStatus() {
        if (this.mIsAllSelected) {
            this.mIsAllSelected = false;
            this.mSelectedAllTextView.setText((CharSequence)this.getResources().getString(R.string.alivc_player_download_video_all_selected));
        } else {
            this.mIsAllSelected = true;
            this.mSelectedAllTextView.setText((CharSequence)this.getResources().getString(R.string.alivc_player_download_video_un_all_selected));
        }
    }

    private void allSelectedOrUnSelected() {
        ArrayList downloadMediaInfos = (ArrayList)this.mAliyunPlayerDownloadListAdapter.getDatas();
        for (int i = 0; i < downloadMediaInfos.size(); ++i) {
            if (this.mIsAllSelected) {
                ((AliyunDownloadMediaInfo)downloadMediaInfos.get(i)).setSelected(true);
                continue;
            }
            ((AliyunDownloadMediaInfo)downloadMediaInfos.get(i)).setSelected(false);
        }
        this.mAliyunPlayerDownloadListAdapter.notifyDataSetChanged();
        this.calculationTotal();
    }

    private void calculationTotal() {
        int totalNumber = 0;
        if (this.mIsEditing) {
            for (int i = 0; i < this.mAliyunPlayerDownloadListAdapter.getDatas().size(); ++i) {
                if (!this.mAliyunPlayerDownloadListAdapter.getDatas().get(i).isSelected()) continue;
                totalNumber += this.mAliyunPlayerDownloadListAdapter.getDatas().get(i).getNumber();
            }
            if (totalNumber == 0) {
                this.mDeleteTextView.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.alivc_common_font_gray_333333));
                this.mDeleteTextView.setText((CharSequence)this.getResources().getString(R.string.alivc_player_download_video_delete));
            } else {
                this.mDeleteTextView.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.alivc_common_bg_red_darker));
                StringBuilder builder = new StringBuilder();
                builder.append(this.getResources().getString(R.string.alivc_player_download_video_delete)).append("(").append(totalNumber).append(")");
                this.mDeleteTextView.setText((CharSequence)builder);
            }
        }
    }

    private void reFreshData(AliyunDownloadMediaInfo mediaInfo) {
        Global.mDownloadMediaLists.remove(mediaInfo);
        this.mAliyunPlayerDownloadListAdapter.deleteData(mediaInfo);
        if (Global.mDownloadMediaLists.isEmpty()) {
            this.mIsEditing = false;
            this.mTvRight.setText((CharSequence)this.getResources().getString(R.string.alivc_player_cache_video_edit));
            this.statusAndCacheVisibility(this.mIsEditing);
        }
        this.calculationTotal();
        this.calculationCache();
    }

    private void calculationCache() {
        long cacheSize = 0L;
        ArrayList aliyunDownloadMediaInfos = (ArrayList)this.mAliyunPlayerDownloadListAdapter.getDatas();
        for (AliyunDownloadMediaInfo mediaInfo : aliyunDownloadMediaInfos) {
            cacheSize += mediaInfo.getSize();
        }
        String intentUseStorage = Formatter.getFileSizeDescription((long)cacheSize);
        long size = StorageUtil.getAvailableExternalMemorySize();
        this.mCacheSizeTextView.setText((CharSequence)String.format(this.getResources().getString(R.string.alivc_player_video_cache_storage_tips), intentUseStorage, Formatter.getFileSizeDescription((long)(size * 1024L))));
        int newSize = (int)((double)cacheSize / 1024.0 / (double)size * 100.0);
        this.mCacheProgressBar.setProgress(newSize);
    }

    private void onWifiTo4G() {
        this.mIsNetWorkconnect = false;
        Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.alivc_player_doawload_operator), (int)0).show();
    }

    private void on4GToWifi() {
        this.mIsNetWorkconnect = true;
    }

    private void onNetDisconnected() {
        Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.alivc_net_disable), (int)0).show();
    }

    protected void onStart() {
        super.onStart();
        this.initData();
        if (this.mNetWatchdog != null) {
            this.mNetWatchdog.startWatch();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mAliyunPlayerDownloadListAdapter != null) {
            this.mAliyunPlayerDownloadListAdapter.notifyDataSetChanged();
        }
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mNetWatchdog.stopWatch();
        if (this.mAliyunDownloadManager != null) {
            this.mAliyunDownloadManager.removeDownloadInfoListener((AliyunDownloadInfoListener)this);
        }
    }

    public void onPrepared(List<AliyunDownloadMediaInfo> infos) {
    }

    public void onAdd(AliyunDownloadMediaInfo info) {
    }

    public void onStart(AliyunDownloadMediaInfo info) {
        if (info == null) {
            return;
        }
        this.mAliyunPlayerDownloadListAdapter.updateData(info);
    }

    public void onProgress(AliyunDownloadMediaInfo info, int percent) {
        if (info == null) {
            return;
        }
        this.mAliyunPlayerDownloadListAdapter.updateData(info);
    }

    public void onStop(AliyunDownloadMediaInfo info) {
        if (info == null) {
            return;
        }
        this.mAliyunPlayerDownloadListAdapter.updateData(info);
    }

    public void onCompletion(AliyunDownloadMediaInfo info) {
        if (Global.mDownloadMediaLists != null && Global.mDownloadMediaLists.contains(info)) {
            AliyunDownloadMediaInfo aliyunDownloadMediaInfo = Global.mDownloadMediaLists.get(Global.mDownloadMediaLists.indexOf(info));
            aliyunDownloadMediaInfo.setSavePath(info.getSavePath());
        }
        this.mAliyunPlayerDownloadListAdapter.updateData(info);
    }

    public void onError(AliyunDownloadMediaInfo info, ErrorCode code, String msg, String requestId) {
        if (info == null || code == null) {
            return;
        }
        if (code.getValue() == ErrorCode.ERROR_SERVER_POP_TOKEN_EXPIRED.getValue() || code.getValue() == ErrorCode.ERROR_SERVER_VOD_INVALIDAUTHINFO_EXPIRETIME.getValue()) {
            this.refresh(info);
        } else {
            this.mAliyunPlayerDownloadListAdapter.updateData(info);
        }
        Log.e((String)TAG, (String)("onError: " + info.getTitle() + "__" + msg));
    }

    public void onWait(AliyunDownloadMediaInfo outMediaInfo) {
    }

    public void onDelete(AliyunDownloadMediaInfo info) {
        this.reFreshData(info);
    }

    public void onDeleteAll() {
    }

    public void onFileProgress(AliyunDownloadMediaInfo info) {
    }

    private void refresh(final AliyunDownloadMediaInfo info) {
        if (info.getVidType() == 0) {
            GetAuthInformation getAuthInformation = new GetAuthInformation();
            getAuthInformation.getVideoPlayStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

                public void onGetStsError(String errorMsg) {
                    ToastUtils.show((Context)AliyunPlayerDownloadListActivity.this, (String)errorMsg);
                    AliyunPlayerDownloadListActivity.this.mAliyunPlayerDownloadListAdapter.updateData(info);
                }

                public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                    if (dataBean != null) {
                        VidSts vidSts = new VidSts();
                        vidSts.setVid(info.getVid());
                        vidSts.setAccessKeyId(dataBean.getAccessKeyId());
                        vidSts.setAccessKeySecret(dataBean.getAccessKeySecret());
                        vidSts.setSecurityToken(dataBean.getSecurityToken());
                        info.setVidSts(vidSts);
                        AliyunPlayerDownloadListActivity.this.mAliyunDownloadManager.setmVidSts(vidSts);
                        AliyunPlayerDownloadListActivity.this.mAliyunDownloadManager.prepareDownloadByQuality(info, 0);
                    }
                }
            });
        } else if (info.getVidType() == 1) {
            GetAuthInformation getAuthInformation = new GetAuthInformation();
            getAuthInformation.getVideoPlayAuthInfo(new GetAuthInformation.OnGetPlayAuthInfoListener(){

                public void onGetPlayAuthError(String msg) {
                    ToastUtils.show((Context)AliyunPlayerDownloadListActivity.this, (String)msg);
                    AliyunPlayerDownloadListActivity.this.mAliyunPlayerDownloadListAdapter.updateData(info);
                }

                public void onGetPlayAuthSuccess(AliyunPlayAuth.PlayAuthBean dataBean) {
                    if (dataBean != null) {
                        GlobalPlayerConfig.mPlayAuth = dataBean.getPlayAuth();
                        VidAuth vidAuth = new VidAuth();
                        vidAuth.setVid(info.getVid());
                        vidAuth.setPlayAuth(dataBean.getPlayAuth());
                        info.setVidAuth(vidAuth);
                        AliyunPlayerDownloadListActivity.this.mAliyunDownloadManager.setmVidAuth(vidAuth);
                        AliyunPlayerDownloadListActivity.this.mAliyunDownloadManager.prepareDownloadByQuality(info, 0);
                    }
                }
            });
        }
    }

    private static class MyNetChangeListener
    implements NetWatchdog.NetChangeListener {
        private WeakReference<AliyunPlayerDownloadListActivity> viewWeakReference;

        public MyNetChangeListener(AliyunPlayerDownloadListActivity cacheVideoActivity) {
            this.viewWeakReference = new WeakReference<AliyunPlayerDownloadListActivity>(cacheVideoActivity);
        }

        public void onWifiTo4G() {
            AliyunPlayerDownloadListActivity downloadListActivity = (AliyunPlayerDownloadListActivity)((Object)this.viewWeakReference.get());
            if (downloadListActivity != null) {
                downloadListActivity.onWifiTo4G();
            }
        }

        public void on4GToWifi() {
            AliyunPlayerDownloadListActivity downloadListActivity = (AliyunPlayerDownloadListActivity)((Object)this.viewWeakReference.get());
            if (downloadListActivity != null) {
                downloadListActivity.on4GToWifi();
            }
        }

        public void onNetDisconnected() {
            AliyunPlayerDownloadListActivity downloadListActivity = (AliyunPlayerDownloadListActivity)((Object)this.viewWeakReference.get());
            if (downloadListActivity != null) {
                downloadListActivity.onNetDisconnected();
            }
        }
    }

    private class MyNetConnectedListener
    implements NetWatchdog.NetConnectedListener {
        public MyNetConnectedListener(AliyunPlayerDownloadListActivity alivcCacheVideoActivity) {
        }

        public void onReNetConnected(boolean isReconnect) {
            if (AliyunPlayerDownloadListActivity.this.mNetConnectedListener != null) {
                AliyunPlayerDownloadListActivity.this.mNetConnectedListener.onReNetConnected(isReconnect);
            }
        }

        public void onNetUnConnected() {
            if (AliyunPlayerDownloadListActivity.this.mNetConnectedListener != null) {
                AliyunPlayerDownloadListActivity.this.mNetConnectedListener.onNetUnConnected();
            }
        }
    }

    public static interface NetConnectedListener {
        public void onReNetConnected(boolean var1);

        public void onNetUnConnected();
    }
}

