/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.fragment;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.aliyunplayerbase.bean.AliyunSts;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.fragment.BaseFragment;
import java.util.Locale;

public class AliyunPlayerTypeStsFragment
extends BaseFragment {
    private EditText mStsPreviewTimeEditText;
    private EditText mStsVidEditText;
    private EditText mStsRegionEditText;
    private EditText mStsAccessKeyIdEditText;
    private EditText mStsSecurityTokenEditText;
    private EditText mStsAccessKeySecretEditText;
    private String mVid;
    private String mRegion;
    private String mPreviewTime;
    private String mAccessKeyId;
    private String mSecurityToken;
    private String mAccessKeySecret;
    private TextView mRefreshTextView;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_aliyun_sts_player_type, container, false);
        this.mStsVidEditText = (EditText)view.findViewById(R.id.et_sts_vid);
        this.mRefreshTextView = (TextView)view.findViewById(R.id.tv_refresh);
        this.mStsRegionEditText = (EditText)view.findViewById(R.id.et_sts_region);
        this.mStsPreviewTimeEditText = (EditText)view.findViewById(R.id.et_preview_time);
        this.mStsAccessKeyIdEditText = (EditText)view.findViewById(R.id.et_sts_access_key_id);
        this.mStsSecurityTokenEditText = (EditText)view.findViewById(R.id.et_sts_security_token);
        this.mStsAccessKeySecretEditText = (EditText)view.findViewById(R.id.et_sts_access_key_secret);
        this.initData();
        this.initListener();
        if (TextUtils.isEmpty((CharSequence)GlobalPlayerConfig.mVid)) {
            this.defaultPlayInfo();
        }
        return view;
    }

    private void getVideoPlayStsInfo() {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

            public void onGetStsError(String errorMsg) {
                Context context = AliyunPlayerTypeStsFragment.this.getContext();
                if (context == null) {
                    return;
                }
                ToastUtils.show((Context)context, (String)errorMsg);
            }

            public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                if (dataBean != null) {
                    AliyunPlayerTypeStsFragment.this.mStsVidEditText.setText((CharSequence)dataBean.getVideoId());
                    AliyunPlayerTypeStsFragment.this.mStsRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
                    AliyunPlayerTypeStsFragment.this.mStsAccessKeyIdEditText.setText((CharSequence)dataBean.getAccessKeyId());
                    AliyunPlayerTypeStsFragment.this.mStsSecurityTokenEditText.setText((CharSequence)dataBean.getSecurityToken());
                    AliyunPlayerTypeStsFragment.this.mStsAccessKeySecretEditText.setText((CharSequence)dataBean.getAccessKeySecret());
                }
            }
        });
    }

    private void getVideoPlayStsInfoWithVideoId(String videoId) {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayStsInfoWithVideoId(videoId, new GetAuthInformation.OnGetStsInfoListener(){

            public void onGetStsError(String errorMsg) {
                if (AliyunPlayerTypeStsFragment.this.getContext() != null) {
                    ToastUtils.show((Context)AliyunPlayerTypeStsFragment.this.getContext(), (String)errorMsg);
                }
            }

            public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                if (dataBean != null) {
                    AliyunPlayerTypeStsFragment.this.mStsRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
                    AliyunPlayerTypeStsFragment.this.mStsAccessKeyIdEditText.setText((CharSequence)dataBean.getAccessKeyId());
                    AliyunPlayerTypeStsFragment.this.mStsSecurityTokenEditText.setText((CharSequence)dataBean.getSecurityToken());
                    AliyunPlayerTypeStsFragment.this.mStsAccessKeySecretEditText.setText((CharSequence)dataBean.getAccessKeySecret());
                }
            }
        });
    }

    private void initData() {
        this.mStsVidEditText.setText((CharSequence)GlobalPlayerConfig.mVid);
        this.mStsRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
        this.mStsAccessKeyIdEditText.setText((CharSequence)GlobalPlayerConfig.mStsAccessKeyId);
        this.mStsPreviewTimeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.mPreviewTime));
        this.mStsSecurityTokenEditText.setText((CharSequence)GlobalPlayerConfig.mStsSecurityToken);
        this.mStsAccessKeySecretEditText.setText((CharSequence)GlobalPlayerConfig.mStsAccessKeySecret);
    }

    private void initListener() {
        this.mRefreshTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AliyunPlayerTypeStsFragment.this.mVid = AliyunPlayerTypeStsFragment.this.mStsVidEditText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)AliyunPlayerTypeStsFragment.this.mVid)) {
                    ToastUtils.show((Context)AliyunPlayerTypeStsFragment.this.getContext(), (int)R.string.alivc_refresh_vid_empty);
                    return;
                }
                AliyunPlayerTypeStsFragment.this.getVideoPlayStsInfoWithVideoId(AliyunPlayerTypeStsFragment.this.mVid);
            }
        });
    }

    private void getInputContent() {
        this.mVid = this.mStsVidEditText.getText().toString();
        this.mRegion = this.mStsRegionEditText.getText().toString();
        this.mPreviewTime = this.mStsPreviewTimeEditText.getText().toString();
        this.mAccessKeyId = this.mStsAccessKeyIdEditText.getText().toString();
        this.mSecurityToken = this.mStsSecurityTokenEditText.getText().toString();
        this.mAccessKeySecret = this.mStsAccessKeySecretEditText.getText().toString();
    }

    private void setGlobaConfig() {
        this.getInputContent();
        GlobalPlayerConfig.mVid = this.mVid;
        GlobalPlayerConfig.mRegion = this.mRegion;
        GlobalPlayerConfig.mPreviewTime = Integer.valueOf(TextUtils.isEmpty((CharSequence)this.mPreviewTime) ? "-1" : this.mPreviewTime);
        GlobalPlayerConfig.mStsAccessKeyId = this.mAccessKeyId;
        GlobalPlayerConfig.mStsSecurityToken = this.mSecurityToken;
        GlobalPlayerConfig.mStsAccessKeySecret = this.mAccessKeySecret;
    }

    @Override
    public void defaultPlayInfo() {
        this.getVideoPlayStsInfo();
    }

    @Override
    public void confirmPlayInfo() {
        this.setGlobaConfig();
        GlobalPlayerConfig.STS_TYPE_CHECKED = true;
    }
}

