/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunlistplayer;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AppCompatActivity;
import com.aliyun.player.aliyunlistplayer.R;
import com.aliyun.player.aliyunlistplayer.view.AliyunListPlayerView;
import com.aliyun.player.aliyunplayerbase.bean.AliyunSts;
import com.aliyun.player.aliyunplayerbase.bean.AliyunVideoListBean;
import com.aliyun.player.aliyunplayerbase.net.GetVideoInfomation;
import com.aliyun.player.aliyunplayerbase.net.ServiceCommon;
import com.aliyun.player.aliyunplayerbase.util.NetWatchdog;
import com.aliyun.player.source.StsInfo;
import com.aliyun.svideo.common.okhttp.AlivcOkHttpClient;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import okhttp3.Request;

public class AliyunListPlayerActivity
extends AppCompatActivity {
    private AliyunListPlayerView mListPlayerView;
    private NetWatchdog mNetWatchDog;
    private String mUserToken;
    private boolean mIsLoadMore = false;
    private int mLastVideoId = -1;
    private ImageView mBackImageView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_aliyun_list_player);
        this.mUserToken = this.getIntent().getStringExtra("list_player_user_token");
        this.initView();
        this.initSts(true);
        this.initListener();
    }

    private void initView() {
        this.mListPlayerView = (AliyunListPlayerView)this.findViewById(R.id.list_player_view);
        this.mBackImageView = (ImageView)this.findViewById(R.id.iv_back);
    }

    private void refreshListDatas() {
        this.initSts(false);
        this.getDatas(this.mLastVideoId);
    }

    private void getDatas(int id2) {
        GetVideoInfomation getVideoInfomation = new GetVideoInfomation();
        getVideoInfomation.getListPlayerVideoInfos((Context)this, "1", this.mUserToken, id2, new GetVideoInfomation.OnGetListPlayerVideoInfosListener(){
            private SparseArray<String> mSparseArray;

            public void onGetSuccess(Request request, String result) {
                Gson gson = new Gson();
                AliyunVideoListBean aliyunVideoListBean = (AliyunVideoListBean)gson.fromJson(result, AliyunVideoListBean.class);
                if (aliyunVideoListBean != null && aliyunVideoListBean.getCode() == ServiceCommon.RESPONSE_SUCCESS) {
                    AliyunVideoListBean.VideoDataBean data = aliyunVideoListBean.getData();
                    int total = data.getTotal();
                    List videoList = data.getVideoList();
                    if (AliyunListPlayerActivity.this.mListPlayerView != null && videoList != null) {
                        if (!AliyunListPlayerActivity.this.mIsLoadMore) {
                            this.mSparseArray = new SparseArray();
                            AliyunListPlayerActivity.this.mListPlayerView.setData(videoList);
                        } else {
                            this.mSparseArray = AliyunListPlayerActivity.this.mListPlayerView.getCorrelationTable();
                            AliyunListPlayerActivity.this.mListPlayerView.addMoreData(videoList);
                        }
                        int size = this.mSparseArray.size();
                        for (int i = 0; i < videoList.size(); ++i) {
                            if (i == videoList.size() - 1) {
                                AliyunListPlayerActivity.this.mLastVideoId = ((AliyunVideoListBean.VideoDataBean.VideoListBean)videoList.get(i)).getId();
                            }
                            String randomUUID = UUID.randomUUID().toString();
                            AliyunListPlayerActivity.this.mListPlayerView.addVid(((AliyunVideoListBean.VideoDataBean.VideoListBean)videoList.get(i)).getVideoId(), randomUUID);
                            this.mSparseArray.put(size + i, (Object)randomUUID);
                        }
                        AliyunListPlayerActivity.this.mListPlayerView.setCorrelationTable(this.mSparseArray);
                    }
                }
                if (AliyunListPlayerActivity.this.mListPlayerView != null) {
                    AliyunListPlayerActivity.this.mListPlayerView.hideRefresh();
                }
            }

            public void onGetError(Request request, IOException e) {
                ToastUtils.show((Context)AliyunListPlayerActivity.this, (String)e.getMessage());
                if (AliyunListPlayerActivity.this.mListPlayerView != null) {
                    AliyunListPlayerActivity.this.mListPlayerView.hideRefresh();
                }
            }
        });
    }

    private void initData() {
        Gson gson;
        AliyunVideoListBean aliyunVideoListBean;
        String listPlayerDatasJson = this.getIntent().getStringExtra("list_player_datas_json");
        if (!TextUtils.isEmpty((CharSequence)listPlayerDatasJson) && (aliyunVideoListBean = (AliyunVideoListBean)(gson = new Gson()).fromJson(listPlayerDatasJson, AliyunVideoListBean.class)) != null && aliyunVideoListBean.getCode() == ServiceCommon.RESPONSE_SUCCESS) {
            AliyunVideoListBean.VideoDataBean data = aliyunVideoListBean.getData();
            int total = data.getTotal();
            List videoList = data.getVideoList();
            if (this.mListPlayerView != null && videoList != null) {
                SparseArray mSparseArray = new SparseArray();
                for (int i = 0; i < videoList.size(); ++i) {
                    if (i == videoList.size() - 1) {
                        this.mLastVideoId = ((AliyunVideoListBean.VideoDataBean.VideoListBean)videoList.get(i)).getId();
                    }
                    String randomUUID = UUID.randomUUID().toString();
                    this.mListPlayerView.addVid(((AliyunVideoListBean.VideoDataBean.VideoListBean)videoList.get(i)).getVideoId(), randomUUID);
                    mSparseArray.put(i, (Object)randomUUID);
                }
                this.mListPlayerView.setData(videoList);
                this.mListPlayerView.setCorrelationTable((SparseArray<String>)mSparseArray);
            }
        }
    }

    private void initSts(final boolean needLoadData) {
        AlivcOkHttpClient.getInstance().get(ServiceCommon.GET_VIDEO_PLAY_STS, new AlivcOkHttpClient.HttpCallBack(){

            public void onError(Request request, IOException e) {
                ToastUtils.show((Context)AliyunListPlayerActivity.this, (String)e.getMessage());
            }

            public void onSuccess(Request request, String result) {
                Gson gson = new Gson();
                AliyunSts aliyunSts = (AliyunSts)gson.fromJson(result, AliyunSts.class);
                if (aliyunSts != null && aliyunSts.getCode() == ServiceCommon.RESPONSE_SUCCESS && AliyunListPlayerActivity.this.mListPlayerView != null) {
                    AliyunSts.StsBean data = aliyunSts.getData();
                    StsInfo stsInfo = new StsInfo();
                    stsInfo.setAccessKeyId(data.getAccessKeyId());
                    stsInfo.setSecurityToken(data.getSecurityToken());
                    stsInfo.setAccessKeySecret(data.getAccessKeySecret());
                    AliyunListPlayerActivity.this.mListPlayerView.setStsInfo(stsInfo);
                    if (needLoadData) {
                        AliyunListPlayerActivity.this.initData();
                    }
                }
            }
        });
    }

    private void initListener() {
        this.mNetWatchDog = new NetWatchdog((Context)this);
        this.mNetWatchDog.setNetChangeListener((NetWatchdog.NetChangeListener)new MyNetChangeListener(this));
        this.mNetWatchDog.setNetConnectedListener((NetWatchdog.NetConnectedListener)new MyNetConnectedListener(this));
        this.mListPlayerView.setOnRefreshDataListener(new MyOnRefreshListener(this));
        this.mBackImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AliyunListPlayerActivity.this.finish();
            }
        });
    }

    protected void onStart() {
        super.onStart();
        if (this.mListPlayerView != null) {
            this.mListPlayerView.setOnBackground(false);
        }
        if (this.mNetWatchDog != null) {
            this.mNetWatchDog.startWatch();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mListPlayerView != null) {
            this.mListPlayerView.setOnBackground(true);
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mListPlayerView != null) {
            this.mListPlayerView.setOnBackground(true);
        }
        if (this.mNetWatchDog != null) {
            this.mNetWatchDog.stopWatch();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mListPlayerView != null) {
            this.mListPlayerView.destroy();
        }
    }

    private void onRefresh() {
        this.mIsLoadMore = false;
        this.mLastVideoId = -1;
        this.refreshListDatas();
    }

    private void onLoadMore() {
        this.mIsLoadMore = true;
        this.getDatas(this.mLastVideoId);
    }

    private void onNetDisconnected() {
    }

    private void on4GToWifi() {
    }

    private void onWifiTo4G() {
        ToastUtils.show((Context)this, (String)this.getString(R.string.alivc_operator_play));
    }

    private void onNetUnConnected() {
        ToastUtils.show((Context)this, (String)this.getString(R.string.alivc_player_net_unconnect));
    }

    private void onReNetConnected(boolean isReconnect) {
    }

    private static class MyNetConnectedListener
    implements NetWatchdog.NetConnectedListener {
        private final WeakReference<AliyunListPlayerActivity> weakReference;

        public MyNetConnectedListener(AliyunListPlayerActivity aliyunLivePlayerView) {
            this.weakReference = new WeakReference<AliyunListPlayerActivity>(aliyunLivePlayerView);
        }

        public void onReNetConnected(boolean isReconnect) {
            AliyunListPlayerActivity aliyunListPlayerActivity = (AliyunListPlayerActivity)((Object)this.weakReference.get());
            if (aliyunListPlayerActivity != null) {
                aliyunListPlayerActivity.onReNetConnected(isReconnect);
            }
        }

        public void onNetUnConnected() {
            AliyunListPlayerActivity aliyunListPlayerActivity = (AliyunListPlayerActivity)((Object)this.weakReference.get());
            if (aliyunListPlayerActivity != null) {
                aliyunListPlayerActivity.onNetUnConnected();
            }
        }
    }

    private static class MyNetChangeListener
    implements NetWatchdog.NetChangeListener {
        private WeakReference<AliyunListPlayerActivity> weakReference;

        public MyNetChangeListener(AliyunListPlayerActivity aliyunListPlayerActivity) {
            this.weakReference = new WeakReference<AliyunListPlayerActivity>(aliyunListPlayerActivity);
        }

        public void onWifiTo4G() {
            AliyunListPlayerActivity aliyunListPlayerActivity = (AliyunListPlayerActivity)((Object)this.weakReference.get());
            if (aliyunListPlayerActivity != null) {
                aliyunListPlayerActivity.onWifiTo4G();
            }
        }

        public void on4GToWifi() {
            AliyunListPlayerActivity aliyunListPlayerActivity = (AliyunListPlayerActivity)((Object)this.weakReference.get());
            if (aliyunListPlayerActivity != null) {
                aliyunListPlayerActivity.on4GToWifi();
            }
        }

        public void onNetDisconnected() {
            AliyunListPlayerActivity aliyunListPlayerActivity = (AliyunListPlayerActivity)((Object)this.weakReference.get());
            if (aliyunListPlayerActivity != null) {
                aliyunListPlayerActivity.onNetDisconnected();
            }
        }
    }

    private static class MyOnRefreshListener
    implements AliyunListPlayerView.OnRefreshDataListener {
        private WeakReference<AliyunListPlayerActivity> weakReference;

        public MyOnRefreshListener(AliyunListPlayerActivity aliyunListPlayerActivity) {
            this.weakReference = new WeakReference<AliyunListPlayerActivity>(aliyunListPlayerActivity);
        }

        @Override
        public void onRefresh() {
            AliyunListPlayerActivity aliyunListPlayerActivity = (AliyunListPlayerActivity)((Object)this.weakReference.get());
            if (aliyunListPlayerActivity != null) {
                aliyunListPlayerActivity.onRefresh();
            }
        }

        @Override
        public void onLoadMore() {
            AliyunListPlayerActivity aliyunListPlayerActivity = (AliyunListPlayerActivity)((Object)this.weakReference.get());
            if (aliyunListPlayerActivity != null) {
                aliyunListPlayerActivity.onLoadMore();
            }
        }
    }
}

