/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunlistplayer.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.aliyun.player.aliyunlistplayer.R;
import com.aliyun.player.aliyunplayerbase.bean.AliyunVideoListBean;
import com.aliyun.svideo.common.utils.image.ImageLoaderImpl;
import com.aliyun.svideo.common.utils.image.ImageLoaderOptions;
import com.aliyun.svideo.common.utils.image.ImageLoaderRequestListener;
import java.util.List;

public class AliyunRecyclerViewAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private Context mContext;
    private Point mScreenPoint = new Point();
    private List<AliyunVideoListBean.VideoDataBean.VideoListBean> mVideoListBeanItems;

    public AliyunRecyclerViewAdapter(Context context) {
        this.mContext = context;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mScreenPoint.x = displayMetrics.widthPixels;
        this.mScreenPoint.y = displayMetrics.heightPixels;
    }

    public MyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View inflate = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_list_player_recyclerview_item, parent, false);
        return new MyViewHolder(inflate);
    }

    public void onBindViewHolder(MyViewHolder holder, int position) {
        AliyunVideoListBean.VideoDataBean.VideoListBean videoListBean = this.mVideoListBeanItems.get(position);
        String coverUrlPath = TextUtils.isEmpty((CharSequence)videoListBean.getFirstFrameUrl()) ? videoListBean.getFirstFrameUrl() : videoListBean.getCoverUrl();
        ImageView mThumb = holder.getCoverView();
        if (this.mContext != null && this.mContext instanceof Activity) {
            Activity activity = (Activity)this.mContext;
            if (Build.VERSION.SDK_INT >= 17) {
                if (!activity.isFinishing() || !activity.isDestroyed()) {
                    this.loadPicture(holder, coverUrlPath, mThumb);
                }
            } else if (!activity.isFinishing()) {
                this.loadPicture(holder, coverUrlPath, mThumb);
            }
        }
    }

    private void loadPicture(final MyViewHolder holder, String coverPath, final ImageView iv) {
        new ImageLoaderImpl().loadImage(this.mContext, coverPath, new ImageLoaderOptions.Builder().asBitmap().placeholder(17170444).thumbnail(0.1f).build()).listener((ImageLoaderRequestListener)new ImageLoaderRequestListener<Bitmap>(){

            public boolean onLoadFailed(String exception, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Bitmap resource, boolean isFirstResource) {
                float aspectRatio = (float)resource.getWidth() / (float)resource.getHeight();
                float screenRatio = (float)((AliyunRecyclerViewAdapter)AliyunRecyclerViewAdapter.this).mScreenPoint.x / (float)((AliyunRecyclerViewAdapter)AliyunRecyclerViewAdapter.this).mScreenPoint.y;
                if ((double)aspectRatio <= 0.5725 && (double)aspectRatio >= 0.5525 && (double)screenRatio < 0.5525) {
                    float height = holder.getContainerView().getHeight();
                    float width = height * (float)resource.getWidth() / (float)resource.getHeight();
                    ViewGroup.LayoutParams layoutParams = iv.getLayoutParams();
                    layoutParams.width = (int)width;
                    layoutParams.height = (int)height;
                    iv.setLayoutParams(layoutParams);
                } else {
                    float screenWith = ((AliyunRecyclerViewAdapter)AliyunRecyclerViewAdapter.this).mScreenPoint.x;
                    ViewGroup.LayoutParams layoutParams = iv.getLayoutParams();
                    float height = screenWith * (float)resource.getHeight() / (float)resource.getWidth();
                    layoutParams.width = (int)screenWith;
                    layoutParams.height = (int)height;
                    iv.setLayoutParams(layoutParams);
                }
                return false;
            }
        }).into(iv);
    }

    public int getItemCount() {
        return this.mVideoListBeanItems == null ? 0 : this.mVideoListBeanItems.size();
    }

    public void setData(List<AliyunVideoListBean.VideoDataBean.VideoListBean> videoListBeanItems) {
        this.mVideoListBeanItems = videoListBeanItems;
    }

    public void addMoreData(List<AliyunVideoListBean.VideoDataBean.VideoListBean> videoListBeanItems) {
        this.mVideoListBeanItems.addAll(videoListBeanItems);
        this.notifyItemRangeInserted(this.mVideoListBeanItems.size() - videoListBeanItems.size(), videoListBeanItems.size());
    }

    public static class MyViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mThumb;
        private ViewGroup mRootView;
        private FrameLayout mPlayerViewRoot;

        public MyViewHolder(View itemView) {
            super(itemView);
            this.mThumb = (ImageView)itemView.findViewById(R.id.img_thumb);
            this.mPlayerViewRoot = (FrameLayout)itemView.findViewById(R.id.list_player_root);
            this.mRootView = (ViewGroup)itemView.findViewById(R.id.root_view);
        }

        public ImageView getCoverView() {
            return this.mThumb;
        }

        public ViewGroup getContainerView() {
            return this.mRootView;
        }
    }
}

