/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.util;

import android.content.Context;
import android.view.OrientationEventListener;

public class OrientationWatchDog {
    private static final String TAG = OrientationWatchDog.class.getSimpleName();
    private Context mContext;
    private OrientationEventListener mLandOrientationListener;
    private OnOrientationListener mOrientationListener;
    private Orientation mLastOrientation = Orientation.Port;

    public OrientationWatchDog(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void startWatch() {
        if (this.mLandOrientationListener == null) {
            this.mLandOrientationListener = new OrientationEventListener(this.mContext, 3){

                public void onOrientationChanged(int orientation) {
                    boolean isPort;
                    if (orientation == -1) {
                        return;
                    }
                    boolean isLand = orientation < 100 && orientation > 80 || orientation < 280 && orientation > 260;
                    boolean bl = isPort = orientation < 10 || orientation > 350 || orientation < 190 && orientation > 170;
                    if (isLand) {
                        if (OrientationWatchDog.this.mOrientationListener != null && orientation < 100 && orientation > 80) {
                            OrientationWatchDog.this.mOrientationListener.changedToLandReverseScape(OrientationWatchDog.this.mLastOrientation == Orientation.Port || OrientationWatchDog.this.mLastOrientation == Orientation.Land_Forward);
                            OrientationWatchDog.this.mLastOrientation = Orientation.Land_Reverse;
                        } else if (OrientationWatchDog.this.mOrientationListener != null && orientation < 280 && orientation > 260) {
                            OrientationWatchDog.this.mOrientationListener.changedToLandForwardScape(OrientationWatchDog.this.mLastOrientation == Orientation.Port || OrientationWatchDog.this.mLastOrientation == Orientation.Land_Reverse);
                            OrientationWatchDog.this.mLastOrientation = Orientation.Land_Forward;
                        }
                    } else if (isPort) {
                        if (OrientationWatchDog.this.mOrientationListener != null) {
                            OrientationWatchDog.this.mOrientationListener.changedToPortrait(OrientationWatchDog.this.mLastOrientation == Orientation.Land_Reverse || OrientationWatchDog.this.mLastOrientation == Orientation.Land_Forward);
                        }
                        OrientationWatchDog.this.mLastOrientation = Orientation.Port;
                    }
                }
            };
        }
        this.mLandOrientationListener.enable();
    }

    public void stopWatch() {
        if (this.mLandOrientationListener != null) {
            this.mLandOrientationListener.disable();
        }
    }

    public void destroy() {
        this.stopWatch();
        this.mLandOrientationListener = null;
    }

    public void setOnOrientationListener(OnOrientationListener l) {
        this.mOrientationListener = l;
    }

    public static interface OnOrientationListener {
        public void changedToLandForwardScape(boolean var1);

        public void changedToLandReverseScape(boolean var1);

        public void changedToPortrait(boolean var1);
    }

    private static enum Orientation {
        Port,
        Land_Forward,
        Land_Reverse;

    }
}

