/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.aliyun.svideo.common.R;

public class AlivcCircleLoadingDialog
extends Dialog {
    private final int mHeight;
    private Context context;
    private ImageView mImageView;

    public AlivcCircleLoadingDialog(Context context, int height) {
        super(context, R.style.CustomDialogStyle);
        this.context = context;
        this.mHeight = height;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        View view = inflater.inflate(R.layout.alivc_common_dialog_circle_progress, null, false);
        this.mImageView = (ImageView)view.findViewById(R.id.iv_dialog_progress);
        this.mImageView.setImageResource(R.mipmap.alivc_common_icon_circle_progress);
        this.setAnimation();
        this.setContentView(view);
        Window dialogWindow = this.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        DisplayMetrics d = this.context.getResources().getDisplayMetrics();
        lp.width = d.widthPixels;
        lp.height = this.mHeight == 0 ? d.heightPixels : this.mHeight;
        lp.gravity = 49;
        dialogWindow.setAttributes(lp);
        this.setCancelable(false);
    }

    private void setAnimation() {
        RotateAnimation rotateAnimation = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        rotateAnimation.setDuration(800L);
        rotateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        rotateAnimation.setRepeatMode(1);
        rotateAnimation.setRepeatCount(-1);
        if (this.mImageView.getAnimation() == null) {
            this.mImageView.startAnimation((Animation)rotateAnimation);
        }
    }

    public void show() {
        super.show();
        if (this.mImageView != null) {
            this.setAnimation();
        }
    }

    public void dismiss() {
        super.dismiss();
        if (this.mImageView != null) {
            this.mImageView.clearAnimation();
        }
    }
}

