/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.utils;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class BaseRequest {
    public static final int WHAT_SUCCESS = 1;
    public static final int WHAT_FAIL = 0;
    public static final String DATA_KEY_EXTRA = "data_extra";
    private static ExecutorService sThreadPool = Executors.newCachedThreadPool();
    public WeakReference<Context> mContextWeak;
    protected boolean wantStop = false;
    private MsgDispatcher handler = null;
    private OnRequestListener outerListener = null;
    private OnRequestListener innerListener = new OnRequestListener(){

        public void onSuccess(Object requestInfo, String extra) {
            if (BaseRequest.this.outerListener != null) {
                BaseRequest.this.outerListener.onSuccess(requestInfo, extra);
            }
        }

        @Override
        public void onFail(int code, String msg, String extra) {
            if (BaseRequest.this.outerListener != null) {
                BaseRequest.this.outerListener.onFail(code, msg, extra);
            }
        }
    };

    public BaseRequest(Context context, OnRequestListener l) {
        this.mContextWeak = new WeakReference<Context>(context);
        this.outerListener = l;
    }

    public abstract void runInBackground();

    public abstract void stopInner();

    public void getSync() {
        this.runInBackground();
    }

    public void getAsync() {
        this.handler = new MsgDispatcher(this);
        sThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                BaseRequest.this.runInBackground();
            }
        });
    }

    private void dealMsg(Message msg) {
        String requestId;
        Bundle data = msg.getData();
        String string = requestId = data != null ? data.getString(DATA_KEY_EXTRA, "") : "";
        if (msg.what == 1) {
            this.innerListener.onSuccess(msg.obj, requestId);
        } else if (msg.what == 0) {
            this.innerListener.onFail(msg.arg1, (String)msg.obj, requestId);
        }
    }

    public void stop() {
        this.wantStop = true;
        this.stopInner();
    }

    public void sendSuccessResult(Object requestInfo, String extra) {
        if (this.wantStop) {
            return;
        }
        if (this.handler == null) {
            this.innerListener.onSuccess(requestInfo, extra);
        } else {
            Message msg = this.handler.obtainMessage(1);
            msg.obj = requestInfo;
            Bundle data = new Bundle();
            data.putString(DATA_KEY_EXTRA, extra);
            msg.setData(data);
            this.handler.sendMessage(msg);
        }
    }

    public void sendFailResult(int code, String msgStr, String extra) {
        if (this.wantStop) {
            return;
        }
        if (this.handler == null) {
            this.innerListener.onFail(code, msgStr, extra);
        } else {
            Message msg = this.handler.obtainMessage(0);
            msg.what = 0;
            msg.arg1 = code;
            msg.obj = msgStr;
            Bundle data = new Bundle();
            data.putString(DATA_KEY_EXTRA, extra);
            msg.setData(data);
            this.handler.sendMessage(msg);
        }
    }

    private static class MsgDispatcher
    extends Handler {
        private BaseRequest mBaseRequest;

        public MsgDispatcher(BaseRequest baseRequest) {
            this.mBaseRequest = baseRequest;
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.mBaseRequest != null) {
                this.mBaseRequest.dealMsg(msg);
            }
        }
    }

    public static interface OnRequestListener<Result> {
        public void onSuccess(Result var1, String var2);

        public void onFail(int var1, String var2, String var3);
    }
}

