/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.gesture;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.aliyun.player.alivcplayerexpand.view.gesture.GestureView;
import com.aliyun.player.aliyunplayerbase.util.ScreenUtils;

public class GestureControl {
    private static final String TAG = GestureControl.class.getSimpleName();
    public Context mContext;
    private View mGesturebleView;
    private boolean isGestureEnable = true;
    private boolean isInHorizenalGesture = false;
    private boolean isInRightGesture = false;
    private boolean isInLeftGesture = false;
    private GestureDetector mGestureDetector;
    private GestureView.GestureListener mGestureListener;
    private boolean mIsMultiWindow;
    private View mView;
    private final GestureDetector.OnGestureListener mOnGestureListener = new GestureDetector.OnGestureListener(){
        private float mXDown;

        public boolean onSingleTapUp(MotionEvent e) {
            return false;
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!GestureControl.this.isGestureEnable || e1 == null || e2 == null) {
                return false;
            }
            if (Math.abs(distanceX) > Math.abs(distanceY)) {
                if (!GestureControl.this.isInLeftGesture && !GestureControl.this.isInRightGesture) {
                    GestureControl.this.isInHorizenalGesture = true;
                }
            } else if (GestureControl.this.isInHorizenalGesture) {
                // empty if block
            }
            if (GestureControl.this.isInHorizenalGesture) {
                if (GestureControl.this.mGestureListener != null) {
                    GestureControl.this.mGestureListener.onHorizontalDistance(e1.getX(), e2.getX());
                }
            } else if (GestureControl.this.mIsMultiWindow) {
                if (ScreenUtils.isInLeft((View)GestureControl.this.mView, (int)((int)this.mXDown))) {
                    GestureControl.this.isInLeftGesture = true;
                    if (GestureControl.this.mGestureListener != null) {
                        GestureControl.this.mGestureListener.onLeftVerticalDistance(e1.getY(), e2.getY());
                    }
                } else if (ScreenUtils.isInRight((View)GestureControl.this.mView, (int)((int)this.mXDown))) {
                    GestureControl.this.isInRightGesture = true;
                    if (GestureControl.this.mGestureListener != null) {
                        GestureControl.this.mGestureListener.onRightVerticalDistance(e1.getY(), e2.getY());
                    }
                }
            } else if (ScreenUtils.isInLeft((Context)GestureControl.this.mContext, (int)((int)this.mXDown))) {
                GestureControl.this.isInLeftGesture = true;
                if (GestureControl.this.mGestureListener != null) {
                    GestureControl.this.mGestureListener.onLeftVerticalDistance(e1.getY(), e2.getY());
                }
            } else if (ScreenUtils.isInRight((Context)GestureControl.this.mContext, (int)((int)this.mXDown))) {
                GestureControl.this.isInRightGesture = true;
                if (GestureControl.this.mGestureListener != null) {
                    GestureControl.this.mGestureListener.onRightVerticalDistance(e1.getY(), e2.getY());
                }
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }

        public boolean onDown(MotionEvent e) {
            this.mXDown = e.getX();
            return true;
        }
    };

    public GestureControl(Context mContext, View gestureView) {
        this.mContext = mContext;
        this.mGesturebleView = gestureView;
        this.init();
    }

    public void setMultiWindow(boolean isMultiWindow) {
        this.mIsMultiWindow = isMultiWindow;
    }

    public void setView(View view) {
        this.mView = view;
    }

    private void init() {
        this.mGestureDetector = new GestureDetector(this.mContext, this.mOnGestureListener);
        this.mGesturebleView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 1: 
                    case 3: {
                        if (GestureControl.this.mGestureListener != null) {
                            GestureControl.this.mGestureListener.onGestureEnd();
                        }
                        GestureControl.this.isInLeftGesture = false;
                        GestureControl.this.isInRightGesture = false;
                        GestureControl.this.isInHorizenalGesture = false;
                        break;
                    }
                }
                return GestureControl.this.mGestureDetector.onTouchEvent(event);
            }
        });
        this.mGestureDetector.setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (GestureControl.this.mGestureListener != null) {
                    GestureControl.this.mGestureListener.onSingleTap();
                }
                return false;
            }

            public boolean onDoubleTap(MotionEvent e) {
                if (GestureControl.this.mGestureListener != null) {
                    GestureControl.this.mGestureListener.onDoubleTap();
                }
                return false;
            }

            public boolean onDoubleTapEvent(MotionEvent e) {
                return false;
            }
        });
    }

    void enableGesture(boolean enable) {
        this.isGestureEnable = enable;
    }

    void setOnGestureControlListener(GestureView.GestureListener mGestureListener) {
        this.mGestureListener = mGestureListener;
    }
}

