/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.download;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.view.download.AlivcDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.view.sectionlist.SectionParameters;
import com.aliyun.player.alivcplayerexpand.view.sectionlist.StatelessSection;
import com.aliyun.svideo.common.utils.image.ImageLoaderImpl;
import com.aliyun.svideo.common.utils.image.ImageLoaderOptions;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;

public class DownloadSection
extends StatelessSection {
    public static final String DOWNLOADED_TAG = "DownloadedTag";
    public static final String DOWNLOADING_TAG = "DownloadingTag";
    private ArrayList<AlivcDownloadMediaInfo> alivcDownloadMediaInfos = new ArrayList();
    private final String title;
    private final String tag;
    private WeakReference<Context> context;
    private OnSectionItemClickListener onSectionItemClickListener;

    public DownloadSection(Context context, String tag, String title, ArrayList<AlivcDownloadMediaInfo> alivcDownloadMediaInfos) {
        super(SectionParameters.builder().itemResourceId(R.layout.alivc_download_item).headerResourceId(R.layout.alivc_download_section_item).build());
        this.context = new WeakReference<Context>(context);
        this.tag = tag;
        this.title = title;
        this.alivcDownloadMediaInfos = alivcDownloadMediaInfos;
    }

    @Override
    public RecyclerView.ViewHolder getHeaderViewHolder(View view) {
        return new SectionItemViewHolder(view);
    }

    @Override
    public RecyclerView.ViewHolder getItemViewHolder(View view) {
        return new DownloadInfoItemViewHolder(view);
    }

    @Override
    public void onBindHeaderViewHolder(RecyclerView.ViewHolder holder) {
        SectionItemViewHolder headerHolder = (SectionItemViewHolder)holder;
        headerHolder.tvSectionItemTitle.setText((CharSequence)this.title);
    }

    @Override
    public void onBindItemViewHolder(RecyclerView.ViewHolder holder, int position) {
        final DownloadInfoItemViewHolder itemViewHolder = (DownloadInfoItemViewHolder)holder;
        AliyunDownloadMediaInfo mediaInfo = this.alivcDownloadMediaInfos.get(position).getAliyunDownloadMediaInfo();
        new ImageLoaderImpl().loadImage((Context)this.context.get(), mediaInfo.getCoverUrl(), new ImageLoaderOptions.Builder().crossFade().centerCrop().placeholder(R.color.alivc_common_bg_cyan_light).build()).into(itemViewHolder.ivVideoCover);
        itemViewHolder.tvVideoTitle.setText((CharSequence)mediaInfo.getTitle());
        itemViewHolder.cbSelect.setVisibility(this.alivcDownloadMediaInfos.get(position).isEditState() ? 0 : 8);
        itemViewHolder.cbSelect.setChecked(this.alivcDownloadMediaInfos.get(position).isCheckedState());
        AliyunDownloadMediaInfo.Status status = mediaInfo.getStatus();
        if (status == AliyunDownloadMediaInfo.Status.Start && mediaInfo.getProgress() == 100) {
            mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Complete);
            status = AliyunDownloadMediaInfo.Status.Complete;
        }
        if (status == AliyunDownloadMediaInfo.Status.Prepare) {
            itemViewHolder.tvDownloadVideoStats.setText((CharSequence)((Context)this.context.get()).getResources().getString(R.string.download_prepare));
        } else if (status == AliyunDownloadMediaInfo.Status.Wait) {
            itemViewHolder.tvDownloadVideoStats.setText((CharSequence)((Context)this.context.get()).getResources().getString(R.string.download_wait));
        } else if (status == AliyunDownloadMediaInfo.Status.Start) {
            itemViewHolder.tvDownloadVideoStats.setText((CharSequence)((Context)this.context.get()).getResources().getString(R.string.download_downloading));
            itemViewHolder.ivVideoState.setBackgroundResource(R.drawable.alivc_download_pause);
            itemViewHolder.ivVideoState.setVisibility(0);
        } else if (status == AliyunDownloadMediaInfo.Status.Stop) {
            itemViewHolder.tvDownloadVideoStats.setText((CharSequence)((Context)this.context.get()).getResources().getString(R.string.download_pause));
            itemViewHolder.ivVideoState.setBackgroundResource(R.drawable.alivc_download_downloading);
            itemViewHolder.ivVideoState.setVisibility(0);
        } else if (status == AliyunDownloadMediaInfo.Status.Complete) {
            itemViewHolder.tvDownloadVideoStats.setVisibility(8);
            itemViewHolder.ivVideoState.setVisibility(8);
            itemViewHolder.progressDownloadVideo.setVisibility(8);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
            lp.addRule(9, -1);
            itemViewHolder.tvDownloadVideoTotalSize.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else if (status == AliyunDownloadMediaInfo.Status.Error) {
            itemViewHolder.tvDownloadVideoStats.setText((CharSequence)((Context)this.context.get()).getResources().getString(R.string.download_error));
            itemViewHolder.ivVideoState.setVisibility(0);
            itemViewHolder.ivVideoState.setBackgroundResource(R.drawable.alivc_download_downloading);
        }
        itemViewHolder.progressDownloadVideo.setProgress(mediaInfo.getProgress());
        itemViewHolder.tvDownloadVideoTotalSize.setText((CharSequence)this.formatSizeDecimal(mediaInfo.getSize()));
        itemViewHolder.llDownloadItemRootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int adapterPosition = itemViewHolder.getAdapterPosition();
                if (DownloadSection.this.onSectionItemClickListener != null) {
                    if (adapterPosition < 0) {
                        return;
                    }
                    DownloadSection.this.onSectionItemClickListener.onItemClick(adapterPosition, DownloadSection.this.tag);
                }
            }
        });
    }

    private String formatSize(long size) {
        int kb = (int)((float)size / 1024.0f);
        if (kb < 1024) {
            return kb + "KB";
        }
        int mb = (int)((float)kb / 1024.0f);
        return mb + "MB";
    }

    private String formatSizeDecimal(long size) {
        float kb = (float)(size / 1024L) * 1.0f;
        BigDecimal bigDecimal = new BigDecimal(kb);
        if (kb < 1024.0f) {
            return String.format("%.1f", bigDecimal.setScale(2, RoundingMode.HALF_UP)) + "KB";
        }
        float mb = kb / 1024.0f * 1.0f;
        BigDecimal decimal = new BigDecimal(mb);
        return String.format("%.1f", decimal.setScale(2, RoundingMode.HALF_UP)) + "MB";
    }

    @Override
    public int getContentItemsTotal() {
        return this.alivcDownloadMediaInfos.size();
    }

    public void setOnSectionItemClickListener(OnSectionItemClickListener onSectionItemClickListener) {
        this.onSectionItemClickListener = onSectionItemClickListener;
    }

    public static interface OnSectionItemClickListener {
        public void onItemClick(int var1, String var2);
    }

    private static class DownloadInfoItemViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llDownloadItemRootView;
        private CheckBox cbSelect;
        private ImageView ivVideoCover;
        private ImageView ivVideoState;
        private TextView tvVideoTitle;
        private TextView tvDownloadVideoStats;
        private TextView tvDownloadVideoCurrentSpeed;
        private TextView tvDownloadVideoTotalSize;
        private ProgressBar progressDownloadVideo;

        DownloadInfoItemViewHolder(View view) {
            super(view);
            this.llDownloadItemRootView = (LinearLayout)view.findViewById(R.id.ll_download_item_root_view);
            this.cbSelect = (CheckBox)view.findViewById(R.id.cb_select);
            this.ivVideoCover = (ImageView)view.findViewById(R.id.iv_video_cover);
            this.ivVideoState = (ImageView)view.findViewById(R.id.iv_video_state);
            this.tvVideoTitle = (TextView)view.findViewById(R.id.tv_video_title);
            this.tvDownloadVideoStats = (TextView)view.findViewById(R.id.tv_download_video_stats);
            this.tvDownloadVideoCurrentSpeed = (TextView)view.findViewById(R.id.tv_download_video_current_speed);
            this.tvDownloadVideoTotalSize = (TextView)view.findViewById(R.id.tv_video_total_size);
            this.progressDownloadVideo = (ProgressBar)view.findViewById(R.id.progress_download_video);
        }
    }

    private static class SectionItemViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvSectionItemTitle;

        SectionItemViewHolder(View view) {
            super(view);
            this.tvSectionItemTitle = (TextView)view.findViewById(R.id.tv_section_item_title);
        }
    }
}

