/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.function;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatSeekBar;
import android.util.AttributeSet;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.view.function.AdvVideoView;
import com.aliyun.svideo.common.utils.DensityUtils;

public class MutiSeekBarView
extends AppCompatSeekBar {
    private Paint mPaint;
    private int mViewWidth;
    private int mPointY;
    private AdvPosition mAdvPosition;
    private long mAdvTime;
    private int mAdvNumber;
    private long mSourceTime;
    private long mTotalTime;
    private int mPaintStrokeWidth = 2;
    private int mSourceSeekColor = this.getResources().getColor(R.color.alivc_common_font_white_light);
    private int mAdvSeekColor = this.getResources().getColor(R.color.alivc_player_theme_blue);
    private int mAdvWidth;
    private int mSourceWidth;
    private int mPaddingRight;
    private int mPaddingLeft;

    public MutiSeekBarView(Context context) {
        super(context);
        this.init();
    }

    public MutiSeekBarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MutiSeekBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint(1);
        this.mPaintStrokeWidth = DensityUtils.dip2px((Context)this.getContext(), (float)2.0f);
        this.mPaint.setStrokeWidth((float)this.mPaintStrokeWidth);
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingRight = this.getPaddingRight();
    }

    public void setSourceSeekColor(int color2) {
        this.mSourceSeekColor = color2;
    }

    public void setAdvSeekColor(int color2) {
        this.mAdvSeekColor = color2;
    }

    public void setTime(long advTime, long sourceTime, AdvPosition advPosition) {
        this.mAdvTime = advTime;
        this.mAdvPosition = advPosition;
        this.mSourceTime = sourceTime;
        switch (advPosition) {
            case ALL: {
                this.mAdvNumber = 3;
                break;
            }
            case START_END: 
            case START_MIDDLE: 
            case MIDDLE_END: {
                this.mAdvNumber = 2;
                break;
            }
            case ONLY_START: 
            case ONLY_MIDDLE: 
            case ONLY_END: {
                this.mAdvNumber = 1;
                break;
            }
            default: {
                this.mAdvNumber = 0;
            }
        }
        this.calculateScale();
        this.calculateWidth();
        this.invalidate();
    }

    private void calculateScale() {
        this.mTotalTime = this.calculateTotal();
    }

    public void calculateWidth() {
        if (this.mTotalTime == 0L) {
            return;
        }
        this.mAdvWidth = (int)((long)(this.mViewWidth - this.mPaddingRight - this.mPaddingLeft) * this.mAdvTime / this.mTotalTime);
        this.mSourceWidth = (int)((long)(this.mViewWidth - this.mPaddingRight - this.mPaddingLeft) * this.mSourceTime / this.mTotalTime);
        this.invalidate();
    }

    private long calculateTotal() {
        if (this.mAdvPosition == null) {
            return 0L;
        }
        long totalTime = (long)this.mAdvNumber * this.mAdvTime + this.mSourceTime;
        this.setMax((int)totalTime);
        this.setCurrentProgress(0);
        return (long)this.mAdvNumber * this.mAdvTime + this.mSourceTime;
    }

    public void setCurrentProgress(int currentProgress) {
        this.setProgress(currentProgress);
    }

    private boolean isVideoPositionInStart(long mVideoPosition) {
        return mVideoPosition >= 0L && mVideoPosition <= this.mAdvTime;
    }

    private boolean betweenStartAndMiddle(int mVideoPosition) {
        return (long)mVideoPosition > this.mAdvTime && (long)mVideoPosition < this.mSourceTime / 2L + this.mAdvTime;
    }

    private boolean betweenMiddleAndEnd(int mVideoPosition) {
        return (long)mVideoPosition > this.mSourceTime / 2L + this.mAdvTime * 2L && (long)mVideoPosition < this.mSourceTime + this.mAdvTime * 2L;
    }

    private boolean inVideoPositionBeforeMiddle(int mVideoPosition) {
        if (this.mAdvPosition == AdvPosition.ALL || this.mAdvPosition == AdvPosition.START_MIDDLE) {
            return (long)mVideoPosition >= this.mSourceTime / 2L + this.mAdvTime && (long)mVideoPosition <= this.mSourceTime / 2L + this.mAdvTime * 2L;
        }
        if (this.mAdvPosition == AdvPosition.START_END || this.mAdvPosition == AdvPosition.ONLY_START || this.mAdvPosition == AdvPosition.ONLY_END) {
            return false;
        }
        return (long)mVideoPosition >= this.mSourceTime / 2L && (long)mVideoPosition <= this.mSourceTime / 2L + this.mAdvTime;
    }

    private boolean isVideoPositionInMiddle(long mVideoPosition) {
        if (this.mAdvPosition == AdvPosition.ALL || this.mAdvPosition == AdvPosition.START_MIDDLE) {
            return mVideoPosition >= this.mSourceTime / 2L + this.mAdvTime && mVideoPosition <= this.mSourceTime / 2L + this.mAdvTime * 2L;
        }
        if (this.mAdvPosition == AdvPosition.START_END || this.mAdvPosition == AdvPosition.ONLY_START || this.mAdvPosition == AdvPosition.ONLY_END) {
            return false;
        }
        return mVideoPosition >= this.mSourceTime / 2L && mVideoPosition <= this.mSourceTime / 2L + this.mAdvTime;
    }

    private boolean isVideoPositionInEnd(long mVideoPosition) {
        if (this.mAdvPosition == AdvPosition.ALL || this.mAdvPosition == AdvPosition.START_MIDDLE) {
            return mVideoPosition >= this.mSourceTime + this.mAdvTime * 2L;
        }
        if (this.mAdvPosition == AdvPosition.ONLY_START || this.mAdvPosition == AdvPosition.ONLY_MIDDLE || this.mAdvPosition == AdvPosition.START_END || this.mAdvPosition == AdvPosition.MIDDLE_END) {
            return mVideoPosition >= this.mSourceTime + this.mAdvTime;
        }
        return mVideoPosition >= this.mSourceTime;
    }

    public long startPlayPosition(long seekToPosition) {
        long startPlayPosition = seekToPosition;
        switch (this.mAdvPosition) {
            case ONLY_START: {
                if (!this.isVideoPositionInStart(seekToPosition)) break;
                startPlayPosition = 0L;
                break;
            }
            case ONLY_MIDDLE: {
                if (!this.isVideoPositionInMiddle(seekToPosition)) break;
                startPlayPosition = this.mSourceTime / 2L;
                break;
            }
            case ONLY_END: {
                if (!this.isVideoPositionInEnd(seekToPosition)) break;
                startPlayPosition = this.mSourceTime;
                break;
            }
            case START_END: {
                if (this.isVideoPositionInStart(seekToPosition)) {
                    startPlayPosition = 0L;
                    break;
                }
                if (this.isVideoPositionInEnd(seekToPosition)) {
                    startPlayPosition = this.mSourceTime + this.mAdvTime;
                    break;
                }
                startPlayPosition = seekToPosition;
                break;
            }
            case MIDDLE_END: {
                if (this.isVideoPositionInMiddle(seekToPosition)) {
                    startPlayPosition = this.mSourceTime / 2L;
                    break;
                }
                if (this.isVideoPositionInEnd(seekToPosition)) {
                    startPlayPosition = this.mSourceTime + this.mAdvTime;
                    break;
                }
                startPlayPosition = seekToPosition;
                break;
            }
            case START_MIDDLE: {
                if (this.isVideoPositionInStart(seekToPosition)) {
                    startPlayPosition = 0L;
                    break;
                }
                if (this.isVideoPositionInMiddle(seekToPosition)) {
                    startPlayPosition = this.mSourceTime / 2L + this.mAdvTime;
                    break;
                }
                startPlayPosition = seekToPosition;
                break;
            }
            case ALL: {
                if (this.isVideoPositionInStart(seekToPosition)) {
                    startPlayPosition = 0L;
                    break;
                }
                if (this.isVideoPositionInMiddle(seekToPosition)) {
                    startPlayPosition = this.mSourceTime / 2L + this.mAdvTime;
                    break;
                }
                if (this.isVideoPositionInEnd(seekToPosition)) {
                    startPlayPosition = this.mSourceTime + this.mAdvTime * 2L;
                    break;
                }
                startPlayPosition = seekToPosition;
                break;
            }
        }
        return startPlayPosition;
    }

    public AdvVideoView.IntentPlayVideo getIntentPlayVideo(int currentPosition, int seekToPosition) {
        if (this.isVideoPositionInStart(seekToPosition)) {
            return AdvVideoView.IntentPlayVideo.START_ADV;
        }
        if (this.isVideoPositionInMiddle(seekToPosition)) {
            return AdvVideoView.IntentPlayVideo.MIDDLE_ADV;
        }
        if (this.betweenStartAndMiddle(currentPosition) && this.betweenMiddleAndEnd(seekToPosition)) {
            return AdvVideoView.IntentPlayVideo.MIDDLE_ADV_SEEK;
        }
        if (this.isVideoPositionInEnd(seekToPosition) && this.betweenMiddleAndEnd(currentPosition)) {
            return AdvVideoView.IntentPlayVideo.END_ADV;
        }
        if (this.betweenStartAndMiddle(currentPosition) && this.betweenMiddleAndEnd(seekToPosition)) {
            return AdvVideoView.IntentPlayVideo.MIDDLE_ADV_SEEK;
        }
        if (this.betweenStartAndMiddle(currentPosition) && this.isVideoPositionInEnd(seekToPosition)) {
            return AdvVideoView.IntentPlayVideo.MIDDLE_END_ADV_SEEK;
        }
        if (this.betweenStartAndMiddle(seekToPosition) && this.betweenStartAndMiddle(seekToPosition)) {
            return AdvVideoView.IntentPlayVideo.REVERSE_SOURCE;
        }
        return AdvVideoView.IntentPlayVideo.NORMAL;
    }

    private void drawSourceLine(int startX, int endX, Canvas canvas) {
        this.mPaint.setColor(this.mSourceSeekColor);
        canvas.drawLine((float)startX, (float)this.mPointY, (float)endX, (float)this.mPointY, this.mPaint);
    }

    private void drawAdvLine(int startX, int endX, Canvas canvas) {
        this.mPaint.setColor(this.mAdvSeekColor);
        canvas.drawLine((float)startX, (float)this.mPointY, (float)endX, (float)this.mPointY, this.mPaint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int mViewHeight = bottom - top;
        this.mViewWidth = right - left;
        this.mPointY = mViewHeight / 2;
        this.calculateWidth();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mAdvPosition == null) {
            return;
        }
        switch (this.mAdvPosition) {
            case ONLY_START: {
                this.drawAdvLine(this.mPaddingLeft, this.mAdvWidth + this.mPaddingLeft, canvas);
                this.drawSourceLine(this.mAdvWidth + this.mPaddingLeft, this.mAdvWidth + this.mSourceWidth + this.mPaddingLeft, canvas);
                break;
            }
            case ONLY_MIDDLE: {
                this.drawSourceLine(this.mPaddingLeft, this.mSourceWidth / 2 + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mSourceWidth / 2 + this.mPaddingLeft, this.mSourceWidth / 2 + this.mAdvWidth + this.mPaddingLeft, canvas);
                this.drawSourceLine(this.mSourceWidth / 2 + this.mAdvWidth + this.mPaddingLeft, this.mSourceWidth + this.mAdvWidth + this.mPaddingLeft, canvas);
                break;
            }
            case ONLY_END: {
                this.drawSourceLine(this.mPaddingLeft, this.mSourceWidth + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mSourceWidth + this.mPaddingLeft, this.mSourceWidth + this.mAdvWidth + this.mPaddingLeft, canvas);
                break;
            }
            case START_END: {
                this.drawAdvLine((int)(this.getX() + (float)this.mPaddingLeft), (int)(this.getX() + (float)this.mAdvWidth + (float)this.mPaddingLeft), canvas);
                this.drawSourceLine(this.mAdvWidth + this.mPaddingLeft, this.mAdvWidth + this.mSourceWidth + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mAdvWidth + this.mSourceWidth + this.mPaddingLeft, this.mAdvWidth * 2 + this.mSourceWidth + this.mPaddingLeft, canvas);
                break;
            }
            case START_MIDDLE: {
                this.drawSourceLine(this.mPaddingLeft, this.mAdvWidth + this.mPaddingLeft, canvas);
                this.drawSourceLine(this.mAdvWidth + this.mPaddingLeft, this.mAdvWidth + this.mSourceWidth / 2 + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mAdvWidth + this.mSourceWidth / 2 + this.mPaddingLeft, this.mAdvWidth * 2 + this.mSourceWidth / 2 + this.mPaddingLeft, canvas);
                this.drawSourceLine(this.mAdvWidth * 2 + this.mSourceWidth / 2 + this.mPaddingLeft, this.mAdvWidth * 2 + this.mSourceWidth + this.mPaddingLeft, canvas);
                break;
            }
            case MIDDLE_END: {
                this.drawSourceLine(this.mPaddingLeft, this.mSourceWidth / 2 + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mSourceWidth / 2 + this.mPaddingLeft, this.mSourceWidth / 2 + this.mAdvWidth + this.mPaddingLeft, canvas);
                this.drawSourceLine(this.mSourceWidth / 2 + this.mAdvWidth + this.mPaddingLeft, this.mSourceWidth + this.mAdvWidth + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mSourceWidth + this.mAdvWidth + this.mPaddingLeft, this.mSourceWidth + this.mAdvWidth * 2 + this.mPaddingLeft, canvas);
                break;
            }
            case ALL: {
                this.drawAdvLine(this.mPaddingLeft, this.mAdvWidth + this.mPaddingLeft, canvas);
                this.drawSourceLine(this.mAdvWidth + this.mPaddingLeft, this.mAdvWidth + this.mSourceWidth / 2 + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mAdvWidth + this.mSourceWidth / 2 + this.mPaddingLeft, this.mAdvWidth * 2 + this.mSourceWidth / 2 + this.mPaddingLeft, canvas);
                this.drawSourceLine(this.mAdvWidth * 2 + this.mSourceWidth / 2 + this.mPaddingLeft, this.mAdvWidth * 2 + this.mSourceWidth + this.mPaddingLeft, canvas);
                this.drawAdvLine(this.mAdvWidth * 2 + this.mSourceWidth + this.mPaddingLeft, this.mAdvWidth * 3 + this.mSourceWidth + this.mPaddingLeft, canvas);
                break;
            }
            default: {
                this.drawSourceLine(this.mPaddingLeft, this.mSourceWidth, canvas);
            }
        }
        super.onDraw(canvas);
    }

    public static enum AdvPosition {
        ONLY_START(0),
        ONLY_MIDDLE(1),
        ONLY_END(2),
        START_END(3),
        START_MIDDLE(4),
        MIDDLE_END(5),
        ALL(6);


        private AdvPosition(int n2) {
        }
    }
}

