/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.function;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import master.flame.danmaku.controller.DrawHandler;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.ui.widget.DanmakuView;

public class PlayerDanmakuView
extends DanmakuView {
    private HashMap<Integer, Integer> mMaxLinesPair;
    private HashMap<Integer, Boolean> mOverLappingEnablePair;
    private float mSpeed = 1.0f;
    private float mTextSize = 8.0f;
    private int mTextColor = -1;
    private int mDanmaType = 1;
    private Map<Integer, ArrayList<String>> mDanmakuList = new HashMap<Integer, ArrayList<String>>();
    private DanmakuContext mDanmakuContext;
    private AliyunScreenMode mScreenMode = AliyunScreenMode.Small;
    private BaseDanmakuParser mBaseDanmakuParser = new BaseDanmakuParser(){

        protected IDanmakus parse() {
            return new Danmakus();
        }
    };

    public PlayerDanmakuView(Context context) {
        super(context);
        this.init();
    }

    public PlayerDanmakuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PlayerDanmakuView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mDanmakuContext = DanmakuContext.create();
        this.mMaxLinesPair = new HashMap();
        this.mOverLappingEnablePair = new HashMap();
        this.mMaxLinesPair.put(1, 3);
        this.mOverLappingEnablePair.put(1, true);
        this.initDanmakuContext();
        this.initCallback();
    }

    private void initDanmakuContext() {
        this.mDanmakuContext.setDanmakuStyle(-1, new float[]{3.0f}).setDuplicateMergingEnabled(true).setScrollSpeedFactor(this.mSpeed).setScaleTextSize(this.mTextSize).setMaximumLines(this.mMaxLinesPair).setMaximumVisibleSizeInScreen(0).preventOverlapping(this.mOverLappingEnablePair).setDanmakuMargin(5);
        this.enableDanmakuDrawingCache(true);
        this.prepare(this.mBaseDanmakuParser, this.mDanmakuContext);
    }

    private void initCallback() {
        this.setCallback(new DrawHandler.Callback(){

            public void prepared() {
                PlayerDanmakuView.this.start();
            }

            public void updateTimer(DanmakuTimer timer) {
            }

            public void danmakuShown(BaseDanmaku danmaku) {
            }

            public void drawingFinished() {
            }
        });
    }

    public void setDanmakuSpeed(float speed) {
        if (this.mDanmakuContext != null) {
            if ((double)speed <= 0.01) {
                speed = 0.01f;
            }
            this.mDanmakuContext.setScrollSpeedFactor(speed);
        }
    }

    public void setDanmakuRegion(int progress) {
        if (this.mMaxLinesPair != null) {
            switch (progress) {
                case 0: {
                    if (this.mDanmakuContext == null) break;
                    this.mMaxLinesPair.put(1, 3);
                    this.mDanmakuContext.setMaximumLines(this.mMaxLinesPair);
                    break;
                }
                case 1: {
                    if (this.mDanmakuContext == null) break;
                    this.mMaxLinesPair.put(1, 5);
                    this.mDanmakuContext.setMaximumLines(this.mMaxLinesPair);
                    break;
                }
                case 2: {
                    if (this.mDanmakuContext == null) break;
                    this.mMaxLinesPair.put(1, 7);
                    this.mDanmakuContext.setMaximumLines(null);
                    break;
                }
                case 3: {
                    if (this.mDanmakuContext == null) break;
                    this.mDanmakuContext.setMaximumLines(null);
                    break;
                }
                default: {
                    if (this.mDanmakuContext == null) break;
                    this.mMaxLinesPair.put(1, 3);
                    this.mDanmakuContext.setMaximumLines(null);
                }
            }
        }
    }

    public void addDanmaku(String content, long time) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        BaseDanmaku baseDanmaku = this.mDanmakuContext.mDanmakuFactory.createDanmaku(this.mDanmaType);
        baseDanmaku.text = content;
        baseDanmaku.textSize = this.mTextSize;
        baseDanmaku.setTime(this.getCurrentTime());
        baseDanmaku.textColor = this.mTextColor;
        this.addDanmaku(baseDanmaku);
        int key = (int)(time / 1000L);
        ArrayList<String> stringsList = this.mDanmakuList.get(key);
        if (stringsList == null) {
            stringsList = new ArrayList();
        }
        stringsList.add(content);
        this.mDanmakuList.put(key, stringsList);
    }

    public void addDanmaku(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        BaseDanmaku baseDanmaku = this.mDanmakuContext.mDanmakuFactory.createDanmaku(this.mDanmaType);
        if (baseDanmaku == null) {
            return;
        }
        baseDanmaku.text = content;
        baseDanmaku.textSize = this.mTextSize;
        baseDanmaku.textColor = this.mTextColor;
        baseDanmaku.setTime(this.getCurrentTime());
        this.addDanmaku(baseDanmaku);
    }

    public void switchDanmaku(boolean show) {
        if (show) {
            this.resume();
            this.show();
        } else {
            this.pause();
            this.hide();
        }
    }

    public boolean danmuIsShown() {
        return this.isShown();
    }

    public void setScreenMode(AliyunScreenMode screenMode) {
        this.mScreenMode = screenMode;
    }

    public void setCurrentPosition(int mCurrentPosition) {
        if (this.mScreenMode == AliyunScreenMode.Small || !this.isShown()) {
            return;
        }
        int time = mCurrentPosition / 1000;
        if (time == 1) {
            this.addDanmaku(this.getResources().getString(R.string.alivc_danmaku_text_1));
        }
        if (time == 2) {
            this.addDanmaku(this.getResources().getString(R.string.alivc_danmaku_text_2));
        }
        if (time == 3) {
            this.addDanmaku(this.getResources().getString(R.string.alivc_danmaku_text_3));
        }
    }

    public void clearDanmaList() {
        if (this.mDanmakuList != null && this.mDanmakuList.size() > 0) {
            this.mDanmakuList.clear();
        }
    }
}

