/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.gesturedialog;

import android.app.Activity;
import android.content.Context;
import android.view.Window;
import android.view.WindowManager;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.view.gesturedialog.BaseGestureDialog;

public class BrightnessDialog
extends BaseGestureDialog {
    private static final String TAG = BrightnessDialog.class.getSimpleName();
    private int mCurrentBrightness = 0;

    public BrightnessDialog(Activity activity, int percent) {
        super((Context)activity);
        this.mCurrentBrightness = percent;
        this.mImageView.setImageResource(R.drawable.alivc_brightness);
        this.updateBrightness(percent);
    }

    public void updateBrightness(int percent) {
        this.mTextView.setText((CharSequence)(percent + "%"));
    }

    public static int getActivityBrightness(Activity activity) {
        if (activity != null) {
            Window window = activity.getWindow();
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            float screenBrightness = layoutParams.screenBrightness;
            if (screenBrightness > 1.0f) {
                screenBrightness = 1.0f;
            } else if (screenBrightness < 0.1f) {
                screenBrightness = 0.1f;
            }
            return (int)(screenBrightness * 100.0f);
        }
        return 0;
    }

    public int getTargetBrightnessPercent(int changePercent) {
        int newBrightness = this.mCurrentBrightness - changePercent;
        if (newBrightness > 100) {
            newBrightness = 100;
        } else if (newBrightness < 0) {
            newBrightness = 0;
        }
        return newBrightness;
    }
}

