/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.aliyun.player.AliPlayer;
import com.aliyun.player.AliPlayerFactory;
import com.aliyun.player.IPlayer;
import com.aliyun.player.VidPlayerConfigGen;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.bean.DotBean;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.alivcplayerexpand.listener.LockPortraitListener;
import com.aliyun.player.alivcplayerexpand.listener.OnAutoPlayListener;
import com.aliyun.player.alivcplayerexpand.listener.OnScreenCostingSingleTagListener;
import com.aliyun.player.alivcplayerexpand.listener.OnStoppedListener;
import com.aliyun.player.alivcplayerexpand.theme.ITheme;
import com.aliyun.player.alivcplayerexpand.theme.Theme;
import com.aliyun.player.alivcplayerexpand.util.BrowserCheckUtil;
import com.aliyun.player.alivcplayerexpand.util.DensityUtil;
import com.aliyun.player.alivcplayerexpand.util.TimeFormater;
import com.aliyun.player.alivcplayerexpand.view.control.ControlView;
import com.aliyun.player.alivcplayerexpand.view.dot.DotView;
import com.aliyun.player.alivcplayerexpand.view.function.AdvPictureView;
import com.aliyun.player.alivcplayerexpand.view.function.AdvVideoView;
import com.aliyun.player.alivcplayerexpand.view.function.MarqueeView;
import com.aliyun.player.alivcplayerexpand.view.function.MutiSeekBarView;
import com.aliyun.player.alivcplayerexpand.view.function.PlayerDanmakuView;
import com.aliyun.player.alivcplayerexpand.view.function.WaterMarkRegion;
import com.aliyun.player.alivcplayerexpand.view.gesture.GestureDialogManager;
import com.aliyun.player.alivcplayerexpand.view.gesture.GestureView;
import com.aliyun.player.alivcplayerexpand.view.guide.GuideView;
import com.aliyun.player.alivcplayerexpand.view.interfaces.ViewAction;
import com.aliyun.player.alivcplayerexpand.view.more.SpeedValue;
import com.aliyun.player.alivcplayerexpand.view.quality.QualityView;
import com.aliyun.player.alivcplayerexpand.view.speed.SpeedView;
import com.aliyun.player.alivcplayerexpand.view.thumbnail.ThumbnailView;
import com.aliyun.player.alivcplayerexpand.view.trailers.TrailersView;
import com.aliyun.player.alivcplayerexpand.widget.AliyunRenderView;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.aliyunplayerbase.util.NetWatchdog;
import com.aliyun.player.aliyunplayerbase.util.OrientationWatchDog;
import com.aliyun.player.aliyunplayerbase.util.ScreenUtils;
import com.aliyun.player.aliyunplayerbase.view.tipsview.OnTipsViewBackClickListener;
import com.aliyun.player.aliyunplayerbase.view.tipsview.TipsView;
import com.aliyun.player.bean.ErrorInfo;
import com.aliyun.player.bean.InfoBean;
import com.aliyun.player.bean.InfoCode;
import com.aliyun.player.nativeclass.CacheConfig;
import com.aliyun.player.nativeclass.MediaInfo;
import com.aliyun.player.nativeclass.PlayerConfig;
import com.aliyun.player.nativeclass.Thumbnail;
import com.aliyun.player.nativeclass.TrackInfo;
import com.aliyun.player.source.LiveSts;
import com.aliyun.player.source.StsInfo;
import com.aliyun.player.source.UrlSource;
import com.aliyun.player.source.VidAuth;
import com.aliyun.player.source.VidMps;
import com.aliyun.player.source.VidSts;
import com.aliyun.subtitle.SubtitleView;
import com.aliyun.svideo.common.utils.DensityUtils;
import com.aliyun.svideo.common.utils.FileUtils;
import com.aliyun.svideo.common.utils.ThreadUtils;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.svideo.common.utils.image.ImageLoaderImpl;
import com.aliyun.thumbnail.ThumbnailBitmapInfo;
import com.aliyun.thumbnail.ThumbnailHelper;
import com.cicada.player.utils.Logger;
import com.cicada.player.utils.ass.AssHeader;
import com.cicada.player.utils.ass.AssSubtitleView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AliyunVodPlayerView
extends RelativeLayout
implements ITheme {
    private static final String VIDEO_ADV_VID = "9fb028c29acb421cb634c77cf4ebe078";
    private static final String ADV_VIDEO_URL = "https://alivc-demo-cms.alicdn.com/video/videoAD.mp4";
    private static final String ADV_URL = "https://www.aliyun.com/product/vod?spm=5176.10695662.782639.1.4ac218e2p7BEEf";
    private static final String ADV_PICTURE_URL = "";
    private static final String WATER_MARK_URL = "";
    private static final WaterMarkRegion WATER_MARK_REGION = WaterMarkRegion.RIGHT_TOP;
    private static final MarqueeView.MarqueeRegion MARQUEE_REGION = MarqueeView.MarqueeRegion.TOP;
    private static final String TAG = AliyunVodPlayerView.class.getSimpleName();
    private static final int ADV_VIDEO_PREPARED = 0;
    private static final int SOURCE_VIDEO_PREPARED = 1;
    private Map<MediaInfo, Boolean> hasLoadEnd = new HashMap<MediaInfo, Boolean>();
    private SurfaceView mSurfaceView;
    private GestureView mGestureView;
    private ControlView mControlView;
    private QualityView mQualityView;
    private SpeedView mSpeedView;
    private GuideView mGuideView;
    private ImageView mCoverView;
    private GestureDialogManager mGestureDialogManager;
    private NetWatchdog mNetWatchdog;
    private OrientationWatchDog mOrientationWatchDog;
    private TipsView mTipsView;
    private AdvPictureView mAdvPictureView;
    private LockPortraitListener mLockPortraitListener = null;
    private boolean mIsFullScreenLocked = false;
    private AliyunScreenMode mCurrentScreenMode = AliyunScreenMode.Small;
    private boolean inSeek = false;
    private boolean isCompleted = false;
    private MediaInfo mAliyunMediaInfo;
    private MediaInfo mAdvVideoMediaInfo;
    private int mCurrentBufferPercentage = 0;
    private MarqueeView mMarqueeView;
    private ThumbnailView mThumbnailView;
    private ThumbnailHelper mThumbnailHelper;
    private boolean mThumbnailPrepareSuccess = false;
    private VodPlayerHandler mVodPlayerHandler;
    private VodPlayerLoadEndHandler vodPlayerLoadEndHandler = new VodPlayerLoadEndHandler(this);
    private long mVideoBufferedPosition = 0L;
    private long mCurrentPosition = 0L;
    private long mAdvCurrentPosition;
    private long mAdvTotalPosition = 0L;
    private int mPlayerState = 0;
    private MutiSeekBarView.AdvPosition mAdvPosition = MutiSeekBarView.AdvPosition.ALL;
    private long mSourceDuration;
    private long mAdvDuration;
    private AdvVideoView mAdvVideoView;
    private PlayerDanmakuView mDanmakuView;
    private ImageView mWaterMark;
    private TrailersView mTrailersView;
    private boolean mIsScreenCosting = false;
    private SubtitleView mSubtitleView;
    private VidAuth mAliyunPlayAuth;
    private VidMps mAliyunVidMps;
    private UrlSource mAliyunLocalSource;
    private VidSts mAliyunVidSts;
    private LiveSts mAliyunLiveSts;
    private OnFinishListener mOnFinishListener = null;
    private IPlayer.OnInfoListener mOutInfoListener = null;
    private IPlayer.OnErrorListener mOutErrorListener = null;
    private IPlayer.OnTrackReadyListener mOutOnTrackReadyListener = null;
    private OnAutoPlayListener mOutAutoPlayListener = null;
    private IPlayer.OnPreparedListener mOutPreparedListener = null;
    private IPlayer.OnCompletionListener mOutCompletionListener = null;
    private IPlayer.OnSeekCompleteListener mOuterSeekCompleteListener = null;
    private IPlayer.OnTrackChangedListener mOutOnTrackChangedListener = null;
    private IPlayer.OnRenderingStartListener mOutFirstFrameStartListener = null;
    private OnScreenCostingSingleTagListener mOnScreenCostingSingleTagListener = null;
    private OnScreenBrightnessListener mOnScreenBrightnessListener = null;
    private OnTimeExpiredErrorListener mOutTimeExpiredErrorListener = null;
    private OnTipsViewBackClickListener mOutOnTipsViewBackClickListener = null;
    private OnSoftKeyHideListener mOnSoftKeyHideListener = null;
    private TrailersView.OnTrailerViewClickListener mOnTrailerViewClickListener = null;
    private IPlayer.OnSeiDataListener mOutOnSeiDataListener = null;
    private AliPlayer.OnVerifyTimeExpireCallback mOutOnVerifyTimeExpireCallback = null;
    private TipsView.OnTipClickListener mOutOnTipClickListener = null;
    private NetConnectedListener mNetConnectedListener = null;
    private ControlView.OnShowMoreClickListener mOutOnShowMoreClickListener;
    private OnPlayStateBtnClickListener onPlayStateBtnClickListener;
    private OnStoppedListener mOnStoppedListener;
    private ControlView.OnDotViewClickListener mOnDotViewClickListener;
    private ControlView.OnControlViewHideListener mOnControlViewHideListener;
    private OnScreenCostingVideoCompletionListener mOnScreenCostingVideoCompletionListener;
    private ControlView.OnTrackInfoClickListener mOutOnTrackInfoClickListener;
    private int mAdvVideoPlayerState;
    private int mSeekToPosition;
    private int mSourceSeekToPosition;
    private int mSeekToCurrentPlayerPosition;
    private int mAdvVideoCount = 0;
    private boolean needToSeek = false;
    private AdvVideoView.IntentPlayVideo mCurrentIntentPlayVideo;
    private int mScreenBrightness;
    private boolean mInBackground = false;
    private boolean mIsOperatorPlay;
    private Map<Integer, AssHeader.SubtitleType> mSubtitleTypeMap = new HashMap<Integer, AssHeader.SubtitleType>();
    private MediaInfo mAdvVideoMeidaInfo;
    private MediaInfo mSourceVideoMediaInfo;
    private float currentSpeed;
    private float currentVolume;
    private int mScreenCostingVolume;
    public static int TRAILER = 300;
    public static String PLAY_DOMAIN = "alivc-demo-vod-player.aliyuncs.com";
    private boolean mIsVipRetry;
    private boolean mIsInMultiWindow;
    private int mStartScreenCostingPosition;
    private boolean mIsNeedOnlyFullScreen;
    private boolean initNetWatch;
    private AliyunRenderView mAliyunRenderView;
    private AssSubtitleView mAssSubtitleView;
    private OnSeekStartListener onSeekStartListener;
    private OnOrientationChangeListener orientationChangeListener;

    public AliyunVodPlayerView(Context context) {
        super(context);
        this.initVideoView();
    }

    public AliyunVodPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView();
    }

    public AliyunVodPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVideoView();
    }

    private void initVideoView() {
        this.mVodPlayerHandler = new VodPlayerHandler(this);
        this.initAliVcPlayer();
        this.initCoverView();
        this.initGestureView();
        this.initWaterMark();
        this.initMarquee();
        this.initTrailersView();
        this.initControlView();
        this.initAdvVideoView();
        this.initQualityView();
        this.initThumbnailView();
        this.initSpeedView();
        this.initGuideView();
        this.initTipsView();
        this.initNetWatchdog();
        this.initOrientationWatchdog();
        this.initGestureDialogManager();
        this.initAdvPicture();
        this.setTheme(Theme.Blue);
        this.hideGestureAndControlViews();
        this.initDanmaku();
        this.initSubtitleView();
    }

    @Override
    public void setTheme(Theme theme) {
        int childCounts = this.getChildCount();
        for (int i = 0; i < childCounts; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof ITheme)) continue;
            ((ITheme)view).setTheme(theme);
        }
    }

    private void initThumbnailView() {
        this.mThumbnailView = new ThumbnailView(this.getContext());
        this.mThumbnailView.setVisibility(8);
        this.addSubViewByCenter((View)this.mThumbnailView);
        this.hideThumbnailView();
    }

    public void initAdvPicture() {
        this.mAdvPictureView = new AdvPictureView(this.getContext());
        this.mAdvPictureView.setAdvPictureUrl("");
        this.mAdvPictureView.setVisibility(8);
        this.addSubView((View)this.mAdvPictureView);
        this.mAdvPictureView.setOnAdvPictureListener(new AdvPictureView.OnAdvPictureListener(){

            @Override
            public void finish() {
                if (AliyunVodPlayerView.this.mOnFinishListener != null) {
                    AliyunVodPlayerView.this.mAdvPictureView.cancel();
                    AliyunVodPlayerView.this.mOnFinishListener.onFinishClick();
                }
            }

            @Override
            public void close() {
                if (AliyunVodPlayerView.this.mAdvPictureView != null) {
                    AliyunVodPlayerView.this.mAdvPictureView.hideAll();
                    AliyunVodPlayerView.this.mAdvPictureView.cancel();
                }
                if (AliyunVodPlayerView.this.mAliyunRenderView != null && !AliyunVodPlayerView.this.mInBackground) {
                    if (NetWatchdog.is4GConnected((Context)AliyunVodPlayerView.this.getContext()) && AliyunVodPlayerView.this.mTipsView != null) {
                        AliyunVodPlayerView.this.mTipsView.showNetChangeTipView();
                    } else {
                        AliyunVodPlayerView.this.mAliyunRenderView.setAutoPlay(true);
                        AliyunVodPlayerView.this.mAliyunRenderView.start();
                    }
                }
            }

            @Override
            public void onClick() {
                AliyunVodPlayerView.this.openAdvertisement();
            }
        });
    }

    public void openAdvertisement() {
        List<ResolveInfo> resolveInfos = BrowserCheckUtil.checkBrowserList(this.getContext());
        if (resolveInfos == null || resolveInfos.size() <= 0) {
            ToastUtils.show((Context)this.getContext(), (String)this.getContext().getString(R.string.alivc_player_not_check_any_browser));
            return;
        }
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)ADV_URL));
        intent.setAction("android.intent.action.VIEW");
        this.getContext().startActivity(intent);
    }

    private void initMarquee() {
        this.mMarqueeView = new MarqueeView(this.getContext());
        this.addSubViewHeightWrap((View)this.mMarqueeView);
    }

    private void initTrailersView() {
        this.mTrailersView = new TrailersView(this.getContext());
        this.addSubView((View)this.mTrailersView);
        this.mTrailersView.hideAll();
        this.mTrailersView.setOnTrailerViewClickListener(this.mOnTrailerViewClickListener);
        this.mTrailersView.setOnTrailerViewClickListener(new TrailersView.OnTrailerViewClickListener(){

            @Override
            public void onTrailerPlayAgainClick() {
                if (AliyunVodPlayerView.this.mOnTrailerViewClickListener != null) {
                    AliyunVodPlayerView.this.mOnTrailerViewClickListener.onTrailerPlayAgainClick();
                }
                AliyunVodPlayerView.this.mTrailersView.hideAll();
            }

            @Override
            public void onOpenVipClick() {
                if (AliyunVodPlayerView.this.mOnTrailerViewClickListener != null) {
                    AliyunVodPlayerView.this.mOnTrailerViewClickListener.onOpenVipClick();
                }
            }
        });
    }

    private void initDanmaku() {
        this.mDanmakuView = new PlayerDanmakuView(this.getContext());
        this.mDanmakuView.hide();
        this.addSubViewBelow((View)this.mDanmakuView, (View)this.mMarqueeView);
    }

    private void initWaterMark() {
        this.mWaterMark = new ImageView(this.getContext());
        this.mWaterMark.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mWaterMark.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.alivc_watermark_icon));
        this.mWaterMark.setVisibility(8);
        this.addSubViewByWrap((View)this.mWaterMark);
    }

    private void hideGestureAndControlViews() {
        if (this.mGestureView != null) {
            this.mGestureView.hide(ViewAction.HideType.Normal);
        }
        if (this.mControlView != null) {
            this.mControlView.hide(ViewAction.HideType.Normal);
        }
    }

    private void initNetWatchdog() {
        Context context = this.getContext();
        this.mNetWatchdog = new NetWatchdog(context);
        this.mNetWatchdog.setNetChangeListener((NetWatchdog.NetChangeListener)new MyNetChangeListener(this));
        this.mNetWatchdog.setNetConnectedListener((NetWatchdog.NetConnectedListener)new MyNetConnectedListener(this));
    }

    private void onWifiTo4G() {
        if (this.mTipsView.isErrorShow() || GlobalPlayerConfig.IS_VIDEO && (this.mAdvVideoPlayerState == 3 || this.mAdvVideoPlayerState == 4)) {
            return;
        }
        if (!this.isLocalSource()) {
            if (this.mIsOperatorPlay) {
                ToastUtils.show((Context)this.getContext(), (int)R.string.alivc_operator_play);
            } else {
                this.pause();
            }
        }
        if (!this.initNetWatch) {
            this.reload();
        }
        if (!this.isLocalSource() && this.mTipsView != null) {
            if (this.mIsOperatorPlay) {
                ToastUtils.show((Context)this.getContext(), (int)R.string.alivc_operator_play);
            } else {
                this.mTipsView.hideAll();
                this.mTipsView.showNetChangeTipView();
                if (this.mControlView != null) {
                    this.mControlView.setHideType(ViewAction.HideType.Normal);
                    this.mControlView.hide(ViewAction.HideType.Normal);
                }
                if (this.mGestureView != null) {
                    this.mGestureView.setHideType(ViewAction.HideType.Normal);
                    this.mGestureView.hide(ViewAction.HideType.Normal);
                }
                if (this.mAdvPictureView != null) {
                    this.mAdvPictureView.hideAll();
                }
            }
        }
        this.initNetWatch = false;
    }

    private void on4GToWifi() {
        if (this.mTipsView.isErrorShow()) {
            return;
        }
        if (this.mTipsView != null) {
            this.mTipsView.hideNetErrorTipView();
        }
        if (!this.initNetWatch) {
            this.reload();
        }
        this.initNetWatch = false;
    }

    private void onNetDisconnected() {
    }

    private void initOrientationWatchdog() {
        Context context = this.getContext();
        this.mOrientationWatchDog = new OrientationWatchDog(context);
        this.mOrientationWatchDog.setOnOrientationListener((OrientationWatchDog.OnOrientationListener)new InnerOrientationListener(this));
    }

    private void changedToLandForwardScape(boolean fromPort) {
        if (!fromPort) {
            return;
        }
        this.changeScreenMode(AliyunScreenMode.Full, false);
        if (this.orientationChangeListener != null) {
            this.orientationChangeListener.orientationChange(fromPort, this.mCurrentScreenMode);
        }
    }

    private void changedToLandReverseScape(boolean fromPort) {
        if (!fromPort) {
            return;
        }
        this.changeScreenMode(AliyunScreenMode.Full, true);
        if (this.orientationChangeListener != null) {
            this.orientationChangeListener.orientationChange(fromPort, this.mCurrentScreenMode);
        }
    }

    private void changedToPortrait(boolean fromLand) {
        if (this.mIsFullScreenLocked) {
            return;
        }
        if (this.mCurrentScreenMode == AliyunScreenMode.Full) {
            if (this.getLockPortraitMode() == null && fromLand) {
                this.changeScreenMode(AliyunScreenMode.Small, false);
            }
        } else if (this.mCurrentScreenMode == AliyunScreenMode.Small) {
            // empty if block
        }
        if (this.orientationChangeListener != null) {
            this.orientationChangeListener.orientationChange(fromLand, this.mCurrentScreenMode);
        }
    }

    private void initGestureDialogManager() {
        Context context = this.getContext();
        if (context instanceof Activity) {
            this.mGestureDialogManager = new GestureDialogManager((Activity)context);
        }
    }

    private void initTipsView() {
        this.mTipsView = new TipsView(this.getContext());
        this.mTipsView.setOnTipClickListener(new TipsView.OnTipClickListener(){

            public void onContinuePlay() {
                AliyunVodPlayerView.this.mIsOperatorPlay = true;
                AliyunVodPlayerView.this.mTipsView.hideAll();
                if (GlobalPlayerConfig.IS_VIDEO) {
                    if (AliyunVodPlayerView.this.mAliyunRenderView != null) {
                        AliyunVodPlayerView.this.mAliyunRenderView.start();
                    }
                    if (AliyunVodPlayerView.this.mControlView != null) {
                        AliyunVodPlayerView.this.mControlView.setHideType(ViewAction.HideType.Normal);
                    }
                    if (AliyunVodPlayerView.this.mGestureView != null) {
                        AliyunVodPlayerView.this.mGestureView.setVisibility(0);
                        AliyunVodPlayerView.this.mGestureView.setHideType(ViewAction.HideType.Normal);
                    }
                } else if (AliyunVodPlayerView.this.mPlayerState == 0 || AliyunVodPlayerView.this.mPlayerState == 5 || AliyunVodPlayerView.this.mPlayerState == 7 || AliyunVodPlayerView.this.mPlayerState == 6) {
                    AliyunVodPlayerView.this.mAliyunRenderView.setAutoPlay(true);
                    if (AliyunVodPlayerView.this.mAliyunPlayAuth != null) {
                        AliyunVodPlayerView.this.prepareAuth(AliyunVodPlayerView.this.mAliyunPlayAuth);
                    } else if (AliyunVodPlayerView.this.mAliyunVidSts != null) {
                        AliyunVodPlayerView.this.prepareVidsts(AliyunVodPlayerView.this.mAliyunVidSts);
                    } else if (AliyunVodPlayerView.this.mAliyunVidMps != null) {
                        AliyunVodPlayerView.this.prepareMps(AliyunVodPlayerView.this.mAliyunVidMps);
                    } else if (AliyunVodPlayerView.this.mAliyunLocalSource != null) {
                        AliyunVodPlayerView.this.prepareLocalSource(AliyunVodPlayerView.this.mAliyunLocalSource);
                    } else if (AliyunVodPlayerView.this.mAliyunLiveSts != null) {
                        AliyunVodPlayerView.this.prepareLiveSts(AliyunVodPlayerView.this.mAliyunLiveSts);
                    }
                } else {
                    AliyunVodPlayerView.this.start();
                }
            }

            public void onStopPlay() {
                AliyunVodPlayerView.this.mTipsView.hideAll();
                AliyunVodPlayerView.this.stop();
                Context context = AliyunVodPlayerView.this.getContext();
                if (context instanceof Activity) {
                    ((Activity)context).finish();
                }
            }

            public void onRetryPlay(int errorCode) {
                if (AliyunVodPlayerView.this.mOutOnTipClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnTipClickListener.onRetryPlay(errorCode);
                }
            }

            public void onReplay() {
                AliyunVodPlayerView.this.rePlay();
            }

            public void onRefreshSts() {
                if (AliyunVodPlayerView.this.mOutTimeExpiredErrorListener != null) {
                    AliyunVodPlayerView.this.mOutTimeExpiredErrorListener.onTimeExpiredError();
                }
            }

            public void onWait() {
                AliyunVodPlayerView.this.mTipsView.hideAll();
                AliyunVodPlayerView.this.mTipsView.showNetLoadingTipView();
            }

            public void onExit() {
                AliyunVodPlayerView.this.mTipsView.hideAll();
                if (AliyunVodPlayerView.this.mOutOnTipClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnTipClickListener.onExit();
                }
            }
        });
        this.mTipsView.setOnTipsViewBackClickListener(new OnTipsViewBackClickListener(){

            public void onBackClick() {
                if (AliyunVodPlayerView.this.mOutOnTipsViewBackClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnTipsViewBackClickListener.onBackClick();
                }
            }
        });
        this.addSubView((View)this.mTipsView);
    }

    private void reset() {
        this.isCompleted = false;
        this.inSeek = false;
        this.mCurrentPosition = 0L;
        this.mAdvTotalPosition = 0L;
        this.mAdvCurrentPosition = 0L;
        this.mVideoBufferedPosition = 0L;
        this.needToSeek = false;
        this.mCurrentIntentPlayVideo = AdvVideoView.IntentPlayVideo.NORMAL;
        if (this.mTipsView != null) {
            this.mTipsView.hideAll();
        }
        if (this.mTrailersView != null) {
            this.mTrailersView.hideAll();
        }
        if (this.mControlView != null) {
            this.mControlView.reset();
        }
        if (this.mGestureView != null) {
            this.mGestureView.reset();
        }
        if (this.mDanmakuView != null) {
            this.mDanmakuView.clearDanmaList();
        }
        if (this.mAdvPictureView != null) {
            this.mAdvPictureView.cancel();
            this.mAdvPictureView.hideAll();
        }
        this.stop();
    }

    private void initCoverView() {
        this.mCoverView = new ImageView(this.getContext());
        this.mCoverView.setId(R.id.custom_id_min);
        this.addSubView((View)this.mCoverView);
    }

    private void initControlView() {
        this.mControlView = new ControlView(this.getContext());
        this.addSubView((View)this.mControlView);
        this.mControlView.setOnPlayStateClickListener(new ControlView.OnPlayStateClickListener(){

            @Override
            public void onPlayStateClick() {
                AliyunVodPlayerView.this.switchPlayerState();
            }
        });
        this.mControlView.setOnSeekListener(new ControlView.OnSeekListener(){

            @Override
            public void onSeekEnd(int position) {
                if (AliyunVodPlayerView.this.mControlView != null) {
                    AliyunVodPlayerView.this.mControlView.setVideoPosition(position);
                }
                if (AliyunVodPlayerView.this.isCompleted) {
                    AliyunVodPlayerView.this.inSeek = false;
                } else {
                    if (!AliyunVodPlayerView.this.mIsScreenCosting) {
                        AliyunVodPlayerView.this.seekTo(position);
                    }
                    if (AliyunVodPlayerView.this.onSeekStartListener != null) {
                        AliyunVodPlayerView.this.onSeekStartListener.onSeekStart(position);
                    }
                    AliyunVodPlayerView.this.hideThumbnailView();
                }
            }

            @Override
            public void onSeekStart(int position) {
                AliyunVodPlayerView.this.inSeek = true;
                AliyunVodPlayerView.this.mSeekToCurrentPlayerPosition = position;
                if (AliyunVodPlayerView.this.mThumbnailPrepareSuccess) {
                    AliyunVodPlayerView.this.showThumbnailView();
                }
            }

            @Override
            public void onProgressChanged(int progress) {
                AliyunVodPlayerView.this.requestBitmapByPosition(progress);
            }
        });
        this.mControlView.setOnQualityBtnClickListener(new ControlView.OnQualityBtnClickListener(){

            @Override
            public void onQualityBtnClick(View v, List<TrackInfo> qualities, String currentQuality) {
                AliyunVodPlayerView.this.mQualityView.setQuality(qualities, currentQuality);
                AliyunVodPlayerView.this.mQualityView.showAtTop(v);
            }

            @Override
            public void onHideQualityView() {
                AliyunVodPlayerView.this.mQualityView.hide();
            }
        });
        this.mControlView.setOnTrackInfoClickListener(new ControlView.OnTrackInfoClickListener(){

            @Override
            public void onSubtitleClick(List<TrackInfo> subtitleTrackInfoList) {
                if (AliyunVodPlayerView.this.mOutOnTrackInfoClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnTrackInfoClickListener.onSubtitleClick(subtitleTrackInfoList);
                }
            }

            @Override
            public void onAudioClick(List<TrackInfo> audioTrackInfoList) {
                if (AliyunVodPlayerView.this.mOutOnTrackInfoClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnTrackInfoClickListener.onAudioClick(audioTrackInfoList);
                }
            }

            @Override
            public void onBitrateClick(List<TrackInfo> bitrateTrackInfoList) {
                if (AliyunVodPlayerView.this.mOutOnTrackInfoClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnTrackInfoClickListener.onBitrateClick(bitrateTrackInfoList);
                }
            }

            @Override
            public void onDefinitionClick(List<TrackInfo> definitionTrackInfoList) {
                if (AliyunVodPlayerView.this.mOutOnTrackInfoClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnTrackInfoClickListener.onDefinitionClick(definitionTrackInfoList);
                }
            }
        });
        this.mControlView.setOnScreenLockClickListener(new ControlView.OnScreenLockClickListener(){

            @Override
            public void onClick() {
                AliyunVodPlayerView.this.lockScreen(!AliyunVodPlayerView.this.mIsFullScreenLocked);
            }
        });
        this.mControlView.setOnScreenModeClickListener(new ControlView.OnScreenModeClickListener(){

            @Override
            public void onClick() {
                if (AliyunVodPlayerView.this.mCurrentScreenMode == AliyunScreenMode.Small) {
                    AliyunVodPlayerView.this.changedToLandForwardScape(true);
                } else {
                    AliyunVodPlayerView.this.changedToPortrait(true);
                }
                if (AliyunVodPlayerView.this.mCurrentScreenMode == AliyunScreenMode.Full) {
                    AliyunVodPlayerView.this.mControlView.showMoreButton();
                } else if (AliyunVodPlayerView.this.mCurrentScreenMode == AliyunScreenMode.Small) {
                    AliyunVodPlayerView.this.mControlView.hideMoreButton();
                }
            }
        });
        this.mControlView.setOnBackClickListener(new ControlView.OnBackClickListener(){

            @Override
            public void onClick() {
                Context context;
                if (AliyunVodPlayerView.this.mCurrentScreenMode == AliyunScreenMode.Full) {
                    if (AliyunVodPlayerView.this.isLocalSource()) {
                        if (AliyunVodPlayerView.this.orientationChangeListener != null) {
                            AliyunVodPlayerView.this.orientationChangeListener.orientationChange(false, AliyunScreenMode.Small);
                        }
                    } else {
                        AliyunVodPlayerView.this.changeScreenMode(AliyunScreenMode.Small, false);
                    }
                } else if (AliyunVodPlayerView.this.mCurrentScreenMode == AliyunScreenMode.Small && (context = AliyunVodPlayerView.this.getContext()) instanceof Activity) {
                    ((Activity)context).finish();
                }
                if (AliyunVodPlayerView.this.mCurrentScreenMode == AliyunScreenMode.Small) {
                    AliyunVodPlayerView.this.mControlView.hideMoreButton();
                }
            }
        });
        this.mControlView.setOnShowMoreClickListener(new ControlView.OnShowMoreClickListener(){

            @Override
            public void showMore() {
                if (AliyunVodPlayerView.this.mOutOnShowMoreClickListener != null) {
                    AliyunVodPlayerView.this.mOutOnShowMoreClickListener.showMore();
                }
            }
        });
        this.mControlView.setOnScreenShotClickListener(new ControlView.OnScreenShotClickListener(){

            @Override
            public void onScreenShotClick() {
                if (!AliyunVodPlayerView.this.mIsFullScreenLocked) {
                    AliyunVodPlayerView.this.snapShot();
                }
            }
        });
        this.mControlView.setOnScreenRecoderClickListener(new ControlView.OnScreenRecoderClickListener(){

            @Override
            public void onScreenRecoderClick() {
                if (!AliyunVodPlayerView.this.mIsFullScreenLocked) {
                    // empty if block
                }
            }
        });
        this.mControlView.setOnInputDanmakuClickListener(new ControlView.OnInputDanmakuClickListener(){

            @Override
            public void onInputDanmakuClick() {
                AliyunVodPlayerView.this.showInputDanmakuClick();
                AliyunVodPlayerView.this.pause();
            }
        });
        this.mControlView.setOnDLNAControlListener(new ControlView.OnDLNAControlListener(){

            @Override
            public void onExit() {
                AliyunVodPlayerView.this.mIsScreenCosting = false;
                if (AliyunVodPlayerView.this.mAdvPictureView != null) {
                    AliyunVodPlayerView.this.mAdvPictureView.hideAll();
                }
                if (AliyunVodPlayerView.this.mControlView != null) {
                    AliyunVodPlayerView.this.mControlView.exitScreenCost();
                    AliyunVodPlayerView.this.mControlView.setInScreenCosting(AliyunVodPlayerView.this.mIsScreenCosting);
                    if (GlobalPlayerConfig.IS_VIDEO) {
                        AliyunVodPlayerView.this.mControlView.hideNativeSeekBar();
                    } else {
                        AliyunVodPlayerView.this.mControlView.showNativeSeekBar();
                    }
                }
                AliyunVodPlayerView.this.seekTo((int)AliyunVodPlayerView.this.mCurrentPosition);
            }

            @Override
            public void onChangeQuality() {
            }
        });
        this.mControlView.setOnDotViewClickListener(new ControlView.OnDotViewClickListener(){

            @Override
            public void onDotViewClick(int x, int y, DotView dotView) {
                if (AliyunVodPlayerView.this.mOnDotViewClickListener != null) {
                    AliyunVodPlayerView.this.mOnDotViewClickListener.onDotViewClick(x, y, dotView);
                }
            }
        });
        this.mControlView.setOnControlViewHideListener(new ControlView.OnControlViewHideListener(){

            @Override
            public void onControlViewHide() {
                if (AliyunVodPlayerView.this.mOnControlViewHideListener != null) {
                    AliyunVodPlayerView.this.mOnControlViewHideListener.onControlViewHide();
                }
            }
        });
    }

    public void setOnDotViewClickListener(ControlView.OnDotViewClickListener listener) {
        this.mOnDotViewClickListener = listener;
    }

    public void setOnControlViewHideListener(ControlView.OnControlViewHideListener listener) {
        this.mOnControlViewHideListener = listener;
    }

    public void setOnTipClickListener(TipsView.OnTipClickListener listener) {
        this.mOutOnTipClickListener = listener;
    }

    private void showInputDanmakuClick() {
        if (this.mOnSoftKeyHideListener != null) {
            this.mOnSoftKeyHideListener.onClickPaint();
        }
    }

    private void initQualityView() {
        this.mQualityView = new QualityView(this.getContext());
        this.addSubView((View)this.mQualityView);
        this.mQualityView.setOnQualityClickListener(new QualityView.OnQualityClickListener(){

            @Override
            public void onQualityClick(TrackInfo qualityTrackInfo) {
                AliyunVodPlayerView.this.mAliyunRenderView.selectTrack(qualityTrackInfo.getIndex());
            }
        });
    }

    private void initSpeedView() {
        this.mSpeedView = new SpeedView(this.getContext());
        this.addSubView((View)this.mSpeedView);
        this.mSpeedView.setOnSpeedClickListener(new SpeedView.OnSpeedClickListener(){

            @Override
            public void onSpeedClick(SpeedView.SpeedValue value) {
                float speed = 1.0f;
                if (value == SpeedView.SpeedValue.Normal) {
                    speed = 1.0f;
                } else if (value == SpeedView.SpeedValue.OneQuartern) {
                    speed = 1.25f;
                } else if (value == SpeedView.SpeedValue.OneHalf) {
                    speed = 1.5f;
                } else if (value == SpeedView.SpeedValue.Twice) {
                    speed = 2.0f;
                }
                if (AliyunVodPlayerView.this.mAliyunRenderView != null) {
                    AliyunVodPlayerView.this.mAliyunRenderView.setSpeed(speed);
                }
                AliyunVodPlayerView.this.mSpeedView.setSpeed(value);
            }

            @Override
            public void onHide() {
            }
        });
    }

    private void initGuideView() {
        this.mGuideView = new GuideView(this.getContext());
        this.addSubView((View)this.mGuideView);
    }

    private void switchPlayerState() {
        if (this.mPlayerState == 3) {
            this.pause();
        } else if (this.mPlayerState == 4 || this.mPlayerState == 2 || this.mPlayerState == 5) {
            this.start();
        }
        if (this.onPlayStateBtnClickListener != null) {
            this.onPlayStateBtnClickListener.onPlayBtnClick(this.mPlayerState);
        }
    }

    private void initGestureView() {
        this.mGestureView = new GestureView(this.getContext());
        this.addSubView(this.mGestureView);
        this.mGestureView.setMultiWindow(this.mIsInMultiWindow);
        this.mGestureView.setOnGestureListener(new GestureView.GestureListener(){

            @Override
            public void onHorizontalDistance(float downX, float nowX) {
                if (AliyunVodPlayerView.this.mIsScreenCosting) {
                    return;
                }
                long duration = AliyunVodPlayerView.this.mAliyunRenderView.getDuration();
                long position = AliyunVodPlayerView.this.mCurrentPosition;
                long deltaPosition = 0L;
                int targetPosition = 0;
                if (AliyunVodPlayerView.this.mPlayerState == 2 || AliyunVodPlayerView.this.mPlayerState == 4 || AliyunVodPlayerView.this.mPlayerState == 3) {
                    deltaPosition = (long)(nowX - downX) * duration / (long)AliyunVodPlayerView.this.getWidth();
                    targetPosition = AliyunVodPlayerView.this.getTargetPosition(duration, position, deltaPosition);
                }
                if (AliyunVodPlayerView.this.mControlView != null) {
                    AliyunVodPlayerView.this.inSeek = true;
                    AliyunVodPlayerView.this.mControlView.setVideoPosition(targetPosition);
                    AliyunVodPlayerView.this.mControlView.closeAutoHide();
                    if (!AliyunVodPlayerView.this.mIsScreenCosting && AliyunVodPlayerView.this.mThumbnailPrepareSuccess) {
                        AliyunVodPlayerView.this.requestBitmapByPosition(targetPosition);
                        AliyunVodPlayerView.this.showThumbnailView();
                    }
                }
            }

            @Override
            public void onLeftVerticalDistance(float downY, float nowY) {
                int changePercent = (int)((nowY - downY) * 100.0f / (float)AliyunVodPlayerView.this.getHeight());
                if (AliyunVodPlayerView.this.mGestureDialogManager != null) {
                    AliyunVodPlayerView.this.mGestureDialogManager.showBrightnessDialog((View)AliyunVodPlayerView.this, AliyunVodPlayerView.this.mScreenBrightness);
                    int brightness = AliyunVodPlayerView.this.mGestureDialogManager.updateBrightnessDialog(changePercent);
                    if (AliyunVodPlayerView.this.mOnScreenBrightnessListener != null) {
                        AliyunVodPlayerView.this.mOnScreenBrightnessListener.onScreenBrightness(brightness);
                    }
                    AliyunVodPlayerView.this.mScreenBrightness = brightness;
                }
            }

            @Override
            public void onRightVerticalDistance(float downY, float nowY) {
                float volume = AliyunVodPlayerView.this.mAliyunRenderView.getVolume();
                int changePercent = (int)((nowY - downY) * 100.0f / (float)AliyunVodPlayerView.this.getHeight());
                if (AliyunVodPlayerView.this.mGestureDialogManager != null) {
                    AliyunVodPlayerView.this.mGestureDialogManager.showVolumeDialog((View)AliyunVodPlayerView.this, volume * 100.0f);
                    float targetVolume = AliyunVodPlayerView.this.mGestureDialogManager.updateVolumeDialog(changePercent);
                    AliyunVodPlayerView.this.currentVolume = targetVolume;
                    AliyunVodPlayerView.this.mAliyunRenderView.setVolume(targetVolume / 100.0f);
                }
            }

            @Override
            public void onGestureEnd() {
                if (AliyunVodPlayerView.this.mGestureDialogManager != null) {
                    int seekPosition = AliyunVodPlayerView.this.mControlView.getVideoPosition();
                    if ((long)seekPosition >= AliyunVodPlayerView.this.mAliyunRenderView.getDuration()) {
                        seekPosition = (int)(AliyunVodPlayerView.this.mAliyunRenderView.getDuration() - 1000L);
                    }
                    if (seekPosition <= 0) {
                        seekPosition = 0;
                    }
                    if (AliyunVodPlayerView.this.mThumbnailView != null && AliyunVodPlayerView.this.inSeek) {
                        AliyunVodPlayerView.this.seekTo(seekPosition);
                        AliyunVodPlayerView.this.inSeek = false;
                        if (AliyunVodPlayerView.this.mThumbnailView.isShown()) {
                            AliyunVodPlayerView.this.hideThumbnailView();
                        }
                    }
                    if (AliyunVodPlayerView.this.mControlView != null) {
                        AliyunVodPlayerView.this.mControlView.openAutoHide();
                    }
                    AliyunVodPlayerView.this.mGestureDialogManager.dismissBrightnessDialog();
                    AliyunVodPlayerView.this.mGestureDialogManager.dismissVolumeDialog();
                }
            }

            @Override
            public void onSingleTap() {
                if (AliyunVodPlayerView.this.mControlView != null) {
                    if (AliyunVodPlayerView.this.mAdvVideoPlayerState == 3 && GlobalPlayerConfig.IS_VIDEO) {
                        AliyunVodPlayerView.this.openAdvertisement();
                    } else if (AliyunVodPlayerView.this.mIsScreenCosting) {
                        if (AliyunVodPlayerView.this.mOnScreenCostingSingleTagListener != null) {
                            AliyunVodPlayerView.this.mOnScreenCostingSingleTagListener.onScreenCostingSingleTag();
                        }
                    } else if (AliyunVodPlayerView.this.mControlView.getVisibility() != 0) {
                        AliyunVodPlayerView.this.mControlView.show();
                    } else {
                        AliyunVodPlayerView.this.mControlView.hide(ViewAction.HideType.Normal);
                    }
                }
            }

            @Override
            public void onDoubleTap() {
                if (!(AliyunVodPlayerView.this.mIsScreenCosting || GlobalPlayerConfig.IS_TRAILER && AliyunVodPlayerView.this.mCurrentPosition >= (long)TRAILER || GlobalPlayerConfig.IS_TRAILER && AliyunVodPlayerView.this.mAdvVideoPlayerState == 3)) {
                    AliyunVodPlayerView.this.switchPlayerState();
                }
            }
        });
    }

    private void initAdvVideoView() {
        this.mAdvVideoView = new AdvVideoView(this.getContext());
        this.addSubView((View)this.mAdvVideoView);
        this.mAdvVideoView.setOutPreparedListener(new VideoPlayerPreparedListener(this, true));
        this.mAdvVideoView.setOutOnLoadingStatusListener(new VideoPlayerLoadingStatusListener(this, true));
        this.mAdvVideoView.setOutOnStateChangedListener(new VideoPlayerStateChangedListener(this, true));
        this.mAdvVideoView.setOutOnCompletionListener(new VideoPlayerCompletionListener(this, true));
        this.mAdvVideoView.setOutOnInfoListener(new VideoPlayerInfoListener(this, true));
        this.mAdvVideoView.setOutOnErrorListener(new VideoPlayerErrorListener(this, true));
        this.mAdvVideoView.setOutOnRenderingStartListener(new VideoPlayerRenderingStartListener(this, true));
        this.mAdvVideoView.setOnBackImageViewClickListener(new VideoPlayerAdvBackImageViewListener(this));
    }

    private void initAliVcPlayer() {
        this.mAliyunRenderView = new AliyunRenderView(this.getContext());
        this.addSubView((View)this.mAliyunRenderView);
        this.mAliyunRenderView.setSurfaceType(AliyunRenderView.SurfaceType.SURFACE_VIEW);
        this.mAliyunRenderView.setOnPreparedListener(new VideoPlayerPreparedListener(this, false));
        this.mAliyunRenderView.setOnErrorListener(new VideoPlayerErrorListener(this, false));
        this.mAliyunRenderView.setOnLoadingStatusListener(new VideoPlayerLoadingStatusListener(this, false));
        this.mAliyunRenderView.setOnTrackReadyListenenr(new VideoPlayerOnTrackReadyListenner(this));
        this.mAliyunRenderView.setOnStateChangedListener(new VideoPlayerStateChangedListener(this, false));
        this.mAliyunRenderView.setOnCompletionListener(new VideoPlayerCompletionListener(this, false));
        this.mAliyunRenderView.setOnInfoListener(new VideoPlayerInfoListener(this, false));
        this.mAliyunRenderView.setOnRenderingStartListener(new VideoPlayerRenderingStartListener(this, false));
        this.mAliyunRenderView.setOnTrackChangedListener(new VideoPlayerTrackChangedListener(this));
        this.mAliyunRenderView.setOnSubtitleDisplayListener(new VideoPlayerSubtitleDeisplayListener(this));
        this.mAliyunRenderView.setOnSeekCompleteListener(new VideoPlayerOnSeekCompleteListener(this));
        this.mAliyunRenderView.setOnSnapShotListener(new VideoPlayerOnSnapShotListener(this));
        this.mAliyunRenderView.setOnSeiDataListener(new VideoPlayerOnSeiDataListener(this));
        this.mAliyunRenderView.setOnVerifyTimeExpireCallback(new VideoPlayerOnVerifyStsCallback(this));
    }

    private void initSubtitleView() {
        this.mSubtitleView = new SubtitleView(this.getContext());
        this.mSubtitleView.setId(R.id.alivc_player_subtitle);
        SubtitleView.DefaultValueBuilder defaultValueBuilder = new SubtitleView.DefaultValueBuilder();
        defaultValueBuilder.setLocation(64);
        defaultValueBuilder.setColor("#e7e7e7");
        this.mSubtitleView.setDefaultValue(defaultValueBuilder);
        this.addSubView((View)this.mSubtitleView);
        this.mAssSubtitleView = new AssSubtitleView(this.getContext());
        this.mAssSubtitleView.setId(R.id.cicada_player_ass_subtitle);
        this.addSubViewByCenter((View)this.mAssSubtitleView);
    }

    private void startAdvVideo() {
        if (GlobalPlayerConfig.IS_TRAILER) {
            if (this.mSourceSeekToPosition < TRAILER * 1000) {
                this.playAdvVideo();
            }
        } else {
            this.playAdvVideo();
        }
    }

    private void playAdvVideo() {
        if (this.mAliyunRenderView != null && this.mAdvVideoView != null) {
            this.mAliyunRenderView.pause();
            int advPlayerState = this.mAdvVideoView.getAdvPlayerState();
            if (advPlayerState == 4 || advPlayerState == 2 || advPlayerState == 3) {
                this.mAdvVideoView.optionStart();
            } else {
                this.mAdvVideoView.optionPrepare();
            }
        }
    }

    private String getTitle(String title) {
        String finalTitle = title;
        if (this.mAliyunLocalSource != null) {
            finalTitle = this.mAliyunLocalSource.getTitle();
        } else if (this.mAliyunPlayAuth != null) {
            finalTitle = this.mAliyunPlayAuth.getTitle();
        } else if (this.mAliyunVidSts != null) {
            finalTitle = this.mAliyunVidSts.getTitle();
        }
        if (TextUtils.isEmpty((CharSequence)finalTitle)) {
            return title;
        }
        return finalTitle;
    }

    private String getPostUrl(String postUrl) {
        String finalPostUrl = postUrl;
        if (this.mAliyunLocalSource != null) {
            finalPostUrl = this.mAliyunLocalSource.getCoverPath();
        } else if (this.mAliyunPlayAuth != null) {
            // empty if block
        }
        if (TextUtils.isEmpty((CharSequence)finalPostUrl)) {
            return postUrl;
        }
        return finalPostUrl;
    }

    public void setMultiWindow(boolean isInMultiWindow) {
        this.mIsInMultiWindow = isInMultiWindow;
        if (this.mGestureView != null) {
            this.mGestureView.setMultiWindow(this.mIsInMultiWindow);
        }
    }

    private void isAutoAccurate(long position) {
        if (GlobalPlayerConfig.PlayConfig.mEnableAccurateSeekModule) {
            this.mAliyunRenderView.seekTo(position, IPlayer.SeekMode.Accurate);
        } else {
            this.mAliyunRenderView.seekTo(position, IPlayer.SeekMode.Inaccurate);
        }
    }

    public int getBufferPercentage() {
        if (this.mAliyunRenderView != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isLocalSource() {
        String scheme = null;
        if (GlobalPlayerConfig.PLAYTYPE.STS.equals((Object)GlobalPlayerConfig.mCurrentPlayType) || GlobalPlayerConfig.PLAYTYPE.MPS.equals((Object)GlobalPlayerConfig.mCurrentPlayType) || GlobalPlayerConfig.PLAYTYPE.AUTH.equals((Object)GlobalPlayerConfig.mCurrentPlayType) || GlobalPlayerConfig.PLAYTYPE.DEFAULT.equals((Object)GlobalPlayerConfig.mCurrentPlayType)) {
            return false;
        }
        if (this.mAliyunLocalSource == null || TextUtils.isEmpty((CharSequence)this.mAliyunLocalSource.getUri())) {
            return false;
        }
        if (GlobalPlayerConfig.PLAYTYPE.URL.equals((Object)GlobalPlayerConfig.mCurrentPlayType)) {
            Uri parse = Uri.parse((String)this.mAliyunLocalSource.getUri());
            scheme = parse.getScheme();
        }
        return scheme == null;
    }

    public int getDuration() {
        if (this.mAliyunRenderView != null) {
            return (int)this.mAliyunRenderView.getDuration();
        }
        return 0;
    }

    public void showErrorTipView(int errorCode, String errorEvent, String errorMsg) {
        this.stop();
        if (this.mAdvPictureView != null) {
            this.mAdvPictureView.cancel();
            this.mAdvPictureView.hideAll();
        }
        if (this.mControlView != null) {
            this.mControlView.setPlayState(ControlView.PlayState.NotPlaying);
        }
        if (this.mTipsView != null) {
            this.mGestureView.hide(ViewAction.HideType.End);
            this.mControlView.hide(ViewAction.HideType.End);
            this.mCoverView.setVisibility(8);
            this.mTipsView.showErrorTipView(errorCode, errorEvent, errorMsg);
            this.mTrailersView.hideAll();
        }
    }

    private void hideErrorTipView() {
        if (this.mTipsView != null) {
            this.mTipsView.hideErrorTipView();
        }
    }

    private void requestBitmapByPosition(int targetPosition) {
        if (this.mThumbnailHelper != null && this.mThumbnailPrepareSuccess) {
            this.mThumbnailHelper.requestBitmapAtPosition((long)targetPosition);
        }
    }

    private void hideThumbnailView() {
        if (this.mThumbnailView != null) {
            this.mThumbnailView.hideThumbnailView();
        }
    }

    private void showThumbnailView() {
        if (this.mThumbnailView != null) {
            this.mThumbnailView.showThumbnailView();
            ImageView thumbnailImageView = this.mThumbnailView.getThumbnailImageView();
            if (thumbnailImageView != null) {
                ViewGroup.LayoutParams layoutParams = thumbnailImageView.getLayoutParams();
                layoutParams.width = ScreenUtils.getWidth((Context)this.getContext()) / 3;
                layoutParams.height = layoutParams.width / 2 - DensityUtils.px2dip((Context)this.getContext(), (float)10.0f);
                thumbnailImageView.setLayoutParams(layoutParams);
            }
        }
    }

    public int getTargetPosition(long duration, long currentPosition, long deltaPosition) {
        long totalMinutes = duration / 1000L / 60L;
        int hours = (int)(totalMinutes / 60L);
        int minutes = (int)(totalMinutes % 60L);
        long finalDeltaPosition = hours >= 1 ? deltaPosition / 10L : (minutes > 30 ? deltaPosition / 5L : (minutes > 10 ? deltaPosition / 3L : (minutes > 3 ? deltaPosition / 2L : deltaPosition)));
        long targetPosition = finalDeltaPosition + currentPosition;
        if (targetPosition < 0L) {
            targetPosition = 0L;
        }
        if (targetPosition > duration) {
            targetPosition = duration;
        }
        return (int)targetPosition;
    }

    private void addSubView(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void addSubViewBelow(final View view, final View belowTargetView) {
        belowTargetView.post(new Runnable(){

            @Override
            public void run() {
                int measuredHeight;
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
                params.topMargin = measuredHeight = belowTargetView.getMeasuredHeight();
                AliyunVodPlayerView.this.addView(view, (ViewGroup.LayoutParams)params);
            }
        });
    }

    private void addSubViewByCenter(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void addSubViewHeightWrap(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        switch (MARQUEE_REGION) {
            case TOP: {
                params.addRule(10);
                break;
            }
            case MIDDLE: {
                params.addRule(15);
                break;
            }
            case BOTTOM: {
                params.addRule(12);
                break;
            }
            default: {
                params.addRule(10);
            }
        }
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void addSubViewByBottom(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void addSubViewByWrap(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        switch (WATER_MARK_REGION) {
            case LEFT_TOP: {
                params.leftMargin = DensityUtil.dip2px(this.getContext(), 20.0f);
                params.topMargin = DensityUtil.dip2px(this.getContext(), 10.0f);
                params.addRule(9);
                params.addRule(10);
                break;
            }
            case LEFT_BOTTOM: {
                params.leftMargin = DensityUtil.dip2px(this.getContext(), 20.0f);
                params.bottomMargin = DensityUtil.dip2px(this.getContext(), 10.0f);
                params.addRule(9);
                params.addRule(12);
                break;
            }
            case RIGHT_TOP: {
                params.rightMargin = DensityUtil.dip2px(this.getContext(), 20.0f);
                params.topMargin = DensityUtil.dip2px(this.getContext(), 10.0f);
                params.addRule(11);
                params.addRule(10);
                break;
            }
            case RIGHT_BOTTOM: {
                params.rightMargin = DensityUtil.dip2px(this.getContext(), 20.0f);
                params.bottomMargin = DensityUtil.dip2px(this.getContext(), 10.0f);
                params.addRule(11);
                params.addRule(12);
                break;
            }
            default: {
                params.rightMargin = DensityUtil.dip2px(this.getContext(), 20.0f);
                params.topMargin = DensityUtil.dip2px(this.getContext(), 10.0f);
                params.addRule(11);
                params.addRule(10);
            }
        }
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    public void changeScreenMode(AliyunScreenMode targetMode, boolean isReverse) {
        AliyunScreenMode finalScreenMode = targetMode;
        if (this.mIsFullScreenLocked) {
            finalScreenMode = AliyunScreenMode.Full;
        }
        if (targetMode != this.mCurrentScreenMode) {
            this.mCurrentScreenMode = finalScreenMode;
        }
        if (this.mGestureDialogManager != null) {
            this.mGestureDialogManager.setCurrentScreenMode(this.mCurrentScreenMode);
        }
        if (this.mControlView != null) {
            this.mControlView.setScreenModeStatus(finalScreenMode);
        }
        if (this.mSpeedView != null) {
            this.mSpeedView.setScreenMode(finalScreenMode);
        }
        if (this.mDanmakuView != null) {
            this.mDanmakuView.setScreenMode(finalScreenMode);
        }
        if (this.mMarqueeView != null) {
            this.mMarqueeView.setScreenMode(finalScreenMode);
        }
        if (this.mGuideView != null) {
            this.mGuideView.setScreenMode(finalScreenMode);
        }
        this.setWaterMarkPosition(finalScreenMode);
        Context context = this.getContext();
        if (context instanceof Activity) {
            if (finalScreenMode == AliyunScreenMode.Full) {
                if (this.getLockPortraitMode() == null) {
                    if (isReverse) {
                        ((Activity)context).setRequestedOrientation(8);
                    } else {
                        ((Activity)context).setRequestedOrientation(0);
                    }
                } else {
                    ViewGroup.LayoutParams aliVcVideoViewLayoutParams = this.getLayoutParams();
                    aliVcVideoViewLayoutParams.height = -1;
                    aliVcVideoViewLayoutParams.width = -1;
                }
                this.showDanmakuAndMarquee();
            } else if (finalScreenMode == AliyunScreenMode.Small) {
                if (this.getLockPortraitMode() == null) {
                    ((Activity)context).setRequestedOrientation(1);
                } else {
                    ViewGroup.LayoutParams aliVcVideoViewLayoutParams = this.getLayoutParams();
                    aliVcVideoViewLayoutParams.height = (int)((float)ScreenUtils.getWidth((Context)context) * 9.0f / 16.0f);
                    aliVcVideoViewLayoutParams.width = -1;
                }
                if (this.mDanmakuView != null) {
                    this.mDanmakuView.hide();
                }
                if (this.mMarqueeView != null) {
                    this.mMarqueeView.pause();
                }
            }
        }
    }

    private void setWaterMarkPosition(AliyunScreenMode screenMode) {
        if (this.mWaterMark == null) {
            return;
        }
        int navigationBarHeight = ScreenUtils.getNavigationBarHeight((Context)this.getContext());
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mWaterMark.getLayoutParams();
        switch (WATER_MARK_REGION) {
            case LEFT_TOP: {
                params.leftMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? (float)(navigationBarHeight / 2) : 20.0f);
                params.topMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? 20.0f : 10.0f);
                break;
            }
            case LEFT_BOTTOM: {
                params.leftMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? (float)(navigationBarHeight / 2) : 20.0f);
                params.bottomMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? 20.0f : 10.0f);
                break;
            }
            case RIGHT_TOP: {
                params.rightMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? (float)(navigationBarHeight / 2) : 20.0f);
                params.topMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? 20.0f : 10.0f);
                break;
            }
            case RIGHT_BOTTOM: {
                params.rightMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? (float)(navigationBarHeight / 2) : 20.0f);
                params.bottomMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? 20.0f : 10.0f);
                break;
            }
            default: {
                params.rightMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? (float)(navigationBarHeight / 2) : 20.0f);
                params.topMargin = DensityUtil.dip2px(this.getContext(), screenMode == AliyunScreenMode.Full ? 20.0f : 10.0f);
            }
        }
        this.mWaterMark.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public AliyunScreenMode getScreenMode() {
        return this.mCurrentScreenMode;
    }

    public void setOnPreparedListener(IPlayer.OnPreparedListener onPreparedListener) {
        this.mOutPreparedListener = onPreparedListener;
    }

    public void setOnTrackReadyListener(IPlayer.OnTrackReadyListener onTrackReadyListener) {
        this.mOutOnTrackReadyListener = onTrackReadyListener;
    }

    public void setOnErrorListener(IPlayer.OnErrorListener onErrorListener) {
        this.mOutErrorListener = onErrorListener;
    }

    public void setOnInfoListener(IPlayer.OnInfoListener onInfoListener) {
        this.mOutInfoListener = onInfoListener;
    }

    public void setOnCompletionListener(IPlayer.OnCompletionListener onCompletionListener) {
        this.mOutCompletionListener = onCompletionListener;
    }

    public void setOnScreenCostingSingleTagListener(OnScreenCostingSingleTagListener listener) {
        this.mOnScreenCostingSingleTagListener = listener;
    }

    public void setOnAutoPlayListener(OnAutoPlayListener l) {
        this.mOutAutoPlayListener = l;
    }

    public void setOnTimeExpiredErrorListener(OnTimeExpiredErrorListener l) {
        this.mOutTimeExpiredErrorListener = l;
    }

    public void setOnScreenCostingVideoCompletionListener(OnScreenCostingVideoCompletionListener listener) {
        this.mOnScreenCostingVideoCompletionListener = listener;
    }

    public void setOnTipsViewBackClickListener(OnTipsViewBackClickListener listener) {
        this.mOutOnTipsViewBackClickListener = listener;
    }

    public void setOnFirstFrameStartListener(IPlayer.OnRenderingStartListener onFirstFrameStartListener) {
        this.mOutFirstFrameStartListener = onFirstFrameStartListener;
    }

    public void setOnSeekCompleteListener(IPlayer.OnSeekCompleteListener onSeekCompleteListener) {
        this.mOuterSeekCompleteListener = onSeekCompleteListener;
    }

    public void setOnTrackChangedListener(IPlayer.OnTrackChangedListener listener) {
        this.mOutOnTrackChangedListener = listener;
    }

    public void setOnStoppedListener(OnStoppedListener onStoppedListener) {
        this.mOnStoppedListener = onStoppedListener;
    }

    public void setOnLoadingListener(IPlayer.OnLoadingStatusListener onLoadingListener) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setOnLoadingStatusListener(onLoadingListener);
        }
    }

    public void setOnVideoSizeChangedListener(IPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setOnVideoSizeChangedListener(onVideoSizeChangedListener);
        }
    }

    public void setAuthInfo(VidAuth aliyunPlayAuth) {
        if (this.mAliyunRenderView == null) {
            return;
        }
        this.clearAllSource();
        this.reset();
        this.mAliyunPlayAuth = aliyunPlayAuth;
        if (this.mControlView != null) {
            this.mControlView.setForceQuality(aliyunPlayAuth.isForceQuality());
        }
        if (!this.show4gTips()) {
            this.prepareAuth(aliyunPlayAuth);
        }
    }

    public void setVidMps(VidMps vidMps) {
        if (this.mAliyunRenderView == null) {
            return;
        }
        this.clearAllSource();
        this.reset();
        this.mAliyunVidMps = vidMps;
        if (this.mControlView != null) {
            this.mControlView.setForceQuality(vidMps.isForceQuality());
        }
        if (!this.show4gTips()) {
            this.prepareMps(vidMps);
        }
    }

    private void prepareAuth(VidAuth aliyunPlayAuth) {
        if (this.mTipsView != null) {
            this.mTipsView.showNetLoadingTipView();
        }
        if (this.mControlView != null) {
            this.mControlView.setIsMtsSource(false);
        }
        if (this.mQualityView != null) {
            this.mQualityView.setIsMtsSource(false);
        }
        this.mAliyunRenderView.setDataSource(aliyunPlayAuth);
        this.mAliyunRenderView.prepare();
    }

    private void prepareMps(VidMps vidMps) {
        if (this.mTipsView != null) {
            this.mTipsView.showNetLoadingTipView();
        }
        if (this.mControlView != null) {
            this.mControlView.setIsMtsSource(false);
        }
        if (this.mQualityView != null) {
            this.mQualityView.setIsMtsSource(false);
        }
        this.mAliyunRenderView.setDataSource(vidMps);
        this.mAliyunRenderView.prepare();
    }

    private void clearAllSource() {
        this.mAliyunPlayAuth = null;
        this.mAliyunVidSts = null;
        this.mAliyunLocalSource = null;
        this.mAliyunVidMps = null;
        this.mAliyunLiveSts = null;
    }

    public void setLiveStsDataSource(LiveSts liveSts) {
        if (this.mAliyunRenderView == null) {
            return;
        }
        this.clearAllSource();
        this.reset();
        this.mAliyunLiveSts = liveSts;
        if (this.mControlView != null) {
            this.mControlView.setForceQuality(liveSts.isForceQuality());
        }
        if (!this.show4gTips()) {
            this.prepareLiveSts(liveSts);
        }
    }

    public void setLocalSource(UrlSource aliyunLocalSource) {
        if (this.mAliyunRenderView == null) {
            return;
        }
        this.clearAllSource();
        this.reset();
        this.mAliyunLocalSource = aliyunLocalSource;
        if (!this.show4gTips()) {
            this.prepareLocalSource(aliyunLocalSource);
        }
    }

    private void prepareLocalSource(UrlSource aliyunLocalSource) {
        if (this.mTipsView != null) {
            this.mTipsView.showNetLoadingTipView();
        }
        if (this.mControlView != null) {
            this.mControlView.setForceQuality(true);
            this.mControlView.setIsMtsSource(false);
            this.mControlView.hideMoreButton();
        }
        if (this.mQualityView != null) {
            this.mQualityView.setIsMtsSource(false);
        }
        if (this.isLocalSource() && this.mIsNeedOnlyFullScreen) {
            this.changeScreenMode(AliyunScreenMode.Full, false);
        }
        if (aliyunLocalSource != null && aliyunLocalSource.getUri().startsWith("artc")) {
            Log.e((String)TAG, (String)"artc setPlayerConfig");
            PlayerConfig playerConfig = this.mAliyunRenderView.getPlayerConfig();
            playerConfig.mMaxDelayTime = 1000;
            playerConfig.mHighBufferDuration = 10;
            playerConfig.mStartBufferDuration = 10;
            this.mAliyunRenderView.setPlayerConfig(playerConfig);
        }
        this.mAliyunRenderView.setAutoPlay(true);
        this.mAliyunRenderView.setDataSource(aliyunLocalSource);
        this.mAliyunRenderView.prepare();
    }

    public void setVidSts(VidSts vidSts) {
        if (this.mAliyunRenderView == null) {
            return;
        }
        this.clearAllSource();
        this.reset();
        this.mAliyunVidSts = vidSts;
        if (this.mControlView != null) {
            this.mControlView.setForceQuality(vidSts.isForceQuality());
        }
        this.showVideoFunction();
    }

    private void showVideoFunction() {
        if (this.mAliyunRenderView != null) {
            this.mPlayerState = 5;
            this.mAliyunRenderView.stop();
        }
        if (this.mAdvVideoView != null) {
            this.mAdvVideoView.optionStop();
            this.mAdvVideoView.isShowAdvVideoBackIamgeView(false);
            this.mAdvVideoView.isShowAdvVideoTipsTextView(false);
        }
        if (GlobalPlayerConfig.IS_WATERMARK) {
            this.mWaterMark.setVisibility(0);
        } else {
            this.mWaterMark.setVisibility(8);
        }
        if (GlobalPlayerConfig.IS_PICTRUE && !GlobalPlayerConfig.IS_VIDEO && !this.mIsScreenCosting) {
            if (this.mAliyunRenderView != null) {
                this.mAliyunRenderView.setAutoPlay(false);
            }
            if (this.mControlView != null) {
                this.mControlView.hide(ViewAction.HideType.Normal);
            }
            if (this.mAdvPictureView != null) {
                this.mAdvPictureView.setVisibility(0);
                this.mAdvPictureView.showAll();
            }
            if (this.mControlView != null) {
                this.mControlView.showNativeSeekBar();
            }
            this.prepareVidsts(this.mAliyunVidSts);
            return;
        }
        if (this.mAdvPictureView != null) {
            this.mAdvPictureView.hideAll();
            this.mAdvPictureView.cancel();
        }
        if (GlobalPlayerConfig.IS_VIDEO) {
            this.mAdvVideoCount = 0;
            VidSts aliyunVidSts = new VidSts();
            aliyunVidSts.setVid(VIDEO_ADV_VID);
            aliyunVidSts.setRegion(GlobalPlayerConfig.mRegion);
            aliyunVidSts.setAccessKeyId(GlobalPlayerConfig.mStsAccessKeyId);
            aliyunVidSts.setAccessKeySecret(GlobalPlayerConfig.mStsAccessKeySecret);
            aliyunVidSts.setSecurityToken(GlobalPlayerConfig.mStsSecurityToken);
            this.preapreAdvVidSts(aliyunVidSts);
            this.prepareVidsts(this.mAliyunVidSts);
            this.mAliyunRenderView.setAutoPlay(false);
            if (this.mControlView != null) {
                this.mControlView.hide(ViewAction.HideType.Normal);
            }
        } else if (this.mControlView != null) {
            this.mControlView.showNativeSeekBar();
        }
        if (!GlobalPlayerConfig.IS_VIDEO && !this.show4gTips()) {
            this.prepareVidsts(this.mAliyunVidSts);
        }
    }

    public void updateStsInfo(StsInfo stsInfo) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.updateStsInfo(stsInfo);
        }
    }

    public void updateAuthInfo(VidAuth vidAuth) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.updateAuthInfo(vidAuth);
        }
    }

    private void preapreAdvVidSts(VidSts vidSts) {
        if (this.mTipsView != null) {
            this.mTipsView.showNetLoadingTipView();
        }
        if (this.mControlView != null) {
            this.mControlView.setIsMtsSource(false);
        }
        if (this.mQualityView != null) {
            this.mQualityView.setIsMtsSource(false);
        }
        if (this.mAdvVideoView != null) {
            UrlSource urlSource = new UrlSource();
            urlSource.setUri(ADV_VIDEO_URL);
            this.mAdvVideoView.optionSetUrlSource(urlSource);
            this.mAdvVideoView.setAutoPlay(!this.mIsScreenCosting);
            this.mAdvVideoView.optionPrepare();
        }
    }

    private void prepareVidsts(VidSts vidSts) {
        if (this.mTipsView != null) {
            this.mTipsView.showNetLoadingTipView();
        }
        if (this.mControlView != null) {
            this.mControlView.setIsMtsSource(false);
        }
        if (this.mQualityView != null) {
            this.mQualityView.setIsMtsSource(false);
        }
        if (this.mAliyunRenderView != null) {
            if (GlobalPlayerConfig.IS_TRAILER) {
                VidPlayerConfigGen vidPlayerConfigGen = new VidPlayerConfigGen();
                vidPlayerConfigGen.addPlayerConfig("PlayDomain", PLAY_DOMAIN);
                vidPlayerConfigGen.setPreviewTime(TRAILER);
                vidSts.setPlayConfig(vidPlayerConfigGen);
            }
            this.mAliyunRenderView.setDataSource(vidSts);
            this.mAliyunRenderView.prepare();
        }
    }

    private void prepareLiveSts(LiveSts mAliyunLiveSts) {
        if (this.mTipsView != null) {
            this.mTipsView.showNetLoadingTipView();
        }
        if (this.mControlView != null) {
            this.mControlView.setIsMtsSource(false);
        }
        if (this.mQualityView != null) {
            this.mQualityView.setIsMtsSource(false);
        }
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setDataSource(mAliyunLiveSts);
            this.mAliyunRenderView.prepare();
        }
    }

    public void setOperatorPlay(boolean isOperatorPlay) {
        this.mIsOperatorPlay = isOperatorPlay;
    }

    public void onResume() {
        this.mInBackground = false;
        if (this.mIsFullScreenLocked) {
            int orientation = this.getResources().getConfiguration().orientation;
            if (orientation == 1) {
                this.changeScreenMode(AliyunScreenMode.Small, false);
            } else if (orientation == 2) {
                this.changeScreenMode(AliyunScreenMode.Full, false);
            }
        }
        if (this.mOrientationWatchDog != null) {
            this.mOrientationWatchDog.startWatch();
        }
        if (this.mAdvPictureView != null && GlobalPlayerConfig.IS_PICTRUE && this.mAdvPictureView.isInCountDown() && !this.mIsScreenCosting) {
            this.mAdvPictureView.reStart();
            return;
        }
        if (!this.mIsScreenCosting) {
            this.resumePlayerState();
        }
    }

    public void startNetWatch() {
        this.initNetWatch = true;
        if (this.mNetWatchdog != null) {
            this.mNetWatchdog.startWatch();
        }
    }

    public void stopNetWatch() {
        if (this.mNetWatchdog != null) {
            this.mNetWatchdog.stopWatch();
        }
    }

    public void onStop() {
        this.mInBackground = true;
        if (this.mOrientationWatchDog != null) {
            this.mOrientationWatchDog.stopWatch();
        }
        this.savePlayerState();
    }

    public void startOrientationWatchDog() {
        if (this.mOrientationWatchDog != null) {
            this.mOrientationWatchDog.startWatch();
        }
    }

    public void stopOrientationWatchDog() {
        if (this.mOrientationWatchDog != null) {
            this.mOrientationWatchDog.stopWatch();
        }
    }

    private void resumePlayerState() {
        if (this.mAliyunRenderView == null) {
            return;
        }
        if (this.mAdvVideoView != null && GlobalPlayerConfig.IS_VIDEO) {
            if (this.mAdvVideoPlayerState == 4 || this.mCurrentPosition == 0L) {
                this.mAdvVideoView.optionStart();
            } else if (this.isLocalSource()) {
                this.reTry();
            } else {
                this.start();
            }
        } else if (!this.isLocalSource() && NetWatchdog.is4GConnected((Context)this.getContext()) && !this.mIsOperatorPlay && this.isPlaying()) {
            this.pause();
        } else if (this.mSourceDuration <= 0L && this.mPlayerState == 5) {
            this.mAliyunRenderView.prepare();
        } else {
            this.start();
        }
    }

    private void savePlayerState() {
        if (this.mAliyunRenderView == null) {
            return;
        }
        if (this.mSourceDuration <= 0L) {
            this.mPlayerState = 5;
            this.mAliyunRenderView.stop();
        } else {
            this.pause();
        }
    }

    private boolean advStyleIsIncludeEnd() {
        return this.mAdvPosition == MutiSeekBarView.AdvPosition.ALL || this.mAdvPosition == MutiSeekBarView.AdvPosition.ONLY_END || this.mAdvPosition == MutiSeekBarView.AdvPosition.START_END || this.mAdvPosition == MutiSeekBarView.AdvPosition.MIDDLE_END;
    }

    public MediaInfo getMediaInfo() {
        if (this.mAliyunRenderView != null) {
            return this.mAliyunRenderView.getMediaInfo();
        }
        return null;
    }

    private boolean show4gTips() {
        if (this.isLocalSource()) {
            return false;
        }
        if (NetWatchdog.is4GConnected((Context)this.getContext())) {
            if (this.mIsOperatorPlay) {
                ToastUtils.show((Context)this.getContext(), (int)R.string.alivc_operator_play);
                return false;
            }
            if (this.mTipsView != null) {
                this.mTipsView.showNetChangeTipView();
            }
            if (this.mAdvPictureView != null) {
                this.mAdvPictureView.hideAll();
            }
            return true;
        }
        return false;
    }

    private void advVideoPlayer4gTips() {
        if (!this.show4gTips()) {
            this.mAliyunRenderView.start();
            this.mAdvVideoView.setAutoPlay(false);
            this.mAdvVideoView.optionPrepare();
        }
    }

    private void afterAdvVideoPlayerComplete() {
        this.mAdvTotalPosition += this.mAdvCurrentPosition;
        if (this.mAliyunRenderView != null && this.mSurfaceView != null) {
            this.mSurfaceView.setVisibility(0);
            if (this.mAdvVideoView != null) {
                this.mAdvVideoView.setSurfaceViewVisibility(8);
            }
            if (this.needToSeek) {
                if (this.mAdvVideoCount < 3) {
                    this.isAutoAccurate((long)this.mSeekToPosition - this.mAdvDuration * 2L);
                    this.advVideoPlayer4gTips();
                }
            } else {
                if (this.mCurrentIntentPlayVideo == AdvVideoView.IntentPlayVideo.MIDDLE_END_ADV_SEEK && this.mAdvVideoCount < 3) {
                    if (this.mAliyunRenderView != null) {
                        this.isAutoAccurate(this.mSourceDuration);
                        this.mAliyunRenderView.pause();
                    }
                    if (this.mControlView != null) {
                        this.mControlView.setAdvVideoPosition((int)(this.mSourceDuration + this.mAdvDuration * 2L), (int)this.mCurrentPosition);
                    }
                    if (this.mAdvVideoView != null) {
                        this.mAdvVideoView.setAutoPlay(!this.mIsScreenCosting);
                        this.mAdvVideoView.optionPrepare();
                    }
                }
                if (this.mAdvVideoCount < 3) {
                    this.advVideoPlayer4gTips();
                }
            }
        }
        if (this.mControlView != null) {
            this.mControlView.setTotalPosition(this.mAdvTotalPosition);
        }
        if (this.advStyleIsIncludeEnd() && this.mAdvVideoCount == 3 && this.mOutCompletionListener != null) {
            this.mOutCompletionListener.onCompletion();
        }
    }

    public void onDestroy() {
        this.stop();
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.release();
            this.mAliyunRenderView = null;
        }
        this.mSurfaceView = null;
        this.mGestureView = null;
        this.mControlView = null;
        this.mCoverView = null;
        this.mGestureDialogManager = null;
        if (this.mNetWatchdog != null) {
            this.mNetWatchdog.stopWatch();
        }
        this.mNetWatchdog = null;
        this.mTipsView = null;
        this.mAliyunMediaInfo = null;
        if (this.mOrientationWatchDog != null) {
            this.mOrientationWatchDog.destroy();
        }
        this.mOrientationWatchDog = null;
        if (this.hasLoadEnd != null) {
            this.hasLoadEnd.clear();
        }
        this.stopNetWatch();
    }

    private void showDanmakuAndMarquee() {
        if (this.mCurrentScreenMode == AliyunScreenMode.Small) {
            return;
        }
        if (GlobalPlayerConfig.IS_BARRAGE && this.mDanmakuView != null) {
            this.mDanmakuView.show();
        }
        if (GlobalPlayerConfig.IS_MARQUEE && this.mMarqueeView != null) {
            this.mMarqueeView.createAnimation();
            this.mMarqueeView.startFlip();
        }
    }

    private void hideDanmakuAndMarquee() {
        if (this.mDanmakuView != null && this.mDanmakuView.isShown()) {
            this.mDanmakuView.hide();
        }
        if (this.mMarqueeView != null && this.mMarqueeView.isStart()) {
            this.mMarqueeView.stopFlip();
        }
    }

    public void needOnlyFullScreenPlay(boolean isNeed) {
        this.mIsNeedOnlyFullScreen = isNeed;
    }

    public void hideDanmakuView() {
        if (this.mDanmakuView != null) {
            this.mDanmakuView.hideAndPauseDrawTask();
            this.mDanmakuView.setVisibility(8);
        }
    }

    public boolean isPlaying() {
        return this.mPlayerState == 3;
    }

    public int getPlayerState() {
        return this.mPlayerState;
    }

    public void reload() {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.reload();
        }
    }

    public void start() {
        if (this.mControlView != null) {
            this.mControlView.setPlayState(ControlView.PlayState.Playing);
        }
        if (this.mAliyunRenderView == null) {
            return;
        }
        if (this.mAdvVideoPlayerState == 3 && GlobalPlayerConfig.IS_VIDEO) {
            this.mControlView.setHideType(ViewAction.HideType.Normal);
            this.mGestureView.setHideType(ViewAction.HideType.Normal);
        } else {
            this.mGestureView.show();
            this.mControlView.show();
        }
        if (this.mSourceDuration <= 0L && this.mPlayerState == 5) {
            this.mAliyunRenderView.prepare();
        } else {
            this.mAliyunRenderView.start();
        }
        if (this.mAdvPictureView != null) {
            this.mAdvPictureView.hideAll();
        }
        if (this.mMarqueeView != null && this.mMarqueeView.isStart() && this.mCurrentScreenMode == AliyunScreenMode.Full) {
            this.mMarqueeView.startFlip();
        }
    }

    public void pause() {
        if (this.mControlView != null && !this.mIsScreenCosting) {
            this.mControlView.setPlayState(ControlView.PlayState.NotPlaying);
        }
        if (this.mAliyunRenderView == null) {
            return;
        }
        if (this.mAdvVideoView != null) {
            this.mAdvVideoView.optionPause();
        }
        if (this.mPlayerState == 3 || this.mPlayerState == 2) {
            if (this.mSourceDuration <= 0L) {
                this.mPlayerState = 5;
                this.mAliyunRenderView.stop();
            } else {
                this.mAliyunRenderView.pause();
            }
            if (GlobalPlayerConfig.IS_PICTRUE && this.mAdvPictureView != null) {
                boolean inCountDown = this.mAdvPictureView.isInCountDown();
                if (inCountDown) {
                    this.mAdvPictureView.stop();
                } else if (!this.mIsScreenCosting) {
                    this.mAdvPictureView.showCenterAdv();
                }
            }
            if (GlobalPlayerConfig.IS_VIDEO && GlobalPlayerConfig.IS_TRAILER && this.mAdvPictureView != null && this.mAdvVideoPlayerState != 3 && this.mAdvVideoPlayerState != 4 && !this.mIsScreenCosting) {
                this.mAdvPictureView.showCenterAdv();
            }
            if (this.mMarqueeView != null) {
                this.mMarqueeView.pause();
            }
        }
    }

    private void stop() {
        Boolean hasLoadedEnd = null;
        MediaInfo mediaInfo = null;
        if (this.mAliyunRenderView != null && this.hasLoadEnd != null) {
            mediaInfo = this.mAliyunRenderView.getMediaInfo();
            hasLoadedEnd = this.hasLoadEnd.get(mediaInfo);
        }
        if (this.mAliyunRenderView != null && hasLoadedEnd != null) {
            this.mPlayerState = 5;
            this.mAliyunRenderView.stop();
        }
        if (this.mAdvVideoView != null) {
            this.mAdvVideoView.optionStop();
        }
        if (this.mControlView != null) {
            this.mControlView.setPlayState(ControlView.PlayState.NotPlaying);
        }
        if (this.hasLoadEnd != null) {
            this.hasLoadEnd.remove(mediaInfo);
        }
    }

    public void clearFrameWhenStop(boolean clearFrameWhenStop) {
        if (this.mAliyunRenderView != null) {
            PlayerConfig config = this.mAliyunRenderView.getPlayerConfig();
            config.mClearFrameWhenStop = clearFrameWhenStop;
            this.mAliyunRenderView.setPlayerConfig(config);
        }
    }

    public void showReplay() {
        if (this.mTipsView != null) {
            this.mGestureView.hide(ViewAction.HideType.End);
            this.mControlView.hide(ViewAction.HideType.End);
            this.mTipsView.showReplayTipView();
        }
    }

    public void seekTo(int position) {
        this.mSeekToPosition = position;
        if (this.mAliyunRenderView == null) {
            return;
        }
        this.inSeek = true;
        if (GlobalPlayerConfig.IS_VIDEO) {
            this.checkAdvVideoSeek(position);
        } else {
            this.mSourceSeekToPosition = position;
            this.realySeekToFunction(position);
        }
    }

    private void realySeekToFunction(int position) {
        if (GlobalPlayerConfig.IS_VIDEO) {
            this.isAutoAccurate((long)position - (long)this.mAdvVideoCount * this.mAdvDuration);
        } else {
            this.isAutoAccurate(position);
        }
        this.mAliyunRenderView.start();
        if (this.mControlView != null) {
            this.mControlView.setPlayState(ControlView.PlayState.Playing);
        }
    }

    private void checkAdvVideoSeek(int position) {
        this.needToSeek = false;
        if (this.mControlView != null) {
            AdvVideoView.IntentPlayVideo intentPlayVideo = this.mControlView.getIntentPlayVideo(this.mControlView.getMutiSeekBarCurrentProgress(), position);
            Log.e((String)TAG, (String)("checkAdvVideoSeek: intentPlayVideo = " + (Object)((Object)intentPlayVideo)));
            this.mCurrentIntentPlayVideo = intentPlayVideo;
            switch (intentPlayVideo) {
                case START_ADV: {
                    if (this.mAliyunRenderView != null) {
                        this.mSourceSeekToPosition = 0;
                        this.isAutoAccurate(this.mSourceSeekToPosition);
                    }
                    if (this.mControlView != null) {
                        this.mControlView.setAdvVideoPosition(0, 0);
                    }
                    this.mAdvTotalPosition = 0L;
                    this.mAdvVideoCount = 0;
                    this.startAdvVideo();
                    break;
                }
                case MIDDLE_ADV: {
                    if (this.mAliyunRenderView != null) {
                        this.mSourceSeekToPosition = (int)(this.mSourceDuration / 2L);
                        this.isAutoAccurate(this.mSourceSeekToPosition);
                    }
                    if (this.mControlView != null) {
                        this.mControlView.setAdvVideoPosition((int)(this.mAdvDuration + this.mSourceDuration / 2L), this.mSourceSeekToPosition);
                    }
                    this.mAdvTotalPosition = this.mAdvDuration;
                    this.mAdvVideoCount = 1;
                    this.startAdvVideo();
                    break;
                }
                case END_ADV: {
                    if (this.mControlView != null) {
                        this.mSourceSeekToPosition = (int)(this.mSourceDuration + this.mAdvDuration * 2L);
                        this.mControlView.setAdvVideoPosition((int)(this.mSourceDuration + this.mAdvDuration * 2L), this.mSourceSeekToPosition);
                    }
                    this.mAdvTotalPosition = this.mAdvDuration * 2L;
                    this.mAdvVideoCount = 2;
                    this.startAdvVideo();
                    break;
                }
                case MIDDLE_ADV_SEEK: {
                    this.needToSeek = true;
                    if (this.mAliyunRenderView != null) {
                        this.mSourceSeekToPosition = (int)(this.mSourceDuration / 2L);
                        this.isAutoAccurate(this.mSourceSeekToPosition);
                    }
                    if (this.mControlView != null) {
                        this.mControlView.setAdvVideoPosition((int)(this.mAdvDuration + this.mSourceDuration / 2L), this.mSourceSeekToPosition);
                    }
                    this.mAdvTotalPosition = this.mAdvDuration;
                    this.mAdvVideoCount = 1;
                    this.startAdvVideo();
                    break;
                }
                case MIDDLE_END_ADV_SEEK: {
                    this.needToSeek = false;
                    if (this.mAliyunRenderView != null) {
                        this.mSourceSeekToPosition = (int)(this.mSourceDuration / 2L);
                        this.isAutoAccurate(this.mSourceSeekToPosition);
                    }
                    if (this.mControlView != null) {
                        this.mControlView.setAdvVideoPosition((int)(this.mAdvDuration + this.mSourceDuration / 2L), this.mSourceSeekToPosition);
                    }
                    this.mAdvTotalPosition = this.mAdvDuration;
                    this.mAdvVideoCount = 1;
                    this.startAdvVideo();
                    break;
                }
                case REVERSE_SOURCE: {
                    if (this.mAliyunRenderView != null) {
                        this.mSourceSeekToPosition = (int)((long)position - this.mAdvDuration);
                        this.isAutoAccurate((long)position - this.mAdvDuration);
                    }
                    if (this.mControlView != null) {
                        this.mControlView.setAdvVideoPosition(position, this.mSourceSeekToPosition);
                    }
                    this.mAdvTotalPosition = this.mAdvDuration;
                    this.mAdvVideoCount = 1;
                    break;
                }
                case NORMAL: {
                    this.realySeekToFunction(position);
                    break;
                }
                default: {
                    this.realySeekToFunction(position);
                }
            }
        }
    }

    public void setLockPortraitMode(LockPortraitListener listener) {
        this.mLockPortraitListener = listener;
    }

    public LockPortraitListener getLockPortraitMode() {
        return this.mLockPortraitListener;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mCurrentScreenMode == AliyunScreenMode.Full && keyCode != 3 && keyCode != 24 && keyCode != 25) {
            this.changedToPortrait(true);
            return false;
        }
        return !this.mIsFullScreenLocked || keyCode == 3;
    }

    public void setOnPlayStateBtnClickListener(OnPlayStateBtnClickListener listener) {
        this.onPlayStateBtnClickListener = listener;
    }

    public void setOnSeekStartListener(OnSeekStartListener listener) {
        this.onSeekStartListener = listener;
    }

    public void setOrientationChangeListener(OnOrientationChangeListener listener) {
        this.orientationChangeListener = listener;
    }

    public void setNetConnectedListener(NetConnectedListener listener) {
        this.mNetConnectedListener = listener;
    }

    public void setOnFinishListener(OnFinishListener onFinishListener) {
        this.mOnFinishListener = onFinishListener;
    }

    public void setOnShowMoreClickListener(ControlView.OnShowMoreClickListener listener) {
        this.mOutOnShowMoreClickListener = listener;
    }

    public void setOnTrackInfoClickListener(ControlView.OnTrackInfoClickListener listener) {
        this.mOutOnTrackInfoClickListener = listener;
    }

    public void setSoftKeyHideListener(OnSoftKeyHideListener listener) {
        this.mOnSoftKeyHideListener = listener;
    }

    public void setOnTrailerViewClickListener(TrailersView.OnTrailerViewClickListener listener) {
        this.mOnTrailerViewClickListener = listener;
    }

    public void setOnScreenBrightness(OnScreenBrightnessListener listener) {
        this.mOnScreenBrightnessListener = listener;
    }

    private void advVideoPlayerPrepared() {
        AliPlayer mAdvVideoAliyunVodPlayer;
        if (this.mAdvVideoView == null) {
            return;
        }
        if (this.mTipsView != null) {
            this.mTipsView.hideNetLoadingTipView();
        }
        if ((mAdvVideoAliyunVodPlayer = this.mAdvVideoView.getAdvVideoAliyunVodPlayer()) == null) {
            return;
        }
        MediaInfo mMediaInfo = mAdvVideoAliyunVodPlayer.getMediaInfo();
        if (mMediaInfo == null) {
            return;
        }
        if (this.mSurfaceView != null && this.mPlayerState == 2) {
            this.mSurfaceView.setVisibility(8);
        }
        if (this.mAdvVideoView != null && this.mPlayerState == 2) {
            this.mAdvVideoView.setSurfaceViewVisibility(0);
        }
        if (this.mControlView != null) {
            this.mControlView.hide(ViewAction.HideType.Normal);
        }
        this.mAdvVideoMediaInfo = mMediaInfo;
        this.mAdvDuration = this.mAdvVideoMediaInfo.getDuration();
        if (this.mAdvVideoCount == 0) {
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = this.mAdvVideoMediaInfo;
            this.mVodPlayerHandler.sendMessage(msg);
        }
    }

    private void sourceVideoPlayerPrepared() {
        this.mThumbnailPrepareSuccess = false;
        if (this.mThumbnailView != null) {
            this.mThumbnailView.setThumbnailPicture(null);
        }
        if (this.mAliyunRenderView == null) {
            return;
        }
        this.mAliyunMediaInfo = this.mAliyunRenderView.getMediaInfo();
        if (this.mAliyunMediaInfo == null) {
            return;
        }
        List thumbnailList = this.mAliyunMediaInfo.getThumbnailList();
        if (thumbnailList != null && thumbnailList.size() > 0) {
            this.mThumbnailHelper = new ThumbnailHelper(((Thumbnail)thumbnailList.get((int)0)).mURL);
            this.mThumbnailHelper.setOnPrepareListener(new ThumbnailHelper.OnPrepareListener(){

                public void onPrepareSuccess() {
                    AliyunVodPlayerView.this.mThumbnailPrepareSuccess = true;
                }

                public void onPrepareFail() {
                    AliyunVodPlayerView.this.mThumbnailPrepareSuccess = false;
                }
            });
            this.mThumbnailHelper.prepare();
            this.mThumbnailHelper.setOnThumbnailGetListener(new ThumbnailHelper.OnThumbnailGetListener(){

                public void onThumbnailGetSuccess(long l, ThumbnailBitmapInfo thumbnailBitmapInfo) {
                    if (thumbnailBitmapInfo != null && thumbnailBitmapInfo.getThumbnailBitmap() != null) {
                        Bitmap thumbnailBitmap = thumbnailBitmapInfo.getThumbnailBitmap();
                        AliyunVodPlayerView.this.mThumbnailView.setTime(TimeFormater.formatMs(l));
                        AliyunVodPlayerView.this.mThumbnailView.setThumbnailPicture(thumbnailBitmap);
                    }
                }

                public void onThumbnailGetFail(long l, String s) {
                }
            });
        }
        this.mSourceDuration = this.mAliyunRenderView.getDuration();
        this.mAliyunMediaInfo.setDuration((int)this.mSourceDuration);
        if (this.mSourceDuration <= 0L) {
            TrackInfo trackVideo = this.mAliyunRenderView.currentTrack(TrackInfo.Type.TYPE_VIDEO);
            TrackInfo trackAudio = this.mAliyunRenderView.currentTrack(TrackInfo.Type.TYPE_AUDIO);
            if (trackVideo == null && trackAudio != null) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.alivc_player_audio_stream), (int)0).show();
            } else if (trackVideo != null && trackAudio == null) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.alivc_player_video_stream), (int)0).show();
            }
        }
        if (!GlobalPlayerConfig.IS_VIDEO) {
            TrackInfo trackInfo = this.mAliyunRenderView.currentTrack(TrackInfo.Type.TYPE_VOD.ordinal());
            if (trackInfo != null) {
                this.mControlView.setMediaInfo(this.mAliyunMediaInfo, this.mAliyunRenderView.currentTrack(TrackInfo.Type.TYPE_VOD.ordinal()).getVodDefinition());
            } else {
                this.mControlView.setMediaInfo(this.mAliyunMediaInfo, "FD");
            }
            this.mControlView.setScreenModeStatus(this.mCurrentScreenMode);
            this.mControlView.show();
            this.mGestureView.show();
        }
        this.mControlView.setHideType(ViewAction.HideType.Normal);
        this.mGestureView.setHideType(ViewAction.HideType.Normal);
        if (this.mTipsView != null) {
            this.mTipsView.hideNetLoadingTipView();
            this.mTipsView.hideBufferLoadingTipView();
        }
        if (GlobalPlayerConfig.IS_VIDEO) {
            if (!this.mIsVipRetry) {
                this.mSurfaceView.setVisibility(8);
            }
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = this.mAliyunMediaInfo;
            this.mVodPlayerHandler.sendMessage(msg);
            return;
        }
        if (GlobalPlayerConfig.IS_TRAILER) {
            if (this.mTrailersView != null) {
                this.mTrailersView.trailerPlayTipsIsShow(true);
            }
        } else {
            if (this.mSurfaceView != null) {
                this.mSurfaceView.setVisibility(0);
            }
            if (this.mAdvVideoView != null) {
                this.mAdvVideoView.setSurfaceViewVisibility(8);
            }
            this.setCoverUri(this.mAliyunMediaInfo.getCoverUrl());
        }
        if (this.mOutPreparedListener != null) {
            this.mOutPreparedListener.onPrepared();
        }
        this.mIsVipRetry = false;
    }

    private void advVideoPlayerError(ErrorInfo errorInfo) {
        if (this.mTipsView != null) {
            this.mTipsView.hideAll();
        }
        this.lockScreen(false);
        this.showErrorTipView(errorInfo.getCode().getValue(), Integer.toHexString(errorInfo.getCode().getValue()), errorInfo.getMsg());
        if (this.mOutErrorListener != null) {
            this.mOutErrorListener.onError(errorInfo);
        }
    }

    private void sourceVideoPlayerError(ErrorInfo errorInfo) {
        if (this.mAdvPictureView != null) {
            this.mAdvPictureView.cancel();
            this.mAdvPictureView.hideAll();
        }
        if (this.mTipsView != null) {
            this.mTipsView.hideAll();
        }
        this.lockScreen(false);
        this.showErrorTipView(errorInfo.getCode().getValue(), Integer.toHexString(errorInfo.getCode().getValue()), errorInfo.getMsg());
        if (this.mOutErrorListener != null) {
            this.mOutErrorListener.onError(errorInfo);
        }
    }

    private void onTrackReady(MediaInfo mediaInfo) {
        if (this.mOutOnTrackReadyListener != null) {
            this.mOutOnTrackReadyListener.onTrackReady(mediaInfo);
        }
    }

    private void advVideoPlayerLoadingBegin() {
        if (this.mTipsView != null) {
            this.mTipsView.showBufferLoadingTipView();
        }
    }

    private void sourceVideoPlayerLoadingBegin() {
        if (!(this.mTipsView == null || GlobalPlayerConfig.IS_VIDEO && this.mAdvVideoPlayerState == 3)) {
            this.mTipsView.hideNetLoadingTipView();
            this.mTipsView.showBufferLoadingTipView();
        }
    }

    private void advVideoPlayerLoadingProgress(int percent) {
        if (this.mTipsView != null) {
            this.mTipsView.updateLoadingPercent(percent);
        }
    }

    private void sourceVideoPlayerLoadingProgress(int percent) {
        if (this.mTipsView != null) {
            if (!GlobalPlayerConfig.IS_VIDEO || this.mAdvVideoPlayerState != 3) {
                this.mTipsView.updateLoadingPercent(percent);
            }
            if (percent == 100) {
                this.mTipsView.hideBufferLoadingTipView();
            }
        }
    }

    private void advVideoPlayerLoadingEnd() {
        if (this.mTipsView != null) {
            this.mTipsView.hideBufferLoadingTipView();
            this.mTipsView.hideErrorTipView();
        }
        if (this.isPlaying()) {
            this.mTipsView.hideErrorTipView();
        }
        this.hasLoadEnd.put(this.mAdvVideoMediaInfo, true);
        this.vodPlayerLoadEndHandler.sendEmptyMessage(1);
    }

    private void sourceVideoPlayerLoadingEnd() {
        if (this.mTipsView != null) {
            if (this.isPlaying()) {
                this.mTipsView.hideErrorTipView();
            }
            this.mTipsView.hideBufferLoadingTipView();
        }
        if (this.mControlView != null) {
            this.mControlView.setHideType(ViewAction.HideType.Normal);
        }
        if (this.mGestureView != null) {
            this.mGestureView.setHideType(ViewAction.HideType.Normal);
            this.mGestureView.show();
        }
        this.hasLoadEnd.put(this.mAliyunMediaInfo, true);
        this.vodPlayerLoadEndHandler.sendEmptyMessage(1);
    }

    private void advVideoPlayerStateChanged(int newState) {
        this.mAdvVideoPlayerState = newState;
        if (newState == 3) {
            if (this.mControlView != null) {
                this.mControlView.setVisibility(8);
            }
            if (this.mMarqueeView != null) {
                this.mMarqueeView.stopFlip();
            }
            if (this.mDanmakuView != null) {
                this.mDanmakuView.hide();
            }
            if (this.mSurfaceView != null) {
                this.mSurfaceView.setVisibility(8);
            }
            if (this.mAdvVideoView != null) {
                this.mAdvVideoView.setSurfaceViewVisibility(0);
            }
            if (this.mAliyunRenderView != null) {
                this.mAliyunRenderView.pause();
            }
        }
    }

    private void sourceVideoPlayerStateChanged(int newState) {
        this.mPlayerState = newState;
        if (GlobalPlayerConfig.IS_PICTRUE && newState == 4 && !this.mIsScreenCosting && this.mAdvPictureView != null && this.mTipsView != null && !this.mTipsView.isShown()) {
            this.mAdvPictureView.showCenterAdv();
        }
        if (GlobalPlayerConfig.IS_PICTRUE && newState == 3 && this.mAdvPictureView != null && this.mAdvPictureView.isShown()) {
            this.mAdvPictureView.hideAll();
        }
        if (newState == 5) {
            if (this.mOnStoppedListener != null) {
                this.mOnStoppedListener.onStop();
            }
        } else if (newState == 3 && this.mControlView != null) {
            this.mControlView.setPlayState(ControlView.PlayState.Playing);
        }
    }

    private void advVideoPlayerCompletion() {
        if (GlobalPlayerConfig.IS_TRAILER && this.mTrailersView != null) {
            this.mTrailersView.trailerPlayTipsIsShow(true);
        }
        this.showDanmakuAndMarquee();
        ++this.mAdvVideoCount;
        this.inSeek = false;
        this.afterAdvVideoPlayerComplete();
    }

    private void sourceVideoPlayerCompletion() {
        this.inSeek = false;
        if (this.mOutCompletionListener != null) {
            if (GlobalPlayerConfig.IS_VIDEO && this.advStyleIsIncludeEnd()) {
                if (GlobalPlayerConfig.IS_TRAILER && this.mCurrentPosition < (long)(TRAILER * 1000)) {
                    this.startAdvVideo();
                } else if (GlobalPlayerConfig.IS_TRAILER) {
                    if (this.mTrailersView != null && this.mCurrentPosition >= (long)(TRAILER * 1000)) {
                        this.mTrailersView.trailerPlayTipsIsShow(false);
                    }
                } else {
                    this.mOutCompletionListener.onCompletion();
                }
            } else if (GlobalPlayerConfig.IS_TRAILER && this.mTrailersView != null && this.mCurrentPosition >= (long)(TRAILER * 1000)) {
                this.mTrailersView.trailerPlayTipsIsShow(false);
            } else {
                this.mOutCompletionListener.onCompletion();
            }
        }
    }

    private void advVideoPlayerInfo(InfoBean infoBean) {
        if (infoBean.getCode().getValue() == TrackInfo.Type.TYPE_VOD.ordinal()) {
            this.mControlView.setCurrentQuality(TrackInfo.Type.TYPE_VOD.name());
            if (this.mTipsView != null) {
                this.mTipsView.hideNetLoadingTipView();
            }
        } else if (infoBean.getCode() != InfoCode.BufferedPosition) {
            if (infoBean.getCode() == InfoCode.CurrentPosition) {
                this.hideDanmakuAndMarquee();
                this.mAdvCurrentPosition = infoBean.getExtraValue();
                if (this.mControlView != null) {
                    this.mControlView.setAdvVideoPosition((int)(this.mAdvCurrentPosition + this.mCurrentPosition + this.mAdvTotalPosition), (int)this.mCurrentPosition);
                }
            } else if (this.mOutInfoListener != null) {
                this.mOutInfoListener.onInfo(infoBean);
            }
        }
    }

    private void sourceVideoPlayerInfo(InfoBean infoBean) {
        if (infoBean.getCode() == InfoCode.AutoPlayStart) {
            if (this.mControlView != null) {
                this.mControlView.setPlayState(ControlView.PlayState.Playing);
            }
            if (this.mOutAutoPlayListener != null) {
                this.mOutAutoPlayListener.onAutoPlayStarted();
            }
        } else if (infoBean.getCode() == InfoCode.BufferedPosition) {
            this.mVideoBufferedPosition = infoBean.getExtraValue();
            this.mControlView.setVideoBufferPosition((int)this.mVideoBufferedPosition);
        } else if (infoBean.getCode() == InfoCode.CurrentPosition) {
            this.mCurrentPosition = infoBean.getExtraValue();
            if (this.mDanmakuView != null) {
                this.mDanmakuView.setCurrentPosition((int)this.mCurrentPosition);
            }
            if (this.mControlView != null) {
                this.mControlView.setOtherEnable(true);
            }
            if (GlobalPlayerConfig.IS_VIDEO) {
                if (this.mControlView != null && this.mControlView.isNeedToPause((int)infoBean.getExtraValue(), this.mAdvVideoCount) && infoBean.getExtraValue() < (long)(TRAILER * 1000)) {
                    this.startAdvVideo();
                }
                if (this.mControlView != null && !this.inSeek && this.mPlayerState == 3) {
                    if (this.mAdvVideoCount == 2 && this.mAdvTotalPosition + this.mCurrentPosition < this.mAdvTotalPosition + this.mSourceDuration / 2L) {
                        this.mControlView.setAdvVideoPosition((int)(this.mAdvTotalPosition + this.mSourceDuration / 2L), (int)this.mCurrentPosition);
                    } else {
                        this.mControlView.setAdvVideoPosition((int)(this.mAdvTotalPosition + this.mCurrentPosition), (int)this.mCurrentPosition);
                    }
                }
            } else if (this.mControlView != null && !this.inSeek && this.mPlayerState == 3) {
                this.mControlView.setVideoPosition((int)this.mCurrentPosition);
            }
        }
        if (this.mOutInfoListener != null) {
            this.mOutInfoListener.onInfo(infoBean);
        }
    }

    private void onAdvBackImageViewClickListener() {
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).finish();
        }
    }

    private void advVideoPlayerOnVideoRenderingStart() {
        if (this.mCoverView != null) {
            this.mCoverView.setVisibility(8);
        }
        if (this.mOutFirstFrameStartListener != null) {
            this.mOutFirstFrameStartListener.onRenderingStart();
        }
    }

    private void sourceVideoPlayerOnVideoRenderingStart() {
        this.mCoverView.setVisibility(8);
        if (this.mOutFirstFrameStartListener != null) {
            this.mOutFirstFrameStartListener.onRenderingStart();
        }
    }

    private void onSubtitleHeader(int trackIndex, String header) {
        if (!TextUtils.isEmpty((CharSequence)header)) {
            this.mSubtitleTypeMap.put(trackIndex, AssHeader.SubtitleType.SubtitleTypeAss);
            this.mAssSubtitleView.setAssHeader(header);
        }
    }

    private void onSubtitleHide(int trackIndex, long id2) {
        if (this.mSubtitleTypeMap.size() > 0 && this.mSubtitleTypeMap.get(trackIndex) == AssHeader.SubtitleType.SubtitleTypeAss) {
            this.mAssSubtitleView.dismiss(id2);
        } else {
            this.mSubtitleView.dismiss(id2 + "");
        }
    }

    private void onSubtitleShow(int trackIndex, long id2, String data) {
        if (this.mSubtitleTypeMap.size() > 0 && this.mSubtitleTypeMap.get(trackIndex) == AssHeader.SubtitleType.SubtitleTypeAss) {
            this.mAssSubtitleView.show(id2, data);
        } else {
            SubtitleView.Subtitle subtitle = new SubtitleView.Subtitle();
            subtitle.id = id2 + "";
            subtitle.content = data;
            this.mSubtitleView.show(subtitle);
        }
    }

    private void sourceVideoPlayerTrackInfoChangedSuccess(TrackInfo trackInfo) {
        if (trackInfo.getType() == TrackInfo.Type.TYPE_VOD) {
            this.mControlView.setCurrentQuality(trackInfo.getVodDefinition());
            if (this.mIsScreenCosting) {
                if (this.mControlView != null) {
                    this.mControlView.setVideoPosition((int)this.mCurrentPosition);
                }
            } else {
                this.start();
            }
            if (this.mTipsView != null) {
                this.mTipsView.hideNetLoadingTipView();
            }
        }
        if (this.mOutOnTrackChangedListener != null) {
            this.mOutOnTrackChangedListener.onChangedSuccess(trackInfo);
        }
    }

    private void sourceVideoPlayerTrackInfoChangedFail(TrackInfo trackInfo, ErrorInfo errorInfo) {
        if (this.mTipsView != null) {
            this.mTipsView.hideNetLoadingTipView();
        }
        this.stop();
        if (this.mOutOnTrackChangedListener != null) {
            this.mOutOnTrackChangedListener.onChangedFail(trackInfo, errorInfo);
        }
    }

    private void sourceVideoPlayerSeekComplete() {
        this.inSeek = false;
        if (this.mOuterSeekCompleteListener != null) {
            this.mOuterSeekCompleteListener.onSeekComplete();
        }
    }

    private void onSeiData(int type, byte[] bytes) {
        if (this.mOutOnSeiDataListener != null) {
            this.mOutOnSeiDataListener.onSeiData(type, bytes);
        }
    }

    public void setOutOnSeiDataListener(IPlayer.OnSeiDataListener listener) {
        this.mOutOnSeiDataListener = listener;
    }

    public void setOutOnVerifyTimeExpireCallback(AliPlayer.OnVerifyTimeExpireCallback listener) {
        this.mOutOnVerifyTimeExpireCallback = listener;
    }

    private AliPlayer.Status onVerifyAuth(VidAuth vidAuth) {
        if (this.mOutOnVerifyTimeExpireCallback != null) {
            return this.mOutOnVerifyTimeExpireCallback.onVerifyAuth(vidAuth);
        }
        return AliPlayer.Status.Valid;
    }

    private AliPlayer.Status onVerifySts(StsInfo stsInfo) {
        if (this.mOutOnVerifyTimeExpireCallback != null) {
            return this.mOutOnVerifyTimeExpireCallback.onVerifySts(stsInfo);
        }
        return AliPlayer.Status.Valid;
    }

    private void sourceVideoSnapShot(final Bitmap bitmap, int width, int height) {
        ThreadUtils.runOnSubThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String videoPath = FileUtils.getDir((Context)AliyunVodPlayerView.this.getContext()) + GlobalPlayerConfig.SNAP_SHOT_PATH;
                String bitmapPath = FileUtils.saveBitmap((Bitmap)bitmap, (String)videoPath);
                if (Build.VERSION.SDK_INT >= 29) {
                    FileUtils.saveImgToMediaStore((Context)AliyunVodPlayerView.this.getContext().getApplicationContext(), (String)bitmapPath, (String)"image/png");
                } else {
                    MediaScannerConnection.scanFile((Context)AliyunVodPlayerView.this.getContext().getApplicationContext(), (String[])new String[]{bitmapPath}, (String[])new String[]{"image/png"}, null);
                }
                Log.e((String)TAG, (String)("snapShot has Saved " + bitmapPath));
                ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.show((Context)AliyunVodPlayerView.this.getContext(), (int)R.string.alivc_player_snap_shot_save_success);
                    }
                });
            }
        });
    }

    private void hideSystemUI() {
        this.setSystemUiVisibility(5894);
    }

    public void setDotInfo(List<DotBean> dotBean) {
        if (this.mControlView != null) {
            this.mControlView.setDotInfo(dotBean);
        }
    }

    public void setEnableHardwareDecoder(boolean enableHardwareDecoder) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.enableHardwareDecoder(enableHardwareDecoder);
        }
    }

    public void setDefaultBandWidth(int bandWidth) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setDefaultBandWidth(bandWidth);
        }
    }

    public void setTrailerTime(int trailerTime) {
        TRAILER = trailerTime;
    }

    public void setPlayDomain(String domain) {
        PLAY_DOMAIN = domain;
    }

    public MediaInfo getCurrentMediaInfo() {
        return this.mAliyunMediaInfo;
    }

    public void setScreenBrightness(int screenBrightness) {
        this.mScreenBrightness = screenBrightness;
    }

    public int getScreenBrightness() {
        return this.mScreenBrightness;
    }

    public void snapShot() {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.snapshot();
        }
    }

    public void setCirclePlay(boolean circlePlay) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setLoop(circlePlay);
        }
    }

    public void setRenderMirrorMode(IPlayer.MirrorMode mode) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setMirrorMode(mode);
        }
    }

    public void setRenderRotate(IPlayer.RotateMode rotate) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setRotateModel(rotate);
        }
    }

    public boolean getIsCreenCosting() {
        return this.mIsScreenCosting;
    }

    public void setTitleBarCanShow(boolean show) {
        if (this.mControlView != null) {
            this.mControlView.setTitleBarCanShow(show);
        }
    }

    public void setControlBarCanShow(boolean show) {
        if (this.mControlView != null) {
            this.mControlView.setControlBarCanShow(show);
        }
    }

    public void enableNativeLog() {
        Logger.getInstance((Context)this.getContext()).enableConsoleLog(true);
        Logger.getInstance((Context)this.getContext()).setLogLevel(Logger.LogLevel.AF_LOG_LEVEL_DEBUG);
    }

    public void disableNativeLog() {
        Logger.getInstance((Context)this.getContext()).enableConsoleLog(false);
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setCacheConfig(cacheConfig);
        }
    }

    public PlayerConfig getPlayerConfig() {
        if (this.mAliyunRenderView != null) {
            return this.mAliyunRenderView.getPlayerConfig();
        }
        return null;
    }

    public void setPlayerConfig(PlayerConfig playerConfig) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setPlayerConfig(playerConfig);
        }
    }

    public String getSDKVersion() {
        return AliPlayerFactory.getSdkVersion();
    }

    public SurfaceView getPlayerView() {
        return this.mSurfaceView;
    }

    public void setAutoPlay(boolean auto) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setAutoPlay(auto);
        }
    }

    public void setmDanmaku(String danmu) {
        if (this.mDanmakuView != null) {
            this.mDanmakuView.addDanmaku(danmu, this.mCurrentPosition);
        }
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.start();
        }
        this.hideSystemUI();
    }

    public void lockScreen(boolean lockScreen) {
        this.mIsFullScreenLocked = lockScreen;
        if (this.mControlView != null) {
            this.mControlView.setScreenLockStatus(this.mIsFullScreenLocked);
        }
        if (this.mGestureView != null) {
            this.mGestureView.setScreenLockStatus(this.mIsFullScreenLocked);
        }
    }

    public void reTry() {
        this.isCompleted = false;
        this.inSeek = false;
        int currentPosition = this.mControlView.getVideoPosition();
        if (this.mTipsView != null) {
            this.mTipsView.hideAll();
        }
        if (this.mControlView != null) {
            this.mControlView.reset();
            this.mControlView.setVideoPosition(currentPosition);
        }
        if (this.mGestureView != null) {
            this.mGestureView.reset();
        }
        if (this.mAliyunRenderView != null) {
            if (this.mTipsView != null) {
                this.mTipsView.showNetLoadingTipView();
            }
            if (GlobalPlayerConfig.IS_VIDEO) {
                if (this.mAliyunRenderView != null) {
                    this.mIsVipRetry = true;
                    this.mAliyunRenderView.prepare();
                }
            } else {
                this.mAliyunRenderView.prepare();
                this.isAutoAccurate(currentPosition);
            }
        }
    }

    public void rePlay() {
        this.isCompleted = false;
        this.inSeek = false;
        if (this.mTipsView != null) {
            this.mTipsView.hideAll();
        }
        if (this.mControlView != null) {
            this.mControlView.reset();
        }
        if (this.mGestureView != null) {
            this.mGestureView.reset();
        }
        if (this.mAdvPictureView != null) {
            this.mAdvPictureView.cancel();
            this.mAdvPictureView.hideAll();
        }
        if (this.mAliyunRenderView != null) {
            if (this.mTipsView != null) {
                this.mTipsView.showNetLoadingTipView();
            }
            this.mAliyunRenderView.prepare();
        }
    }

    public void changeSpeed(SpeedValue speedValue) {
        if (speedValue == SpeedValue.One) {
            this.currentSpeed = 1.0f;
        } else if (speedValue == SpeedValue.OneQuartern) {
            this.currentSpeed = 0.5f;
        } else if (speedValue == SpeedValue.OneHalf) {
            this.currentSpeed = 1.5f;
        } else if (speedValue == SpeedValue.Twice) {
            this.currentSpeed = 2.0f;
        }
        this.mAliyunRenderView.setSpeed(this.currentSpeed);
    }

    public float getCurrentSpeed() {
        return this.currentSpeed;
    }

    public void setCurrentVolume(float progress) {
        if (progress <= 0.0f) {
            progress = 0.0f;
        }
        if (progress >= 1.0f) {
            progress = 1.0f;
        }
        this.currentVolume = progress;
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setVolume(progress);
        }
    }

    public float getCurrentVolume() {
        if (this.mAliyunRenderView != null) {
            return this.mAliyunRenderView.getVolume();
        }
        return 0.0f;
    }

    public void setMute(boolean isMute) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setMute(isMute);
        }
    }

    public void setScreenCostingVolume(int volume) {
        if (volume <= 0) {
            volume = 0;
        }
        if (volume >= 100) {
            volume = 100;
        }
        this.mScreenCostingVolume = volume;
    }

    public int getScreenCostingVolume() {
        return this.mScreenCostingVolume;
    }

    public void setDanmakuAlpha(int progress) {
        if (this.mDanmakuView != null) {
            this.mDanmakuView.setAlpha((float)(1.0 - (double)progress / 100.0 * 1.0));
        }
    }

    public void setDanmakuSpeed(int progress) {
        if (this.mDanmakuView != null) {
            this.mDanmakuView.setDanmakuSpeed((float)(2.5 - (double)(100 + progress) / 100.0 * 1.0));
        }
    }

    public void setDanmakuRegion(int progress) {
        if (this.mDanmakuView != null) {
            this.mDanmakuView.setDanmakuRegion(progress);
        }
    }

    public void screenCostPlay() {
        this.mIsScreenCosting = true;
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.pause();
        }
        if (this.mAdvPictureView != null) {
            this.mAdvPictureView.hideAll();
        }
        if (this.mControlView != null) {
            this.mControlView.setInScreenCosting(this.mIsScreenCosting);
            this.mControlView.show();
            this.mControlView.startScreenCost();
        }
    }

    public void screenCostStop() {
        this.mIsScreenCosting = false;
        if (this.mControlView != null) {
            this.mControlView.setInScreenCosting(this.mIsScreenCosting);
        }
    }

    public void setDanmakuDefault() {
        if (this.mDanmakuView != null) {
            this.setDanmakuAlpha(0);
            this.setDanmakuSpeed(30);
            this.setDanmakuRegion(0);
        }
    }

    public void setCoverUri(String uri) {
        if (this.mCoverView != null && !TextUtils.isEmpty((CharSequence)uri)) {
            new ImageLoaderImpl().loadImage(this.getContext(), uri).into(this.mCoverView);
            this.mCoverView.setVisibility(this.isPlaying() ? 8 : 0);
        }
    }

    public void setCoverResource(int resId) {
        if (this.mCoverView != null) {
            this.mCoverView.setImageResource(resId);
            this.mCoverView.setVisibility(this.isPlaying() ? 8 : 0);
        }
    }

    public void setScaleMode(IPlayer.ScaleMode scaleMode) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setScaleModel(scaleMode);
        }
    }

    public IPlayer.ScaleMode getScaleMode() {
        IPlayer.ScaleMode scaleMode = IPlayer.ScaleMode.SCALE_ASPECT_FIT;
        if (this.mAliyunRenderView != null) {
            scaleMode = this.mAliyunRenderView.getScaleModel();
        }
        return scaleMode;
    }

    public void setLoop(boolean isLoop) {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.setLoop(isLoop);
        }
    }

    public boolean isLoop() {
        if (this.mAliyunRenderView != null) {
            return this.mAliyunRenderView.isLoop();
        }
        return false;
    }

    public void selectTrack(TrackInfo trackInfo) {
        if (this.mAliyunRenderView != null && trackInfo != null) {
            int trackIndex = trackInfo.getIndex();
            this.mAliyunRenderView.selectTrack(trackIndex);
        }
    }

    public void selectAutoBitrateTrack() {
        if (this.mAliyunRenderView != null) {
            this.mAliyunRenderView.selectTrack(-1);
        }
    }

    public TrackInfo currentTrack(TrackInfo.Type type) {
        if (this.mAliyunRenderView == null) {
            return null;
        }
        return this.mAliyunRenderView.currentTrack(type);
    }

    private static class VodPlayerHandler
    extends Handler {
        private WeakReference<AliyunVodPlayerView> weakReference;

        public VodPlayerHandler(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: 
                case 1: {
                    TrackInfo trackInfo;
                    AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
                    if (aliyunVodPlayerView == null) {
                        return;
                    }
                    if (msg.what == 0) {
                        aliyunVodPlayerView.mAdvVideoMeidaInfo = (MediaInfo)msg.obj;
                    }
                    if (msg.what == 1) {
                        aliyunVodPlayerView.mSourceVideoMediaInfo = (MediaInfo)msg.obj;
                    }
                    if (aliyunVodPlayerView.mSourceVideoMediaInfo == null || aliyunVodPlayerView.mAdvVideoMeidaInfo == null) break;
                    MediaInfo mediaInfo = new MediaInfo();
                    mediaInfo.setDuration(aliyunVodPlayerView.mAdvVideoMeidaInfo.getDuration() + aliyunVodPlayerView.mSourceVideoMediaInfo.getDuration());
                    if (aliyunVodPlayerView.mAliyunRenderView != null && (trackInfo = aliyunVodPlayerView.mAliyunRenderView.currentTrack(TrackInfo.Type.TYPE_VOD.ordinal())) != null) {
                        aliyunVodPlayerView.mControlView.setMediaInfo(aliyunVodPlayerView.mSourceVideoMediaInfo, trackInfo.getVodDefinition());
                    }
                    aliyunVodPlayerView.mControlView.setHideType(ViewAction.HideType.Normal);
                    aliyunVodPlayerView.mGestureView.setHideType(ViewAction.HideType.Normal);
                    aliyunVodPlayerView.mControlView.setPlayState(ControlView.PlayState.Playing);
                    aliyunVodPlayerView.mControlView.setMutiSeekBarInfo(aliyunVodPlayerView.mAdvVideoMeidaInfo.getDuration(), aliyunVodPlayerView.mSourceVideoMediaInfo.getDuration(), aliyunVodPlayerView.mAdvPosition);
                    aliyunVodPlayerView.mControlView.hideNativeSeekBar();
                    aliyunVodPlayerView.mGestureView.show();
                    if (aliyunVodPlayerView.mTipsView == null) break;
                    aliyunVodPlayerView.mTipsView.hideNetLoadingTipView();
                    break;
                }
            }
        }
    }

    private static class VideoPlayerOnSnapShotListener
    implements IPlayer.OnSnapShotListener {
        private WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerOnSnapShotListener(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void onSnapShot(Bitmap bitmap, int width, int height) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.sourceVideoSnapShot(bitmap, width, height);
            }
        }
    }

    private static class VideoPlayerOnVerifyStsCallback
    implements AliPlayer.OnVerifyTimeExpireCallback {
        private WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerOnVerifyStsCallback(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public AliPlayer.Status onVerifySts(StsInfo stsInfo) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                return aliyunVodPlayerView.onVerifySts(stsInfo);
            }
            return AliPlayer.Status.Valid;
        }

        public AliPlayer.Status onVerifyAuth(VidAuth vidAuth) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                return aliyunVodPlayerView.onVerifyAuth(vidAuth);
            }
            return AliPlayer.Status.Valid;
        }
    }

    private static class VideoPlayerOnSeiDataListener
    implements IPlayer.OnSeiDataListener {
        private WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerOnSeiDataListener(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void onSeiData(int type, byte[] bytes) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onSeiData(type, bytes);
            }
        }
    }

    private static class VideoPlayerOnSeekCompleteListener
    implements IPlayer.OnSeekCompleteListener {
        private WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerOnSeekCompleteListener(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void onSeekComplete() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.sourceVideoPlayerSeekComplete();
            }
        }
    }

    private static class VideoPlayerTrackChangedListener
    implements IPlayer.OnTrackChangedListener {
        private WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerTrackChangedListener(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void onChangedSuccess(TrackInfo trackInfo) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.sourceVideoPlayerTrackInfoChangedSuccess(trackInfo);
            }
        }

        public void onChangedFail(TrackInfo trackInfo, ErrorInfo errorInfo) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.sourceVideoPlayerTrackInfoChangedFail(trackInfo, errorInfo);
            }
        }
    }

    private static class VideoPlayerSubtitleDeisplayListener
    implements IPlayer.OnSubtitleDisplayListener {
        private final WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerSubtitleDeisplayListener(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void onSubtitleExtAdded(int trackIndex, String url) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.mAliyunRenderView.selectExtSubtitle(trackIndex, true);
            }
        }

        public void onSubtitleShow(int trackIndex, long id2, String data) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onSubtitleShow(trackIndex, id2, data);
            }
        }

        public void onSubtitleHide(int trackIndex, long id2) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onSubtitleHide(trackIndex, id2);
            }
        }

        public void onSubtitleHeader(int trackIndex, String header) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onSubtitleHeader(trackIndex, header);
            }
        }
    }

    private static class VideoPlayerAdvBackImageViewListener
    implements AdvVideoView.OnBackImageViewClickListener {
        private WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerAdvBackImageViewListener(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        @Override
        public void onBackImageViewClick() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onAdvBackImageViewClickListener();
            }
        }
    }

    private static class VideoPlayerRenderingStartListener
    implements IPlayer.OnRenderingStartListener {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean isAdvPlayer;

        public VideoPlayerRenderingStartListener(AliyunVodPlayerView aliyunVodPlayerView, boolean isAdvPlayer) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
            this.isAdvPlayer = isAdvPlayer;
        }

        public void onRenderingStart() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerOnVideoRenderingStart();
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerOnVideoRenderingStart();
                }
            }
        }
    }

    private static class VideoPlayerInfoListener
    implements IPlayer.OnInfoListener {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean isAdvPlayer;

        public VideoPlayerInfoListener(AliyunVodPlayerView aliyunVodPlayerView, boolean isAdvPlayer) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
            this.isAdvPlayer = isAdvPlayer;
        }

        public void onInfo(InfoBean infoBean) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerInfo(infoBean);
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerInfo(infoBean);
                }
            }
        }
    }

    private static class VideoPlayerCompletionListener
    implements IPlayer.OnCompletionListener {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean isAdvPlayer;

        public VideoPlayerCompletionListener(AliyunVodPlayerView aliyunVodPlayerView, boolean isAdvPlayer) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
            this.isAdvPlayer = isAdvPlayer;
        }

        public void onCompletion() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerCompletion();
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerCompletion();
                }
            }
        }
    }

    private static class VideoPlayerStateChangedListener
    implements IPlayer.OnStateChangedListener {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean isAdvPlayer;

        public VideoPlayerStateChangedListener(AliyunVodPlayerView aliyunVodPlayerView, boolean isAdvPlayer) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
            this.isAdvPlayer = isAdvPlayer;
        }

        public void onStateChanged(int newState) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerStateChanged(newState);
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerStateChanged(newState);
                }
            }
        }
    }

    private static class VideoPlayerLoadingStatusListener
    implements IPlayer.OnLoadingStatusListener {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean isAdvPlayer;

        public VideoPlayerLoadingStatusListener(AliyunVodPlayerView aliyunVodPlayerView, boolean isAdvPlayer) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
            this.isAdvPlayer = isAdvPlayer;
        }

        public void onLoadingBegin() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerLoadingBegin();
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerLoadingBegin();
                }
            }
        }

        public void onLoadingProgress(int percent, float v) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerLoadingProgress(percent);
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerLoadingProgress(percent);
                }
            }
        }

        public void onLoadingEnd() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerLoadingEnd();
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerLoadingEnd();
                }
            }
        }
    }

    private static class VideoPlayerOnTrackReadyListenner
    implements IPlayer.OnTrackReadyListener {
        public WeakReference<AliyunVodPlayerView> weakReference;

        public VideoPlayerOnTrackReadyListenner(AliyunVodPlayerView playerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(playerView);
        }

        public void onTrackReady(MediaInfo mediaInfo) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onTrackReady(mediaInfo);
            }
        }
    }

    private static class VideoPlayerErrorListener
    implements IPlayer.OnErrorListener {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean isAdvPlayer;

        public VideoPlayerErrorListener(AliyunVodPlayerView aliyunVodPlayerView, boolean isAdvPlayer) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
            this.isAdvPlayer = isAdvPlayer;
        }

        public void onError(ErrorInfo errorInfo) {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerError(errorInfo);
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerError(errorInfo);
                }
            }
        }
    }

    public static class VideoPlayerPreparedListener
    implements IPlayer.OnPreparedListener {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean isAdvPlayer;

        public VideoPlayerPreparedListener(AliyunVodPlayerView aliyunVodPlayerView, boolean isAdvPlayer) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
            this.isAdvPlayer = isAdvPlayer;
        }

        public void onPrepared() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get();
            if (aliyunVodPlayerView != null) {
                if (this.isAdvPlayer) {
                    aliyunVodPlayerView.advVideoPlayerPrepared();
                } else {
                    aliyunVodPlayerView.sourceVideoPlayerPrepared();
                }
            }
        }
    }

    public static interface OnScreenBrightnessListener {
        public void onScreenBrightness(int var1);
    }

    public static interface OnSoftKeyHideListener {
        public void softKeyHide();

        public void onClickPaint();
    }

    public static interface OnFinishListener {
        public void onFinishClick();
    }

    public static interface NetConnectedListener {
        public void onReNetConnected(boolean var1);

        public void onNetUnConnected();
    }

    private class MyNetConnectedListener
    implements NetWatchdog.NetConnectedListener {
        public MyNetConnectedListener(AliyunVodPlayerView aliyunVodPlayerView2) {
        }

        public void onReNetConnected(boolean isReconnect) {
            if (AliyunVodPlayerView.this.mNetConnectedListener != null) {
                AliyunVodPlayerView.this.mNetConnectedListener.onReNetConnected(isReconnect);
            }
        }

        public void onNetUnConnected() {
            if (AliyunVodPlayerView.this.mNetConnectedListener != null) {
                AliyunVodPlayerView.this.mNetConnectedListener.onNetUnConnected();
            }
        }
    }

    public static interface OnOrientationChangeListener {
        public void orientationChange(boolean var1, AliyunScreenMode var2);
    }

    public static interface OnSeekStartListener {
        public void onSeekStart(int var1);
    }

    public static interface OnPlayStateBtnClickListener {
        public void onPlayBtnClick(int var1);
    }

    private static class VodPlayerLoadEndHandler
    extends Handler {
        private WeakReference<AliyunVodPlayerView> weakReference;
        private boolean intentPause;

        public VodPlayerLoadEndHandler(AliyunVodPlayerView aliyunVodPlayerView) {
            this.weakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void handleMessage(Message msg) {
            AliyunVodPlayerView aliyunVodPlayerView;
            super.handleMessage(msg);
            if (msg.what == 0) {
                this.intentPause = true;
            }
            if (msg.what == 1 && (aliyunVodPlayerView = (AliyunVodPlayerView)this.weakReference.get()) != null && this.intentPause) {
                aliyunVodPlayerView.onStop();
                this.intentPause = false;
            }
        }
    }

    public static interface OnScreenCostingVideoCompletionListener {
        public void onScreenCostingVideoCompletion();
    }

    public static interface OnTimeExpiredErrorListener {
        public void onTimeExpiredError();
    }

    private static class InnerOrientationListener
    implements OrientationWatchDog.OnOrientationListener {
        private WeakReference<AliyunVodPlayerView> playerViewWeakReference;

        public InnerOrientationListener(AliyunVodPlayerView playerView) {
            this.playerViewWeakReference = new WeakReference<AliyunVodPlayerView>(playerView);
        }

        public void changedToLandForwardScape(boolean fromPort) {
            AliyunVodPlayerView playerView = (AliyunVodPlayerView)this.playerViewWeakReference.get();
            if (playerView != null) {
                playerView.changedToLandForwardScape(fromPort);
            }
        }

        public void changedToLandReverseScape(boolean fromPort) {
            AliyunVodPlayerView playerView = (AliyunVodPlayerView)this.playerViewWeakReference.get();
            if (playerView != null) {
                playerView.changedToLandReverseScape(fromPort);
            }
        }

        public void changedToPortrait(boolean fromLand) {
            AliyunVodPlayerView playerView = (AliyunVodPlayerView)this.playerViewWeakReference.get();
            if (playerView != null) {
                playerView.changedToPortrait(fromLand);
            }
        }
    }

    private static class MyNetChangeListener
    implements NetWatchdog.NetChangeListener {
        private WeakReference<AliyunVodPlayerView> viewWeakReference;

        public MyNetChangeListener(AliyunVodPlayerView aliyunVodPlayerView) {
            this.viewWeakReference = new WeakReference<AliyunVodPlayerView>(aliyunVodPlayerView);
        }

        public void onWifiTo4G() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.viewWeakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onWifiTo4G();
            }
        }

        public void on4GToWifi() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.viewWeakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.on4GToWifi();
            }
        }

        public void onNetDisconnected() {
            AliyunVodPlayerView aliyunVodPlayerView = (AliyunVodPlayerView)this.viewWeakReference.get();
            if (aliyunVodPlayerView != null) {
                aliyunVodPlayerView.onNetDisconnected();
            }
        }
    }
}

