/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.aliyun.player.IPlayer;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.alivcplayerexpand.util.Common;
import com.aliyun.player.alivcplayerexpand.util.database.DatabaseManager;
import com.aliyun.player.alivcplayerexpand.util.database.LoadDbDatasListener;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadManager;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.aliyunplayerbase.activity.BaseActivity;
import com.aliyun.player.aliyunplayerbase.bean.AliyunMps;
import com.aliyun.player.aliyunplayerbase.bean.AliyunPlayAuth;
import com.aliyun.player.aliyunplayerbase.bean.AliyunSts;
import com.aliyun.player.aliyunplayerbase.bean.AliyunVideoList;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.private_service.PrivateService;
import com.aliyun.svideo.common.utils.FileUtils;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.activity.AliyunPlayerConfigActivity;
import com.aliyun.vodplayerview.activity.AliyunPlayerSkinActivity;
import com.aliyun.vodplayerview.activity.AliyunPlayerTypeEditActivity;
import com.aliyun.vodplayerview.global.Global;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AliyunPlayerSettingActivity
extends BaseActivity
implements View.OnClickListener {
    private static final int PLAY_TYPE_EDIT_ACTIVITY_REQUEST = 1;
    private TextView mStartPlayTextView;
    private RadioGroup mDecodeRadioGroup;
    private RadioGroup mMirrorRadioGroup;
    private RadioGroup mAutoSwithRadioGroup;
    private RadioGroup mSeekModuleRadioGroup;
    private RadioGroup mEnableBackgroundRadioGroup;
    private ImageView mPlayConfigSettingImageView;
    private RadioButton mPlayTypeUrlRadioButton;
    private RadioButton mPlayTypeStsRadioButton;
    private RadioButton mPlayTypeMpsRadioButton;
    private RadioButton mPlayTypeAuthRadioButton;
    private RadioButton mPlayTypeDefaultRadioButton;
    private RadioButton mPlayTypeLiveStsRadioButton;
    private RadioButton mPlayTypeRotate0RadioButton;
    private RadioButton mPlayTypeRotate90RadioButton;
    private RadioButton mPlayTypeRotate180RadioButton;
    private RadioButton mPlayTypeRotate270RadioButton;
    private TextView mPlayTypeEditTextView;
    private List<RadioButton> mPlayTypeRadioButtonList = new ArrayList<RadioButton>();
    private ProgressBar mLoadingProgressBar;
    private ImageView mBackImageView;
    private RadioButton mMutiRate400RadioButton;
    private RadioButton mMutiRate900RadioButton;
    private RadioButton mMutiRate1500RadioButton;
    private RadioButton mMutiRate3000RadioButton;
    private RadioButton mMutiRate3500RadioButton;
    private RadioButton mMutiRate6000RadioButton;
    private List<RadioButton> mPlayMutiRateRadioButtonList = new ArrayList<RadioButton>();
    private Common commenUtils;
    private AliyunDownloadManager mAliyunDownloadManager;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.copyAssets();
        this.setContentView(R.layout.activity_aliyun_player_setting);
        this.initDownloadInfo();
        this.initView();
        this.initListener();
        this.initCacheDir();
        this.initDataBase();
        this.initGlobalConfig();
    }

    private void initGlobalConfig() {
        GlobalPlayerConfig.mEnableHardDecodeType = true;
        GlobalPlayerConfig.PlayConfig.mAutoSwitchOpen = false;
        GlobalPlayerConfig.PlayConfig.mEnablePlayBackground = false;
        GlobalPlayerConfig.PlayConfig.mEnableAccurateSeekModule = false;
        GlobalPlayerConfig.mRotateMode = IPlayer.RotateMode.ROTATE_0;
        GlobalPlayerConfig.mMirrorMode = IPlayer.MirrorMode.MIRROR_MODE_NONE;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.commenUtils != null) {
            this.commenUtils.onDestroy();
            this.commenUtils = null;
        }
        if (Global.mDownloadMediaLists != null && Global.mDownloadMediaLists.size() > 0) {
            Global.mDownloadMediaLists.clear();
        }
    }

    private void copyAssets() {
        final String encryptPath = FileUtils.getDir((Context)this.getApplicationContext()) + GlobalPlayerConfig.ENCRYPT_DIR_PATH;
        this.commenUtils = Common.getInstance((Context)this.getApplicationContext()).copyAssetsToSD("encrypt", encryptPath);
        this.commenUtils.setFileOperateCallback(new Common.FileOperateCallback(){

            public void onSuccess() {
                PrivateService.initService((Context)AliyunPlayerSettingActivity.this.getApplicationContext(), (String)(encryptPath + "encryptedApp.dat"));
            }

            public void onFailed(String error) {
                Toast.makeText((Context)AliyunPlayerSettingActivity.this, (CharSequence)("encrypt copy error : " + error), (int)0).show();
            }
        });
    }

    private void initDownloadInfo() {
        Global.mDownloadMediaLists = new ArrayList<AliyunDownloadMediaInfo>();
        DatabaseManager.getInstance().createDataBase((Context)this);
        this.mAliyunDownloadManager = AliyunDownloadManager.getInstance((Context)this.getApplicationContext());
        this.mAliyunDownloadManager.setDownloadDir(FileUtils.getDir((Context)this.getApplicationContext()) + GlobalPlayerConfig.DOWNLOAD_DIR_PATH);
    }

    private void initCacheDir() {
        File externalFilesDir = this.getExternalFilesDir(null);
        if (externalFilesDir != null && !externalFilesDir.exists()) {
            externalFilesDir.mkdirs();
            GlobalPlayerConfig.PlayCacheConfig.mDir = externalFilesDir.getAbsolutePath();
        }
    }

    private void initDataBase() {
        this.mAliyunDownloadManager.findDatasByDb(new LoadDbDatasListener(){

            public void onLoadSuccess(List<AliyunDownloadMediaInfo> dataList) {
                Global.mDownloadMediaLists.addAll(dataList);
            }
        });
    }

    private void initView() {
        this.mBackImageView = (ImageView)this.findViewById(R.id.iv_back);
        this.mStartPlayTextView = (TextView)this.findViewById(R.id.tv_start_play);
        this.mLoadingProgressBar = (ProgressBar)this.findViewById(R.id.loading_progress);
        this.mPlayConfigSettingImageView = (ImageView)this.findViewById(R.id.iv_config_setting);
        this.mDecodeRadioGroup = (RadioGroup)this.findViewById(R.id.radio_group_decode);
        this.mMirrorRadioGroup = (RadioGroup)this.findViewById(R.id.radio_group_mirror);
        this.mAutoSwithRadioGroup = (RadioGroup)this.findViewById(R.id.radio_group_auto_switch);
        this.mSeekModuleRadioGroup = (RadioGroup)this.findViewById(R.id.radio_group_seek_module);
        this.mEnableBackgroundRadioGroup = (RadioGroup)this.findViewById(R.id.radio_group_enable_background);
        this.mPlayTypeEditTextView = (TextView)this.findViewById(R.id.tv_play_type_edit);
        this.mPlayTypeUrlRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_url);
        this.mPlayTypeStsRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_sts);
        this.mPlayTypeMpsRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_mps);
        this.mPlayTypeAuthRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_auth);
        this.mPlayTypeLiveStsRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_live_sts);
        this.mPlayTypeDefaultRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_default);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeUrlRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeStsRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeMpsRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeAuthRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeDefaultRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeLiveStsRadioButton);
        this.mMutiRate400RadioButton = (RadioButton)this.findViewById(R.id.radio_rate_400);
        this.mMutiRate900RadioButton = (RadioButton)this.findViewById(R.id.radio_rate_900);
        this.mMutiRate1500RadioButton = (RadioButton)this.findViewById(R.id.radio_rate_1500);
        this.mMutiRate3000RadioButton = (RadioButton)this.findViewById(R.id.radio_rate_3000);
        this.mMutiRate3500RadioButton = (RadioButton)this.findViewById(R.id.radio_rate_3500);
        this.mMutiRate6000RadioButton = (RadioButton)this.findViewById(R.id.radio_rate_6000);
        this.mPlayMutiRateRadioButtonList.add(this.mMutiRate400RadioButton);
        this.mPlayMutiRateRadioButtonList.add(this.mMutiRate900RadioButton);
        this.mPlayMutiRateRadioButtonList.add(this.mMutiRate1500RadioButton);
        this.mPlayMutiRateRadioButtonList.add(this.mMutiRate3000RadioButton);
        this.mPlayMutiRateRadioButtonList.add(this.mMutiRate3500RadioButton);
        this.mPlayMutiRateRadioButtonList.add(this.mMutiRate6000RadioButton);
        this.mPlayTypeRotate0RadioButton = (RadioButton)this.findViewById(R.id.radio_btn_rotate_0);
        this.mPlayTypeRotate90RadioButton = (RadioButton)this.findViewById(R.id.radio_btn_rotate_90);
        this.mPlayTypeRotate180RadioButton = (RadioButton)this.findViewById(R.id.radio_btn_rotate_180);
        this.mPlayTypeRotate270RadioButton = (RadioButton)this.findViewById(R.id.radio_btn_rotate_270);
    }

    private void initListener() {
        this.mBackImageView.setOnClickListener((View.OnClickListener)this);
        this.mStartPlayTextView.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeEditTextView.setOnClickListener((View.OnClickListener)this);
        this.mPlayConfigSettingImageView.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeUrlRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeStsRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeMpsRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeAuthRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeLiveStsRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeDefaultRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mMutiRate400RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mMutiRate900RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mMutiRate1500RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mMutiRate3000RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mMutiRate3500RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mMutiRate6000RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeRotate0RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeRotate90RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeRotate180RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeRotate270RadioButton.setOnClickListener((View.OnClickListener)this);
        this.mDecodeRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
                GlobalPlayerConfig.mEnableHardDecodeType = checkedId != R.id.radio_btn_decode_soft;
            }
        });
        this.mMirrorRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
                GlobalPlayerConfig.mMirrorMode = checkedId == R.id.radio_btn_mirror_none ? IPlayer.MirrorMode.MIRROR_MODE_NONE : (checkedId == R.id.radio_btn_mirror_vertical ? IPlayer.MirrorMode.MIRROR_MODE_VERTICAL : (checkedId == R.id.radio_btn_mirror_horizontal ? IPlayer.MirrorMode.MIRROR_MODE_HORIZONTAL : IPlayer.MirrorMode.MIRROR_MODE_NONE));
            }
        });
        this.mAutoSwithRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
                GlobalPlayerConfig.PlayConfig.mAutoSwitchOpen = checkedId == R.id.radio_btn_auto_open;
            }
        });
        this.mSeekModuleRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
                GlobalPlayerConfig.PlayConfig.mEnableAccurateSeekModule = checkedId == R.id.radio_btn_seek_accurate;
            }
        });
        this.mEnableBackgroundRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
                GlobalPlayerConfig.PlayConfig.mEnablePlayBackground = checkedId == R.id.radio_btn_background_open;
            }
        });
    }

    public void onClick(View view) {
        if (view == this.mBackImageView) {
            this.finish();
        } else if (view == this.mStartPlayTextView) {
            this.getCurrentPlayType();
            this.checkedIsNeedNormalData();
        } else if (view == this.mPlayTypeEditTextView) {
            this.getCurrentPlayType();
            Intent intent = new Intent((Context)this, AliyunPlayerTypeEditActivity.class);
            this.startActivityForResult(intent, 1);
        } else if (view == this.mPlayConfigSettingImageView) {
            Intent intent = new Intent((Context)this, AliyunPlayerConfigActivity.class);
            this.startActivity(intent);
        } else if (view == this.mPlayTypeUrlRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.URL;
            this.selectedPlayType();
        } else if (view == this.mPlayTypeStsRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.STS;
            this.selectedPlayType();
        } else if (view == this.mPlayTypeMpsRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.MPS;
            this.selectedPlayType();
        } else if (view == this.mPlayTypeAuthRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.AUTH;
            this.selectedPlayType();
        } else if (view == this.mPlayTypeLiveStsRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.LIVE_STS;
            this.selectedPlayType();
        } else if (view == this.mPlayTypeDefaultRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.DEFAULT;
            this.selectedPlayType();
        } else if (view == this.mMutiRate400RadioButton) {
            GlobalPlayerConfig.mCurrentMutiRate = GlobalPlayerConfig.MUTIRATE.RATE_400;
            this.selectMutiRate();
        } else if (view == this.mMutiRate900RadioButton) {
            GlobalPlayerConfig.mCurrentMutiRate = GlobalPlayerConfig.MUTIRATE.RATE_900;
            this.selectMutiRate();
        } else if (view == this.mMutiRate1500RadioButton) {
            GlobalPlayerConfig.mCurrentMutiRate = GlobalPlayerConfig.MUTIRATE.RATE_1500;
            this.selectMutiRate();
        } else if (view == this.mMutiRate3000RadioButton) {
            GlobalPlayerConfig.mCurrentMutiRate = GlobalPlayerConfig.MUTIRATE.RATE_3000;
            this.selectMutiRate();
        } else if (view == this.mMutiRate3500RadioButton) {
            GlobalPlayerConfig.mCurrentMutiRate = GlobalPlayerConfig.MUTIRATE.RATE_3500;
            this.selectMutiRate();
        } else if (view == this.mMutiRate6000RadioButton) {
            GlobalPlayerConfig.mCurrentMutiRate = GlobalPlayerConfig.MUTIRATE.RATE_6000;
            this.selectMutiRate();
        } else if (view == this.mPlayTypeRotate0RadioButton) {
            GlobalPlayerConfig.mRotateMode = IPlayer.RotateMode.ROTATE_0;
            this.mPlayTypeRotate0RadioButton.setChecked(true);
            this.mPlayTypeRotate90RadioButton.setChecked(false);
            this.mPlayTypeRotate180RadioButton.setChecked(false);
            this.mPlayTypeRotate270RadioButton.setChecked(false);
        } else if (view == this.mPlayTypeRotate90RadioButton) {
            GlobalPlayerConfig.mRotateMode = IPlayer.RotateMode.ROTATE_90;
            this.mPlayTypeRotate90RadioButton.setChecked(true);
            this.mPlayTypeRotate0RadioButton.setChecked(false);
            this.mPlayTypeRotate180RadioButton.setChecked(false);
            this.mPlayTypeRotate270RadioButton.setChecked(false);
        } else if (view == this.mPlayTypeRotate180RadioButton) {
            GlobalPlayerConfig.mRotateMode = IPlayer.RotateMode.ROTATE_180;
            this.mPlayTypeRotate180RadioButton.setChecked(true);
            this.mPlayTypeRotate0RadioButton.setChecked(false);
            this.mPlayTypeRotate90RadioButton.setChecked(false);
            this.mPlayTypeRotate270RadioButton.setChecked(false);
        } else if (view == this.mPlayTypeRotate270RadioButton) {
            GlobalPlayerConfig.mRotateMode = IPlayer.RotateMode.ROTATE_270;
            this.mPlayTypeRotate270RadioButton.setChecked(true);
            this.mPlayTypeRotate0RadioButton.setChecked(false);
            this.mPlayTypeRotate90RadioButton.setChecked(false);
            this.mPlayTypeRotate180RadioButton.setChecked(false);
        }
    }

    private void selectedPlayType() {
        RadioButton selectedRadioButton = GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS ? this.mPlayTypeStsRadioButton : (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH ? this.mPlayTypeAuthRadioButton : (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.MPS ? this.mPlayTypeMpsRadioButton : (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.URL ? this.mPlayTypeUrlRadioButton : (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.LIVE_STS ? this.mPlayTypeLiveStsRadioButton : this.mPlayTypeDefaultRadioButton))));
        if (this.mPlayTypeRadioButtonList != null && selectedRadioButton != null) {
            for (RadioButton radioButton : this.mPlayTypeRadioButtonList) {
                radioButton.setChecked(radioButton == selectedRadioButton);
            }
        }
    }

    private void getCurrentPlayType() {
        GlobalPlayerConfig.mCurrentPlayType = this.mPlayTypeStsRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.STS : (this.mPlayTypeAuthRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.AUTH : (this.mPlayTypeMpsRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.MPS : (this.mPlayTypeDefaultRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.DEFAULT : (this.mPlayTypeLiveStsRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.LIVE_STS : GlobalPlayerConfig.PLAYTYPE.URL))));
    }

    private void selectMutiRate() {
        RadioButton selectedRadioButton = GlobalPlayerConfig.mCurrentMutiRate == GlobalPlayerConfig.MUTIRATE.RATE_400 ? this.mMutiRate400RadioButton : (GlobalPlayerConfig.mCurrentMutiRate == GlobalPlayerConfig.MUTIRATE.RATE_900 ? this.mMutiRate900RadioButton : (GlobalPlayerConfig.mCurrentMutiRate == GlobalPlayerConfig.MUTIRATE.RATE_1500 ? this.mMutiRate1500RadioButton : (GlobalPlayerConfig.mCurrentMutiRate == GlobalPlayerConfig.MUTIRATE.RATE_3000 ? this.mMutiRate3000RadioButton : (GlobalPlayerConfig.mCurrentMutiRate == GlobalPlayerConfig.MUTIRATE.RATE_3500 ? this.mMutiRate3500RadioButton : this.mMutiRate6000RadioButton))));
        if (this.mPlayMutiRateRadioButtonList != null && selectedRadioButton != null) {
            for (RadioButton radioButton : this.mPlayMutiRateRadioButtonList) {
                radioButton.setChecked(radioButton == selectedRadioButton);
            }
        }
    }

    private void checkedIsNeedNormalData() {
        this.mLoadingProgressBar.setVisibility(0);
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.URL && !GlobalPlayerConfig.URL_TYPE_CHECKED) {
            getAuthInformation.getVideoPlayUrlInfo(new GetAuthInformation.OnGetUrlInfoListener(){

                public void onGetUrlError(String msg) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    ToastUtils.show((Context)AliyunPlayerSettingActivity.this, (String)msg);
                }

                public void onGetUrlSuccess(AliyunVideoList.VideoList dataBean) {
                    List playInfoList;
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    if (dataBean != null && (playInfoList = dataBean.getPlayInfoList()) != null && playInfoList.size() > 0) {
                        AliyunVideoList.VideoList.VideoListItem videoListItem = (AliyunVideoList.VideoList.VideoListItem)playInfoList.get(0);
                        GlobalPlayerConfig.mUrlPath = videoListItem.getPlayURL();
                        AliyunPlayerSettingActivity.this.startPlay();
                    }
                }
            });
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS && !GlobalPlayerConfig.STS_TYPE_CHECKED) {
            getAuthInformation.getVideoPlayStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

                public void onGetStsError(String msg) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    ToastUtils.show((Context)AliyunPlayerSettingActivity.this, (String)msg);
                }

                public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    if (dataBean != null) {
                        GlobalPlayerConfig.mVid = dataBean.getVideoId();
                        GlobalPlayerConfig.mStsAccessKeyId = dataBean.getAccessKeyId();
                        GlobalPlayerConfig.mStsSecurityToken = dataBean.getSecurityToken();
                        GlobalPlayerConfig.mStsAccessKeySecret = dataBean.getAccessKeySecret();
                        AliyunPlayerSettingActivity.this.startPlay();
                    }
                }
            });
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH && !GlobalPlayerConfig.AUTH_TYPE_CHECKED) {
            getAuthInformation.getVideoPlayAuthInfo(new GetAuthInformation.OnGetPlayAuthInfoListener(){

                public void onGetPlayAuthError(String msg) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    ToastUtils.show((Context)AliyunPlayerSettingActivity.this, (String)msg);
                }

                public void onGetPlayAuthSuccess(AliyunPlayAuth.PlayAuthBean dataBean) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    if (dataBean != null) {
                        GlobalPlayerConfig.mVid = dataBean.getVideoMeta().getVideoId();
                        GlobalPlayerConfig.mPlayAuth = dataBean.getPlayAuth();
                        AliyunPlayerSettingActivity.this.startPlay();
                    }
                }
            });
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.MPS && !GlobalPlayerConfig.MPS_TYPE_CHECKED) {
            getAuthInformation.getVideoPlayMpsInfo(new GetAuthInformation.OnGetMpsInfoListener(){

                public void onGetMpsError(String msg) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    ToastUtils.show((Context)AliyunPlayerSettingActivity.this, (String)msg);
                }

                public void onGetMpsSuccess(AliyunMps.MpsBean dataBean) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    if (dataBean != null) {
                        GlobalPlayerConfig.mVid = dataBean.getMediaId();
                        GlobalPlayerConfig.mMpsRegion = dataBean.getRegionId();
                        GlobalPlayerConfig.mMpsAuthInfo = dataBean.getAuthInfo();
                        GlobalPlayerConfig.mMpsHlsUriToken = dataBean.getHlsUriToken();
                        GlobalPlayerConfig.mMpsAccessKeyId = dataBean.getAkInfo().getAccessKeyId();
                        GlobalPlayerConfig.mMpsSecurityToken = dataBean.getAkInfo().getSecurityToken();
                        GlobalPlayerConfig.mMpsAccessKeySecret = dataBean.getAkInfo().getAccessKeySecret();
                        AliyunPlayerSettingActivity.this.startPlay();
                    }
                }
            });
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.LIVE_STS && !GlobalPlayerConfig.LIVE_STS_TYPE_CHECKED) {
            getAuthInformation.getVideoPlayStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

                public void onGetStsError(String msg) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    ToastUtils.show((Context)AliyunPlayerSettingActivity.this, (String)msg);
                }

                public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    if (dataBean != null) {
                        GlobalPlayerConfig.mLiveStsAccessKeyId = dataBean.getAccessKeyId();
                        GlobalPlayerConfig.mLiveStsSecurityToken = dataBean.getSecurityToken();
                        GlobalPlayerConfig.mLiveStsAccessKeySecret = dataBean.getAccessKeySecret();
                        AliyunPlayerSettingActivity.this.startPlay();
                    }
                }
            });
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.DEFAULT) {
            getAuthInformation.getVideoPlayStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

                public void onGetStsError(String msg) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    ToastUtils.show((Context)AliyunPlayerSettingActivity.this, (String)msg);
                }

                public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                    AliyunPlayerSettingActivity.this.mLoadingProgressBar.setVisibility(8);
                    if (dataBean != null) {
                        GlobalPlayerConfig.mVid = "";
                        GlobalPlayerConfig.mStsAccessKeyId = dataBean.getAccessKeyId();
                        GlobalPlayerConfig.mStsSecurityToken = dataBean.getSecurityToken();
                        GlobalPlayerConfig.mStsAccessKeySecret = dataBean.getAccessKeySecret();
                        AliyunPlayerSettingActivity.this.startPlay();
                    }
                }
            });
        } else {
            this.mLoadingProgressBar.setVisibility(8);
            this.startPlay();
        }
    }

    private void startPlay() {
        Intent intent = new Intent((Context)this, AliyunPlayerSkinActivity.class);
        this.startActivity(intent);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            this.selectedPlayType();
        }
    }
}

