/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.adapter;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.playlist.AlivcVideoInfo;
import com.aliyun.svideo.common.utils.image.ImageLoaderImpl;
import com.aliyun.vodplayer.R;
import java.util.ArrayList;

public class AliyunPlayerVideoListAdapter
extends RecyclerView.Adapter<PlayerVideoListViewHolder> {
    private ArrayList<AlivcVideoInfo.DataBean.VideoListBean> mPlayInfoList;
    private Context mContext;
    public OnItemClickListener mOnItemClickListener;

    public AliyunPlayerVideoListAdapter(Context context) {
        this.mContext = context;
    }

    public PlayerVideoListViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View inflate = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.alivc_player_video_list_item, parent, false);
        return new PlayerVideoListViewHolder(inflate);
    }

    public void onBindViewHolder(final PlayerVideoListViewHolder holder, int position) {
        AlivcVideoInfo.DataBean.VideoListBean videoListBean = this.mPlayInfoList.get(position);
        holder.mVideoTitleTextView.setText((CharSequence)videoListBean.getTitle());
        String coverUrlPath = videoListBean.getCoverUrl();
        ImageView mThumb = holder.mVideoCoverImageView;
        if (this.mContext != null && this.mContext instanceof Activity) {
            Activity activity = (Activity)this.mContext;
            if (Build.VERSION.SDK_INT >= 17) {
                if (!activity.isFinishing() || !activity.isDestroyed()) {
                    this.loadPicture(coverUrlPath, mThumb);
                }
            } else if (!activity.isFinishing()) {
                this.loadPicture(coverUrlPath, mThumb);
            }
        }
        holder.mPlayListItemRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AliyunPlayerVideoListAdapter.this.mOnItemClickListener != null) {
                    AliyunPlayerVideoListAdapter.this.mOnItemClickListener.onItemClick(holder.getAdapterPosition());
                }
            }
        });
    }

    private void loadPicture(String coverPath, ImageView mThumb) {
        new ImageLoaderImpl().loadImage(this.mContext, coverPath).into(mThumb);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public int getItemCount() {
        return this.mPlayInfoList == null ? 0 : this.mPlayInfoList.size();
    }

    public void setData(ArrayList<AlivcVideoInfo.DataBean.VideoListBean> mPlayInfoList) {
        this.mPlayInfoList = mPlayInfoList;
    }

    public class PlayerVideoListViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mVideoTitleTextView;
        private ImageView mVideoCoverImageView;
        private TextView mVideoDescriptionTextView;
        private LinearLayout mPlayListItemRoot;

        public PlayerVideoListViewHolder(View itemView) {
            super(itemView);
            this.mVideoCoverImageView = (ImageView)itemView.findViewById(R.id.iv_cover);
            this.mVideoTitleTextView = (TextView)itemView.findViewById(R.id.tv_video_title);
            this.mPlayListItemRoot = (LinearLayout)itemView.findViewById(R.id.ll_play_list_item_root);
            this.mVideoDescriptionTextView = (TextView)itemView.findViewById(R.id.tv_video_description);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

