/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils.upgrade;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.util.Log;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.utils.ThreadUtils;
import com.aliyun.svideo.common.utils.upgrade.UpgradeBean;
import com.aliyun.svideo.common.widget.CustomProgressDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class AutoUpgradeClient {
    private static final int PERMISSION_WRITE_EXTERNAL_STORAGE_REQUEST_CODE = 10001;
    private static String TAG = AutoUpgradeClient.class.getName();
    private static String UPGRADE_JSON_BASE_URL = "https://alivc-demo-cms.alicdn.com";
    private static String sOutputBasePath = Environment.getExternalStorageDirectory() + "/Download/" + File.separator + "aliyunVideoAllmodule";
    private static Context sContext;
    private static String outPath;
    private static final int DOWN_UPDATE = 1;
    private static final int DOWN_OVER = 2;
    private static final int DOWN_ERROR = 3;
    private static CustomProgressDialog progressDialog;
    private static int progress;
    private static Handler mHandler;

    private static void initHandler() {
        mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        progressDialog.setProgress(progress);
                        break;
                    }
                    case 2: {
                        progressDialog.dismiss();
                        AutoUpgradeClient.installApk(outPath);
                        break;
                    }
                    case 3: {
                        progressDialog.dismiss();
                        break;
                    }
                }
                super.handleMessage(msg);
            }
        };
    }

    public static void setUpgradeJsonBaseUrl(String upgradeJsonBaseUrl) {
        UPGRADE_JSON_BASE_URL = upgradeJsonBaseUrl;
    }

    public static String getUpgradeJsonBaseUrl() {
        return UPGRADE_JSON_BASE_URL;
    }

    public static void checkUpgrade(Context context, String jsonName, final int currentVersion) {
        sContext = context;
        final String urlPath = UPGRADE_JSON_BASE_URL + jsonName;
        ThreadUtils.runOnSubThread(new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                BufferedReader reader = null;
                try {
                    URL url = new URL(urlPath);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.connect();
                    if (conn.getResponseCode() == 200) {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            sb.append(line);
                        }
                        String info = sb.toString();
                        Log.d((String)"text", (String)("\u7248\u672c\u5347\u7ea7\u4fe1\u606f:" + info));
                        JSONObject object = new JSONObject(info);
                        final UpgradeBean upgradeBean = new UpgradeBean();
                        upgradeBean.setVersionName(object.optString("versionName"));
                        upgradeBean.setVersionCode(object.optInt("versionCode"));
                        upgradeBean.setDescribe(object.optString("describe"));
                        upgradeBean.setUrl(object.optString("url"));
                        Log.i((String)TAG, (String)("\u5f53\u524d\u7248\u672ccode = " + currentVersion + " ,\u6700\u65b0\u7248\u672ccode = " + upgradeBean.getVersionCode()));
                        if (upgradeBean.getVersionCode() > currentVersion) {
                            ThreadUtils.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    AutoUpgradeClient.showHintDialog(upgradeBean);
                                }
                            });
                        } else {
                            AutoUpgradeClient.release();
                        }
                    }
                }
                catch (Exception e) {
                    AutoUpgradeClient.release();
                    e.printStackTrace();
                }
            }
        });
    }

    private static void showHintDialog(final UpgradeBean upgradeBean) {
        if (sContext == null) {
            return;
        }
        AlertDialog dialog = new AlertDialog.Builder(sContext).setPositiveButton((CharSequence)sContext.getResources().getString(R.string.aliyun_common_confirm), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                AutoUpgradeClient.startDownload(upgradeBean);
            }
        }).setNegativeButton((CharSequence)sContext.getResources().getString(R.string.aliyun_common_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setMessage((CharSequence)upgradeBean.getDescribe()).setTitle((CharSequence)sContext.getResources().getString(R.string.aliyun_common_update_app)).setCancelable(false).create();
        dialog.show();
    }

    private static void startDownload(final UpgradeBean upgradeBean) {
        if (sContext == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)sContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)sContext), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)10001);
            Log.e((String)TAG, (String)"\u81ea\u52a8\u5347\u7ea7 Failure : Permission Not WRITE_EXTERNAL_STORAGE  ");
            return;
        }
        Log.i((String)TAG, (String)"\u81ea\u52a8\u5347\u7ea7,----------------- start ----------------");
        outPath = sOutputBasePath + upgradeBean.getVersionCode() + ".apk";
        progressDialog = new CustomProgressDialog(sContext);
        progressDialog.setMaxProgress(100);
        progressDialog.setMessage(upgradeBean.getDescribe());
        progressDialog.setCancelable(false);
        progressDialog.setTitle(sContext.getResources().getString(R.string.aliyun_common_updating));
        progressDialog.show();
        if (mHandler == null) {
            AutoUpgradeClient.initHandler();
        }
        ThreadUtils.runOnSubThread(new Runnable(){

            @Override
            public void run() {
                try {
                    int numread;
                    URL url = new URL(upgradeBean.getUrl());
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.connect();
                    int length = conn.getContentLength();
                    InputStream ins = conn.getInputStream();
                    FileOutputStream outStream = new FileOutputStream(outPath);
                    int count = 0;
                    byte[] buf = new byte[1024];
                    while ((numread = ins.read(buf)) != -1) {
                        outStream.write(buf, 0, numread);
                        progress = (int)((float)(count += numread) / (float)length * 100.0f);
                        mHandler.sendEmptyMessage(1);
                        if (progress != 100) continue;
                        mHandler.sendEmptyMessage(2);
                        break;
                    }
                    outStream.close();
                    ins.close();
                }
                catch (Exception e) {
                    mHandler.sendEmptyMessage(3);
                    AutoUpgradeClient.release();
                    e.printStackTrace();
                }
            }
        });
    }

    private static void installApk(String outPath) {
        if (sContext != null) {
            File apkFile = new File(outPath);
            Intent install = new Intent("android.intent.action.VIEW");
            install.addFlags(1);
            install.addFlags(0x10000000);
            install.setDataAndType(AutoUpgradeClient.getUriForFile(sContext, apkFile), "application/vnd.android.package-archive");
            Log.e((String)TAG, (String)"installApk: ");
            sContext.startActivity(install);
        }
    }

    private static Uri getUriForFile(Context context, File file) {
        if (context == null || file == null) {
            throw new NullPointerException();
        }
        Uri uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
        return uri;
    }

    private static void release() {
        sContext = null;
        mHandler = null;
    }

    static {
        mHandler = null;
    }
}

