/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.liveshift.request;

import android.content.Context;
import android.text.TextUtils;
import com.aliyun.player.bean.ErrorCode;
import com.aliyun.sdk.utils.BaseRequest;
import com.aliyun.sdk.utils.HttpClientHelper;
import com.aliyun.sdk.utils.JsonUtil;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

public class GetServerTimeRequest
extends BaseRequest {
    private static final String TAG = "GetServerTimeRequest";
    private WeakReference<Context> mContextWeak;
    private String mHost;
    private HttpClientHelper httpClientHelper = null;

    GetServerTimeRequest(Context context, String host, BaseRequest.OnRequestListener<Long> l) {
        super(context, l);
        this.mHost = host;
        this.mContextWeak = new WeakReference<Context>(context);
    }

    @Override
    public void runInBackground() {
        String requestUrl = "https://" + this.mHost + "/openapi/getutc?lhs_start=1";
        if (this.wantStop) {
            this.sendFailResult(-1, "", "");
            return;
        }
        String responseStr = null;
        try {
            this.httpClientHelper = new HttpClientHelper(requestUrl);
            responseStr = this.httpClientHelper.doGet();
            if (TextUtils.isEmpty((CharSequence)responseStr)) {
                this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_REQUEST_ERROR.getValue(), "request fail", "");
                return;
            }
            String[] values = responseStr.split("=");
            if (values.length == 2) {
                JSONObject responseJson = new JSONObject(responseStr);
                long serverTime = JsonUtil.getLong(responseJson, "GT");
                if (serverTime == 0L) {
                    this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_REQUEST_ERROR.getValue(), "request fail", "");
                } else {
                    this.sendSuccessResult(serverTime, "");
                }
            } else {
                this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_REQUEST_ERROR.getValue(), "request fail", "");
            }
        }
        catch (JSONException e) {
            this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_DATA_PARSER_ERROR.getValue(), "response not json", "");
        }
        catch (Exception e) {
            this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_UNKNOWN.getValue(), "unknow error", "");
        }
    }

    @Override
    public void stopInner() {
        if (this.httpClientHelper != null) {
            this.httpClientHelper.stop();
        }
    }
}

