/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ui.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.aliyun.player.IPlayer;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.aliyunplayerbase.util.NetWatchdog;
import com.aliyun.player.aliyunplayerbase.util.OrientationWatchDog;
import com.aliyun.player.aliyunplayerbase.view.tipsview.TipsView;
import com.aliyun.player.bean.ErrorInfo;
import com.aliyun.player.source.LiveShift;
import com.aliyun.sdk.player.AliLiveShiftPlayer;
import com.aliyun.sdk.player.ApsaraLiveShiftPlayer;
import com.aliyun.ui.view.control.ControlView;
import java.lang.ref.WeakReference;

public class AliyunLiveShiftPlayerView
extends RelativeLayout {
    private static final String URL = "http://qt1.alivecdn.com/timeline/testshift.m3u8?auth_key=1594730859-0-0-b71fd57c57a62a3c2b014f24ca2b9da3";
    private static final int HANDLER_MSG_WHAT = 0;
    private SurfaceView mSurfaceView;
    private AliLiveShiftPlayer mAliLiveShiftPlayer;
    private ControlView mControlView;
    private TipsView mTipsView;
    private NetWatchdog mNetWatchdog;
    private long mCurrentLiveTime;
    private long mCurrentTime;
    private long mShiftStartTime;
    private long mShiftEndTime;
    private long mEndTime = -1L;
    private ProgressUpdateTimerHandler mProgressUpdateTimerHandler = new ProgressUpdateTimerHandler(this);
    private int mPlayerState;
    private LiveShift mAliyunLiveTimeShift;
    private ControlView.OnBackIconClickListener mOutOnBackIconClickListener;
    private OrientationWatchDog mOrientationWatchDog;
    private OnOrientationChangeListener orientationChangeListener;
    private AliLiveShiftPlayer.OnSeekLiveCompletionListener mOutOnSeekLiveCompletionListener;
    private AliLiveShiftPlayer.OnTimeShiftUpdaterListener mOutOnTimeShiftUpdaterListener;
    private AliyunScreenMode mCurrentScreenMode = AliyunScreenMode.Small;

    public AliyunLiveShiftPlayerView(Context context) {
        super(context);
        this.initVideoView();
    }

    public AliyunLiveShiftPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView();
    }

    public AliyunLiveShiftPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVideoView();
    }

    private void initVideoView() {
        this.initSurfaceView();
        this.initLiveShiftPlayer();
        this.initControlView();
        this.initTipsView();
        this.initNetWatchDog();
        this.initOrientationWatchdog();
    }

    private void setPlaySource() {
        this.mAliyunLiveTimeShift = new LiveShift();
        long currentSeconds = System.currentTimeMillis() / 1000L;
        this.mAliyunLiveTimeShift.setUrl(URL);
        this.mAliyunLiveTimeShift.setTimeLineUrl("http://qt1.alivecdn.com/openapi/timeline/query?auth_key=1594731135-0-0-61c9bd253b29ef4c8017ce05c0953083&app=timeline&stream=testshift&format=ts&lhs_start_unix_s_0=" + (currentSeconds - 300L) + "&lhs_end_unix_s_0=" + (currentSeconds + 300L));
        this.mAliyunLiveTimeShift.setTitle("\u55b7\u51fa\u5f69\u5e26!\u5e86\u795d\u6297\u6218\u80dc\u522970\u5468\u5e74");
    }

    private void addSubView(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void initSurfaceView() {
        this.mSurfaceView = new SurfaceView(this.getContext());
        this.addSubView((View)this.mSurfaceView);
        this.mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                if (AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer != null) {
                    AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.setDisplay(surfaceHolder);
                }
            }

            public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int w, int h) {
                if (AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer != null) {
                    AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.redraw();
                }
            }

            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                if (AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer != null) {
                    AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.setSurface(null);
                }
            }
        });
    }

    private void initLiveShiftPlayer() {
        this.mAliLiveShiftPlayer = new ApsaraLiveShiftPlayer(this.getContext().getApplicationContext());
        this.mAliLiveShiftPlayer.setAutoPlay(true);
        this.mAliLiveShiftPlayer.setOnPreparedListener(new IPlayer.OnPreparedListener(){

            public void onPrepared() {
                if (AliyunLiveShiftPlayerView.this.mTipsView != null) {
                    AliyunLiveShiftPlayerView.this.mTipsView.hideNetLoadingTipView();
                }
                AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.start();
            }
        });
        this.mAliLiveShiftPlayer.setOnStateChangedListener(new IPlayer.OnStateChangedListener(){

            public void onStateChanged(int newState) {
                AliyunLiveShiftPlayerView.this.mPlayerState = newState;
                if (AliyunLiveShiftPlayerView.this.mControlView != null) {
                    AliyunLiveShiftPlayerView.this.mControlView.setPlayState(newState);
                }
            }
        });
        this.mAliLiveShiftPlayer.setOnRenderingStartListener(new IPlayer.OnRenderingStartListener(){

            public void onRenderingStart() {
                if (AliyunLiveShiftPlayerView.this.mControlView != null) {
                    AliyunLiveShiftPlayerView.this.mControlView.show();
                }
            }
        });
        this.mAliLiveShiftPlayer.setOnErrorListener(new IPlayer.OnErrorListener(){

            public void onError(ErrorInfo errorInfo) {
                if (AliyunLiveShiftPlayerView.this.mTipsView != null) {
                    AliyunLiveShiftPlayerView.this.mTipsView.hideAll();
                }
                AliyunLiveShiftPlayerView.this.showErrorTipView(errorInfo.getCode().getValue(), Integer.toHexString(errorInfo.getCode().getValue()), errorInfo.getMsg());
            }
        });
        this.mAliLiveShiftPlayer.setOnLoadingStatusListener(new IPlayer.OnLoadingStatusListener(){

            public void onLoadingBegin() {
                if (AliyunLiveShiftPlayerView.this.mTipsView != null) {
                    AliyunLiveShiftPlayerView.this.mTipsView.showBufferLoadingTipView();
                }
            }

            public void onLoadingProgress(int percent, float v) {
                if (AliyunLiveShiftPlayerView.this.mTipsView != null) {
                    AliyunLiveShiftPlayerView.this.mTipsView.updateLoadingPercent(percent);
                }
            }

            public void onLoadingEnd() {
                if (AliyunLiveShiftPlayerView.this.mTipsView != null) {
                    AliyunLiveShiftPlayerView.this.mTipsView.hideBufferLoadingTipView();
                }
            }
        });
        this.mAliLiveShiftPlayer.setOnSeekCompleteListener(new IPlayer.OnSeekCompleteListener(){

            public void onSeekComplete() {
                if (AliyunLiveShiftPlayerView.this.mControlView != null) {
                    AliyunLiveShiftPlayerView.this.mControlView.seekLiveCompletion();
                }
            }
        });
        this.mAliLiveShiftPlayer.setOnSeekLiveCompletionListener(new AliLiveShiftPlayer.OnSeekLiveCompletionListener(){

            @Override
            public void onSeekLiveCompletion(long playTime) {
                if (AliyunLiveShiftPlayerView.this.mOutOnSeekLiveCompletionListener != null) {
                    AliyunLiveShiftPlayerView.this.mOutOnSeekLiveCompletionListener.onSeekLiveCompletion(playTime);
                }
            }
        });
        this.mAliLiveShiftPlayer.setOnTimeShiftUpdaterListener(new AliLiveShiftPlayer.OnTimeShiftUpdaterListener(){

            @Override
            public void onUpdater(long currentLiveTime, long shiftStartTime, long shiftEndTime) {
                AliyunLiveShiftPlayerView.this.mCurrentLiveTime = currentLiveTime;
                AliyunLiveShiftPlayerView.this.mShiftStartTime = shiftStartTime;
                AliyunLiveShiftPlayerView.this.mShiftEndTime = shiftEndTime;
                if (AliyunLiveShiftPlayerView.this.mOutOnTimeShiftUpdaterListener != null) {
                    AliyunLiveShiftPlayerView.this.mOutOnTimeShiftUpdaterListener.onUpdater(currentLiveTime, shiftStartTime, shiftEndTime);
                }
                AliyunLiveShiftPlayerView.this.updater(shiftStartTime, shiftEndTime);
            }
        });
    }

    private void updater(long shiftStartTime, long shiftEndTime) {
        if (this.mAliLiveShiftPlayer == null) {
            return;
        }
        this.mCurrentLiveTime = this.mAliLiveShiftPlayer.getCurrentLiveTime();
        this.mCurrentTime = this.mAliLiveShiftPlayer.getCurrentTime();
        this.mShiftEndTime = shiftEndTime;
        this.mShiftStartTime = shiftStartTime;
        long offsetTimeLen = this.mShiftEndTime - this.mShiftStartTime;
        if ((double)(this.mEndTime - this.mCurrentLiveTime) < (double)offsetTimeLen * 0.05) {
            this.mEndTime = (long)((double)this.mCurrentLiveTime + (double)offsetTimeLen * 0.1);
        }
        if (this.mControlView != null) {
            this.mControlView.setPlayProgress(this.mCurrentTime);
            this.mControlView.setLiveTime(this.mCurrentLiveTime);
            this.mControlView.updateRange(this.mShiftStartTime, this.mEndTime);
        }
        this.startUpdateTimer();
    }

    private void startUpdateTimer() {
        if (this.mProgressUpdateTimerHandler != null) {
            this.mProgressUpdateTimerHandler.removeMessages(0);
            this.mProgressUpdateTimerHandler.sendEmptyMessageDelayed(0, 1000L);
        }
    }

    private void stopUpdateTimer() {
        if (this.mProgressUpdateTimerHandler != null) {
            this.mProgressUpdateTimerHandler.removeMessages(0);
        }
    }

    private void initControlView() {
        this.mControlView = new ControlView(this.getContext());
        this.addSubView((View)this.mControlView);
        this.mControlView.setOnBackIconClickListener(new ControlView.OnBackIconClickListener(){

            @Override
            public void onBackClickListener() {
                if (AliyunLiveShiftPlayerView.this.mOutOnBackIconClickListener != null) {
                    AliyunLiveShiftPlayerView.this.mOutOnBackIconClickListener.onBackClickListener();
                }
            }
        });
        this.mControlView.setOnPlayStateClickListener(new ControlView.OnPlayStateClickListener(){

            @Override
            public void onPlayStateClickListener(int currentPlayState) {
                if (AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer != null) {
                    if (currentPlayState == 3) {
                        AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.start();
                    }
                    if (currentPlayState == 4) {
                        AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.pause();
                    }
                }
            }
        });
        this.mControlView.setOnSeekBarChangeListener(new ControlView.OnSeekBarChangeListener(){

            @Override
            public void onStopTrackingTouch(long seekTime) {
                if (AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer != null) {
                    AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.seekToLiveTime(seekTime + AliyunLiveShiftPlayerView.this.mShiftStartTime);
                }
            }
        });
        this.mControlView.setOnScreenModeBtnClickListener(new ControlView.OnScreenModeBtnClickListener(){

            @Override
            public void onScreenModeClick() {
                if (AliyunLiveShiftPlayerView.this.mCurrentScreenMode == AliyunScreenMode.Small) {
                    AliyunLiveShiftPlayerView.this.changedToLandForwardScape(true);
                } else {
                    AliyunLiveShiftPlayerView.this.changedToPortrait(true);
                }
            }
        });
    }

    private void initTipsView() {
        this.mTipsView = new TipsView(this.getContext());
        this.mTipsView.setOnTipClickListener(new TipsView.OnTipClickListener(){

            public void onContinuePlay() {
                AliyunLiveShiftPlayerView.this.mTipsView.hideAll();
                if (AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer != null) {
                    AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer.setAutoPlay(true);
                }
            }

            public void onStopPlay() {
                AliyunLiveShiftPlayerView.this.mTipsView.hideAll();
                AliyunLiveShiftPlayerView.this.stop();
                Context context = AliyunLiveShiftPlayerView.this.getContext();
                if (context instanceof Activity) {
                    ((Activity)context).finish();
                }
            }

            public void onRetryPlay(int errorCode) {
                if (AliyunLiveShiftPlayerView.this.mTipsView != null) {
                    AliyunLiveShiftPlayerView.this.mTipsView.hideAll();
                }
                if (AliyunLiveShiftPlayerView.this.mAliLiveShiftPlayer != null) {
                    AliyunLiveShiftPlayerView.this.prepare();
                }
            }

            public void onReplay() {
            }

            public void onRefreshSts() {
            }

            public void onWait() {
            }

            public void onExit() {
            }
        });
        this.addSubView((View)this.mTipsView);
    }

    private void initNetWatchDog() {
        this.mNetWatchdog = new NetWatchdog(this.getContext());
        this.mNetWatchdog.setNetChangeListener((NetWatchdog.NetChangeListener)new MyNetChangeListener(this));
        this.mNetWatchdog.startWatch();
    }

    private void initOrientationWatchdog() {
        Context context = this.getContext();
        this.mOrientationWatchDog = new OrientationWatchDog(context);
        this.mOrientationWatchDog.setOnOrientationListener((OrientationWatchDog.OnOrientationListener)new InnerOrientationListener(this));
    }

    private void changedToLandForwardScape(boolean fromPort) {
        if (!fromPort) {
            return;
        }
        this.changeScreenMode(AliyunScreenMode.Full, false);
        if (this.orientationChangeListener != null) {
            this.orientationChangeListener.orientationChange(fromPort, this.mCurrentScreenMode);
        }
    }

    private void changedToLandReverseScape(boolean fromPort) {
        if (!fromPort) {
            return;
        }
        this.changeScreenMode(AliyunScreenMode.Full, true);
        if (this.orientationChangeListener != null) {
            this.orientationChangeListener.orientationChange(fromPort, this.mCurrentScreenMode);
        }
    }

    private void changedToPortrait(boolean fromLand) {
        if (this.mCurrentScreenMode == AliyunScreenMode.Full) {
            if (fromLand) {
                this.changeScreenMode(AliyunScreenMode.Small, false);
            }
        } else if (this.mCurrentScreenMode == AliyunScreenMode.Small) {
            // empty if block
        }
        if (this.orientationChangeListener != null) {
            this.orientationChangeListener.orientationChange(fromLand, this.mCurrentScreenMode);
        }
    }

    public void changeScreenMode(AliyunScreenMode targetMode, boolean isReverse) {
        this.mCurrentScreenMode = targetMode;
        Context context = this.getContext();
        if (context instanceof Activity) {
            if (targetMode == AliyunScreenMode.Full) {
                if (isReverse) {
                    ((Activity)context).setRequestedOrientation(8);
                } else {
                    ((Activity)context).setRequestedOrientation(0);
                }
            } else if (targetMode == AliyunScreenMode.Small) {
                ((Activity)context).setRequestedOrientation(1);
            }
        }
        if (this.mControlView != null) {
            this.mControlView.setScreenModeStatus(targetMode);
        }
    }

    public void setOrientationChangeListener(OnOrientationChangeListener listener) {
        this.orientationChangeListener = listener;
    }

    private void onWifiTo4G() {
        if (this.mControlView != null) {
            this.mPlayerState = this.mControlView.getCurrentPlayState();
        }
        if (this.mPlayerState == 3) {
            this.pause();
        }
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this.getContext());
        alertDialog.setTitle((CharSequence)"\u7f51\u7edc\u5207\u6362\u52304g");
        alertDialog.setMessage((CharSequence)"\u7ee7\u7eed\u64ad\u653e\uff1f");
        alertDialog.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                AliyunLiveShiftPlayerView.this.replay();
            }
        });
        alertDialog.setNegativeButton((CharSequence)"No", null);
        AlertDialog alert = alertDialog.create();
        alert.show();
    }

    private void on4GToWifi() {
    }

    private void onNetDisconnected() {
    }

    public void setAutoPlay(boolean autoPlay) {
        if (this.mAliLiveShiftPlayer != null) {
            this.mAliLiveShiftPlayer.setAutoPlay(autoPlay);
        }
    }

    public void showErrorTipView(int errorCode, String errorEvent, String errorMsg) {
        this.stop();
        if (this.mControlView != null) {
            this.mControlView.setPlayState(4);
        }
        if (this.mControlView != null) {
            this.mControlView.hide();
        }
        if (this.mTipsView != null) {
            this.mTipsView.showErrorTipView(errorCode, errorEvent, errorMsg);
        }
    }

    public void prepare() {
        if (this.mTipsView != null) {
            this.mTipsView.showNetLoadingTipView();
        }
        this.setPlaySource();
        if (this.mAliLiveShiftPlayer != null) {
            this.mAliLiveShiftPlayer.setAutoPlay(true);
            this.mAliLiveShiftPlayer.setDataSource(this.mAliyunLiveTimeShift);
            this.mAliLiveShiftPlayer.prepare();
        }
    }

    public void replay() {
        this.stop();
        this.prepare();
    }

    public void start() {
        if (this.mAliLiveShiftPlayer != null && this.mPlayerState == 4) {
            this.mAliLiveShiftPlayer.start();
        }
    }

    public void stop() {
        this.stopUpdateTimer();
        if (this.mAliLiveShiftPlayer != null) {
            this.mAliLiveShiftPlayer.stop();
        }
    }

    public void pause() {
        if (this.mAliLiveShiftPlayer != null && this.mPlayerState == 3) {
            this.mAliLiveShiftPlayer.pause();
        }
    }

    public void destroy() {
        if (this.mAliLiveShiftPlayer != null) {
            this.mAliLiveShiftPlayer.stop();
            this.mAliLiveShiftPlayer.release();
        }
        if (this.mNetWatchdog != null) {
            this.mNetWatchdog.stopWatch();
        }
    }

    public void setOutOnBackIconClickListener(ControlView.OnBackIconClickListener listener) {
        this.mOutOnBackIconClickListener = listener;
    }

    public void setmOutOnSeekLiveCompletionListener(AliLiveShiftPlayer.OnSeekLiveCompletionListener listener) {
        this.mOutOnSeekLiveCompletionListener = listener;
    }

    public void setmOutOnTimeShiftUpdaterListener(AliLiveShiftPlayer.OnTimeShiftUpdaterListener listener) {
        this.mOutOnTimeShiftUpdaterListener = listener;
    }

    private static class MyNetChangeListener
    implements NetWatchdog.NetChangeListener {
        private WeakReference<AliyunLiveShiftPlayerView> weakReference;

        public MyNetChangeListener(AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView) {
            this.weakReference = new WeakReference<AliyunLiveShiftPlayerView>(aliyunLiveShiftPlayerView);
        }

        public void onWifiTo4G() {
            AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView = (AliyunLiveShiftPlayerView)((Object)this.weakReference.get());
            if (aliyunLiveShiftPlayerView != null) {
                aliyunLiveShiftPlayerView.onWifiTo4G();
            }
        }

        public void on4GToWifi() {
            AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView = (AliyunLiveShiftPlayerView)((Object)this.weakReference.get());
            if (aliyunLiveShiftPlayerView != null) {
                aliyunLiveShiftPlayerView.on4GToWifi();
            }
        }

        public void onNetDisconnected() {
            AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView = (AliyunLiveShiftPlayerView)((Object)this.weakReference.get());
            if (aliyunLiveShiftPlayerView != null) {
                aliyunLiveShiftPlayerView.onNetDisconnected();
            }
        }
    }

    public static interface OnOrientationChangeListener {
        public void orientationChange(boolean var1, AliyunScreenMode var2);
    }

    private static class InnerOrientationListener
    implements OrientationWatchDog.OnOrientationListener {
        private WeakReference<AliyunLiveShiftPlayerView> weakReference;

        public InnerOrientationListener(AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView) {
            this.weakReference = new WeakReference<AliyunLiveShiftPlayerView>(aliyunLiveShiftPlayerView);
        }

        public void changedToLandForwardScape(boolean fromPort) {
            AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView = (AliyunLiveShiftPlayerView)((Object)this.weakReference.get());
            if (aliyunLiveShiftPlayerView != null) {
                aliyunLiveShiftPlayerView.changedToLandForwardScape(fromPort);
            }
        }

        public void changedToLandReverseScape(boolean fromPort) {
            AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView = (AliyunLiveShiftPlayerView)((Object)this.weakReference.get());
            if (aliyunLiveShiftPlayerView != null) {
                aliyunLiveShiftPlayerView.changedToLandReverseScape(fromPort);
            }
        }

        public void changedToPortrait(boolean fromLand) {
            AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView = (AliyunLiveShiftPlayerView)((Object)this.weakReference.get());
            if (aliyunLiveShiftPlayerView != null) {
                aliyunLiveShiftPlayerView.changedToPortrait(fromLand);
            }
        }
    }

    private static class ProgressUpdateTimerHandler
    extends Handler {
        private WeakReference<AliyunLiveShiftPlayerView> weakReference;

        public ProgressUpdateTimerHandler(AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView) {
            this.weakReference = new WeakReference<AliyunLiveShiftPlayerView>(aliyunLiveShiftPlayerView);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            AliyunLiveShiftPlayerView aliyunLiveShiftPlayerView = (AliyunLiveShiftPlayerView)((Object)this.weakReference.get());
            if (aliyunLiveShiftPlayerView != null && msg.what == 0) {
                aliyunLiveShiftPlayerView.updater(aliyunLiveShiftPlayerView.mShiftStartTime, aliyunLiveShiftPlayerView.mShiftEndTime);
            }
        }
    }
}

