/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.common;

public enum UploadTypeEnum {
    FILE_STREAM(0, "FileStream"),
    URL_STREAM(1, "URLStream");

    private int code;
    private String desc;

    private UploadTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDesc(Integer code) {
        if (code == null) {
            return null;
        }
        for (UploadTypeEnum typeEnum : UploadTypeEnum.values()) {
            if (typeEnum.getCode() != code.intValue()) continue;
            return typeEnum.getDesc();
        }
        return FILE_STREAM.getDesc();
    }

    public static Integer getCode(String desc) {
        if (desc == null) {
            return null;
        }
        for (UploadTypeEnum typeEnum : UploadTypeEnum.values()) {
            if (!typeEnum.getDesc().equals(desc)) continue;
            return typeEnum.getCode();
        }
        return null;
    }

    public static UploadTypeEnum toEnum(Integer code) {
        for (UploadTypeEnum typeEnum : UploadTypeEnum.values()) {
            if (typeEnum.getCode() != code.intValue()) continue;
            return typeEnum;
        }
        return FILE_STREAM;
    }

    public static Boolean isLegal(Integer code) {
        if (code == null) {
            return false;
        }
        for (UploadTypeEnum typeEnum : UploadTypeEnum.values()) {
            if (typeEnum.getCode() != code.intValue()) continue;
            return true;
        }
        return false;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

