/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.common.utils.StringUtils;
import com.aliyun.oss.model.Callback;
import com.aliyun.oss.model.UploadFileResult;
import com.aliyun.vod.upload.common.Constants;
import com.aliyun.vod.upload.common.Util;
import com.aliyun.vod.upload.dto.STSTokenDTO;
import com.aliyun.vod.upload.dto.UploadTokenDTO;
import com.aliyun.vod.upload.dto.VoDUploadProgressDTO;
import com.aliyun.vod.upload.impl.VoDRefreshSTSTokenListener;
import com.aliyun.vod.upload.oss.OSSClientInternal;
import com.aliyun.vod.upload.oss.OSSConfig;
import com.aliyun.vod.upload.req.MultiPartUploadFileRequest;
import com.aliyun.vod.upload.req.VoDUploadFileRequest;
import com.aliyun.vod.upload.resp.UploadVideoResponse;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class BaseServiceImpl {
    private static Long slowRequestsThreshold = 300000L;
    private static Boolean enableCheckpoint = false;

    public static Long getSlowRequestsThreshold() {
        return slowRequestsThreshold;
    }

    public static void setSlowRequestsThreshold(Long slowRequestsThreshold) {
        BaseServiceImpl.slowRequestsThreshold = slowRequestsThreshold;
    }

    public static Boolean getEnableCheckpoint() {
        return enableCheckpoint;
    }

    public static void setEnableCheckpoint(Boolean enableCheckpoint) {
        BaseServiceImpl.enableCheckpoint = enableCheckpoint;
    }

    protected Map<String, String> formatUserData(Boolean isShowWatermark) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (isShowWatermark != null) {
            String userData = Util.encodeBase64("{\"Vod\":{\"UserData\":{\"IsShowWaterMark\":\"" + isShowWatermark + "\"}}}");
            headers.put("x-oss-notification", userData);
        }
        return headers;
    }

    protected Callback formatCallback(String url, Long fileSize) {
        String[] paramArray;
        String params;
        Callback callback = new Callback();
        callback.setCallbackUrl(url.substring(0, url.indexOf("?") == -1 ? url.length() : url.indexOf("?")));
        callback.setCalbackBodyType(Callback.CalbackBodyType.JSON);
        String callBody = "";
        if (url.indexOf("?") != -1 && (params = url.substring(url.indexOf("?") + 1)).length() > 0 && (paramArray = params.split("&")).length >= 0) {
            for (int i = 0; i < paramArray.length; ++i) {
                callBody = callBody + "\\\"" + paramArray[i].split("=")[0] + "\\\":\\\"" + paramArray[i].split("=")[1] + "\\\",";
            }
        }
        if (callBody.length() > 2) {
            callback.setCallbackBody("{" + callBody.substring(0, callBody.length() - 1) + "}");
        } else {
            callback.setCallbackBody("{\\\"size\\\":" + fileSize + "}");
        }
        return callback;
    }

    public DefaultAcsClient initVodClient(String apiRegionId, String access_key_id, String access_key_secret, String security_token, OSSConfig ossConfig) {
        DefaultProfile profile = security_token != null ? DefaultProfile.getProfile((String)apiRegionId, (String)access_key_id, (String)access_key_secret, (String)security_token) : DefaultProfile.getProfile((String)apiRegionId, (String)access_key_id, (String)access_key_secret);
        if (ossConfig != null && StringUtils.isNullOrEmpty((String)ossConfig.getProxyHost()) && ossConfig.getProxyPort() != -1) {
            HttpClientConfig clientConfig = HttpClientConfig.getDefault();
            StringBuffer proxyUrl = new StringBuffer();
            if (ProtocolType.HTTP.toString().equals(ossConfig.getProtocol())) {
                proxyUrl.append("http://").append(ossConfig.getProxyHost()).append(":").append(ossConfig.getProxyPort());
                clientConfig.setHttpProxy(proxyUrl.toString());
            } else if (ProtocolType.HTTPS.toString().equals(ossConfig.getProtocol())) {
                proxyUrl.append("https://").append(ossConfig.getProxyUsername()).append(":").append(ossConfig.getProxyPassword()).append("@").append(ossConfig.getProxyHost()).append(":").append(ossConfig.getProxyPort());
                clientConfig.setHttpsProxy(proxyUrl.toString());
            }
            profile.setHttpClientConfig(clientConfig);
        }
        return new DefaultAcsClient((IClientProfile)profile);
    }

    protected OSSClientInternal initOSSClient(String endpoint, final String accessKeyId, final String accessKeySecret, final String securityToken, Boolean crcCheckEnabled, OSSConfig ossConfig) {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setConnectionTimeout(Constants.REQUEST_CONNECT_TIMEOUT.intValue());
        conf.setConnectionRequestTimeout(Constants.REQUEST_CONNECT_TIMEOUT.intValue());
        conf.setSlowRequestsThreshold(slowRequestsThreshold.longValue());
        conf.setCrcCheckEnabled(crcCheckEnabled.booleanValue());
        if (ossConfig != null) {
            conf.setSocketTimeout(ossConfig.getSocketTimeOut());
            if (Protocol.HTTPS.toString().equals(ossConfig.getProtocol())) {
                conf.setProtocol(Protocol.HTTPS);
            }
            if (!StringUtils.isNullOrEmpty((String)ossConfig.getUserAgent())) {
                conf.setUserAgent(ossConfig.getUserAgent());
            }
            if (!StringUtils.isNullOrEmpty((String)ossConfig.getProxyHost())) {
                conf.setProxyHost(ossConfig.getProxyHost());
            }
            if (ossConfig.getProxyPort() != -1) {
                conf.setProxyPort(ossConfig.getProxyPort());
            }
            if (!StringUtils.isNullOrEmpty((String)ossConfig.getProxyUsername())) {
                conf.setProxyUsername(ossConfig.getProxyUsername());
            }
            if (!StringUtils.isNullOrEmpty((String)ossConfig.getProxyPassword())) {
                conf.setProxyPassword(ossConfig.getProxyPassword());
            }
        }
        final Credentials credentials1 = new Credentials(){

            public String getAccessKeyId() {
                return accessKeyId;
            }

            public String getSecretAccessKey() {
                return accessKeySecret;
            }

            public String getSecurityToken() {
                return securityToken;
            }

            public boolean useSecurityToken() {
                return true;
            }
        };
        CredentialsProvider credentialsProvider = new CredentialsProvider(){
            private Credentials mCredentials;

            public void setCredentials(Credentials credentials) {
                this.mCredentials = credentials;
            }

            public Credentials getCredentials() {
                return credentials1;
            }
        };
        return new OSSClientInternal(endpoint, credentialsProvider, conf);
    }

    public JSONObject loadVideoIdFromLocal(MultiPartUploadFileRequest request) {
        String localFilename = this.processRequest(request);
        JSONObject localVideo = new JSONObject();
        String requestFilePath = request.getFileName().substring(0, request.getFileName().lastIndexOf("/") + 1);
        String vidFilePath = requestFilePath + localFilename;
        localVideo.put("path", (Object)vidFilePath);
        for (int i = 0; i <= 1; ++i) {
            try {
                String videoId = this.loadFile(vidFilePath);
                if (videoId != null) {
                    localVideo.put("vid", (Object)videoId);
                }
                return localVideo;
            }
            catch (IOException e) {
                continue;
            }
        }
        return localVideo;
    }

    public String processRequest(MultiPartUploadFileRequest request) {
        JSONObject object = new JSONObject();
        if (request.getSecurityToken() == null) {
            object.put("akid", (Object)request.getAccessKeyId());
            object.put("akst", (Object)request.getAccessKeySecret());
        }
        object.put("tt", (Object)request.getTitle());
        object.put("desc", (Object)request.getDescription());
        object.put("tags", (Object)request.getTags());
        object.put("cid", (Object)request.getCateId());
        object.put("curl", (Object)request.getCoverURL());
        object.put("ip", (Object)request.getIP());
        object.put("fnm", (Object)request.getFileName());
        object.put("cbk", (Object)request.getCallback());
        object.put("wm", (Object)request.getShowWaterMark());
        object.put("gid", (Object)request.getTemplateGroupId());
        return BaseServiceImpl.md5(object.toJSONString()) + ".vid";
    }

    public static String md5(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes("UTF-8"));
            return BaseServiceImpl.bytesToHex(md5.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String hashtext = bigInt.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        return hashtext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadFile(String filePath) throws IOException {
        FileInputStream fileIn = null;
        ObjectInputStream streamIn = null;
        try {
            fileIn = new FileInputStream(filePath);
            streamIn = new ObjectInputStream(fileIn);
            String string = (String)streamIn.readObject();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (streamIn != null) {
                streamIn.close();
            }
            if (fileIn != null) {
                fileIn.close();
            }
        }
    }

    public void writeFile(String filePath, String object) throws IOException {
        FileOutputStream fileOut = null;
        ObjectOutputStream outStream = null;
        try {
            fileOut = new FileOutputStream(filePath);
            outStream = new ObjectOutputStream(fileOut);
            outStream.writeObject(object);
            outStream.close();
            fileOut.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (fileOut != null) {
                fileOut.close();
            }
        }
    }

    public void writeM3u8File(String filePath, String object) throws IOException {
        FileOutputStream fs = new FileOutputStream(filePath, true);
        fs.write(object.getBytes());
        fs.write("\n".getBytes());
        fs.close();
    }

    public boolean removeFile(String filePath) {
        boolean flag = false;
        try {
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                flag = file.delete();
            }
            return flag;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean removeDirectory(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.removeDirectory(f);
            }
        }
        return file.delete();
    }

    public void clearTmpFile(String filePath) {
        try {
            File file = new File(filePath);
            this.removeDirectory(file);
        }
        catch (Exception e) {
            System.out.println(String.format("clear tmp file %s failed", filePath));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void multiPartUpload(UploadTokenDTO uploadTokenDTO, MultiPartUploadFileRequest request, UploadVideoResponse response) throws OSSException, ClientException {
        VoDUploadFileRequest uploadFileRequest = new VoDUploadFileRequest(uploadTokenDTO.getBucket(), uploadTokenDTO.getFileName());
        if (!request.getM3u8().booleanValue()) {
            uploadFileRequest.setUploadFile(request.getFileName());
        } else {
            uploadFileRequest.setUploadFile(request.getLocalFilePath());
        }
        uploadFileRequest.setTaskNum(request.getTaskNum());
        uploadFileRequest.setPartSize(request.getPartSize());
        uploadFileRequest.setEnableCheckpoint(BaseServiceImpl.getEnableCheckpoint());
        uploadFileRequest.setHeaders(this.formatUserData(request.getShowWaterMark()));
        if (!StringUtils.isNullOrEmpty((String)request.getCallback())) {
            uploadFileRequest.setCallback(this.formatCallback(request.getCallback(), request.getFileSize()));
        }
        if (request.getProgressListener() != null && !request.getM3u8().booleanValue()) {
            uploadFileRequest.setProgressListener(request.getProgressListener());
        }
        if (BaseServiceImpl.getEnableCheckpoint().booleanValue()) {
            for (int i = 0; i <= 1; ++i) {
                try {
                    this.writeFile(request.getLocalFilePath(), response.getVideoId());
                    break;
                }
                catch (IOException e) {
                    continue;
                }
            }
        }
        OSSClientInternal ossClient = null;
        try {
            UploadFileResult result;
            while (true) {
                ossClient = this.initOSSClient(uploadTokenDTO.getEndpoint(), uploadTokenDTO.getAccessKeyId(), uploadTokenDTO.getAccessKeySecret(), uploadTokenDTO.getSecurityToken(), request.getCrcCheckEnabled(), request.getOssConfig());
                if (!request.getM3u8().booleanValue()) {
                    VoDUploadProgressDTO voDUploadProgressDTO = new VoDUploadProgressDTO();
                    voDUploadProgressDTO.setAccessKeyId(request.getAccessKeyId());
                    voDUploadProgressDTO.setAccesskeySecret(request.getAccessKeySecret());
                    voDUploadProgressDTO.setApiRegionId(request.getApiRegionId());
                    voDUploadProgressDTO.setVideoId(response.getVideoId());
                    voDUploadProgressDTO.setFilename(request.getFileName());
                    voDUploadProgressDTO.setPartSize(request.getPartSize());
                    voDUploadProgressDTO.setFileCreateTime(String.valueOf(System.currentTimeMillis() / 1000L));
                    voDUploadProgressDTO.setClientId(request.getAccessKeyId());
                    voDUploadProgressDTO.setUploadAddress(request.getUploadAddress());
                    uploadFileRequest.setVodUploadProgressDTO(voDUploadProgressDTO);
                }
                if ((result = ossClient.uploadFile(uploadFileRequest)) != null || !BaseServiceImpl.getEnableCheckpoint().booleanValue()) break;
                VoDRefreshSTSTokenListener listener = request.getVoDRefreshSTSTokenListener();
                if (listener != null) {
                    STSTokenDTO stsTokenDTO = listener.onRefreshSTSToken();
                    request.setAccessKeyId(stsTokenDTO.getAccessKeyId());
                    request.setAccessKeySecret(stsTokenDTO.getAccessKeySecret());
                    request.setSecurityToken(stsTokenDTO.getSecurityToken());
                }
                uploadTokenDTO = this.refreshUploadToken(request, response.getVideoId());
                this.closeOssClient(ossClient);
                this.closeOssClient(ossClient);
            }
            if (result == null) {
                response.setCode("The upload token has expired.");
                response.setMessage("Please enable the parameter enableCheckpoint in UploadVideoRequest");
                this.removeFile(request.getLocalFilePath());
                this.closeOssClient(ossClient);
                return;
            }
            response.setCode("Success");
            response.setMessage("Success");
            if (BaseServiceImpl.getEnableCheckpoint().booleanValue()) {
                this.removeFile(request.getLocalFilePath());
            }
            this.closeOssClient(ossClient);
            return;
        }
        catch (OSSException e) {
            block23: {
                try {
                    if (!e.getErrorCode().equalsIgnoreCase("CallbackFailed")) break block23;
                    response.setCode("CallbackFailed");
                    response.setMessage("Unable to execute callback HTTP request.");
                    if (BaseServiceImpl.getEnableCheckpoint().booleanValue()) {
                        this.removeFile(request.getLocalFilePath());
                    }
                    this.closeOssClient(ossClient);
                    return;
                }
                catch (Throwable throwable) {
                    this.closeOssClient(ossClient);
                    throw throwable;
                }
            }
            throw e;
            catch (Throwable e2) {
                if (BaseServiceImpl.getEnableCheckpoint().booleanValue()) {
                    this.removeFile(request.getLocalFilePath());
                }
                throw new OSSException(e2.getMessage(), e2);
            }
        }
    }

    public UploadTokenDTO refreshUploadToken(MultiPartUploadFileRequest request, String videoId) throws ClientException {
        RefreshUploadVideoRequest refreshUploadVideoRequest = new RefreshUploadVideoRequest();
        refreshUploadVideoRequest.setVideoId(videoId);
        refreshUploadVideoRequest.setSysConnectTimeout(Constants.VOD_REQUEST_CONNECT_TIMEOUT);
        refreshUploadVideoRequest.setSysReadTimeout(Constants.VOD_REQUEST_SOCKECT_TIMEOUT);
        DefaultAcsClient vodClient = this.initVodClient(request.getApiRegionId(), request.getAccessKeyId(), request.getAccessKeySecret(), request.getSecurityToken(), request.getOssConfig());
        RefreshUploadVideoResponse refreshUploadVideoResponse = (RefreshUploadVideoResponse)vodClient.getAcsResponse((AcsRequest)refreshUploadVideoRequest);
        String uploadAuth = Util.decodeBase64(refreshUploadVideoResponse.getUploadAuth()).replaceAll("\n", "").replaceAll("\r", "");
        String uploadAddress = Util.decodeBase64(refreshUploadVideoResponse.getUploadAddress()).replaceAll("\n", "").replaceAll("\r", "");
        UploadTokenDTO uploadTokenDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAuth, UploadTokenDTO.class);
        UploadTokenDTO uploadAddressDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAddress, UploadTokenDTO.class);
        uploadTokenDTO.setBucket(uploadAddressDTO.getBucket());
        uploadTokenDTO.setEndpoint(Util.convertOSSInternal(uploadAddressDTO.getEndpoint(), request.getEcsRegionId()));
        uploadTokenDTO.setFileName(uploadAddressDTO.getFileName());
        uploadTokenDTO.setObjectPrefix(uploadAddressDTO.getObjectPrefix());
        request.setRequestId(refreshUploadVideoResponse.getRequestId());
        return uploadTokenDTO;
    }

    public void closeOssClient(OSSClientInternal ossClient) {
        if (ossClient != null) {
            ossClient.shutdown();
            ossClient = null;
        }
    }
}

