/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class DownloadFileImpl {
    private int M3U8_CONNECT_TIMEOUT = 10000;
    private int M3U8_READ_TIMEOUT = 10000;
    private int SLICE_CONNECT_TIMEOUT = 10000;
    private int SLICE_READ_TIMEOUT = 10000;
    private int URL_CONNECT_TIMEOUT = 2000;
    private int URL_READ_TIMEOUT = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadWebFile(String httpURL) {
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedReader br = null;
        String result = null;
        try {
            URL url = new URL(httpURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(this.M3U8_CONNECT_TIMEOUT);
            connection.setReadTimeout(this.M3U8_READ_TIMEOUT);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                is = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                StringBuffer sbf = new StringBuffer();
                String temp = null;
                while ((temp = br.readLine()) != null) {
                    sbf.append(temp);
                    sbf.append("\n");
                }
                sbf.deleteCharAt(sbf.length() - 1);
                result = sbf.toString();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            connection.disconnect();
        }
        return result;
    }

    public void downloadWebTSFile(String sliceFileURL, String sliceLocalFile) throws IOException {
        File file = new File(sliceLocalFile);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(sliceFileURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.SLICE_CONNECT_TIMEOUT);
            conn.setReadTimeout(this.SLICE_READ_TIMEOUT);
            if (conn.getResponseCode() == 200) {
                inputStream = conn.getInputStream();
                fileOutputStream = new FileOutputStream(sliceLocalFile);
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) != -1) {
                    fileOutputStream.write(buf, 0, len);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public void downloadFile(String sURL, String localFilePath) throws Exception {
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(sURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.URL_CONNECT_TIMEOUT);
            conn.setReadTimeout(this.URL_READ_TIMEOUT);
            if (conn.getResponseCode() == 200) {
                inputStream = conn.getInputStream();
                fileOutputStream = new FileOutputStream(localFilePath);
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) != -1) {
                    fileOutputStream.write(buf, 0, len);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public int getSLICE_CONNECT_TIMEOUT() {
        return this.SLICE_CONNECT_TIMEOUT;
    }

    public void setSLICE_CONNECT_TIMEOUT(int SLICE_CONNECT_TIMEOUT) {
        this.SLICE_CONNECT_TIMEOUT = SLICE_CONNECT_TIMEOUT;
    }

    public int getSLICE_READ_TIMEOUT() {
        return this.SLICE_READ_TIMEOUT;
    }

    public void setSLICE_READ_TIMEOUT(int SLICE_READ_TIMEOUT) {
        this.SLICE_READ_TIMEOUT = SLICE_READ_TIMEOUT;
    }

    public int getURL_CONNECT_TIMEOUT() {
        return this.URL_CONNECT_TIMEOUT;
    }

    public void setURL_CONNECT_TIMEOUT(int URL_CONNECT_TIMEOUT) {
        this.URL_CONNECT_TIMEOUT = URL_CONNECT_TIMEOUT;
    }

    public int getURL_READ_TIMEOUT() {
        return this.URL_READ_TIMEOUT;
    }

    public void setURL_READ_TIMEOUT(int URL_READ_TIMEOUT) {
        this.URL_READ_TIMEOUT = URL_READ_TIMEOUT;
    }
}

