/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.vod.upload.impl.VoDProgressListener;

public class PutObjectProgressListener
implements VoDProgressListener {
    private long bytesWritten = 0L;
    private long totalBytes = -1L;
    private boolean succeed = false;
    private String videoId;
    private String imageId;

    public void progressChanged(ProgressEvent progressEvent) {
        long bytes = progressEvent.getBytes();
        ProgressEventType eventType = progressEvent.getEventType();
        switch (eventType) {
            case TRANSFER_STARTED_EVENT: {
                if (this.videoId != null) {
                    System.out.println("Start to upload videoId " + this.videoId + "......");
                }
                if (this.imageId == null) break;
                System.out.println("Start to upload imageId " + this.imageId + "......");
                break;
            }
            case REQUEST_CONTENT_LENGTH_EVENT: {
                this.totalBytes = bytes;
                System.out.println(this.totalBytes + " bytes in total will be uploaded to OSS.");
                break;
            }
            case REQUEST_BYTE_TRANSFER_EVENT: {
                this.bytesWritten += bytes;
                if (this.totalBytes != -1L) {
                    int percent = (int)((double)this.bytesWritten * 100.0 / (double)this.totalBytes);
                    System.out.println(bytes + " bytes have been written at this time, upload progress: " + percent + "%(" + this.bytesWritten + "/" + this.totalBytes + ")");
                    break;
                }
                System.out.println(bytes + " bytes have been written at this time, upload sub total : (" + this.bytesWritten + ")");
                break;
            }
            case TRANSFER_COMPLETED_EVENT: {
                this.succeed = true;
                if (this.videoId != null) {
                    System.out.println("Succeed to upload videoId " + this.videoId + " , " + this.bytesWritten + " bytes have been transferred in total.");
                }
                if (this.imageId == null) break;
                System.out.println("Succeed to upload imageId " + this.imageId + " , " + this.bytesWritten + " bytes have been transferred in total.");
                break;
            }
            case TRANSFER_FAILED_EVENT: {
                if (this.videoId != null) {
                    System.out.println("Failed to upload videoId " + this.videoId + " , " + this.bytesWritten + " bytes have been transferred.");
                }
                if (this.imageId == null) break;
                System.out.println("Failed to upload imageId " + this.imageId + " , " + this.bytesWritten + " bytes have been transferred.");
                break;
            }
        }
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    @Override
    public void onVidReady(String videoId) {
        this.setVideoId(videoId);
    }

    @Override
    public void onImageIdReady(String imageId) {
        this.setImageId(imageId);
    }

    public String getVideoId() {
        return this.videoId;
    }

    public void setVideoId(String videoId) {
        this.videoId = videoId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }
}

