/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import com.aliyun.vod.upload.common.MD5Util;
import com.aliyun.vod.upload.common.Util;
import com.aliyun.vod.upload.dto.VoDUploadProgressDTO;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ReportUploadProgress {
    private static String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static String HTTP_METHOD = "GET";
    private static String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public static final String CHARSET_UTF_8 = "utf-8";
    private static PoolingHttpClientConnectionManager pool;
    private static RequestConfig requestConfig;

    public void reportUploadProgress(VoDUploadProgressDTO voDUploadProgressDTO) {
        try {
            Map<String, String> publicParams = ReportUploadProgress.generatePublicParamters(voDUploadProgressDTO.getAccesskeySecret());
            Map<String, String> privateParams = ReportUploadProgress.generatePrivateParamters(voDUploadProgressDTO);
            String URL2 = ReportUploadProgress.generateURL(publicParams, privateParams, voDUploadProgressDTO);
            ReportUploadProgress.sendHttpGet(URL2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String generateURL(Map<String, String> publicParams, Map<String, String> privateParams, VoDUploadProgressDTO voDUploadProgressDTO) {
        List<String> allEncodeParams = ReportUploadProgress.getAllParams(publicParams, privateParams);
        String CanonicalizedQueryString = ReportUploadProgress.getCQS(allEncodeParams);
        String StringtoSign = HTTP_METHOD + "&" + ReportUploadProgress.percentEncode("/") + "&" + ReportUploadProgress.percentEncode(CanonicalizedQueryString);
        String Signature = ReportUploadProgress.computeSign(voDUploadProgressDTO.getAccesskeySecret(), StringtoSign);
        String vodDomain = "http://vod." + voDUploadProgressDTO.getApiRegionId() + ".aliyuncs.com";
        return vodDomain + "?" + CanonicalizedQueryString + "&" + ReportUploadProgress.percentEncode("Signature") + "=" + ReportUploadProgress.percentEncode(Signature);
    }

    private static List<String> getAllParams(Map<String, String> publicParams, Map<String, String> privateParams) {
        String encodeVal;
        String encodeKey;
        String value;
        ArrayList<String> encodeParams = new ArrayList<String>();
        if (publicParams != null) {
            for (String key : publicParams.keySet()) {
                value = publicParams.get(key);
                if (value == null) continue;
                encodeKey = ReportUploadProgress.percentEncode(key);
                encodeVal = ReportUploadProgress.percentEncode(value);
                encodeParams.add(encodeKey + "=" + encodeVal);
            }
        }
        if (privateParams != null) {
            for (String key : privateParams.keySet()) {
                value = privateParams.get(key);
                if (value == null) continue;
                encodeKey = ReportUploadProgress.percentEncode(key);
                encodeVal = ReportUploadProgress.percentEncode(value);
                encodeParams.add(encodeKey + "=" + encodeVal);
            }
        }
        return encodeParams;
    }

    private static String percentEncode(String value) {
        try {
            String urlEncodeOrignStr = URLEncoder.encode(value, "UTF-8");
            String plusReplaced = urlEncodeOrignStr.replace("+", "%20");
            String starReplaced = plusReplaced.replace("*", "%2A");
            String waveReplaced = starReplaced.replace("%7E", "~");
            return waveReplaced;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return value;
        }
    }

    private static String getCQS(List<String> allParams) {
        ParamsComparator paramsComparator = new ParamsComparator();
        Collections.sort(allParams, paramsComparator);
        String cqString = "";
        for (int i = 0; i < allParams.size(); ++i) {
            cqString = cqString + allParams.get(i);
            if (i == allParams.size() - 1) continue;
            cqString = cqString + "&";
        }
        return cqString;
    }

    private static String computeSign(String accessKeySecret, String stringtoSign) {
        try {
            String key = accessKeySecret + "&";
            try {
                SecretKeySpec signKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
                Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
                mac.init(signKey);
                byte[] rawHmac = mac.doFinal(stringtoSign.getBytes());
                return new String(Util.encodeBase64(rawHmac.toString()));
            }
            catch (Exception e) {
                throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
            }
        }
        catch (SignatureException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String generateRandom() {
        String signatureNonce = UUID.randomUUID().toString();
        return signatureNonce;
    }

    private static String generateTimestamp() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATE_FORMAT);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpGet(String httpUrl) {
        HttpGet httpGet = new HttpGet(httpUrl);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String responseContent = null;
        try {
            httpClient = ReportUploadProgress.getHttpClient();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() >= 300) {
                // empty if block
            }
            if (200 == response.getStatusLine().getStatusCode()) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
        return responseContent;
    }

    public static CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)pool).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).build();
        return httpClient;
    }

    private static String computeAuthInfo(String clientId, String authTimestamp) {
        StringBuilder authKey = new StringBuilder();
        authKey.append(clientId).append("|").append("Vo*8Z75!r8S$qdVg").append("|").append(authTimestamp);
        return MD5Util.md5(authKey.toString());
    }

    private static Map<String, String> generatePrivateParamters(VoDUploadProgressDTO data) {
        HashMap<String, String> privateParams = new HashMap<String, String>();
        privateParams.put("Action", "ReportUploadProgress");
        privateParams.put("Source", "JavaSDK");
        privateParams.put("ClientId", data.getClientId());
        privateParams.put("BusinessType", "UploadVideo");
        privateParams.put("TerminalType", "ServerSDK");
        privateParams.put("DeviceModel", "Server");
        privateParams.put("AppVersion", "1.4.8");
        data.setAuthTimestamp(String.valueOf(System.currentTimeMillis() / 1000L));
        privateParams.put("AuthTimestamp", data.getAuthTimestamp());
        privateParams.put("AuthInfo", ReportUploadProgress.computeAuthInfo(data.getClientId(), data.getAuthTimestamp()));
        privateParams.put("FileName", data.getFilename());
        privateParams.put("FileSize", data.getFileSize().toString());
        privateParams.put("FileCreateTime", data.getFileCreateTime());
        privateParams.put("FileHash", data.getFileHash());
        Float uploadRatio = Float.valueOf((float)data.getDonePartsCount().longValue() / (float)data.getTotalPart().longValue());
        privateParams.put("UploadRatio", String.valueOf(uploadRatio));
        privateParams.put("UploadId", data.getUploadId());
        privateParams.put("DonePartsCount", String.valueOf(data.getDonePartsCount()));
        privateParams.put("TotalPart", data.getTotalPart().toString());
        privateParams.put("PartSize", data.getPartSize().toString());
        privateParams.put("UploadPoint", data.getUploadPoint());
        privateParams.put("UploadAddress", data.getUploadAddress());
        privateParams.put("VideoId", data.getVideoId());
        return privateParams;
    }

    private static Map<String, String> generatePublicParamters(String accessKeyId) {
        HashMap<String, String> publicParams = new HashMap<String, String>();
        publicParams.put("Format", "JSON");
        publicParams.put("Version", "2017-03-21");
        publicParams.put("AccessKeyId", accessKeyId);
        publicParams.put("SignatureMethod", "HMAC-SHA1");
        publicParams.put("Timestamp", ReportUploadProgress.generateTimestamp());
        publicParams.put("SignatureVersion", "1.0");
        publicParams.put("SignatureNonce", ReportUploadProgress.generateRandom());
        return publicParams;
    }

    static {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            pool = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            pool.setMaxTotal(200);
            pool.setDefaultMaxPerRoute(200);
            int socketTimeout = 200;
            int connectTimeout = 200;
            int connectionRequestTimeout = 200;
            requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
    }

    private static class ParamsComparator
    implements Comparator<String> {
        private ParamsComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            return lhs.compareTo(rhs);
        }
    }
}

