/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.vod.upload.UploadAttachedMedia;
import com.aliyun.vod.upload.common.Constants;
import com.aliyun.vod.upload.common.Util;
import com.aliyun.vod.upload.dto.UploadTokenDTO;
import com.aliyun.vod.upload.impl.BaseServiceImpl;
import com.aliyun.vod.upload.oss.OSSClientInternal;
import com.aliyun.vod.upload.req.UploadAttachedMediaRequest;
import com.aliyun.vod.upload.resp.UploadAttachedMediaResponse;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.vod.model.v20170321.CreateUploadAttachedMediaRequest;
import com.aliyuncs.vod.model.v20170321.CreateUploadAttachedMediaResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UploadAttachedMediaImpl
extends BaseServiceImpl
implements UploadAttachedMedia {
    @Override
    public UploadAttachedMediaResponse upload(UploadAttachedMediaRequest request) {
        CreateUploadAttachedMediaResponse createUploadAttachedMediaResponse;
        String protocol;
        CreateUploadAttachedMediaRequest uploadAttachedMediaRequest = new CreateUploadAttachedMediaRequest();
        String string = protocol = request.getOssConfig() != null ? request.getOssConfig().getProtocol() : "http";
        if ("https".equalsIgnoreCase(protocol)) {
            uploadAttachedMediaRequest.setSysProtocol(ProtocolType.HTTPS);
        }
        uploadAttachedMediaRequest.setBusinessType(request.getBusinessType());
        uploadAttachedMediaRequest.setMediaExt(request.getMediaExt());
        uploadAttachedMediaRequest.setTitle(request.getTitle());
        uploadAttachedMediaRequest.setCateId(request.getCateId());
        uploadAttachedMediaRequest.setFileName(request.getFileName());
        uploadAttachedMediaRequest.setTags(request.getTags());
        uploadAttachedMediaRequest.setDescription(request.getDescription());
        uploadAttachedMediaRequest.setUserData(request.getUserData());
        uploadAttachedMediaRequest.setStorageLocation(request.getStorageLocation());
        uploadAttachedMediaRequest.setAppId(request.getAppId());
        uploadAttachedMediaRequest.setSysConnectTimeout(Constants.VOD_REQUEST_CONNECT_TIMEOUT);
        uploadAttachedMediaRequest.setSysReadTimeout(Constants.VOD_REQUEST_SOCKECT_TIMEOUT);
        UploadAttachedMediaResponse uploadAttachedMediaResponse = new UploadAttachedMediaResponse();
        try {
            DefaultAcsClient vodClient = this.initVodClient(request.getApiRegionId(), request.getAccessKeyId(), request.getAccessKeySecret(), request.getSecurityToken(), request.getOssConfig());
            createUploadAttachedMediaResponse = (CreateUploadAttachedMediaResponse)vodClient.getAcsResponse((AcsRequest)uploadAttachedMediaRequest);
            uploadAttachedMediaResponse.setRequestId(createUploadAttachedMediaResponse.getRequestId());
            uploadAttachedMediaResponse.setFileURL(createUploadAttachedMediaResponse.getFileURL());
            uploadAttachedMediaResponse.setMediaURL(createUploadAttachedMediaResponse.getMediaURL());
            uploadAttachedMediaResponse.setMediaId(createUploadAttachedMediaResponse.getMediaId());
        }
        catch (ClientException e) {
            uploadAttachedMediaResponse.setCode(e.getErrCode());
            uploadAttachedMediaResponse.setMessage(e.getErrMsg());
            uploadAttachedMediaResponse.setRequestId(e.getRequestId());
            return uploadAttachedMediaResponse;
        }
        String uploadAuth = Util.decodeBase64(createUploadAttachedMediaResponse.getUploadAuth()).replaceAll("\n", "").replaceAll("\r", "");
        String uploadAddress = Util.decodeBase64(createUploadAttachedMediaResponse.getUploadAddress()).replaceAll("\n", "").replaceAll("\r", "");
        UploadTokenDTO uploadTokenDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAuth, UploadTokenDTO.class);
        UploadTokenDTO uploadAddressDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAddress, UploadTokenDTO.class);
        uploadTokenDTO.setBucket(uploadAddressDTO.getBucket());
        uploadTokenDTO.setEndpoint(Util.convertOSSInternal(uploadAddressDTO.getEndpoint(), request.getEcsRegionId()));
        uploadTokenDTO.setFileName(uploadAddressDTO.getFileName());
        OSSClientInternal ossClient = this.initOSSClient(uploadTokenDTO.getEndpoint(), uploadTokenDTO.getAccessKeyId(), uploadTokenDTO.getAccessKeySecret(), uploadTokenDTO.getSecurityToken(), false, request.getOssConfig());
        this.uploadAttachedMedia(ossClient, uploadTokenDTO, request, uploadAttachedMediaResponse);
        return uploadAttachedMediaResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadAttachedMediaResponse uploadAttachedMedia(OSSClientInternal ossClient, UploadTokenDTO uploadTokenDTO, UploadAttachedMediaRequest request, UploadAttachedMediaResponse response) {
        InputStream inputStream;
        if (request.getInputStream() != null) {
            inputStream = request.getInputStream();
        } else {
            try {
                inputStream = new FileInputStream(request.getFileName());
            }
            catch (IOException e) {
                response.setCode(String.format("FileNotFoundException : %s", request.getFileName()));
                response.setMessage(e.getLocalizedMessage());
                return response;
            }
        }
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(uploadTokenDTO.getBucket(), uploadTokenDTO.getFileName(), inputStream);
            ossClient.putObject(putObjectRequest);
            response.setCode("Success");
            response.setMessage("Success");
            UploadAttachedMediaResponse uploadAttachedMediaResponse = response;
            return uploadAttachedMediaResponse;
        }
        catch (OSSException e) {
            response.setCode(e.getErrorCode());
            response.setMessage(e.getErrorMessage());
        }
        catch (RuntimeException e) {
            response.setCode(e.getMessage());
            response.setMessage(e.getLocalizedMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return response;
    }
}

