/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.vod.upload.UploadImage;
import com.aliyun.vod.upload.common.Constants;
import com.aliyun.vod.upload.common.Util;
import com.aliyun.vod.upload.dto.UploadTokenDTO;
import com.aliyun.vod.upload.impl.BaseServiceImpl;
import com.aliyun.vod.upload.impl.PutObjectProgressListener;
import com.aliyun.vod.upload.oss.OSSClientInternal;
import com.aliyun.vod.upload.req.UploadImageRequest;
import com.aliyun.vod.upload.resp.UploadImageResponse;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.vod.model.v20170321.CreateUploadImageRequest;
import com.aliyuncs.vod.model.v20170321.CreateUploadImageResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UploadImageImpl
extends BaseServiceImpl
implements UploadImage {
    @Override
    public UploadImageResponse upload(UploadImageRequest request) {
        String protocol;
        UploadImageResponse uploadImageResponse = new UploadImageResponse();
        CreateUploadImageRequest createUploadImageRequest = new CreateUploadImageRequest();
        String string = protocol = request.getOssConfig() != null ? request.getOssConfig().getProtocol() : "http";
        if ("https".equalsIgnoreCase(protocol)) {
            createUploadImageRequest.setSysProtocol(ProtocolType.HTTPS);
        }
        createUploadImageRequest.setCateId(request.getCateId());
        createUploadImageRequest.setDescription(request.getDescription());
        createUploadImageRequest.setImageExt(request.getImageExt());
        createUploadImageRequest.setImageType(request.getImageType());
        createUploadImageRequest.setOriginalFileName(request.getFileName());
        createUploadImageRequest.setTitle(request.getTitle());
        createUploadImageRequest.setTags(request.getTags());
        createUploadImageRequest.setUserData(request.getUserData());
        createUploadImageRequest.setStorageLocation(request.getStorageLocation());
        createUploadImageRequest.setAppId(request.getAppId());
        createUploadImageRequest.setSysConnectTimeout(Constants.VOD_REQUEST_CONNECT_TIMEOUT);
        createUploadImageRequest.setSysReadTimeout(Constants.VOD_REQUEST_SOCKECT_TIMEOUT);
        CreateUploadImageResponse createUploadImageResponse = new CreateUploadImageResponse();
        try {
            DefaultAcsClient vodClient = this.initVodClient(request.getApiRegionId(), request.getAccessKeyId(), request.getAccessKeySecret(), request.getSecurityToken(), request.getOssConfig());
            createUploadImageResponse = (CreateUploadImageResponse)vodClient.getAcsResponse((AcsRequest)createUploadImageRequest);
        }
        catch (ClientException e) {
            uploadImageResponse.setCode(e.getErrCode());
            uploadImageResponse.setMessage(e.getErrMsg());
            uploadImageResponse.setRequestId(createUploadImageResponse.getRequestId());
            return uploadImageResponse;
        }
        uploadImageResponse.setRequestId(createUploadImageResponse.getRequestId());
        uploadImageResponse.setImageId(createUploadImageResponse.getImageId());
        uploadImageResponse.setImageURL(createUploadImageResponse.getImageURL());
        if (request.getPrintProgress().booleanValue() && request.getProgressListener() == null) {
            request.setProgressListener(new PutObjectProgressListener());
        } else if (!request.getPrintProgress().booleanValue() || request.getProgressListener() == null) {
            request.setProgressListener(null);
        }
        if (request.getProgressListener() != null) {
            request.getProgressListener().onImageIdReady(uploadImageResponse.getImageId());
        }
        String uploadAuth = Util.decodeBase64(createUploadImageResponse.getUploadAuth()).replaceAll("\n", "").replaceAll("\r", "");
        String uploadAddress = Util.decodeBase64(createUploadImageResponse.getUploadAddress()).replaceAll("\n", "").replaceAll("\r", "");
        UploadTokenDTO uploadTokenDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAuth, UploadTokenDTO.class);
        UploadTokenDTO uploadAddressDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAddress, UploadTokenDTO.class);
        uploadTokenDTO.setBucket(uploadAddressDTO.getBucket());
        uploadTokenDTO.setEndpoint(Util.convertOSSInternal(uploadAddressDTO.getEndpoint(), request.getEcsRegionId()));
        uploadTokenDTO.setFileName(uploadAddressDTO.getFileName());
        OSSClientInternal ossClient = this.initOSSClient(uploadTokenDTO.getEndpoint(), uploadTokenDTO.getAccessKeyId(), uploadTokenDTO.getAccessKeySecret(), uploadTokenDTO.getSecurityToken(), false, request.getOssConfig());
        this.uploadImage(ossClient, uploadTokenDTO, request, uploadImageResponse);
        return uploadImageResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadImageResponse uploadImage(OSSClientInternal ossClient, UploadTokenDTO uploadTokenDTO, UploadImageRequest request, UploadImageResponse response) {
        InputStream inputStream;
        if (request.getInputStream() != null) {
            inputStream = request.getInputStream();
        } else {
            try {
                inputStream = new FileInputStream(request.getFileName());
            }
            catch (IOException e) {
                response.setCode(String.format("FileNotFoundException : %s", request.getFileName()));
                response.setMessage(e.getLocalizedMessage());
                return response;
            }
        }
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(uploadTokenDTO.getBucket(), uploadTokenDTO.getFileName(), inputStream);
            if (request.getProgressListener() != null) {
                putObjectRequest.setProgressListener((ProgressListener)request.getProgressListener());
            }
            ossClient.putObject(putObjectRequest);
            response.setCode("Success");
            response.setMessage("Success");
            UploadImageResponse uploadImageResponse = response;
            return uploadImageResponse;
        }
        catch (OSSException e) {
            response.setCode(e.getErrorCode());
            response.setMessage(e.getErrorMessage());
        }
        catch (RuntimeException e) {
            response.setCode(e.getMessage());
            response.setMessage(e.getLocalizedMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return response;
    }
}

