/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSSException;
import com.aliyun.vod.upload.UploadM3u8File;
import com.aliyun.vod.upload.common.Constants;
import com.aliyun.vod.upload.common.MD5Util;
import com.aliyun.vod.upload.common.Util;
import com.aliyun.vod.upload.dto.UploadTokenDTO;
import com.aliyun.vod.upload.impl.BaseServiceImpl;
import com.aliyun.vod.upload.impl.DownloadFileImpl;
import com.aliyun.vod.upload.impl.PutObjectProgressListener;
import com.aliyun.vod.upload.req.MultiPartUploadFileRequest;
import com.aliyun.vod.upload.req.UploadLocalM3u8Request;
import com.aliyun.vod.upload.req.UploadWebM3u8Request;
import com.aliyun.vod.upload.resp.UploadLocalM3u8Response;
import com.aliyun.vod.upload.resp.UploadVideoResponse;
import com.aliyun.vod.upload.resp.UploadWebM3u8Response;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UploadM3u8FileImpl
extends BaseServiceImpl
implements UploadM3u8File {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadLocalM3u8Response uploadLocalM3u8(UploadLocalM3u8Request request) {
        UploadLocalM3u8Response uploadLocalM3u8Response = request.checkParams();
        if (!uploadLocalM3u8Response.isSuccess()) {
            return uploadLocalM3u8Response;
        }
        CreateUploadVideoResponse createUploadVideoResponse = null;
        try {
            createUploadVideoResponse = this.createUploadVideo(request);
        }
        catch (ClientException e) {
            uploadLocalM3u8Response.setCode(e.getErrCode());
            uploadLocalM3u8Response.setMessage(e.getErrMsg());
            uploadLocalM3u8Response.setRequestId(e.getRequestId());
            return uploadLocalM3u8Response;
        }
        uploadLocalM3u8Response.setVideoId(createUploadVideoResponse.getVideoId());
        String uploadAuth = Util.decodeBase64(createUploadVideoResponse.getUploadAuth()).replaceAll("\n", "").replaceAll("\r", "");
        String uploadAddress = Util.decodeBase64(createUploadVideoResponse.getUploadAddress()).replaceAll("\n", "").replaceAll("\r", "");
        UploadTokenDTO uploadTokenDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAuth, UploadTokenDTO.class);
        UploadTokenDTO uploadAddressDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAddress, UploadTokenDTO.class);
        uploadTokenDTO.setBucket(uploadAddressDTO.getBucket());
        uploadTokenDTO.setEndpoint(Util.convertOSSInternal(uploadAddressDTO.getEndpoint(), request.getEcsRegionId()));
        uploadTokenDTO.setFileName(uploadAddressDTO.getFileName());
        uploadTokenDTO.setObjectPrefix(uploadAddressDTO.getObjectPrefix());
        uploadLocalM3u8Response.setVideoId(createUploadVideoResponse.getVideoId());
        uploadLocalM3u8Response.setRequestId(createUploadVideoResponse.getRequestId());
        String vodM3u8Filename = uploadTokenDTO.getFileName();
        String fileSeparator = request.getM3u8Filename().contains("/") ? "/" : "\\";
        String localM3u8TmpFilePath = request.getM3u8Filename().substring(0, request.getM3u8Filename().lastIndexOf(fileSeparator) + 1) + MD5Util.md5(createUploadVideoResponse.getVideoId()) + ".m3u8";
        request.setLocalTmpM3u8FilePath(localM3u8TmpFilePath);
        LinkedHashMap<String, String> sliceFilePaths = new LinkedHashMap<String, String>();
        try {
            this.rewriteLocalM3u8File(request.getM3u8Filename(), localM3u8TmpFilePath, uploadTokenDTO.getFileName(), sliceFilePaths, request.getSliceFilenames());
        }
        catch (IOException e) {
            this.clearTmpFile(request.getLocalTmpM3u8FilePath());
            uploadLocalM3u8Response.setCode("FileNotFoundException : %s");
            uploadLocalM3u8Response.setMessage(e.getLocalizedMessage());
            return uploadLocalM3u8Response;
        }
        if (sliceFilePaths == null || sliceFilePaths.size() == 0) {
            uploadLocalM3u8Response.setCode("SliceFileNotFound.");
            uploadLocalM3u8Response.setMessage("The slice file does not exist.");
            return uploadLocalM3u8Response;
        }
        MultiPartUploadFileRequest multiPartUploadFileRequest = new MultiPartUploadFileRequest(request.getAccessKeyId(), request.getAccessKeySecret(), request.getTitle(), request.getM3u8Filename());
        multiPartUploadFileRequest.setAccessKeyId(request.getAccessKeyId());
        multiPartUploadFileRequest.setShowWaterMark(request.getShowWaterMark());
        multiPartUploadFileRequest.setPartSize(request.getPartSize());
        multiPartUploadFileRequest.setTaskNum(request.getTaskNum());
        multiPartUploadFileRequest.setCateId(request.getCateId());
        multiPartUploadFileRequest.setCoverURL(request.getCoverURL());
        multiPartUploadFileRequest.setDescription(request.getDescription());
        multiPartUploadFileRequest.setTags(request.getTags());
        multiPartUploadFileRequest.setTemplateGroupId(request.getTemplateGroupId());
        multiPartUploadFileRequest.setWorkflowId(request.getWorkflowId());
        multiPartUploadFileRequest.setStorageLocation(request.getStorageLocation());
        multiPartUploadFileRequest.setUserData(request.getUserData());
        multiPartUploadFileRequest.setM3u8(true);
        multiPartUploadFileRequest.setOssConfig(request.getOssConfig());
        if (request.getPrintProgress().booleanValue() && request.getProgressListener() == null) {
            multiPartUploadFileRequest.setProgressListener(new PutObjectProgressListener());
        } else if (request.getPrintProgress().booleanValue() && request.getProgressListener() != null) {
            multiPartUploadFileRequest.setProgressListener(request.getProgressListener());
        } else {
            multiPartUploadFileRequest.setProgressListener(null);
        }
        if (request.getApiRegionId() != null) {
            multiPartUploadFileRequest.setApiRegionId(request.getApiRegionId());
        }
        if (request.getEcsRegionId() != null) {
            multiPartUploadFileRequest.setEcsRegionId(request.getEcsRegionId());
        }
        try {
            for (String sliceFilePath : ((HashMap)sliceFilePaths).keySet()) {
                UploadVideoResponse uploadVideoSliceResponse = new UploadVideoResponse();
                multiPartUploadFileRequest.setLocalFilePath(sliceFilePath);
                uploadTokenDTO.setFileName(uploadTokenDTO.getObjectPrefix() + (String)((HashMap)sliceFilePaths).get(sliceFilePath));
                this.multiPartUpload(uploadTokenDTO, multiPartUploadFileRequest, uploadVideoSliceResponse);
            }
            multiPartUploadFileRequest.setLocalFilePath(localM3u8TmpFilePath);
            uploadTokenDTO.setFileName(vodM3u8Filename);
            UploadVideoResponse response = new UploadVideoResponse();
            this.multiPartUpload(uploadTokenDTO, multiPartUploadFileRequest, response);
            uploadLocalM3u8Response.setCode("Success");
            uploadLocalM3u8Response.setMessage("Success");
        }
        catch (OSSException e) {
            uploadLocalM3u8Response.setCode(e.getErrorCode());
            uploadLocalM3u8Response.setMessage(e.getErrorMessage());
        }
        catch (ClientException e) {
            uploadLocalM3u8Response.setCode(e.getErrCode());
            uploadLocalM3u8Response.setMessage(e.getErrMsg());
        }
        finally {
            this.clearTmpFile(localM3u8TmpFilePath);
        }
        return uploadLocalM3u8Response;
    }

    @Override
    public UploadWebM3u8Response uploadWebM3u8(UploadWebM3u8Request request) {
        UploadWebM3u8Response response = request.checkParams();
        if (!response.isSuccess()) {
            return response;
        }
        String srcM3u8FileURL = request.getM3u8FileURL();
        String localTmpM3u8FilePath = "";
        localTmpM3u8FilePath = StringUtils.isBlank((CharSequence)request.getGlobalLocalFilePath()) ? "./srcdlfiles/" + MD5Util.md5(request.getM3u8FileURL()) + "/" : request.getGlobalLocalFilePath() + "/" + "srcdlfiles" + "/" + MD5Util.md5(request.getM3u8FileURL()) + "/";
        String localSrcM3u8FileURL = localTmpM3u8FilePath + srcM3u8FileURL.substring(srcM3u8FileURL.lastIndexOf("/") + 1);
        if (srcM3u8FileURL.contains("?Expires") || srcM3u8FileURL.contains("?auth_key")) {
            localSrcM3u8FileURL = localTmpM3u8FilePath + srcM3u8FileURL.substring(srcM3u8FileURL.lastIndexOf("/") + 1, srcM3u8FileURL.indexOf("?"));
        }
        UploadM3u8FileImpl uploadM3u8File = new UploadM3u8FileImpl();
        try {
            uploadM3u8File.downloadWebM3u8File(request, srcM3u8FileURL, localTmpM3u8FilePath);
        }
        catch (Exception e) {
            response.setCode("DownloadM3u8FileFailed.");
            response.setMessage("Download m3u8 FileURL from remote failed.");
            return response;
        }
        UploadLocalM3u8Request uploadLocalM3u8Request = new UploadLocalM3u8Request(request.getAccessKeyId(), request.getAccessKeySecret(), request.getTitle(), localSrcM3u8FileURL);
        uploadLocalM3u8Request.setSecurityToken(request.getSecurityToken());
        uploadLocalM3u8Request.setSliceFilenames(request.getSliceFileURLs());
        uploadLocalM3u8Request.setLocalTmpM3u8FilePath(localTmpM3u8FilePath);
        uploadLocalM3u8Request.setWorkflowId(request.getWorkflowId());
        uploadLocalM3u8Request.setTemplateGroupId(request.getTemplateGroupId());
        uploadLocalM3u8Request.setDescription(request.getDescription());
        uploadLocalM3u8Request.setUserData(request.getUserData());
        uploadLocalM3u8Request.setStorageLocation(request.getStorageLocation());
        uploadLocalM3u8Request.setCateId(request.getCateId());
        uploadLocalM3u8Request.setTags(request.getTags());
        uploadLocalM3u8Request.setCoverURL(request.getCoverURL());
        uploadLocalM3u8Request.setApiRegionId(request.getApiRegionId());
        uploadLocalM3u8Request.setEcsRegionId(request.getEcsRegionId());
        uploadLocalM3u8Request.setAppId(request.getAppId());
        uploadLocalM3u8Request.setOssConfig(request.getOssConfig());
        UploadLocalM3u8Response uploadLocalM3u8Response = uploadM3u8File.uploadLocalM3u8(uploadLocalM3u8Request);
        response.setRequestId(uploadLocalM3u8Response.getRequestId());
        response.setVideoId(uploadLocalM3u8Response.getVideoId());
        response.setCode(uploadLocalM3u8Response.getCode());
        response.setMessage(uploadLocalM3u8Response.getMessage());
        this.clearTmpFile(localTmpM3u8FilePath);
        return response;
    }

    private void rewriteLocalM3u8File(String localM3u8FilePath, String localTmpM3u8FilePath, String vodM3u8Filename, Map<String, String> sliceFiles, String[] sliceFilenames) throws IOException {
        String vodM3u8ObjectName = vodM3u8Filename.substring(vodM3u8Filename.lastIndexOf("/") + 1, vodM3u8Filename.lastIndexOf("."));
        String fileSeparator = localM3u8FilePath.contains("/") ? "/" : "\\";
        String localM3u8Path = localM3u8FilePath.substring(0, localM3u8FilePath.lastIndexOf(fileSeparator) + 1);
        File file = new File(localM3u8FilePath);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int index = 1;
        int filenameIndex = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.startsWith("#")) {
                    this.writeM3u8File(localTmpM3u8FilePath, line);
                    continue;
                }
                StringBuffer newSliceFilename = new StringBuffer();
                newSliceFilename.append(vodM3u8ObjectName).append("-").append(String.format("%05d", index++)).append(".ts");
                if (sliceFilenames == null || sliceFilenames.length == 0) {
                    if (line.contains("?auth_key") || line.contains("?Expires")) {
                        line = line.substring(0, line.indexOf("?"));
                    }
                    sliceFiles.put(localM3u8Path + line, newSliceFilename.toString());
                } else {
                    if (sliceFilenames[filenameIndex].contains("?auth_key") || sliceFilenames[filenameIndex].contains("?Expires")) {
                        String sliceFilename = sliceFilenames[filenameIndex].substring(0, sliceFilenames[filenameIndex].indexOf("?"));
                        sliceFiles.put(sliceFilename, newSliceFilename.toString());
                    } else {
                        sliceFiles.put(sliceFilenames[filenameIndex], newSliceFilename.toString());
                    }
                    ++filenameIndex;
                }
                this.writeM3u8File(localTmpM3u8FilePath, newSliceFilename.toString());
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void downloadWebM3u8File(UploadWebM3u8Request request, String srcM3u8URL, String localTmpM3u8FilePath) throws Exception {
        DownloadFileImpl downloadFile = new DownloadFileImpl();
        downloadFile.setSLICE_CONNECT_TIMEOUT(request.getDownloadConnectTimeout());
        downloadFile.setSLICE_READ_TIMEOUT(request.getDownloadSocketTimeout());
        String srcM3u8Content = downloadFile.downloadWebFile(srcM3u8URL);
        if (StringUtils.isBlank((CharSequence)srcM3u8Content)) {
            throw new Exception("download from remote fail");
        }
        File file = new File(localTmpM3u8FilePath);
        if (!file.exists()) {
            file.mkdirs();
            file.canWrite();
        }
        String srcM3u8URLPath = srcM3u8URL.substring(0, srcM3u8URL.lastIndexOf("/") + 1);
        String localM3u8Filename = srcM3u8URL.substring(srcM3u8URL.lastIndexOf("/") + 1);
        if (srcM3u8URL.contains("?Expires") || srcM3u8URL.contains("?auth_key")) {
            localM3u8Filename = srcM3u8URL.substring(srcM3u8URL.lastIndexOf("/") + 1, srcM3u8URL.indexOf("?"));
        }
        this.writeM3u8File(localTmpM3u8FilePath + localM3u8Filename, srcM3u8Content);
        String[] srcM3u8ContentArray = StringUtils.split((String)srcM3u8Content, (String)"\n");
        LinkedList<String> localSliceFiles = new LinkedList<String>();
        int index = 0;
        String localSliceFile = "";
        for (String m3u8Content : srcM3u8ContentArray) {
            if (m3u8Content.startsWith("#")) continue;
            while (m3u8Content.startsWith("/")) {
                m3u8Content = m3u8Content.substring(1);
                srcM3u8URLPath = srcM3u8URLPath.substring(0, this.getbatchId(srcM3u8URLPath, "/", 3)) + "/";
            }
            if (m3u8Content.toLowerCase().startsWith("http://") || m3u8Content.toLowerCase().startsWith("https://")) {
                srcM3u8URLPath = "";
                String suffixM3u8Content = m3u8Content.substring(m3u8Content.lastIndexOf("/") + 1);
                localSliceFile = localTmpM3u8FilePath + suffixM3u8Content;
            } else {
                localSliceFile = localTmpM3u8FilePath + m3u8Content;
            }
            if (request.getSliceFileURLs() == null || request.getSliceFileURLs().length == 0) {
                if (m3u8Content.contains("?auth_key") || m3u8Content.contains("?Expires")) {
                    localSliceFile = localTmpM3u8FilePath + m3u8Content.substring(0, m3u8Content.indexOf("?"));
                }
                downloadFile.downloadWebTSFile(srcM3u8URLPath + m3u8Content, localSliceFile);
            } else {
                if (m3u8Content.contains("?auth_key") || m3u8Content.contains("?Expires")) {
                    localSliceFile = localTmpM3u8FilePath + m3u8Content.substring(0, m3u8Content.indexOf("?"));
                }
                downloadFile.downloadWebTSFile(request.getSliceFileURLs()[index++], localSliceFile);
            }
            localSliceFiles.add(localSliceFile);
        }
        if (localSliceFiles.size() > 0) {
            request.setSliceFileURLs(localSliceFiles.toArray(new String[0]));
        }
    }

    private CreateUploadVideoResponse createUploadVideo(UploadLocalM3u8Request uploadLocalM3u8Request) throws ClientException {
        String protocol;
        CreateUploadVideoRequest createUploadVideoRequest = new CreateUploadVideoRequest();
        String string = protocol = uploadLocalM3u8Request.getOssConfig() != null ? uploadLocalM3u8Request.getOssConfig().getProtocol() : "http";
        if ("https".equalsIgnoreCase(protocol)) {
            createUploadVideoRequest.setSysProtocol(ProtocolType.HTTPS);
        }
        createUploadVideoRequest.setTitle(uploadLocalM3u8Request.getTitle());
        createUploadVideoRequest.setFileName(uploadLocalM3u8Request.getM3u8Filename());
        createUploadVideoRequest.setDescription(uploadLocalM3u8Request.getDescription());
        createUploadVideoRequest.setUserData(uploadLocalM3u8Request.getUserData());
        createUploadVideoRequest.setStorageLocation(uploadLocalM3u8Request.getStorageLocation());
        createUploadVideoRequest.setCateId(uploadLocalM3u8Request.getCateId());
        createUploadVideoRequest.setTags(uploadLocalM3u8Request.getTags());
        createUploadVideoRequest.setTemplateGroupId(uploadLocalM3u8Request.getTemplateGroupId());
        createUploadVideoRequest.setWorkflowId(uploadLocalM3u8Request.getWorkflowId());
        createUploadVideoRequest.setCoverURL(uploadLocalM3u8Request.getCoverURL());
        createUploadVideoRequest.setAppId(uploadLocalM3u8Request.getAppId());
        createUploadVideoRequest.setSysConnectTimeout(Constants.VOD_REQUEST_CONNECT_TIMEOUT);
        createUploadVideoRequest.setSysReadTimeout(Constants.VOD_REQUEST_SOCKECT_TIMEOUT);
        DefaultAcsClient vodClient = this.initVodClient(uploadLocalM3u8Request.getApiRegionId(), uploadLocalM3u8Request.getAccessKeyId(), uploadLocalM3u8Request.getAccessKeySecret(), uploadLocalM3u8Request.getSecurityToken(), uploadLocalM3u8Request.getOssConfig());
        return (CreateUploadVideoResponse)vodClient.getAcsResponse((AcsRequest)createUploadVideoRequest);
    }

    private int getbatchId(String url, String symbol, int n) {
        int i = 0;
        int s = 0;
        while (i++ < n && (s = url.indexOf(symbol, s + 1)) != -1) {
        }
        return s;
    }
}

