/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.StringUtils;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.vod.upload.UploadVideo;
import com.aliyun.vod.upload.common.Constants;
import com.aliyun.vod.upload.common.MD5Util;
import com.aliyun.vod.upload.common.Util;
import com.aliyun.vod.upload.dto.STSTokenDTO;
import com.aliyun.vod.upload.dto.UploadTokenDTO;
import com.aliyun.vod.upload.impl.BaseServiceImpl;
import com.aliyun.vod.upload.impl.DownloadFileImpl;
import com.aliyun.vod.upload.impl.PutObjectProgressListener;
import com.aliyun.vod.upload.impl.VoDRefreshSTSTokenListener;
import com.aliyun.vod.upload.req.MultiPartUploadFileRequest;
import com.aliyun.vod.upload.req.UploadFileStreamRequest;
import com.aliyun.vod.upload.req.UploadStreamRequest;
import com.aliyun.vod.upload.req.UploadURLStreamRequest;
import com.aliyun.vod.upload.req.UploadVideoRequest;
import com.aliyun.vod.upload.resp.UploadFileStreamResponse;
import com.aliyun.vod.upload.resp.UploadStreamResponse;
import com.aliyun.vod.upload.resp.UploadURLStreamResponse;
import com.aliyun.vod.upload.resp.UploadVideoResponse;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class UploadVideoImpl
extends BaseServiceImpl
implements UploadVideo {
    @Override
    public UploadVideoResponse uploadVideo(UploadVideoRequest request) {
        MultiPartUploadFileRequest multiPartUploadFileRequest = new MultiPartUploadFileRequest(request.getAccessKeyId(), request.getAccessKeySecret(), request.getTitle(), request.getFileName());
        multiPartUploadFileRequest.setSecurityToken(request.getSecurityToken());
        multiPartUploadFileRequest.setShowWaterMark(request.getIsShowWaterMark());
        multiPartUploadFileRequest.setPartSize(request.getPartSize());
        multiPartUploadFileRequest.setTaskNum(request.getTaskNum());
        multiPartUploadFileRequest.setCallback(request.getCallback());
        multiPartUploadFileRequest.setCateId(request.getCateId());
        multiPartUploadFileRequest.setCoverURL(request.getCoverURL());
        multiPartUploadFileRequest.setDescription(request.getDescription());
        multiPartUploadFileRequest.setIP(request.getIP());
        multiPartUploadFileRequest.setTags(request.getTags());
        multiPartUploadFileRequest.setTemplateGroupId(request.getTemplateGroupId());
        multiPartUploadFileRequest.setStorageLocation(request.getStorageLocation());
        multiPartUploadFileRequest.setUserData(request.getUserData());
        multiPartUploadFileRequest.setApiRegionId(request.getApiRegionId());
        multiPartUploadFileRequest.setEcsRegionId(request.getEcsRegionId());
        multiPartUploadFileRequest.setWorkflowId(request.getWorkflowId());
        multiPartUploadFileRequest.setAppId(request.getAppId());
        multiPartUploadFileRequest.setOssConfig(request.getOssConfig());
        if (request.getSlowRequestsThreshold() != null) {
            UploadVideoImpl.setSlowRequestsThreshold(request.getSlowRequestsThreshold());
        }
        if (request.getEnableCheckpoint().booleanValue()) {
            UploadVideoImpl.setEnableCheckpoint(request.getEnableCheckpoint());
        }
        if (request.getPrintProgress().booleanValue() && request.getProgressListener() == null) {
            multiPartUploadFileRequest.setProgressListener(new PutObjectProgressListener());
        } else if (request.getPrintProgress().booleanValue() && request.getProgressListener() != null) {
            multiPartUploadFileRequest.setProgressListener(request.getProgressListener());
        } else {
            multiPartUploadFileRequest.setProgressListener(null);
        }
        if (request.getVoDRefreshSTSTokenListener() != null) {
            multiPartUploadFileRequest.setVoDRefreshSTSTokenListener(request.getVoDRefreshSTSTokenListener());
        }
        UploadVideoResponse response = new UploadVideoResponse();
        this.uploadFileStream(multiPartUploadFileRequest, response);
        return response;
    }

    private void uploadFileStream(MultiPartUploadFileRequest request, UploadVideoResponse response) {
        Long fileSize;
        try {
            File file = new File(request.getFileName());
            if (!file.exists()) {
                response.setCode("InvalidFile.Damaged");
                response.setMessage("The video file has been Damaged.");
                return;
            }
            if ((double)file.length() > Constants.MAX_FILE_SIZE) {
                response.setCode("FileSizeExceededMax");
                response.setMessage("The file size exceeded maximum.");
                return;
            }
            fileSize = file.length();
        }
        catch (Exception e) {
            response.setCode("InvalidFile.Damaged");
            response.setMessage("The video file has been Damaged.");
            return;
        }
        request.setFileSize(fileSize);
        UploadTokenDTO uploadTokenDTO = new UploadTokenDTO();
        Boolean createToken = true;
        String videoId = null;
        String localVideoPath = null;
        if (UploadVideoImpl.getEnableCheckpoint().booleanValue()) {
            JSONObject localVideo = this.loadVideoIdFromLocal(request);
            localVideoPath = localVideo.getString("path");
            videoId = localVideo.getString("vid");
            if (!StringUtils.isNullOrEmpty((String)videoId)) {
                for (int i = 0; i <= 1; ++i) {
                    try {
                        VoDRefreshSTSTokenListener listener = request.getVoDRefreshSTSTokenListener();
                        if (listener != null) {
                            STSTokenDTO stsTokenDTO = listener.onRefreshSTSToken();
                            request.setAccessKeyId(stsTokenDTO.getAccessKeyId());
                            request.setAccessKeySecret(stsTokenDTO.getAccessKeySecret());
                            request.setSecurityToken(stsTokenDTO.getSecurityToken());
                        }
                        uploadTokenDTO = this.refreshUploadToken(request, videoId);
                        createToken = false;
                        break;
                    }
                    catch (ClientException e) {
                        createToken = true;
                        continue;
                    }
                }
            }
            response.setVideoId(videoId);
            if (request.getProgressListener() != null) {
                request.getProgressListener().onVidReady(videoId);
            }
        }
        request.setLocalFilePath(localVideoPath);
        if (createToken.booleanValue()) {
            String protocol;
            CreateUploadVideoRequest createUploadVideoRequest = new CreateUploadVideoRequest();
            String string = protocol = request.getOssConfig() != null ? request.getOssConfig().getProtocol() : "http";
            if ("https".equalsIgnoreCase(protocol)) {
                createUploadVideoRequest.setSysProtocol(ProtocolType.HTTPS);
            }
            createUploadVideoRequest.setTitle(request.getTitle());
            createUploadVideoRequest.setDescription(request.getDescription());
            createUploadVideoRequest.setFileName(request.getFileName());
            createUploadVideoRequest.setCoverURL(request.getCoverURL());
            createUploadVideoRequest.setIP(request.getIP());
            createUploadVideoRequest.setCateId(request.getCateId());
            createUploadVideoRequest.setTags(request.getTags());
            createUploadVideoRequest.setTemplateGroupId(request.getTemplateGroupId());
            createUploadVideoRequest.setStorageLocation(request.getStorageLocation());
            createUploadVideoRequest.setUserData(request.getUserData());
            createUploadVideoRequest.setWorkflowId(request.getWorkflowId());
            createUploadVideoRequest.setAppId(request.getAppId());
            createUploadVideoRequest.setSysConnectTimeout(Constants.VOD_REQUEST_CONNECT_TIMEOUT);
            createUploadVideoRequest.setSysReadTimeout(Constants.VOD_REQUEST_SOCKECT_TIMEOUT);
            CreateUploadVideoResponse createUploadVideoResponse = new CreateUploadVideoResponse();
            try {
                DefaultAcsClient vodClient = this.initVodClient(request.getApiRegionId(), request.getAccessKeyId(), request.getAccessKeySecret(), request.getSecurityToken(), request.getOssConfig());
                createUploadVideoResponse = (CreateUploadVideoResponse)vodClient.getAcsResponse((AcsRequest)createUploadVideoRequest);
            }
            catch (ClientException e) {
                response.setCode(e.getErrCode());
                response.setMessage(e.getErrMsg());
                response.setRequestId(createUploadVideoResponse.getRequestId());
                return;
            }
            response.setVideoId(createUploadVideoResponse.getVideoId());
            videoId = createUploadVideoResponse.getVideoId();
            if (request.getProgressListener() != null) {
                request.getProgressListener().onVidReady(videoId);
            }
            request.setRequestId(createUploadVideoResponse.getRequestId());
            if (StringUtils.isNullOrEmpty((String)videoId) || StringUtils.isNullOrEmpty((String)createUploadVideoResponse.getUploadAuth()) || StringUtils.isNullOrEmpty((String)createUploadVideoResponse.getUploadAddress())) {
                response.setCode("AddVideoInfoFailed");
                response.setMessage("Adding video info has failed due to some unknown error.");
                response.setRequestId(createUploadVideoResponse.getRequestId());
                return;
            }
            request.setUploadAddress(createUploadVideoResponse.getUploadAddress());
            String uploadAuth = Util.decodeBase64(createUploadVideoResponse.getUploadAuth()).replaceAll("\n", "").replaceAll("\r", "");
            String uploadAddress = Util.decodeBase64(createUploadVideoResponse.getUploadAddress()).replaceAll("\n", "").replaceAll("\r", "");
            uploadTokenDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAuth, UploadTokenDTO.class);
            UploadTokenDTO uploadAddressDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAddress, UploadTokenDTO.class);
            uploadTokenDTO.setBucket(uploadAddressDTO.getBucket());
            uploadTokenDTO.setEndpoint(Util.convertOSSInternal(uploadAddressDTO.getEndpoint(), request.getEcsRegionId()));
            uploadTokenDTO.setFileName(uploadAddressDTO.getFileName());
        }
        try {
            this.multiPartUpload(uploadTokenDTO, request, response);
            if (!response.isSuccess()) {
                response.setRequestId(request.getRequestId());
                return;
            }
        }
        catch (OSSException e) {
            response.setCode(e.getErrorCode());
            response.setMessage(e.getErrorMessage());
            response.setRequestId(request.getRequestId());
            return;
        }
        catch (ClientException ce) {
            response.setCode(ce.getErrCode());
            response.setMessage(ce.getLocalizedMessage());
            response.setRequestId(request.getRequestId());
            return;
        }
        response.setCode("Success");
        response.setMessage("Success");
        response.setRequestId(request.getRequestId());
    }

    @Override
    public UploadURLStreamResponse uploadURLStream(UploadURLStreamRequest request) {
        UploadURLStreamResponse uploadURLStreamResponse = new UploadURLStreamResponse();
        try {
            request.setUrl(URLDecoder.decode(request.getUrl(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            uploadURLStreamResponse.setCode(e.getLocalizedMessage());
            uploadURLStreamResponse.setMessage(e.getLocalizedMessage());
            return uploadURLStreamResponse;
        }
        DownloadFileImpl downloadFile = new DownloadFileImpl();
        if (request.getDownloadConnectTimeout() > 0) {
            downloadFile.setURL_CONNECT_TIMEOUT(request.getDownloadConnectTimeout());
        }
        if (request.getDownloadReadTimeout() > 0) {
            downloadFile.setURL_READ_TIMEOUT(request.getDownloadReadTimeout());
        }
        String briefURL = request.getUrl().indexOf("?") != -1 ? request.getUrl().substring(0, request.getUrl().indexOf("?")) : request.getUrl();
        String fileExtension = "";
        if (briefURL.indexOf(".") == -1) {
            if (request.getFileExtension() == null) {
                uploadURLStreamResponse.setCode("NotExist.FileExtension");
                uploadURLStreamResponse.setMessage("The url or fileExtension of request parameter needs to specify the file extension.");
                return uploadURLStreamResponse;
            }
            if (!Constants.FILE_FORMAT.contains(request.getFileExtension())) {
                uploadURLStreamResponse.setCode("InvalidParameter.FileExtension");
                uploadURLStreamResponse.setMessage("The specified fileExtension is not supported.");
                return uploadURLStreamResponse;
            }
            fileExtension = request.getFileExtension();
        } else {
            fileExtension = briefURL.substring(briefURL.lastIndexOf(".") + 1);
            if (StringUtils.isNullOrEmpty((String)fileExtension) || !Constants.FILE_FORMAT.contains(fileExtension.toUpperCase())) {
                if (request.getFileExtension() == null) {
                    uploadURLStreamResponse.setCode("NotExist.FileExtension");
                    uploadURLStreamResponse.setMessage("The url or fileExtension of request parameter needs to specify the file extension.");
                    return uploadURLStreamResponse;
                }
                if (!Constants.FILE_FORMAT.contains(request.getFileExtension().toUpperCase())) {
                    uploadURLStreamResponse.setCode("InvalidParameter.FileExtension");
                    uploadURLStreamResponse.setMessage("The specified fileExtension is not supported.");
                    return uploadURLStreamResponse;
                }
                fileExtension = request.getFileExtension();
            }
        }
        if (StringUtils.isNullOrEmpty((String)fileExtension)) {
            uploadURLStreamResponse.setCode("NotExist.FileExtension");
            uploadURLStreamResponse.setMessage("The url or fileExtension of request parameter needs to specify the file extension.");
            return uploadURLStreamResponse;
        }
        if (!Constants.FILE_FORMAT.contains(fileExtension.toUpperCase())) {
            uploadURLStreamResponse.setCode("InvalidParameter.FileExtension");
            uploadURLStreamResponse.setMessage("The specified fileExtension is not supported.");
            return uploadURLStreamResponse;
        }
        request.setFileExtension(fileExtension);
        String localDownloadFilePath = request.getLocalDownloadFilePath();
        String system = System.getProperties().getProperty("os.name").toUpperCase();
        String downloadFilename = "";
        String downloadFilePath = "";
        downloadFilePath = request.getLocalDownloadFilePath() != null ? (system.indexOf("WINDOWS") != -1 ? localDownloadFilePath + (localDownloadFilePath.endsWith("\\") ? "srcdlfiles\\" : "\\srcdlfiles\\") : localDownloadFilePath + (localDownloadFilePath.endsWith("/") ? "srcdlfiles/" : "/srcdlfiles/")) : (system.indexOf("WINDOWS") != -1 ? ".\\srcdlfiles\\" : "./srcdlfiles/");
        File filePath = new File(downloadFilePath);
        if (!filePath.exists()) {
            filePath.mkdirs();
            filePath.canWrite();
        } else if (!filePath.isDirectory()) {
            filePath.mkdirs();
            filePath.canWrite();
        }
        downloadFilename = downloadFilePath + MD5Util.md5(request.getUrl()) + "." + request.getFileExtension();
        File dlFilename = new File(downloadFilename);
        if (dlFilename.exists()) {
            System.out.println("file " + dlFilename + " has exist, clear it ...");
            dlFilename.delete();
        }
        long time = System.currentTimeMillis();
        System.out.println("start download data from url " + request.getUrl() + " ...");
        try {
            downloadFile.downloadFile(request.getUrl(), downloadFilename);
        }
        catch (Exception e) {
            System.out.println("download exception total cost " + (System.currentTimeMillis() - time) + " (s) error message " + e.getLocalizedMessage());
            uploadURLStreamResponse.setCode(e.getLocalizedMessage());
            uploadURLStreamResponse.setMessage(e.getLocalizedMessage());
            return uploadURLStreamResponse;
        }
        System.out.println("download success total cost " + (System.currentTimeMillis() - time) / 1000L + " (s)");
        UploadVideoRequest uploadVideoRequest = new UploadVideoRequest(request.getAccessKeyId(), request.getAccessKeySecret(), request.getTitle(), downloadFilename);
        uploadVideoRequest.setSecurityToken(request.getSecurityToken());
        uploadVideoRequest.setDescription(request.getDescription());
        uploadVideoRequest.setCoverURL(request.getCoverURL());
        uploadVideoRequest.setCateId(request.getCateId());
        uploadVideoRequest.setTags(request.getTags());
        uploadVideoRequest.setTemplateGroupId(request.getTemplateGroupId());
        uploadVideoRequest.setStorageLocation(request.getStorageLocation());
        uploadVideoRequest.setUserData(request.getUserData());
        uploadVideoRequest.setWorkflowId(request.getWorkflowId());
        uploadVideoRequest.setAppId(request.getAppId());
        uploadVideoRequest.setApiRegionId(request.getApiRegionId());
        uploadVideoRequest.setEcsRegionId(request.getEcsRegionId());
        uploadVideoRequest.setPrintProgress(request.getPrintProgress());
        uploadVideoRequest.setProgressListener(request.getProgressListener());
        uploadVideoRequest.setPartSize(request.getPartSize());
        uploadVideoRequest.setTaskNum(request.getTaskNum());
        uploadVideoRequest.setIsShowWaterMark(request.getShowWaterMark());
        uploadVideoRequest.setOssConfig(request.getOssConfig());
        UploadVideoResponse uploadVideoResponse = this.uploadVideo(uploadVideoRequest);
        uploadURLStreamResponse.setVideoId(uploadVideoResponse.getVideoId());
        uploadURLStreamResponse.setCode(uploadVideoResponse.getCode());
        uploadURLStreamResponse.setMessage(uploadVideoResponse.getMessage());
        uploadURLStreamResponse.setRequestId(uploadVideoResponse.getRequestId());
        if (uploadVideoResponse.isSuccess() && (dlFilename = new File(downloadFilename)).exists()) {
            System.out.println("file " + dlFilename + " upload success, clear it ...");
            dlFilename.delete();
        }
        return uploadURLStreamResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public UploadFileStreamResponse uploadFileStream(UploadFileStreamRequest request) {
        uploadFileStreamResponse = new UploadFileStreamResponse();
        createUploadVideoRequest = new CreateUploadVideoRequest();
        v0 = protocol = request.getOssConfig() != null ? request.getOssConfig().getProtocol() : "http";
        if ("https".equalsIgnoreCase(protocol)) {
            createUploadVideoRequest.setSysProtocol(ProtocolType.HTTPS);
        }
        createUploadVideoRequest.setTitle(request.getTitle());
        createUploadVideoRequest.setDescription(request.getDescription());
        createUploadVideoRequest.setFileName(request.getFileName());
        createUploadVideoRequest.setCoverURL(request.getCoverURL());
        createUploadVideoRequest.setIP(request.getIP());
        createUploadVideoRequest.setCateId(request.getCateId());
        createUploadVideoRequest.setTags(request.getTags());
        createUploadVideoRequest.setTemplateGroupId(request.getTemplateGroupId());
        createUploadVideoRequest.setStorageLocation(request.getStorageLocation());
        createUploadVideoRequest.setUserData(request.getUserData());
        createUploadVideoRequest.setWorkflowId(request.getWorkflowId());
        createUploadVideoRequest.setAppId(request.getAppId());
        createUploadVideoRequest.setSysConnectTimeout(Constants.VOD_REQUEST_CONNECT_TIMEOUT);
        createUploadVideoRequest.setSysReadTimeout(Constants.VOD_REQUEST_SOCKECT_TIMEOUT);
        createUploadVideoResponse = new CreateUploadVideoResponse();
        try {
            vodClient = this.initVodClient(request.getApiRegionId(), request.getAccessKeyId(), request.getAccessKeySecret(), request.getSecurityToken(), request.getOssConfig());
            createUploadVideoResponse = (CreateUploadVideoResponse)vodClient.getAcsResponse((AcsRequest)createUploadVideoRequest);
        }
        catch (ClientException e) {
            uploadFileStreamResponse.setCode(e.getErrCode());
            uploadFileStreamResponse.setMessage(e.getErrMsg());
            uploadFileStreamResponse.setRequestId(createUploadVideoResponse.getRequestId());
            return uploadFileStreamResponse;
        }
        videoId = createUploadVideoResponse.getVideoId();
        uploadFileStreamResponse.setVideoId(videoId);
        request.setRequestId(createUploadVideoResponse.getRequestId());
        if (StringUtils.isNullOrEmpty((String)videoId) || StringUtils.isNullOrEmpty((String)createUploadVideoResponse.getUploadAuth()) || StringUtils.isNullOrEmpty((String)createUploadVideoResponse.getUploadAddress())) {
            uploadFileStreamResponse.setCode("AddVideoInfoFailed");
            uploadFileStreamResponse.setMessage("Adding video info has failed due to some unknown error.");
            uploadFileStreamResponse.setRequestId(createUploadVideoResponse.getRequestId());
            return uploadFileStreamResponse;
        }
        uploadAuth = Util.decodeBase64(createUploadVideoResponse.getUploadAuth()).replaceAll("\n", "").replaceAll("\r", "");
        uploadAddress = Util.decodeBase64(createUploadVideoResponse.getUploadAddress()).replaceAll("\n", "").replaceAll("\r", "");
        uploadTokenDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAuth, UploadTokenDTO.class);
        uploadAddressDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAddress, UploadTokenDTO.class);
        uploadTokenDTO.setBucket(uploadAddressDTO.getBucket());
        uploadTokenDTO.setEndpoint(Util.convertOSSInternal(uploadAddressDTO.getEndpoint(), request.getEcsRegionId()));
        uploadTokenDTO.setFileName(uploadAddressDTO.getFileName());
        ossClient = null;
        try {
            ossClient = this.initOSSClient(uploadTokenDTO.getEndpoint(), uploadTokenDTO.getAccessKeyId(), uploadTokenDTO.getAccessKeySecret(), uploadTokenDTO.getSecurityToken(), request.getCrcCheckEnabled(), request.getOssConfig());
            inputStream = new FileInputStream(request.getFileName());
            putObjectRequest = new PutObjectRequest(uploadTokenDTO.getBucket(), uploadTokenDTO.getFileName(), (InputStream)inputStream);
            if (request.getPrintProgress().booleanValue() && request.getProgressListener() == null) {
                listener = new PutObjectProgressListener();
                putObjectRequest.withProgressListener((ProgressListener)listener);
                request.setProgressListener(listener);
            } else if (request.getPrintProgress().booleanValue() && request.getProgressListener() != null) {
                putObjectRequest.withProgressListener((ProgressListener)request.getProgressListener());
            } else {
                request.setProgressListener(null);
            }
            if (request.getProgressListener() != null) {
                request.getProgressListener().onVidReady(createUploadVideoResponse.getVideoId());
            }
            putObjectRequest.setHeaders(this.formatUserData(request.getShowWaterMark()));
            if (!StringUtils.isNullOrEmpty((String)request.getCallback())) {
                putObjectRequest.setCallback(this.formatCallback(request.getCallback(), 0L));
            }
            ossClient.putObject(putObjectRequest);
            ** if (ossClient == null) goto lbl-1000
        }
        catch (FileNotFoundException e) {
            block16: {
                try {
                    uploadFileStreamResponse.setCode(String.format("FileNotFoundException : %s", new Object[]{request.getFileName()}));
                    uploadFileStreamResponse.setMessage(e.getLocalizedMessage());
                    uploadFileStreamResponse.setRequestId(request.getRequestId());
                    var14_17 = uploadFileStreamResponse;
                    if (ossClient == null) break block16;
                }
                catch (Throwable var16_19) {
                    if (ossClient != null) {
                        this.closeOssClient(ossClient);
                    }
                    throw var16_19;
                }
                this.closeOssClient(ossClient);
            }
            return var14_17;
        }
lbl-1000:
        // 1 sources

        {
            this.closeOssClient(ossClient);
        }
lbl-1000:
        // 2 sources

        {
        }
        uploadFileStreamResponse.setCode("Success");
        uploadFileStreamResponse.setMessage("Success");
        uploadFileStreamResponse.setRequestId(request.getRequestId());
        return uploadFileStreamResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public UploadStreamResponse uploadStream(UploadStreamRequest request) {
        uploadStreamResponse = new UploadStreamResponse();
        createUploadVideoRequest = new CreateUploadVideoRequest();
        v0 = protocol = request.getOssConfig() != null ? request.getOssConfig().getProtocol() : "http";
        if ("https".equalsIgnoreCase(protocol)) {
            createUploadVideoRequest.setSysProtocol(ProtocolType.HTTPS);
        }
        createUploadVideoRequest.setTitle(request.getTitle());
        createUploadVideoRequest.setDescription(request.getDescription());
        createUploadVideoRequest.setFileName(request.getFileName());
        createUploadVideoRequest.setCoverURL(request.getCoverURL());
        createUploadVideoRequest.setIP(request.getIP());
        createUploadVideoRequest.setCateId(request.getCateId());
        createUploadVideoRequest.setTags(request.getTags());
        createUploadVideoRequest.setTemplateGroupId(request.getTemplateGroupId());
        createUploadVideoRequest.setStorageLocation(request.getStorageLocation());
        createUploadVideoRequest.setUserData(request.getUserData());
        createUploadVideoRequest.setWorkflowId(request.getWorkflowId());
        createUploadVideoRequest.setAppId(request.getAppId());
        createUploadVideoRequest.setSysConnectTimeout(Constants.VOD_REQUEST_CONNECT_TIMEOUT);
        createUploadVideoRequest.setSysReadTimeout(Constants.VOD_REQUEST_SOCKECT_TIMEOUT);
        createUploadVideoResponse = new CreateUploadVideoResponse();
        try {
            vodClient = this.initVodClient(request.getApiRegionId(), request.getAccessKeyId(), request.getAccessKeySecret(), request.getSecurityToken(), request.getOssConfig());
            createUploadVideoResponse = (CreateUploadVideoResponse)vodClient.getAcsResponse((AcsRequest)createUploadVideoRequest);
        }
        catch (ClientException e) {
            uploadStreamResponse.setCode(e.getErrCode());
            uploadStreamResponse.setMessage(e.getErrMsg());
            uploadStreamResponse.setRequestId(createUploadVideoResponse.getRequestId());
            return uploadStreamResponse;
        }
        videoId = createUploadVideoResponse.getVideoId();
        uploadStreamResponse.setVideoId(videoId);
        request.setRequestId(createUploadVideoResponse.getRequestId());
        if (StringUtils.isNullOrEmpty((String)videoId) || StringUtils.isNullOrEmpty((String)createUploadVideoResponse.getUploadAuth()) || StringUtils.isNullOrEmpty((String)createUploadVideoResponse.getUploadAddress())) {
            uploadStreamResponse.setCode("AddVideoInfoFailed");
            uploadStreamResponse.setMessage("Adding video info has failed due to some unknown error.");
            uploadStreamResponse.setRequestId(createUploadVideoResponse.getRequestId());
            return uploadStreamResponse;
        }
        uploadAuth = Util.decodeBase64(createUploadVideoResponse.getUploadAuth()).replaceAll("\n", "").replaceAll("\r", "");
        uploadAddress = Util.decodeBase64(createUploadVideoResponse.getUploadAddress()).replaceAll("\n", "").replaceAll("\r", "");
        uploadTokenDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAuth, UploadTokenDTO.class);
        uploadAddressDTO = (UploadTokenDTO)JSON.parseObject((String)uploadAddress, UploadTokenDTO.class);
        uploadTokenDTO.setBucket(uploadAddressDTO.getBucket());
        uploadTokenDTO.setEndpoint(Util.convertOSSInternal(uploadAddressDTO.getEndpoint(), request.getEcsRegionId()));
        uploadTokenDTO.setFileName(uploadAddressDTO.getFileName());
        ossClient = null;
        try {
            ossClient = this.initOSSClient(uploadTokenDTO.getEndpoint(), uploadTokenDTO.getAccessKeyId(), uploadTokenDTO.getAccessKeySecret(), uploadTokenDTO.getSecurityToken(), request.getCrcCheckEnabled(), request.getOssConfig());
            putObjectRequest = new PutObjectRequest(uploadTokenDTO.getBucket(), uploadTokenDTO.getFileName(), request.getInputStream());
            if (request.getPrintProgress().booleanValue() && request.getProgressListener() == null) {
                listener = new PutObjectProgressListener();
                putObjectRequest.withProgressListener((ProgressListener)listener);
                request.setProgressListener(listener);
            } else if (request.getPrintProgress().booleanValue() && request.getProgressListener() != null) {
                putObjectRequest.withProgressListener((ProgressListener)request.getProgressListener());
            } else {
                request.setProgressListener(null);
            }
            if (request.getProgressListener() != null) {
                request.getProgressListener().onVidReady(createUploadVideoResponse.getVideoId());
            }
            putObjectRequest.setHeaders(this.formatUserData(request.getShowWaterMark()));
            if (!StringUtils.isNullOrEmpty((String)request.getCallback())) {
                putObjectRequest.setCallback(this.formatCallback(request.getCallback(), 0L));
            }
            if ((result = ossClient.putObject(putObjectRequest)).getServerCRC() != null) {
                uploadStreamResponse.setServerCRC(result.getServerCRC());
            }
            if (result.getClientCRC() != null) {
                uploadStreamResponse.setClientCRC(result.getClientCRC());
            }
            ** if (ossClient == null) goto lbl-1000
        }
        catch (Exception e) {
            block18: {
                try {
                    uploadStreamResponse.setCode(e.getLocalizedMessage());
                    uploadStreamResponse.setMessage(e.getMessage());
                    uploadStreamResponse.setRequestId(request.getRequestId());
                    var14_17 = uploadStreamResponse;
                    if (ossClient == null) break block18;
                }
                catch (Throwable var15_18) {
                    if (ossClient != null) {
                        this.closeOssClient(ossClient);
                    }
                    throw var15_18;
                }
                this.closeOssClient(ossClient);
            }
            return var14_17;
        }
lbl-1000:
        // 1 sources

        {
            this.closeOssClient(ossClient);
        }
lbl-1000:
        // 2 sources

        {
        }
        uploadStreamResponse.setCode("Success");
        uploadStreamResponse.setMessage("Success");
        uploadStreamResponse.setVideoId(videoId);
        uploadStreamResponse.setRequestId(request.getRequestId());
        return uploadStreamResponse;
    }
}

