/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.DefaultServiceClient;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.common.comm.TimeoutServiceClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.CORSOperation;
import com.aliyun.oss.internal.LiveChannelOperation;
import com.aliyun.oss.internal.OSSBucketOperation;
import com.aliyun.oss.internal.OSSDownloadOperation;
import com.aliyun.oss.internal.OSSMultipartOperation;
import com.aliyun.oss.internal.OSSObjectOperation;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.SignUtils;
import com.aliyun.oss.internal.SignV2Utils;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.AddBucketCnameRequest;
import com.aliyun.oss.model.AddBucketReplicationRequest;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.AsyncFetchTaskConfiguration;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketMetadata;
import com.aliyun.oss.model.BucketProcess;
import com.aliyun.oss.model.BucketQosInfo;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketReplicationProgress;
import com.aliyun.oss.model.BucketStat;
import com.aliyun.oss.model.BucketVersioningConfiguration;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CORSConfiguration;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CnameConfiguration;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.CreateBucketVpcipRequest;
import com.aliyun.oss.model.CreateLiveChannelRequest;
import com.aliyun.oss.model.CreateLiveChannelResult;
import com.aliyun.oss.model.CreateSelectObjectMetadataRequest;
import com.aliyun.oss.model.CreateSymlinkRequest;
import com.aliyun.oss.model.CreateUdfApplicationRequest;
import com.aliyun.oss.model.CreateUdfRequest;
import com.aliyun.oss.model.CreateVpcipRequest;
import com.aliyun.oss.model.CreateVpcipResult;
import com.aliyun.oss.model.DeleteBucketCnameRequest;
import com.aliyun.oss.model.DeleteBucketInventoryConfigurationRequest;
import com.aliyun.oss.model.DeleteBucketReplicationRequest;
import com.aliyun.oss.model.DeleteBucketVpcipRequest;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.DeleteVersionRequest;
import com.aliyun.oss.model.DeleteVersionsRequest;
import com.aliyun.oss.model.DeleteVersionsResult;
import com.aliyun.oss.model.DeleteVpcipRequest;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.DownloadFileResult;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GenerateRtmpUriRequest;
import com.aliyun.oss.model.GenerateVodPlaylistRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GenericResult;
import com.aliyun.oss.model.GetAsyncFetchTaskRequest;
import com.aliyun.oss.model.GetAsyncFetchTaskResult;
import com.aliyun.oss.model.GetBucketImageResult;
import com.aliyun.oss.model.GetBucketInventoryConfigurationRequest;
import com.aliyun.oss.model.GetBucketInventoryConfigurationResult;
import com.aliyun.oss.model.GetBucketPolicyResult;
import com.aliyun.oss.model.GetBucketReplicationProgressRequest;
import com.aliyun.oss.model.GetBucketRequestPaymentResult;
import com.aliyun.oss.model.GetImageStyleResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.GetUdfApplicationLogRequest;
import com.aliyun.oss.model.GetVodPlaylistRequest;
import com.aliyun.oss.model.HeadObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.InventoryConfiguration;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListBucketInventoryConfigurationsRequest;
import com.aliyun.oss.model.ListBucketInventoryConfigurationsResult;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListLiveChannelsRequest;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.ListVersionsRequest;
import com.aliyun.oss.model.LiveChannel;
import com.aliyun.oss.model.LiveChannelGenericRequest;
import com.aliyun.oss.model.LiveChannelInfo;
import com.aliyun.oss.model.LiveChannelListing;
import com.aliyun.oss.model.LiveChannelStat;
import com.aliyun.oss.model.LiveChannelStatus;
import com.aliyun.oss.model.LiveRecord;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSSymlink;
import com.aliyun.oss.model.ObjectAcl;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.OptionsRequest;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.ProcessObjectRequest;
import com.aliyun.oss.model.PutBucketImageRequest;
import com.aliyun.oss.model.PutImageStyleRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.ReplicationRule;
import com.aliyun.oss.model.ResizeUdfApplicationRequest;
import com.aliyun.oss.model.RestoreConfiguration;
import com.aliyun.oss.model.RestoreObjectRequest;
import com.aliyun.oss.model.RestoreObjectResult;
import com.aliyun.oss.model.SelectObjectMetadata;
import com.aliyun.oss.model.SelectObjectRequest;
import com.aliyun.oss.model.ServerSideEncryptionConfiguration;
import com.aliyun.oss.model.SetAsyncFetchTaskRequest;
import com.aliyun.oss.model.SetAsyncFetchTaskResult;
import com.aliyun.oss.model.SetBucketAclRequest;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.SetBucketEncryptionRequest;
import com.aliyun.oss.model.SetBucketInventoryConfigurationRequest;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketPolicyRequest;
import com.aliyun.oss.model.SetBucketProcessRequest;
import com.aliyun.oss.model.SetBucketQosInfoRequest;
import com.aliyun.oss.model.SetBucketRefererRequest;
import com.aliyun.oss.model.SetBucketRequestPaymentRequest;
import com.aliyun.oss.model.SetBucketStorageCapacityRequest;
import com.aliyun.oss.model.SetBucketTaggingRequest;
import com.aliyun.oss.model.SetBucketVersioningRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import com.aliyun.oss.model.SetLiveChannelRequest;
import com.aliyun.oss.model.SetObjectAclRequest;
import com.aliyun.oss.model.SetObjectTaggingRequest;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import com.aliyun.oss.model.Style;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.UdfApplicationInfo;
import com.aliyun.oss.model.UdfApplicationLog;
import com.aliyun.oss.model.UdfGenericRequest;
import com.aliyun.oss.model.UdfImageInfo;
import com.aliyun.oss.model.UdfInfo;
import com.aliyun.oss.model.UpgradeUdfApplicationRequest;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import com.aliyun.oss.model.UploadUdfImageRequest;
import com.aliyun.oss.model.UserQos;
import com.aliyun.oss.model.UserQosInfo;
import com.aliyun.oss.model.VersionListing;
import com.aliyun.oss.model.VpcPolicy;
import com.aliyun.oss.model.Vpcip;
import com.aliyun.vod.upload.oss.OSSUploadOperation;
import com.aliyun.vod.upload.req.VoDUploadFileRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class OSSClientInternal
implements OSS {
    private CredentialsProvider credsProvider;
    private URI endpoint;
    private ServiceClient serviceClient;
    private OSSBucketOperation bucketOperation;
    private OSSObjectOperation objectOperation;
    private OSSMultipartOperation multipartOperation;
    private CORSOperation corsOperation;
    private OSSUploadOperation uploadOperation;
    private OSSDownloadOperation downloadOperation;
    private LiveChannelOperation liveChannelOperation;

    public OSSMultipartOperation getMultipartOperation() {
        return this.multipartOperation;
    }

    public OSSObjectOperation getObjectOperation() {
        return this.objectOperation;
    }

    public void setDownloadOperation(OSSDownloadOperation downloadOperation) {
        this.downloadOperation = downloadOperation;
    }

    public void setUploadOperation(OSSUploadOperation uploadOperation) {
        this.uploadOperation = uploadOperation;
    }

    public OSSClientInternal(String endpoint, CredentialsProvider credsProvider, ClientConfiguration config) {
        this.credsProvider = credsProvider;
        config = config == null ? new ClientConfiguration() : config;
        this.serviceClient = config.isRequestTimeoutEnabled() ? new TimeoutServiceClient(config) : new DefaultServiceClient(config);
        this.initOperations();
        this.setEndpoint(endpoint);
    }

    public synchronized URI getEndpoint() {
        return URI.create(this.endpoint.toString());
    }

    public synchronized void setEndpoint(String endpoint) {
        URI uri;
        this.endpoint = uri = this.toURI(endpoint);
        if (this.isIpOrLocalhost(uri)) {
            this.serviceClient.getClientConfiguration().setSLDEnabled(true);
        }
        this.bucketOperation.setEndpoint(uri);
        this.objectOperation.setEndpoint(uri);
        this.multipartOperation.setEndpoint(uri);
        this.corsOperation.setEndpoint(uri);
        this.liveChannelOperation.setEndpoint(uri);
    }

    private boolean isIpOrLocalhost(URI uri) {
        InetAddress ia;
        if (uri.getHost().equals("localhost")) {
            return true;
        }
        try {
            ia = InetAddress.getByName(uri.getHost());
        }
        catch (UnknownHostException var4) {
            return false;
        }
        return uri.getHost().equals(ia.getHostAddress());
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            ClientConfiguration conf = this.serviceClient.getClientConfiguration();
            endpoint = conf.getProtocol().toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException var3) {
            throw new IllegalArgumentException(var3);
        }
    }

    private void initOperations() {
        this.bucketOperation = new OSSBucketOperation(this.serviceClient, this.credsProvider);
        this.objectOperation = new OSSObjectOperation(this.serviceClient, this.credsProvider);
        this.multipartOperation = new OSSMultipartOperation(this.serviceClient, this.credsProvider);
        this.corsOperation = new CORSOperation(this.serviceClient, this.credsProvider);
        this.uploadOperation = new OSSUploadOperation(this.multipartOperation);
        this.downloadOperation = new OSSDownloadOperation(this.objectOperation);
        this.liveChannelOperation = new LiveChannelOperation(this.serviceClient, this.credsProvider);
    }

    public void switchCredentials(Credentials creds) {
        if (creds == null) {
            throw new IllegalArgumentException("creds should not be null.");
        }
        this.credsProvider.setCredentials(creds);
    }

    public void switchSignatureVersion(SignVersion signatureVersion) {
        if (signatureVersion == null) {
            throw new IllegalArgumentException("signatureVersion should not be null.");
        }
        this.getClientConfiguration().setSignatureVersion(signatureVersion);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credsProvider;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.serviceClient.getClientConfiguration();
    }

    public Bucket createBucket(String bucketName) throws OSSException, ClientException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws OSSException, ClientException {
        return this.bucketOperation.createBucket(createBucketRequest);
    }

    public void deleteBucket(String bucketName) throws OSSException, ClientException {
        this.deleteBucket(new GenericRequest(bucketName));
    }

    public void deleteBucket(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucket(genericRequest);
    }

    public List<Bucket> listBuckets() throws OSSException, ClientException {
        return this.bucketOperation.listBuckets();
    }

    public BucketList listBuckets(ListBucketsRequest listBucketsRequest) throws OSSException, ClientException {
        return this.bucketOperation.listBuckets(listBucketsRequest);
    }

    public BucketList listBuckets(String prefix, String marker, Integer maxKeys) throws OSSException, ClientException {
        return this.bucketOperation.listBuckets(new ListBucketsRequest(prefix, marker, maxKeys));
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList cannedACL) throws OSSException, ClientException {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, cannedACL));
    }

    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketAcl(setBucketAclRequest);
    }

    public AccessControlList getBucketAcl(String bucketName) throws OSSException, ClientException {
        return this.getBucketAcl(new GenericRequest(bucketName));
    }

    public AccessControlList getBucketAcl(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketAcl(genericRequest);
    }

    public BucketMetadata getBucketMetadata(String bucketName) throws OSSException, ClientException {
        return this.getBucketMetadata(new GenericRequest(bucketName));
    }

    public BucketMetadata getBucketMetadata(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketMetadata(genericRequest);
    }

    public void setBucketReferer(String bucketName, BucketReferer referer) throws OSSException, ClientException {
        this.setBucketReferer(new SetBucketRefererRequest(bucketName, referer));
    }

    public void setBucketReferer(SetBucketRefererRequest setBucketRefererRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketReferer(setBucketRefererRequest);
    }

    public BucketReferer getBucketReferer(String bucketName) throws OSSException, ClientException {
        return this.getBucketReferer(new GenericRequest(bucketName));
    }

    public BucketReferer getBucketReferer(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketReferer(genericRequest);
    }

    public String getBucketLocation(String bucketName) throws OSSException, ClientException {
        return this.getBucketLocation(new GenericRequest(bucketName));
    }

    public String getBucketLocation(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketLocation(genericRequest);
    }

    public boolean doesBucketExist(String bucketName) throws OSSException, ClientException {
        return this.doesBucketExist(new GenericRequest(bucketName));
    }

    public boolean doesBucketExist(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.doesBucketExists(genericRequest);
    }

    @Deprecated
    public boolean isBucketExist(String bucketName) throws OSSException, ClientException {
        return this.doesBucketExist(bucketName);
    }

    public ObjectListing listObjects(String bucketName) throws OSSException, ClientException {
        return this.listObjects(new ListObjectsRequest(bucketName, (String)null, (String)null, (String)null, (Integer)null));
    }

    public ObjectListing listObjects(String bucketName, String prefix) throws OSSException, ClientException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, (String)null, (String)null, (Integer)null));
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws OSSException, ClientException {
        return this.bucketOperation.listObjects(listObjectsRequest);
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws OSSException, ClientException {
        return this.bucketOperation.listObjectsV2(listObjectsV2Request);
    }

    public ListObjectsV2Result listObjectsV2(String bucketName) throws OSSException, ClientException {
        return this.bucketOperation.listObjectsV2(new ListObjectsV2Request(bucketName));
    }

    public ListObjectsV2Result listObjectsV2(String bucketName, String prefix) throws OSSException, ClientException {
        return this.bucketOperation.listObjectsV2(new ListObjectsV2Request(bucketName, prefix));
    }

    public ListObjectsV2Result listObjectsV2(String bucketName, String prefix, String continuationToken, String startAfter, String delimiter, Integer maxKeys, String encodingType, boolean fetchOwner) throws OSSException, ClientException {
        return this.bucketOperation.listObjectsV2(new ListObjectsV2Request(bucketName, prefix, continuationToken, startAfter, delimiter, maxKeys, encodingType, fetchOwner));
    }

    public VersionListing listVersions(String bucketName, String prefix) throws OSSException, ClientException {
        return this.listVersions(new ListVersionsRequest(bucketName, prefix, (String)null, (String)null, (String)null, (Integer)null));
    }

    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxResults) throws OSSException, ClientException {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(bucketName).withPrefix(prefix).withDelimiter(delimiter).withKeyMarker(keyMarker).withVersionIdMarker(versionIdMarker).withMaxResults(maxResults);
        return this.listVersions(request);
    }

    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws OSSException, ClientException {
        return this.bucketOperation.listVersions(listVersionsRequest);
    }

    public PutObjectResult putObject(String bucketName, String key, InputStream input) throws OSSException, ClientException {
        return this.putObject(bucketName, key, input, (ObjectMetadata)null);
    }

    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws OSSException, ClientException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    public PutObjectResult putObject(String bucketName, String key, File file, ObjectMetadata metadata) throws OSSException, ClientException {
        return this.putObject(new PutObjectRequest(bucketName, key, file, metadata));
    }

    public PutObjectResult putObject(String bucketName, String key, File file) throws OSSException, ClientException {
        return this.putObject(bucketName, key, file, (ObjectMetadata)null);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.putObject(putObjectRequest);
    }

    public PutObjectResult putObject(URL signedUrl, String filePath, Map<String, String> requestHeaders) throws OSSException, ClientException {
        return this.putObject(signedUrl, filePath, requestHeaders, false);
    }

    public PutObjectResult putObject(URL signedUrl, String filePath, Map<String, String> requestHeaders, boolean useChunkEncoding) throws OSSException, ClientException {
        PutObjectResult var9;
        FileInputStream requestContent = null;
        try {
            File toUpload = new File(filePath);
            if (!IOUtils.checkFile((File)toUpload)) {
                throw new IllegalArgumentException("Illegal file path: " + filePath);
            }
            long fileSize = toUpload.length();
            requestContent = new FileInputStream(toUpload);
            var9 = this.putObject(signedUrl, requestContent, fileSize, requestHeaders, useChunkEncoding);
        }
        catch (FileNotFoundException var18) {
            throw new ClientException((Throwable)var18);
        }
        finally {
            if (requestContent != null) {
                try {
                    requestContent.close();
                }
                catch (IOException iOException) {}
            }
        }
        return var9;
    }

    public PutObjectResult putObject(URL signedUrl, InputStream requestContent, long contentLength, Map<String, String> requestHeaders) throws OSSException, ClientException {
        return this.putObject(signedUrl, requestContent, contentLength, requestHeaders, false);
    }

    public PutObjectResult putObject(URL signedUrl, InputStream requestContent, long contentLength, Map<String, String> requestHeaders, boolean useChunkEncoding) throws OSSException, ClientException {
        return this.objectOperation.putObject(signedUrl, requestContent, contentLength, requestHeaders, useChunkEncoding);
    }

    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws OSSException, ClientException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.copyObject(copyObjectRequest);
    }

    public OSSObject getObject(String bucketName, String key) throws OSSException, ClientException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) throws OSSException, ClientException {
        return this.objectOperation.getObject(getObjectRequest, file);
    }

    public OSSObject getObject(GetObjectRequest getObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.getObject(getObjectRequest);
    }

    public OSSObject getObject(URL signedUrl, Map<String, String> requestHeaders) throws OSSException, ClientException {
        GetObjectRequest getObjectRequest = new GetObjectRequest(signedUrl, requestHeaders);
        return this.objectOperation.getObject(getObjectRequest);
    }

    public OSSObject selectObject(SelectObjectRequest selectObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.selectObject(selectObjectRequest);
    }

    public SimplifiedObjectMeta getSimplifiedObjectMeta(String bucketName, String key) throws OSSException, ClientException {
        return this.getSimplifiedObjectMeta(new GenericRequest(bucketName, key));
    }

    public SimplifiedObjectMeta getSimplifiedObjectMeta(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.objectOperation.getSimplifiedObjectMeta(genericRequest);
    }

    public SelectObjectMetadata createSelectObjectMetadata(CreateSelectObjectMetadataRequest createSelectObjectMetadataRequest) throws OSSException, ClientException {
        return this.objectOperation.createSelectObjectMetadata(createSelectObjectMetadataRequest);
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws OSSException, ClientException {
        return this.getObjectMetadata(new GenericRequest(bucketName, key));
    }

    public ObjectMetadata getObjectMetadata(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.objectOperation.getObjectMetadata(genericRequest);
    }

    public ObjectMetadata headObject(String bucketName, String key) throws OSSException, ClientException {
        return this.headObject(new HeadObjectRequest(bucketName, key));
    }

    public ObjectMetadata headObject(HeadObjectRequest headObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.headObject(headObjectRequest);
    }

    public AppendObjectResult appendObject(AppendObjectRequest appendObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.appendObject(appendObjectRequest);
    }

    public void deleteObject(String bucketName, String key) throws OSSException, ClientException {
        this.deleteObject(new GenericRequest(bucketName, key));
    }

    public void deleteObject(GenericRequest genericRequest) throws OSSException, ClientException {
        this.objectOperation.deleteObject(genericRequest);
    }

    public void deleteVersion(String bucketName, String key, String versionId) throws OSSException, ClientException {
        this.deleteVersion(new DeleteVersionRequest(bucketName, key, versionId));
    }

    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws OSSException, ClientException {
        this.objectOperation.deleteVersion(deleteVersionRequest);
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws OSSException, ClientException {
        return this.objectOperation.deleteObjects(deleteObjectsRequest);
    }

    public DeleteVersionsResult deleteVersions(DeleteVersionsRequest deleteVersionsRequest) throws OSSException, ClientException {
        return this.objectOperation.deleteVersions(deleteVersionsRequest);
    }

    public boolean doesObjectExist(String bucketName, String key) throws OSSException, ClientException {
        return this.doesObjectExist(new GenericRequest(bucketName, key));
    }

    public boolean doesObjectExist(String bucketName, String key, boolean isOnlyInOSS) {
        return isOnlyInOSS ? this.doesObjectExist(bucketName, key) : this.objectOperation.doesObjectExistWithRedirect(new GenericRequest(bucketName, key));
    }

    @Deprecated
    public boolean doesObjectExist(HeadObjectRequest headObjectRequest) throws OSSException, ClientException {
        return this.doesObjectExist(new GenericRequest(headObjectRequest.getBucketName(), headObjectRequest.getKey()));
    }

    public boolean doesObjectExist(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.objectOperation.doesObjectExist(genericRequest);
    }

    public boolean doesObjectExist(GenericRequest genericRequest, boolean isOnlyInOSS) throws OSSException, ClientException {
        return isOnlyInOSS ? this.objectOperation.doesObjectExist(genericRequest) : this.objectOperation.doesObjectExistWithRedirect(genericRequest);
    }

    public void setObjectAcl(String bucketName, String key, CannedAccessControlList cannedACL) throws OSSException, ClientException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, cannedACL));
    }

    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws OSSException, ClientException {
        this.objectOperation.setObjectAcl(setObjectAclRequest);
    }

    public ObjectAcl getObjectAcl(String bucketName, String key) throws OSSException, ClientException {
        return this.getObjectAcl(new GenericRequest(bucketName, key));
    }

    public ObjectAcl getObjectAcl(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.objectOperation.getObjectAcl(genericRequest);
    }

    public RestoreObjectResult restoreObject(String bucketName, String key) throws OSSException, ClientException {
        return this.restoreObject(new GenericRequest(bucketName, key));
    }

    public RestoreObjectResult restoreObject(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.objectOperation.restoreObject(genericRequest);
    }

    public RestoreObjectResult restoreObject(String bucketName, String key, RestoreConfiguration restoreConfiguration) throws OSSException, ClientException {
        return this.restoreObject(new RestoreObjectRequest(bucketName, key, restoreConfiguration));
    }

    public RestoreObjectResult restoreObject(RestoreObjectRequest restoreObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.restoreObject((GenericRequest)restoreObjectRequest);
    }

    public void setObjectTagging(String bucketName, String key, Map<String, String> tags) throws OSSException, ClientException {
        this.setObjectTagging(new SetObjectTaggingRequest(bucketName, key, tags));
    }

    public void setObjectTagging(String bucketName, String key, TagSet tagSet) throws OSSException, ClientException {
        this.setObjectTagging(new SetObjectTaggingRequest(bucketName, key, tagSet));
    }

    public void setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) throws OSSException, ClientException {
        this.objectOperation.setObjectTagging(setObjectTaggingRequest);
    }

    public TagSet getObjectTagging(String bucketName, String key) throws OSSException, ClientException {
        return this.getObjectTagging(new GenericRequest(bucketName, key));
    }

    public TagSet getObjectTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.objectOperation.getObjectTagging(genericRequest);
    }

    public void deleteObjectTagging(String bucketName, String key) throws OSSException, ClientException {
        this.deleteObjectTagging(new GenericRequest(bucketName, key));
    }

    public void deleteObjectTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        this.objectOperation.deleteObjectTagging(genericRequest);
    }

    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws ClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethod.GET);
    }

    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key);
        request.setExpiration(expiration);
        request.setMethod(method);
        return this.generatePresignedUrl(request);
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest request) throws ClientException {
        CodingUtils.assertParameterNotNull((Object)request, (String)"request");
        if (request.getBucketName() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetBucketName"));
        }
        OSSUtils.ensureBucketNameValid((String)request.getBucketName());
        if (request.getExpiration() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetExpiration"));
        }
        String url = this.serviceClient.getClientConfiguration().getSignatureVersion() != null && this.serviceClient.getClientConfiguration().getSignatureVersion() == SignVersion.V2 ? SignV2Utils.buildSignedURL((GeneratePresignedUrlRequest)request, (Credentials)this.credsProvider.getCredentials(), (ClientConfiguration)this.serviceClient.getClientConfiguration(), (URI)this.endpoint) : SignUtils.buildSignedURL((GeneratePresignedUrlRequest)request, (Credentials)this.credsProvider.getCredentials(), (ClientConfiguration)this.serviceClient.getClientConfiguration(), (URI)this.endpoint);
        try {
            return new URL(url);
        }
        catch (MalformedURLException var4) {
            throw new ClientException((Throwable)var4);
        }
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest request) throws OSSException, ClientException {
        this.multipartOperation.abortMultipartUpload(request);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) throws OSSException, ClientException {
        return this.multipartOperation.completeMultipartUpload(request);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws OSSException, ClientException {
        return this.multipartOperation.initiateMultipartUpload(request);
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest request) throws OSSException, ClientException {
        return this.multipartOperation.listMultipartUploads(request);
    }

    public PartListing listParts(ListPartsRequest request) throws OSSException, ClientException {
        return this.multipartOperation.listParts(request);
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws OSSException, ClientException {
        return this.multipartOperation.uploadPart(request);
    }

    public UploadPartCopyResult uploadPartCopy(UploadPartCopyRequest request) throws OSSException, ClientException {
        return this.multipartOperation.uploadPartCopy(request);
    }

    public void setBucketCORS(SetBucketCORSRequest request) throws OSSException, ClientException {
        this.corsOperation.setBucketCORS(request);
    }

    public List<SetBucketCORSRequest.CORSRule> getBucketCORSRules(String bucketName) throws OSSException, ClientException {
        return this.getBucketCORSRules(new GenericRequest(bucketName));
    }

    public List<SetBucketCORSRequest.CORSRule> getBucketCORSRules(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.getBucketCORS(genericRequest).getCorsRules();
    }

    public CORSConfiguration getBucketCORS(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.corsOperation.getBucketCORS(genericRequest);
    }

    public void deleteBucketCORSRules(String bucketName) throws OSSException, ClientException {
        this.deleteBucketCORSRules(new GenericRequest(bucketName));
    }

    public void deleteBucketCORSRules(GenericRequest genericRequest) throws OSSException, ClientException {
        this.corsOperation.deleteBucketCORS(genericRequest);
    }

    public ResponseMessage optionsObject(OptionsRequest request) throws OSSException, ClientException {
        return this.corsOperation.optionsObject(request);
    }

    public void setBucketLogging(SetBucketLoggingRequest request) throws OSSException, ClientException {
        this.bucketOperation.setBucketLogging(request);
    }

    public BucketLoggingResult getBucketLogging(String bucketName) throws OSSException, ClientException {
        return this.getBucketLogging(new GenericRequest(bucketName));
    }

    public BucketLoggingResult getBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketLogging(genericRequest);
    }

    public void deleteBucketLogging(String bucketName) throws OSSException, ClientException {
        this.deleteBucketLogging(new GenericRequest(bucketName));
    }

    public void deleteBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketLogging(genericRequest);
    }

    public void putBucketImage(PutBucketImageRequest request) throws OSSException, ClientException {
        this.bucketOperation.putBucketImage(request);
    }

    public GetBucketImageResult getBucketImage(String bucketName) throws OSSException, ClientException {
        return this.bucketOperation.getBucketImage(bucketName, new GenericRequest());
    }

    public GetBucketImageResult getBucketImage(String bucketName, GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketImage(bucketName, genericRequest);
    }

    public void deleteBucketImage(String bucketName) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketImage(bucketName, new GenericRequest());
    }

    public void deleteBucketImage(String bucketName, GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketImage(bucketName, genericRequest);
    }

    public void putImageStyle(PutImageStyleRequest putImageStyleRequest) throws OSSException, ClientException {
        this.bucketOperation.putImageStyle(putImageStyleRequest);
    }

    public void deleteImageStyle(String bucketName, String styleName) throws OSSException, ClientException {
        this.bucketOperation.deleteImageStyle(bucketName, styleName, new GenericRequest());
    }

    public void deleteImageStyle(String bucketName, String styleName, GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteImageStyle(bucketName, styleName, genericRequest);
    }

    public GetImageStyleResult getImageStyle(String bucketName, String styleName) throws OSSException, ClientException {
        return this.bucketOperation.getImageStyle(bucketName, styleName, new GenericRequest());
    }

    public GetImageStyleResult getImageStyle(String bucketName, String styleName, GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getImageStyle(bucketName, styleName, genericRequest);
    }

    public List<Style> listImageStyle(String bucketName) throws OSSException, ClientException {
        return this.bucketOperation.listImageStyle(bucketName, new GenericRequest());
    }

    public List<Style> listImageStyle(String bucketName, GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.listImageStyle(bucketName, genericRequest);
    }

    public void setBucketProcess(SetBucketProcessRequest setBucketProcessRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketProcess(setBucketProcessRequest);
    }

    public BucketProcess getBucketProcess(String bucketName) throws OSSException, ClientException {
        return this.getBucketProcess(new GenericRequest(bucketName));
    }

    public BucketProcess getBucketProcess(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketProcess(genericRequest);
    }

    public void setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketWebsite(setBucketWebSiteRequest);
    }

    public BucketWebsiteResult getBucketWebsite(String bucketName) throws OSSException, ClientException {
        return this.getBucketWebsite(new GenericRequest(bucketName));
    }

    public BucketWebsiteResult getBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketWebsite(genericRequest);
    }

    public void deleteBucketWebsite(String bucketName) throws OSSException, ClientException {
        this.deleteBucketWebsite(new GenericRequest(bucketName));
    }

    public void deleteBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketWebsite(genericRequest);
    }

    public BucketVersioningConfiguration getBucketVersioning(String bucketName) throws OSSException, ClientException {
        return this.getBucketVersioning(new GenericRequest(bucketName));
    }

    public BucketVersioningConfiguration getBucketVersioning(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketVersioning(genericRequest);
    }

    public void setBucketVersioning(SetBucketVersioningRequest setBucketVersioningRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketVersioning(setBucketVersioningRequest);
    }

    public String generatePostPolicy(Date expiration, PolicyConditions conds) {
        String formatedExpiration = DateUtil.formatIso8601Date((Date)expiration);
        String jsonizedExpiration = String.format("\"expiration\":\"%s\"", formatedExpiration);
        String jsonizedConds = conds.jsonize();
        StringBuilder postPolicy = new StringBuilder();
        postPolicy.append(String.format("{%s,%s}", jsonizedExpiration, jsonizedConds));
        return postPolicy.toString();
    }

    public String calculatePostSignature(String postPolicy) throws ClientException {
        try {
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            return ServiceSignature.create().computeSignature(this.credsProvider.getCredentials().getSecretAccessKey(), encPolicy);
        }
        catch (UnsupportedEncodingException var4) {
            throw new ClientException("Unsupported charset: " + var4.getMessage());
        }
    }

    public void setBucketLifecycle(SetBucketLifecycleRequest setBucketLifecycleRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketLifecycle(setBucketLifecycleRequest);
    }

    public List<LifecycleRule> getBucketLifecycle(String bucketName) throws OSSException, ClientException {
        return this.getBucketLifecycle(new GenericRequest(bucketName));
    }

    public List<LifecycleRule> getBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketLifecycle(genericRequest);
    }

    public void deleteBucketLifecycle(String bucketName) throws OSSException, ClientException {
        this.deleteBucketLifecycle(new GenericRequest(bucketName));
    }

    public void deleteBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketLifecycle(genericRequest);
    }

    public void setBucketTagging(String bucketName, Map<String, String> tags) throws OSSException, ClientException {
        this.setBucketTagging(new SetBucketTaggingRequest(bucketName, tags));
    }

    public void setBucketTagging(String bucketName, TagSet tagSet) throws OSSException, ClientException {
        this.setBucketTagging(new SetBucketTaggingRequest(bucketName, tagSet));
    }

    public void setBucketTagging(SetBucketTaggingRequest setBucketTaggingRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketTagging(setBucketTaggingRequest);
    }

    public TagSet getBucketTagging(String bucketName) throws OSSException, ClientException {
        return this.getBucketTagging(new GenericRequest(bucketName));
    }

    public TagSet getBucketTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketTagging(genericRequest);
    }

    public void deleteBucketTagging(String bucketName) throws OSSException, ClientException {
        this.deleteBucketTagging(new GenericRequest(bucketName));
    }

    public void deleteBucketTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketTagging(genericRequest);
    }

    public void addBucketReplication(AddBucketReplicationRequest addBucketReplicationRequest) throws OSSException, ClientException {
        this.bucketOperation.addBucketReplication(addBucketReplicationRequest);
    }

    public List<ReplicationRule> getBucketReplication(String bucketName) throws OSSException, ClientException {
        return this.getBucketReplication(new GenericRequest(bucketName));
    }

    public List<ReplicationRule> getBucketReplication(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketReplication(genericRequest);
    }

    public void deleteBucketReplication(String bucketName, String replicationRuleID) throws OSSException, ClientException {
        this.deleteBucketReplication(new DeleteBucketReplicationRequest(bucketName, replicationRuleID));
    }

    public void deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketReplication(deleteBucketReplicationRequest);
    }

    public BucketReplicationProgress getBucketReplicationProgress(String bucketName, String replicationRuleID) throws OSSException, ClientException {
        return this.getBucketReplicationProgress(new GetBucketReplicationProgressRequest(bucketName, replicationRuleID));
    }

    public BucketReplicationProgress getBucketReplicationProgress(GetBucketReplicationProgressRequest getBucketReplicationProgressRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketReplicationProgress(getBucketReplicationProgressRequest);
    }

    public List<String> getBucketReplicationLocation(String bucketName) throws OSSException, ClientException {
        return this.getBucketReplicationLocation(new GenericRequest(bucketName));
    }

    public List<String> getBucketReplicationLocation(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketReplicationLocation(genericRequest);
    }

    public void addBucketCname(AddBucketCnameRequest addBucketCnameRequest) throws OSSException, ClientException {
        this.bucketOperation.addBucketCname(addBucketCnameRequest);
    }

    public List<CnameConfiguration> getBucketCname(String bucketName) throws OSSException, ClientException {
        return this.getBucketCname(new GenericRequest(bucketName));
    }

    public List<CnameConfiguration> getBucketCname(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketCname(genericRequest);
    }

    public void deleteBucketCname(String bucketName, String domain) throws OSSException, ClientException {
        this.deleteBucketCname(new DeleteBucketCnameRequest(bucketName, domain));
    }

    public void deleteBucketCname(DeleteBucketCnameRequest deleteBucketCnameRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketCname(deleteBucketCnameRequest);
    }

    public BucketInfo getBucketInfo(String bucketName) throws OSSException, ClientException {
        return this.getBucketInfo(new GenericRequest(bucketName));
    }

    public BucketInfo getBucketInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketInfo(genericRequest);
    }

    public BucketStat getBucketStat(String bucketName) throws OSSException, ClientException {
        return this.getBucketStat(new GenericRequest(bucketName));
    }

    public BucketStat getBucketStat(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketStat(genericRequest);
    }

    public void setBucketStorageCapacity(String bucketName, UserQos userQos) throws OSSException, ClientException {
        this.setBucketStorageCapacity(new SetBucketStorageCapacityRequest(bucketName).withUserQos(userQos));
    }

    public void setBucketStorageCapacity(SetBucketStorageCapacityRequest setBucketStorageCapacityRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketStorageCapacity(setBucketStorageCapacityRequest);
    }

    public UserQos getBucketStorageCapacity(String bucketName) throws OSSException, ClientException {
        return this.getBucketStorageCapacity(new GenericRequest(bucketName));
    }

    public UserQos getBucketStorageCapacity(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketStorageCapacity(genericRequest);
    }

    public void setBucketEncryption(SetBucketEncryptionRequest setBucketEncryptionRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketEncryption(setBucketEncryptionRequest);
    }

    public ServerSideEncryptionConfiguration getBucketEncryption(String bucketName) throws OSSException, ClientException {
        return this.getBucketEncryption(new GenericRequest(bucketName));
    }

    public ServerSideEncryptionConfiguration getBucketEncryption(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketEncryption(genericRequest);
    }

    public void deleteBucketEncryption(String bucketName) throws OSSException, ClientException {
        this.deleteBucketEncryption(new GenericRequest(bucketName));
    }

    public void deleteBucketEncryption(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketEncryption(genericRequest);
    }

    public void setBucketPolicy(String bucketName, String policyText) throws OSSException, ClientException {
        this.setBucketPolicy(new SetBucketPolicyRequest(bucketName, policyText));
    }

    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketPolicy(setBucketPolicyRequest);
    }

    public GetBucketPolicyResult getBucketPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketPolicy(genericRequest);
    }

    public GetBucketPolicyResult getBucketPolicy(String bucketName) throws OSSException, ClientException {
        return this.getBucketPolicy(new GenericRequest(bucketName));
    }

    public void deleteBucketPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketPolicy(genericRequest);
    }

    public void deleteBucketPolicy(String bucketName) throws OSSException, ClientException {
        this.deleteBucketPolicy(new GenericRequest(bucketName));
    }

    public UploadFileResult uploadFile(UploadFileRequest uploadFileRequest) throws Throwable {
        return this.uploadOperation.uploadFile(uploadFileRequest);
    }

    public UploadFileResult uploadFile(VoDUploadFileRequest uploadFileRequest) throws Throwable {
        return this.uploadOperation.uploadFile(uploadFileRequest);
    }

    public DownloadFileResult downloadFile(DownloadFileRequest downloadFileRequest) throws Throwable {
        return this.downloadOperation.downloadFile(downloadFileRequest);
    }

    public CreateLiveChannelResult createLiveChannel(CreateLiveChannelRequest createLiveChannelRequest) throws OSSException, ClientException {
        return this.liveChannelOperation.createLiveChannel(createLiveChannelRequest);
    }

    public void setLiveChannelStatus(String bucketName, String liveChannel, LiveChannelStatus status) throws OSSException, ClientException {
        this.setLiveChannelStatus(new SetLiveChannelRequest(bucketName, liveChannel, status));
    }

    public void setLiveChannelStatus(SetLiveChannelRequest setLiveChannelRequest) throws OSSException, ClientException {
        this.liveChannelOperation.setLiveChannelStatus(setLiveChannelRequest);
    }

    public LiveChannelInfo getLiveChannelInfo(String bucketName, String liveChannel) throws OSSException, ClientException {
        return this.getLiveChannelInfo(new LiveChannelGenericRequest(bucketName, liveChannel));
    }

    public LiveChannelInfo getLiveChannelInfo(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        return this.liveChannelOperation.getLiveChannelInfo(liveChannelGenericRequest);
    }

    public LiveChannelStat getLiveChannelStat(String bucketName, String liveChannel) throws OSSException, ClientException {
        return this.getLiveChannelStat(new LiveChannelGenericRequest(bucketName, liveChannel));
    }

    public LiveChannelStat getLiveChannelStat(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        return this.liveChannelOperation.getLiveChannelStat(liveChannelGenericRequest);
    }

    public void deleteLiveChannel(String bucketName, String liveChannel) throws OSSException, ClientException {
        this.deleteLiveChannel(new LiveChannelGenericRequest(bucketName, liveChannel));
    }

    public void deleteLiveChannel(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        this.liveChannelOperation.deleteLiveChannel(liveChannelGenericRequest);
    }

    public List<LiveChannel> listLiveChannels(String bucketName) throws OSSException, ClientException {
        return this.liveChannelOperation.listLiveChannels(bucketName);
    }

    public LiveChannelListing listLiveChannels(ListLiveChannelsRequest listLiveChannelRequest) throws OSSException, ClientException {
        return this.liveChannelOperation.listLiveChannels(listLiveChannelRequest);
    }

    public List<LiveRecord> getLiveChannelHistory(String bucketName, String liveChannel) throws OSSException, ClientException {
        return this.getLiveChannelHistory(new LiveChannelGenericRequest(bucketName, liveChannel));
    }

    public List<LiveRecord> getLiveChannelHistory(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        return this.liveChannelOperation.getLiveChannelHistory(liveChannelGenericRequest);
    }

    public void generateVodPlaylist(String bucketName, String liveChannelName, String PlaylistName, long startTime, long endTime) throws OSSException, ClientException {
        this.generateVodPlaylist(new GenerateVodPlaylistRequest(bucketName, liveChannelName, PlaylistName, startTime, endTime));
    }

    public void generateVodPlaylist(GenerateVodPlaylistRequest generateVodPlaylistRequest) throws OSSException, ClientException {
        this.liveChannelOperation.generateVodPlaylist(generateVodPlaylistRequest);
    }

    public OSSObject getVodPlaylist(String bucketName, String liveChannelName, long startTime, long endTime) throws OSSException, ClientException {
        return this.getVodPlaylist(new GetVodPlaylistRequest(bucketName, liveChannelName, startTime, endTime));
    }

    public OSSObject getVodPlaylist(GetVodPlaylistRequest getVodPlaylistRequest) throws OSSException, ClientException {
        return this.liveChannelOperation.getVodPlaylist(getVodPlaylistRequest);
    }

    public String generateRtmpUri(String bucketName, String liveChannelName, String PlaylistName, long expires) throws OSSException, ClientException {
        return this.generateRtmpUri(new GenerateRtmpUriRequest(bucketName, liveChannelName, PlaylistName, expires));
    }

    public String generateRtmpUri(GenerateRtmpUriRequest generateRtmpUriRequest) throws OSSException, ClientException {
        return this.liveChannelOperation.generateRtmpUri(generateRtmpUriRequest);
    }

    public void createSymlink(String bucketName, String symLink, String targetObject) throws OSSException, ClientException {
        this.createSymlink(new CreateSymlinkRequest(bucketName, symLink, targetObject));
    }

    public void createSymlink(CreateSymlinkRequest createSymlinkRequest) throws OSSException, ClientException {
        this.objectOperation.createSymlink(createSymlinkRequest);
    }

    public OSSSymlink getSymlink(String bucketName, String symLink) throws OSSException, ClientException {
        return this.getSymlink(new GenericRequest(bucketName, symLink));
    }

    public OSSSymlink getSymlink(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.objectOperation.getSymlink(genericRequest);
    }

    public GenericResult processObject(ProcessObjectRequest processObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.processObject(processObjectRequest);
    }

    public void setBucketRequestPayment(String bucketName, Payer payer) throws OSSException, ClientException {
        this.setBucketRequestPayment(new SetBucketRequestPaymentRequest(bucketName, payer));
    }

    public void setBucketRequestPayment(SetBucketRequestPaymentRequest setBucketRequestPaymentRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketRequestPayment(setBucketRequestPaymentRequest);
    }

    public GetBucketRequestPaymentResult getBucketRequestPayment(String bucketName) throws OSSException, ClientException {
        return this.getBucketRequestPayment(new GenericRequest(bucketName));
    }

    public GetBucketRequestPaymentResult getBucketRequestPayment(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketRequestPayment(genericRequest);
    }

    public void setBucketQosInfo(String bucketName, BucketQosInfo bucketQosInfo) throws OSSException, ClientException {
        this.setBucketQosInfo(new SetBucketQosInfoRequest(bucketName, bucketQosInfo));
    }

    public void setBucketQosInfo(SetBucketQosInfoRequest setBucketQosInfoRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketQosInfo(setBucketQosInfoRequest);
    }

    public BucketQosInfo getBucketQosInfo(String bucketName) throws OSSException, ClientException {
        return this.getBucketQosInfo(new GenericRequest(bucketName));
    }

    public BucketQosInfo getBucketQosInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketQosInfo(genericRequest);
    }

    public void deleteBucketQosInfo(String bucketName) throws OSSException, ClientException {
        this.deleteBucketQosInfo(new GenericRequest(bucketName));
    }

    public void deleteBucketQosInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketQosInfo(genericRequest);
    }

    public UserQosInfo getUserQosInfo() throws OSSException, ClientException {
        return this.bucketOperation.getUserQosInfo();
    }

    public SetAsyncFetchTaskResult setAsyncFetchTask(String bucketName, AsyncFetchTaskConfiguration asyncFetchTaskConfiguration) throws OSSException, ClientException {
        return this.setAsyncFetchTask(new SetAsyncFetchTaskRequest(bucketName, asyncFetchTaskConfiguration));
    }

    public SetAsyncFetchTaskResult setAsyncFetchTask(SetAsyncFetchTaskRequest setAsyncFetchTaskRequest) throws OSSException, ClientException {
        return this.bucketOperation.setAsyncFetchTask(setAsyncFetchTaskRequest);
    }

    public GetAsyncFetchTaskResult getAsyncFetchTask(String bucketName, String taskId) throws OSSException, ClientException {
        return this.getAsyncFetchTask(new GetAsyncFetchTaskRequest(bucketName, taskId));
    }

    public GetAsyncFetchTaskResult getAsyncFetchTask(GetAsyncFetchTaskRequest getAsyncFetchTaskRequest) throws OSSException, ClientException {
        return this.bucketOperation.getAsyncFetchTask(getAsyncFetchTaskRequest);
    }

    public CreateVpcipResult createVpcip(CreateVpcipRequest createVpcipRequest) throws OSSException, ClientException {
        return this.bucketOperation.createVpcip(createVpcipRequest);
    }

    public List<Vpcip> listVpcip() throws OSSException, ClientException {
        return this.bucketOperation.listVpcip();
    }

    public void deleteVpcip(DeleteVpcipRequest deleteVpcipRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteVpcip(deleteVpcipRequest);
    }

    public void createBucketVpcip(CreateBucketVpcipRequest createBucketVpcipRequest) throws OSSException, ClientException {
        this.bucketOperation.createBucketVpcip(createBucketVpcipRequest);
    }

    public void deleteBucketVpcip(DeleteBucketVpcipRequest deleteBucketVpcipRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketVpcip(deleteBucketVpcipRequest);
    }

    public List<VpcPolicy> getBucketVpcip(GenericRequest genericRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketVpcip(genericRequest);
    }

    public void setBucketInventoryConfiguration(String bucketName, InventoryConfiguration inventoryConfiguration) throws OSSException, ClientException {
        this.setBucketInventoryConfiguration(new SetBucketInventoryConfigurationRequest(bucketName, inventoryConfiguration));
    }

    public void setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketInventoryConfiguration(setBucketInventoryConfigurationRequest);
    }

    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(String bucketName, String inventoryId) throws OSSException, ClientException {
        return this.getBucketInventoryConfiguration(new GetBucketInventoryConfigurationRequest(bucketName, inventoryId));
    }

    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws OSSException, ClientException {
        return this.bucketOperation.getBucketInventoryConfiguration(getBucketInventoryConfigurationRequest);
    }

    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(String bucketName) throws OSSException, ClientException {
        return this.listBucketInventoryConfigurations(new ListBucketInventoryConfigurationsRequest(bucketName));
    }

    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(String bucketName, String continuationToken) throws OSSException, ClientException {
        return this.listBucketInventoryConfigurations(new ListBucketInventoryConfigurationsRequest(bucketName, continuationToken));
    }

    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws OSSException, ClientException {
        return this.bucketOperation.listBucketInventoryConfigurations(listBucketInventoryConfigurationsRequest);
    }

    public void deleteBucketInventoryConfiguration(String bucketName, String inventoryId) throws OSSException, ClientException {
        this.deleteBucketInventoryConfiguration(new DeleteBucketInventoryConfigurationRequest(bucketName, inventoryId));
    }

    public void deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketInventoryConfiguration(deleteBucketInventoryConfigurationRequest);
    }

    public void createUdf(CreateUdfRequest createUdfRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public UdfInfo getUdfInfo(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public List<UdfInfo> listUdfs() throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void deleteUdf(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void uploadUdfImage(UploadUdfImageRequest uploadUdfImageRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public List<UdfImageInfo> getUdfImageInfo(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void deleteUdfImage(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void createUdfApplication(CreateUdfApplicationRequest createUdfApplicationRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public UdfApplicationInfo getUdfApplicationInfo(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public List<UdfApplicationInfo> listUdfApplications() throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void deleteUdfApplication(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void upgradeUdfApplication(UpgradeUdfApplicationRequest upgradeUdfApplicationRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void resizeUdfApplication(ResizeUdfApplicationRequest resizeUdfApplicationRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public UdfApplicationLog getUdfApplicationLog(GetUdfApplicationLogRequest getUdfApplicationLogRequest) throws OSSException, ClientException {
        throw new ClientException("Not supported.");
    }

    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        }
        catch (Exception var2) {
            LogUtils.logException((String)"shutdown throw exception: ", (Object)var2);
        }
    }
}

