/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.oss;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.internal.OSSMultipartOperation;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import com.aliyun.vod.upload.common.Constants;
import com.aliyun.vod.upload.common.Util;
import com.aliyun.vod.upload.dto.VoDUploadProgressDTO;
import com.aliyun.vod.upload.impl.ReportUploadProgress;
import com.aliyun.vod.upload.req.VoDUploadFileRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class OSSUploadOperation {
    private OSSMultipartOperation multipartOperation;
    private static final String UPLOAD_MAGIC = "FE8BB4EA-B593-4FAC-AD7A-2459A36E2E62";

    public OSSUploadOperation(OSSMultipartOperation multipartOperation) {
        this.multipartOperation = multipartOperation;
    }

    public UploadFileResult uploadFile(UploadFileRequest uploadFileRequest) throws Throwable {
        CodingUtils.assertParameterNotNull((Object)uploadFileRequest, (String)"uploadFileRequest");
        String bucketName = uploadFileRequest.getBucketName();
        String key = uploadFileRequest.getKey();
        CodingUtils.assertParameterNotNull((Object)bucketName, (String)"bucketName");
        CodingUtils.assertParameterNotNull((Object)key, (String)"key");
        OSSUtils.ensureBucketNameValid((String)bucketName);
        OSSUtils.ensureObjectKeyValid((String)key);
        CodingUtils.assertParameterNotNull((Object)uploadFileRequest.getUploadFile(), (String)"uploadFile");
        if (uploadFileRequest.isEnableCheckpoint() && (uploadFileRequest.getCheckpointFile() == null || uploadFileRequest.getCheckpointFile().length() == 0)) {
            uploadFileRequest.setCheckpointFile(uploadFileRequest.getUploadFile() + ".ucp");
        }
        return this.uploadFileWithCheckpoint(uploadFileRequest);
    }

    public UploadFileResult uploadFile(VoDUploadFileRequest uploadFileRequest) throws Throwable {
        CodingUtils.assertParameterNotNull((Object)((Object)uploadFileRequest), (String)"uploadFileRequest");
        String bucketName = uploadFileRequest.getBucketName();
        String key = uploadFileRequest.getKey();
        CodingUtils.assertParameterNotNull((Object)bucketName, (String)"bucketName");
        CodingUtils.assertParameterNotNull((Object)key, (String)"key");
        OSSUtils.ensureBucketNameValid((String)bucketName);
        OSSUtils.ensureObjectKeyValid((String)key);
        CodingUtils.assertParameterNotNull((Object)uploadFileRequest.getUploadFile(), (String)"uploadFile");
        if (uploadFileRequest.isEnableCheckpoint() && (uploadFileRequest.getCheckpointFile() == null || uploadFileRequest.getCheckpointFile().length() == 0)) {
            uploadFileRequest.setCheckpointFile(uploadFileRequest.getUploadFile() + ".ucp");
        }
        return this.uploadFileWithCheckpoint(uploadFileRequest);
    }

    private UploadFileResult uploadFileWithCheckpoint(UploadFileRequest uploadFileRequest) throws Throwable {
        PartResult partResult;
        UploadFileResult uploadFileResult = new UploadFileResult();
        UploadCheckPoint uploadCheckPoint = new UploadCheckPoint();
        if (uploadFileRequest.isEnableCheckpoint()) {
            try {
                uploadCheckPoint.load(uploadFileRequest.getCheckpointFile());
            }
            catch (Exception var8) {
                this.remove(uploadFileRequest.getCheckpointFile());
            }
            if (!uploadCheckPoint.isValid(uploadFileRequest.getUploadFile())) {
                this.prepare(uploadCheckPoint, uploadFileRequest);
                this.remove(uploadFileRequest.getCheckpointFile());
            }
        } else {
            this.prepare(uploadCheckPoint, uploadFileRequest);
        }
        ProgressListener listener = uploadFileRequest.getProgressListener();
        ProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_STARTED_EVENT);
        ArrayList<PartResult> partResults = this.upload(uploadCheckPoint, uploadFileRequest);
        if (partResults == null || partResults.size() == 0) {
            return null;
        }
        Iterator i$ = partResults.iterator();
        do {
            if (i$.hasNext()) continue;
            ProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
            CompleteMultipartUploadResult multipartUploadResult = this.complete(uploadCheckPoint, uploadFileRequest);
            uploadFileResult.setMultipartUploadResult(multipartUploadResult);
            if (uploadFileRequest.isEnableCheckpoint()) {
                this.remove(uploadFileRequest.getCheckpointFile());
            }
            return uploadFileResult;
        } while (!(partResult = (PartResult)i$.next()).isFailed());
        ProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_PART_FAILED_EVENT);
        throw partResult.getException();
    }

    private String generateUploadPoint(String method, Long partSize, Long doneBytes) {
        JSONObject uploadPoint = new JSONObject();
        uploadPoint.put("Method", (Object)method);
        uploadPoint.put("PartSize", (Object)partSize);
        uploadPoint.put("DoneBytes", (Object)doneBytes);
        return uploadPoint.toJSONString();
    }

    private UploadFileResult uploadFileWithCheckpoint(VoDUploadFileRequest uploadFileRequest) throws Throwable {
        PartResult partResult;
        ArrayList<PartResult> partResults;
        UploadFileResult uploadFileResult = new UploadFileResult();
        UploadCheckPoint uploadCheckPoint = new UploadCheckPoint();
        if (uploadFileRequest.isEnableCheckpoint()) {
            try {
                uploadCheckPoint.load(uploadFileRequest.getCheckpointFile());
            }
            catch (Exception var8) {
                this.remove(uploadFileRequest.getCheckpointFile());
            }
            if (!uploadCheckPoint.isValid(uploadFileRequest.getUploadFile())) {
                this.prepare(uploadCheckPoint, uploadFileRequest);
                this.remove(uploadFileRequest.getCheckpointFile());
            }
        } else {
            this.prepare(uploadCheckPoint, uploadFileRequest);
        }
        ProgressListener listener = uploadFileRequest.getProgressListener();
        ProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_STARTED_EVENT);
        VoDUploadProgressDTO voDUploadProgressDTO = uploadFileRequest.getVodUploadProgressDTO();
        if (voDUploadProgressDTO != null) {
            voDUploadProgressDTO.setUploadId(uploadCheckPoint.uploadID);
            voDUploadProgressDTO.setFileSize(uploadCheckPoint.uploadFileStat.size);
            voDUploadProgressDTO.setDonePartsCount(0L);
            voDUploadProgressDTO.setTotalPart(Long.valueOf(uploadCheckPoint.uploadParts.size()));
            voDUploadProgressDTO.setFileHash(Util.generateFilePartHash(uploadFileRequest.getUploadFile(), uploadCheckPoint.uploadFileStat.size));
            uploadFileRequest.setVodUploadProgressDTO(voDUploadProgressDTO);
        }
        if ((partResults = this.upload(uploadCheckPoint, uploadFileRequest)) == null) {
            return null;
        }
        Iterator i$ = partResults.iterator();
        do {
            if (i$.hasNext()) continue;
            ProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
            CompleteMultipartUploadResult multipartUploadResult = this.complete(uploadCheckPoint, uploadFileRequest);
            uploadFileResult.setMultipartUploadResult(multipartUploadResult);
            if (uploadFileRequest.isEnableCheckpoint()) {
                this.remove(uploadFileRequest.getCheckpointFile());
            }
            if (voDUploadProgressDTO != null) {
                voDUploadProgressDTO.setDonePartsCount(Long.valueOf(uploadCheckPoint.uploadParts.size()));
                voDUploadProgressDTO.setTotalPart(Long.valueOf(uploadCheckPoint.uploadParts.size()));
                ReportUploadProgress reportUploadProgress = new ReportUploadProgress();
                reportUploadProgress.reportUploadProgress(voDUploadProgressDTO);
            }
            return uploadFileResult;
        } while (!(partResult = (PartResult)i$.next()).isFailed());
        ProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_PART_FAILED_EVENT);
        throw partResult.getException();
    }

    private void prepare(UploadCheckPoint uploadCheckPoint, UploadFileRequest uploadFileRequest) {
        uploadCheckPoint.magic = UPLOAD_MAGIC;
        uploadCheckPoint.uploadFile = uploadFileRequest.getUploadFile();
        uploadCheckPoint.key = uploadFileRequest.getKey();
        uploadCheckPoint.uploadFileStat = FileStat.getFileStat(uploadCheckPoint.uploadFile);
        uploadCheckPoint.uploadParts = this.splitFile(uploadCheckPoint.uploadFileStat.size, uploadFileRequest.getPartSize());
        uploadCheckPoint.partETags = new ArrayList();
        ObjectMetadata metadata = uploadFileRequest.getObjectMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType(Mimetypes.getInstance().getMimetype(uploadCheckPoint.uploadFile, uploadCheckPoint.key));
        }
        InitiateMultipartUploadRequest initiateUploadRequest = new InitiateMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getKey(), metadata);
        InitiateMultipartUploadResult initiateUploadResult = this.multipartOperation.initiateMultipartUpload(initiateUploadRequest);
        uploadCheckPoint.uploadID = initiateUploadResult.getUploadId();
    }

    private ArrayList<PartResult> upload(UploadCheckPoint uploadCheckPoint, VoDUploadFileRequest uploadFileRequest) throws Throwable {
        int i;
        ArrayList<PartResult> taskResults = new ArrayList<PartResult>();
        ExecutorService service = Executors.newFixedThreadPool(uploadFileRequest.getTaskNum());
        ArrayList<Future<PartResult>> futures = new ArrayList<Future<PartResult>>();
        ProgressListener listener = uploadFileRequest.getProgressListener();
        long contentLength = 0L;
        for (i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
            if (uploadCheckPoint.uploadParts.get((int)i).isCompleted) continue;
            contentLength += uploadCheckPoint.uploadParts.get((int)i).size;
        }
        ProgressPublisher.publishRequestContentLength((ProgressListener)listener, (long)contentLength);
        uploadFileRequest.setProgressListener(null);
        VoDUploadProgressDTO uploadProgressDTO = uploadFileRequest.getVodUploadProgressDTO();
        for (i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
            if (!uploadCheckPoint.uploadParts.get((int)i).isCompleted) {
                futures.add(service.submit(new Task(i, "upload-" + i, uploadCheckPoint, i, uploadFileRequest, this.multipartOperation, listener)));
                if (uploadProgressDTO == null) continue;
                uploadProgressDTO.setDonePartsCount(Long.valueOf(i + 1));
                uploadProgressDTO.setUploadPoint(this.generateUploadPoint("UploadVideo", uploadProgressDTO.getPartSize(), uploadProgressDTO.getDonePartsCount() * uploadProgressDTO.getPartSize()));
                uploadProgressDTO.setTotalPart(Long.valueOf(uploadCheckPoint.uploadParts.size()));
                uploadProgressDTO.setFileHash(Util.generateFilePartHash(uploadFileRequest.getUploadFile(), uploadCheckPoint.uploadFileStat.size));
                ReportUploadProgress reportUploadProgress = new ReportUploadProgress();
                reportUploadProgress.reportUploadProgress(uploadProgressDTO);
                continue;
            }
            taskResults.add(new PartResult(i + 1, uploadCheckPoint.uploadParts.get((int)i).offset, uploadCheckPoint.uploadParts.get((int)i).size));
        }
        service.shutdown();
        if (!service.awaitTermination(Constants.UPLOAD_TOKEN_REFRESH_TIMEOUT, TimeUnit.SECONDS)) {
            service.shutdownNow();
            return new ArrayList<PartResult>();
        }
        for (Future future : futures) {
            try {
                PartResult tr = (PartResult)future.get();
                taskResults.add(tr);
            }
            catch (ExecutionException var12) {
                uploadFileRequest.setProgressListener(listener);
                throw var12.getCause();
            }
        }
        Collections.sort(taskResults, new Comparator<PartResult>(){

            @Override
            public int compare(PartResult p1, PartResult p2) {
                return p1.getNumber() - p2.getNumber();
            }
        });
        uploadFileRequest.setProgressListener(listener);
        return taskResults;
    }

    private ArrayList<PartResult> upload(UploadCheckPoint uploadCheckPoint, UploadFileRequest uploadFileRequest) throws Throwable {
        int i;
        ArrayList<PartResult> taskResults = new ArrayList<PartResult>();
        ExecutorService service = Executors.newFixedThreadPool(uploadFileRequest.getTaskNum());
        ArrayList<Future<PartResult>> futures = new ArrayList<Future<PartResult>>();
        ProgressListener listener = uploadFileRequest.getProgressListener();
        long contentLength = 0L;
        for (i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
            if (uploadCheckPoint.uploadParts.get((int)i).isCompleted) continue;
            contentLength += uploadCheckPoint.uploadParts.get((int)i).size;
        }
        ProgressPublisher.publishRequestContentLength((ProgressListener)listener, (long)contentLength);
        uploadFileRequest.setProgressListener((ProgressListener)null);
        for (i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
            if (!uploadCheckPoint.uploadParts.get((int)i).isCompleted) {
                futures.add(service.submit(new Task(i, "upload-" + i, uploadCheckPoint, i, uploadFileRequest, this.multipartOperation, listener)));
                continue;
            }
            taskResults.add(new PartResult(i + 1, uploadCheckPoint.uploadParts.get((int)i).offset, uploadCheckPoint.uploadParts.get((int)i).size));
        }
        service.shutdown();
        if (!service.awaitTermination(Constants.UPLOAD_TOKEN_REFRESH_TIMEOUT, TimeUnit.SECONDS)) {
            service.shutdownNow();
            return new ArrayList<PartResult>();
        }
        for (Future future : futures) {
            try {
                PartResult tr = (PartResult)future.get();
                taskResults.add(tr);
            }
            catch (ExecutionException var12) {
                uploadFileRequest.setProgressListener(listener);
                throw var12.getCause();
            }
        }
        Collections.sort(taskResults, new Comparator<PartResult>(){

            @Override
            public int compare(PartResult p1, PartResult p2) {
                return p1.getNumber() - p2.getNumber();
            }
        });
        uploadFileRequest.setProgressListener(listener);
        return taskResults;
    }

    private CompleteMultipartUploadResult complete(UploadCheckPoint uploadCheckPoint, UploadFileRequest uploadFileRequest) {
        Collections.sort(uploadCheckPoint.partETags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag p1, PartETag p2) {
                return p1.getPartNumber() - p2.getPartNumber();
            }
        });
        CompleteMultipartUploadRequest completeUploadRequest = new CompleteMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getKey(), uploadCheckPoint.uploadID, uploadCheckPoint.partETags);
        completeUploadRequest.setCallback(uploadFileRequest.getCallback());
        completeUploadRequest.setHeaders(uploadFileRequest.getHeaders());
        return this.multipartOperation.completeMultipartUpload(completeUploadRequest);
    }

    private ArrayList<UploadPart> splitFile(long fileSize, long partSize) {
        ArrayList<UploadPart> parts = new ArrayList<UploadPart>();
        long partNum = fileSize / partSize;
        if (partNum >= 10000L) {
            partSize = fileSize / 9999L;
            partNum = fileSize / partSize;
        }
        for (long i = 0L; i < partNum; ++i) {
            UploadPart part = new UploadPart();
            part.number = (int)(i + 1L);
            part.offset = i * partSize;
            part.size = partSize;
            part.isCompleted = false;
            parts.add(part);
        }
        if (fileSize % partSize > 0L) {
            UploadPart part = new UploadPart();
            part.number = parts.size() + 1;
            part.offset = (long)parts.size() * partSize;
            part.size = fileSize % partSize;
            part.isCompleted = false;
            parts.add(part);
        }
        return parts;
    }

    private boolean remove(String filePath) {
        boolean flag = false;
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    static class UploadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 5424904565837227164L;
        public String magic;
        public int md5;
        public String uploadFile;
        public FileStat uploadFileStat;
        public String key;
        public String uploadID;
        public ArrayList<UploadPart> uploadParts;
        public ArrayList<PartETag> partETags;

        UploadCheckPoint() {
        }

        public synchronized void load(String cpFile) throws IOException, ClassNotFoundException {
            FileInputStream fileIn = new FileInputStream(cpFile);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            UploadCheckPoint ucp = (UploadCheckPoint)in.readObject();
            this.assign(ucp);
            in.close();
            fileIn.close();
        }

        public synchronized void dump(String cpFile) throws IOException {
            this.md5 = this.hashCode();
            FileOutputStream fileOut = new FileOutputStream(cpFile);
            ObjectOutputStream outStream = new ObjectOutputStream(fileOut);
            outStream.writeObject(this);
            outStream.close();
            fileOut.close();
        }

        public synchronized void update(int partIndex, PartETag partETag, boolean completed) throws IOException {
            this.partETags.add(partETag);
            this.uploadParts.get((int)partIndex).isCompleted = completed;
        }

        public synchronized boolean isValid(String uploadFile) {
            if (this.magic != null && this.magic.equals(OSSUploadOperation.UPLOAD_MAGIC) && this.md5 == this.hashCode()) {
                File upload = new File(uploadFile);
                return !upload.exists() ? false : this.uploadFile.equals(uploadFile) && this.uploadFileStat.size == upload.length() && this.uploadFileStat.lastModified == upload.lastModified();
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.magic == null ? 0 : this.magic.hashCode());
            result = 31 * result + (this.partETags == null ? 0 : this.partETags.hashCode());
            result = 31 * result + (this.uploadFile == null ? 0 : this.uploadFile.hashCode());
            result = 31 * result + (this.uploadFileStat == null ? 0 : this.uploadFileStat.hashCode());
            result = 31 * result + (this.uploadID == null ? 0 : this.uploadID.hashCode());
            result = 31 * result + (this.uploadParts == null ? 0 : this.uploadParts.hashCode());
            return result;
        }

        private void assign(UploadCheckPoint ucp) {
            this.magic = ucp.magic;
            this.md5 = ucp.md5;
            this.uploadFile = ucp.uploadFile;
            this.uploadFileStat = ucp.uploadFileStat;
            this.key = ucp.key;
            this.uploadID = ucp.uploadID;
            this.uploadParts = ucp.uploadParts;
            this.partETags = ucp.partETags;
        }
    }

    static class FileStat
    implements Serializable {
        private static final long serialVersionUID = -1223810339796425415L;
        public long size;
        public long lastModified;
        public String digest;

        FileStat() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public static FileStat getFileStat(String uploadFile) {
            FileStat fileStat = new FileStat();
            File file = new File(uploadFile);
            fileStat.size = file.length();
            fileStat.lastModified = file.lastModified();
            return fileStat;
        }
    }

    static class UploadPart
    implements Serializable {
        private static final long serialVersionUID = 6692863980224332199L;
        public int number;
        public long offset;
        public long size;
        public boolean isCompleted;

        UploadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isCompleted ? 1231 : 1237);
            result = 31 * result + this.number;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }
    }

    static class PartResult {
        private int number;
        private long offset;
        private long length;
        private boolean failed;
        private Exception exception;

        public PartResult(int number, long offset, long length) {
            this.number = number;
            this.offset = offset;
            this.length = length;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setFailed(boolean failed) {
            this.failed = failed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }

    static class Task
    implements Callable<PartResult> {
        private int id;
        private String name;
        private UploadCheckPoint uploadCheckPoint;
        private int partIndex;
        private UploadFileRequest uploadFileRequest;
        private OSSMultipartOperation multipartOperation;
        private ProgressListener progressListener;

        public Task(int id, String name, UploadCheckPoint uploadCheckPoint, int partIndex, UploadFileRequest uploadFileRequest, OSSMultipartOperation multipartOperation, ProgressListener progressListener) {
            this.id = id;
            this.name = name;
            this.uploadCheckPoint = uploadCheckPoint;
            this.partIndex = partIndex;
            this.uploadFileRequest = uploadFileRequest;
            this.multipartOperation = multipartOperation;
            this.progressListener = progressListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartResult call() throws Exception {
            PartResult tr = null;
            try (FileInputStream instream = null;){
                UploadPart uploadPart = this.uploadCheckPoint.uploadParts.get(this.partIndex);
                tr = new PartResult(this.partIndex + 1, uploadPart.offset, uploadPart.size);
                instream = new FileInputStream(this.uploadCheckPoint.uploadFile);
                instream.skip(uploadPart.offset);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(this.uploadFileRequest.getBucketName());
                uploadPartRequest.setKey(this.uploadFileRequest.getKey());
                uploadPartRequest.setUploadId(this.uploadCheckPoint.uploadID);
                uploadPartRequest.setPartNumber(uploadPart.number);
                uploadPartRequest.setInputStream((InputStream)instream);
                uploadPartRequest.setPartSize(uploadPart.size);
                UploadPartResult uploadPartResult = this.multipartOperation.uploadPart(uploadPartRequest);
                PartETag partETag = new PartETag(uploadPartResult.getPartNumber(), uploadPartResult.getETag());
                this.uploadCheckPoint.update(this.partIndex, partETag, true);
                if (this.uploadFileRequest.isEnableCheckpoint()) {
                    this.uploadCheckPoint.dump(this.uploadFileRequest.getCheckpointFile());
                }
                ProgressPublisher.publishRequestBytesTransferred((ProgressListener)this.progressListener, (long)uploadPart.size);
            }
            return tr;
        }
    }
}

