/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.req;

import com.aliyun.vod.upload.req.BaseM3U8Request;
import com.aliyun.vod.upload.resp.UploadLocalM3u8Response;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class UploadLocalM3u8Request
extends BaseM3U8Request {
    private String m3u8Filename;
    private String[] sliceFilenames;
    private Integer taskNum = 1;
    private Long partSize = 0xA00000L;
    private String localTmpM3u8FilePath;

    public UploadLocalM3u8Request(String accessKeyId, String accessKeySecret, String title, String m3u8Filename) {
        super(accessKeyId, accessKeySecret, title);
        this.setM3u8Filename(m3u8Filename);
    }

    public UploadLocalM3u8Response checkParams() {
        UploadLocalM3u8Response response = new UploadLocalM3u8Response();
        if (StringUtils.isBlank((CharSequence)this.m3u8Filename)) {
            response.setCode("InvalidParameter");
            response.setMessage("The parameter M3u8Filename must be specified.");
            return response;
        }
        File file = new File(this.m3u8Filename);
        if (!file.isFile() || !file.exists()) {
            response.setCode("InvalidParameter");
            response.setMessage("The m3u8 file does not exist.");
            return response;
        }
        if (!this.m3u8Filename.contains(".")) {
            response.setCode("InvalidParameter");
            response.setMessage("The M3u8Filename has no Extension.");
            return response;
        }
        String mediaExt = this.m3u8Filename.substring(this.m3u8Filename.lastIndexOf(".") + 1);
        if (StringUtils.isBlank((CharSequence)mediaExt) || !mediaExt.equalsIgnoreCase("m3u8")) {
            response.setCode("InvalidParameter");
            response.setMessage("The Extension of M3u8Filename is invalid.");
            return response;
        }
        if (this.sliceFilenames != null) {
            for (int i = 0; i < this.sliceFilenames.length; ++i) {
                String sliceFilename = this.sliceFilenames[i];
                if (StringUtils.isBlank((CharSequence)sliceFilename)) {
                    response.setCode("InvalidParameter");
                    response.setMessage(String.format("The SliceFilenames %s is invalid.", sliceFilename));
                    return response;
                }
                File sliceFile = new File(sliceFilename);
                if (sliceFile.isFile() && sliceFile.exists()) continue;
                response.setCode("InvalidParameter");
                response.setMessage(String.format("The slice file %s does not exist.", sliceFilename));
                return response;
            }
        }
        response.setCode("Success");
        response.setMessage("Success");
        return response;
    }

    public Integer getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(Integer taskNum) {
        this.taskNum = taskNum;
    }

    public Long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(Long partSize) {
        this.partSize = partSize;
    }

    public String getM3u8Filename() {
        return this.m3u8Filename;
    }

    public void setM3u8Filename(String m3u8Filename) {
        this.m3u8Filename = m3u8Filename;
    }

    public String[] getSliceFilenames() {
        return this.sliceFilenames;
    }

    public void setSliceFilenames(String[] sliceFilenames) {
        this.sliceFilenames = sliceFilenames;
    }

    public String getLocalTmpM3u8FilePath() {
        return this.localTmpM3u8FilePath;
    }

    public void setLocalTmpM3u8FilePath(String localTmpM3u8FilePath) {
        this.localTmpM3u8FilePath = localTmpM3u8FilePath;
    }
}

