/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vod.upload.req;

import com.aliyun.vod.upload.req.BaseM3U8Request;
import com.aliyun.vod.upload.resp.UploadWebM3u8Response;
import org.apache.commons.lang3.StringUtils;

public class UploadWebM3u8Request
extends BaseM3U8Request {
    private Integer taskNum = 1;
    private Long partSize = 0xA00000L;
    private int downloadConnectTimeout = 2000;
    private int downloadSocketTimeout = 3000;
    private String m3u8FileURL;
    private String[] sliceFileURLs;
    private String globalLocalFilePath;

    public UploadWebM3u8Request(String accessKeyId, String accessKeySecret, String title, String m3u8FileURL) {
        super(accessKeyId, accessKeySecret, title);
        this.setM3u8FileURL(m3u8FileURL);
    }

    public UploadWebM3u8Response checkParams() {
        UploadWebM3u8Response response = new UploadWebM3u8Response();
        if (StringUtils.isBlank((CharSequence)this.m3u8FileURL)) {
            response.setCode("InvalidParameter");
            response.setMessage("The parameter M3u8Filename must be specified.");
            return response;
        }
        if (!this.m3u8FileURL.contains(".")) {
            response.setCode("InvalidParameter");
            response.setMessage("The M3u8Filename has no Extension.");
            return response;
        }
        String urlPrefix = "";
        String mediaExtend = "";
        if (this.m3u8FileURL.contains("?")) {
            urlPrefix = this.m3u8FileURL.substring(0, this.m3u8FileURL.indexOf("?"));
            mediaExtend = urlPrefix.substring(urlPrefix.lastIndexOf(".") + 1);
        } else {
            mediaExtend = this.m3u8FileURL.substring(this.m3u8FileURL.lastIndexOf(".") + 1);
        }
        if (StringUtils.isBlank((CharSequence)mediaExtend) || !mediaExtend.contains("m3u8")) {
            response.setCode("InvalidParameter");
            response.setMessage("The Extension of M3u8Filename is invalid.");
            return response;
        }
        if (this.sliceFileURLs != null) {
            for (int i = 0; i < this.sliceFileURLs.length; ++i) {
                String sliceFilename = this.sliceFileURLs[i];
                if (!StringUtils.isBlank((CharSequence)sliceFilename)) continue;
                response.setCode("InvalidParameter");
                response.setMessage(String.format("The SliceFileURLs %s is invalid.", sliceFilename));
                return response;
            }
        }
        response.setCode("Success");
        response.setMessage("Success");
        return response;
    }

    public Integer getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(Integer taskNum) {
        this.taskNum = taskNum;
    }

    public Long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(Long partSize) {
        this.partSize = partSize;
    }

    public String getM3u8FileURL() {
        return this.m3u8FileURL;
    }

    public void setM3u8FileURL(String m3u8FileURL) {
        this.m3u8FileURL = m3u8FileURL;
    }

    public int getDownloadConnectTimeout() {
        return this.downloadConnectTimeout;
    }

    public void setDownloadConnectTimeout(int downloadConnectTimeout) {
        this.downloadConnectTimeout = downloadConnectTimeout;
    }

    public int getDownloadSocketTimeout() {
        return this.downloadSocketTimeout;
    }

    public void setDownloadSocketTimeout(int downloadSocketTimeout) {
        this.downloadSocketTimeout = downloadSocketTimeout;
    }

    public String[] getSliceFileURLs() {
        return this.sliceFileURLs;
    }

    public void setSliceFileURLs(String[] sliceFileURLs) {
        this.sliceFileURLs = sliceFileURLs;
    }

    public String getGlobalLocalFilePath() {
        return this.globalLocalFilePath;
    }

    public void setGlobalLocalFilePath(String globalLocalFilePath) {
        this.globalLocalFilePath = globalLocalFilePath;
    }
}

